/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;

public class LightAction
extends BaseSpellAction {
    private int level;
    private boolean async;
    private boolean update;
    private boolean undoPrevious;
    private MageController controller;
    private LightUndoAction previous;
    private double minDistanceSquared;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.controller = context.getController();
        this.async = parameters.getBoolean("async", false);
        this.update = parameters.getBoolean("update", true);
        this.level = parameters.getInt("level", 15);
        this.undoPrevious = parameters.getBoolean("undo_previous", false);
        this.minDistanceSquared = parameters.getDouble("min_distance");
        this.minDistanceSquared *= this.minDistanceSquared;
    }

    @Override
    public SpellResult perform(CastContext context) {
        if (!context.getController().isLightingAvailable()) {
            return SpellResult.FAIL;
        }
        Location location = context.getTargetLocation();
        if (this.minDistanceSquared > 0.0 && this.previous != null && this.previous.getLocation().getWorld().equals(location.getWorld()) && this.previous.getLocation().distanceSquared(location) < this.minDistanceSquared) {
            return SpellResult.NO_TARGET;
        }
        context.addWork(5);
        if (this.controller.createLight(location, this.level, this.async) && this.update) {
            this.controller.updateLight(location);
            context.addWork(10);
        }
        if (this.undoPrevious && this.previous != null) {
            this.previous.run();
        }
        this.previous = new LightUndoAction(location, this.update);
        context.registerForUndo(this.previous);
        return SpellResult.CAST;
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    @Override
    public boolean requiresTarget() {
        return true;
    }

    private class LightUndoAction
    implements Runnable {
        private final Location location;
        private final boolean update;
        private boolean undone;

        public LightUndoAction(Location location, boolean update) {
            this.location = location;
            this.update = update;
        }

        @Override
        public void run() {
            if (this.location != null && !this.undone) {
                boolean removed = LightAction.this.controller.deleteLight(this.location, LightAction.this.async);
                if (this.update && removed) {
                    LightAction.this.controller.updateLight(this.location, false);
                }
                this.undone = true;
            }
        }

        public Location getLocation() {
            return this.location;
        }
    }
}

