/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.block.DefaultMaterials;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;

public class ChangeBiomeAction
extends BaseSpellAction {
    private Biome biome;
    private Map<Biome, Biome> biomeMap;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        ConfigurationSection replaceConfiguration;
        super.prepare(context, parameters);
        String biomeKey = parameters.getString("biome", "");
        if (!biomeKey.isEmpty()) {
            this.biome = DefaultMaterials.getInstance().getBiome(biomeKey);
            if (this.biome == null) {
                context.getLogger().warning("Invalid biome: " + biomeKey);
            }
        }
        if ((replaceConfiguration = parameters.getConfigurationSection("biome_replacements")) != null) {
            this.biomeMap = new HashMap<Biome, Biome>();
            Set fromKeys = replaceConfiguration.getKeys(false);
            for (String fromKey : fromKeys) {
                Biome fromBiome = DefaultMaterials.getInstance().getBiome(fromKey);
                if (fromBiome == null) {
                    context.getLogger().warning("Invalid biome replacement (from): " + fromKey);
                    continue;
                }
                String toKey = replaceConfiguration.getString(fromKey);
                Biome toBiome = DefaultMaterials.getInstance().getBiome(toKey);
                if (toBiome == null) {
                    context.getLogger().warning("Invalid biome replacement (to): " + toKey);
                    continue;
                }
                this.biomeMap.put(fromBiome, toBiome);
            }
        }
        if (this.biome == null && this.biomeMap == null) {
            context.getLogger().warning("Biome action missing either biome or biome_replacements parameters");
        }
    }

    @Override
    public SpellResult perform(CastContext context) {
        Block block = context.getTargetBlock();
        Biome targetBiome = this.biome;
        if (this.biomeMap != null) {
            targetBiome = this.biomeMap.get(block.getBiome());
        }
        if (targetBiome == null) {
            return SpellResult.NO_TARGET;
        }
        block.setBiome(targetBiome);
        return SpellResult.CAST;
    }

    @Override
    public boolean requiresTarget() {
        return true;
    }
}

