/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility.platform.base.entity;

import com.elmakers.mine.bukkit.entity.EntityExtraData;
import com.elmakers.mine.bukkit.utility.ConfigUtils;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Slime;

public class EntitySlimeData
extends EntityExtraData {
    public Integer size;
    public boolean splittable;

    public EntitySlimeData(ConfigurationSection parameters) {
        this.size = ConfigUtils.getOptionalInteger(parameters, "size");
        this.splittable = parameters.getBoolean("split", true);
    }

    public EntitySlimeData(Slime slime) {
        this.size = slime.getSize();
        this.splittable = true;
    }

    @Override
    public void apply(Entity entity) {
        if (!(entity instanceof Slime)) {
            return;
        }
        Slime slime = (Slime)entity;
        if (this.size != null) {
            slime.setSize(this.size.intValue());
        }
    }

    @Override
    public boolean isSplittable() {
        return this.splittable;
    }
}

