/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.integration.skript;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import com.elmakers.mine.bukkit.api.event.CastEvent;
import org.bukkit.ChatColor;
import org.bukkit.event.Event;

public class EvtCast
extends SkriptEvent {
    private Literal<String> spells;

    public static void register() {
        Skript.registerEvent((String)"Cast Spell", EvtCast.class, CastEvent.class, (String[])new String[]{"cast [[of] [spell] %-string%]"}).description(new String[]{"Called when a player or magic mob casts a spell"}).examples(new String[]{"on cast", "on cast of missile", "on cast of spell blink"});
    }

    public boolean init(Literal<?>[] args, int i, SkriptParser.ParseResult parseResult) {
        this.spells = args[0];
        return true;
    }

    public boolean check(Event event) {
        if (!(event instanceof CastEvent)) {
            return false;
        }
        CastEvent spellCast = (CastEvent)event;
        if (this.spells != null) {
            String spellKey = spellCast.getSpell().getKey();
            String spellName = ChatColor.stripColor((String)spellCast.getSpell().getName());
            for (String spell : (String[])this.spells.getAll()) {
                if (spellKey.equalsIgnoreCase(spell)) {
                    return true;
                }
                if (!spellName.equalsIgnoreCase(spell)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public String toString(Event event, boolean debug) {
        return "cast" + (this.spells != null ? " of " + this.spells.toString(event, debug) : "");
    }
}

