/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.arena;

import com.elmakers.mine.bukkit.api.entity.EntityData;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.arena.Arena;
import com.elmakers.mine.bukkit.arena.ArenaMobSpawner;
import com.elmakers.mine.bukkit.arena.EditingStage;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.util.Vector;

public abstract class ArenaStageTemplate
implements EditingStage {
    protected final Arena arena;
    protected final ConfigurationSection configuration;
    protected List<ArenaMobSpawner> mobs = new ArrayList<ArenaMobSpawner>();
    protected List<Location> mobSpawns = new ArrayList<Location>();
    protected String startSpell;
    protected String endSpell;
    protected Vector randomizeMobSpawn;
    protected int winXP = 0;
    protected int winSP = 0;
    protected int winMoney = 0;
    protected int duration = 0;
    protected int respawnDuration = 0;
    protected boolean defaultDrops = false;
    protected boolean forceTarget = false;

    public ArenaStageTemplate(Arena arena) {
        this.arena = arena;
        this.configuration = ConfigurationUtils.newConfigurationSection();
        this.load();
    }

    public ArenaStageTemplate(Arena arena, ConfigurationSection configuration) {
        this.arena = arena;
        this.configuration = configuration;
        this.load();
    }

    protected void load() {
        this.load(this.configuration);
    }

    protected void load(ConfigurationSection configuration) {
        MageController controller = this.arena.getController().getMagic();
        if (configuration.contains("mobs")) {
            List<ConfigurationSection> mobConfigurations = ConfigurationUtils.getNodeList(configuration, "mobs");
            for (ConfigurationSection mobConfiguration : mobConfigurations) {
                ArenaMobSpawner mob = new ArenaMobSpawner(controller, mobConfiguration);
                if (!mob.isValid()) continue;
                this.mobs.add(mob);
            }
        }
        this.startSpell = configuration.getString("spell_start");
        this.endSpell = configuration.getString("spell_end");
        for (String s : configuration.getStringList("mob_spawns")) {
            this.mobSpawns.add(ConfigurationUtils.toLocation(s, this.arena.getCenter()));
        }
        this.winXP = configuration.getInt("win_xp");
        this.winSP = configuration.getInt("win_sp");
        this.winMoney = configuration.getInt("win_money");
        this.defaultDrops = configuration.getBoolean("drops");
        this.forceTarget = configuration.getBoolean("aggro", false);
        this.duration = configuration.getInt("duration", 0);
        this.respawnDuration = configuration.getInt("respawn_duration", 0);
        if (configuration.contains("randomize_mob_spawn")) {
            this.randomizeMobSpawn = ConfigurationUtils.toVector(configuration.getString("randomize_mob_spawn"));
        }
    }

    protected void saveMobs() {
        ArrayList<MemoryConfiguration> mobsConfigurations = new ArrayList<MemoryConfiguration>();
        for (ArenaMobSpawner mob : this.mobs) {
            if (!mob.isValid()) continue;
            MemoryConfiguration section = new MemoryConfiguration();
            mob.save((ConfigurationSection)section);
            mobsConfigurations.add(section);
        }
        this.configuration.set("mobs", mobsConfigurations);
        this.arena.saveEditingStage();
    }

    protected void saveMobSpawns() {
        ArrayList<String> mobSpawnList = new ArrayList<String>();
        for (Location spawn : this.mobSpawns) {
            mobSpawnList.add(ConfigurationUtils.fromLocation(spawn, this.arena.getCenter()));
        }
        this.configuration.set("mob_spawns", mobSpawnList);
        this.arena.saveEditingStage();
    }

    @Override
    public void addMob(EntityData entityType, int count) {
        this.mobs.add(new ArenaMobSpawner(entityType, count));
        this.saveMobs();
    }

    @Override
    public void removeMob(EntityData entityType) {
        Iterator<ArenaMobSpawner> it = this.mobs.iterator();
        while (it.hasNext()) {
            ArenaMobSpawner spawner = it.next();
            if (!spawner.getEntity().getKey().equalsIgnoreCase(entityType.getKey())) continue;
            it.remove();
        }
        this.saveMobs();
    }

    @Override
    public void describe(CommandSender sender) {
        int mobSpawnSize = this.mobSpawns.size();
        if (mobSpawnSize == 1) {
            sender.sendMessage(ChatColor.BLUE + "Mob Spawn: " + this.arena.printLocation(this.mobSpawns.get(0)));
        } else if (mobSpawnSize > 1) {
            sender.sendMessage(ChatColor.BLUE + "Mob Spawns: " + ChatColor.GRAY + mobSpawnSize);
            for (Location spawn : this.mobSpawns) {
                sender.sendMessage(this.arena.printLocation(spawn));
            }
        }
        int numMobs = this.mobs.size();
        if (numMobs == 0) {
            sender.sendMessage(ChatColor.GRAY + "(No Mobs)");
        } else {
            sender.sendMessage(ChatColor.DARK_GREEN + "Mobs: " + ChatColor.BLUE + numMobs);
            for (ArenaMobSpawner mob : this.mobs) {
                sender.sendMessage(" " + this.describeMob(mob));
            }
        }
        if (this.randomizeMobSpawn != null) {
            sender.sendMessage(ChatColor.DARK_GREEN + " Randomize Spawning: " + ChatColor.BLUE + this.randomizeMobSpawn);
        }
        if (this.duration > 0) {
            int minutes = (int)Math.ceil((double)this.duration / 60.0 / 1000.0);
            sender.sendMessage(ChatColor.AQUA + "Duration: " + ChatColor.DARK_AQUA + minutes + ChatColor.WHITE + " minutes");
        }
        if (this.respawnDuration > 0) {
            int seconds = (int)Math.ceil((double)this.respawnDuration / 1000.0);
            sender.sendMessage(ChatColor.AQUA + "Respawn: " + ChatColor.DARK_AQUA + seconds + ChatColor.WHITE + " seconds");
        }
        if (this.startSpell != null) {
            sender.sendMessage(ChatColor.DARK_AQUA + "Cast at Start: " + ChatColor.AQUA + this.startSpell);
        }
        if (this.endSpell != null) {
            sender.sendMessage(ChatColor.DARK_AQUA + "Cast at End: " + ChatColor.AQUA + this.endSpell);
        }
        if (this.winXP > 0) {
            sender.sendMessage(ChatColor.AQUA + "Winning Reward: " + ChatColor.LIGHT_PURPLE + this.winXP + ChatColor.AQUA + " xp");
        }
        if (this.winSP > 0) {
            sender.sendMessage(ChatColor.AQUA + "Winning Reward: " + ChatColor.LIGHT_PURPLE + this.winSP + ChatColor.AQUA + " sp");
        }
        if (this.winMoney > 0) {
            sender.sendMessage(ChatColor.AQUA + "Winning Reward: $" + ChatColor.LIGHT_PURPLE + this.winMoney);
        }
    }

    protected String describeMob(ArenaMobSpawner mob) {
        if (mob == null) {
            return ChatColor.RED + "(Invalid Mob)";
        }
        if (mob.getEntity() == null) {
            return ChatColor.RED + "(Invalid Mob)" + ChatColor.YELLOW + " x" + mob.getCount();
        }
        return ChatColor.DARK_GREEN + " " + mob.getEntity().describe() + ChatColor.YELLOW + " x" + mob.getCount();
    }

    public String getStartSpell() {
        return this.startSpell;
    }

    @Override
    public void setStartSpell(String startSpell) {
        this.startSpell = startSpell;
        this.configuration.set("spell_start", (Object)startSpell);
        this.arena.saveEditingStage();
    }

    public String getEndSpell() {
        return this.endSpell;
    }

    @Override
    public void setEndSpell(String endSpell) {
        this.endSpell = endSpell;
        this.configuration.set("spell_end", (Object)endSpell);
        this.arena.saveEditingStage();
    }

    @Override
    public void addMobSpawn(Location location) {
        this.mobSpawns.add(location.clone());
        this.saveMobSpawns();
    }

    @Override
    public Location removeMobSpawn(Location location) {
        int rangeSquared = 9;
        for (Location spawn : this.mobSpawns) {
            if (!(spawn.distanceSquared(location) < (double)rangeSquared)) continue;
            this.mobSpawns.remove(spawn);
            this.saveMobSpawns();
            return spawn;
        }
        return null;
    }

    public List<Location> getMobSpawns() {
        if (this.mobSpawns.size() == 0) {
            ArrayList<Location> centerList = new ArrayList<Location>();
            centerList.add(this.arena.getCenter());
            return centerList;
        }
        return this.mobSpawns;
    }

    @Override
    public Collection<EntityData> getSpawns() {
        ArrayList<EntityData> spawns = new ArrayList<EntityData>();
        List<ArenaMobSpawner> spawners = this.getMobSpawners();
        for (ArenaMobSpawner spawner : spawners) {
            if (!spawner.isValid()) continue;
            spawns.add(spawner.getEntity());
        }
        return spawns;
    }

    public boolean hasMobs() {
        return !this.mobs.isEmpty();
    }

    @Override
    public Arena getArena() {
        return this.arena;
    }

    @Override
    public void setRandomizeMobSpawn(Vector vector) {
        this.randomizeMobSpawn = vector;
        this.configuration.set("randomize_mob_spawn", (Object)ConfigurationUtils.fromVector(this.randomizeMobSpawn));
        this.arena.saveEditingStage();
    }

    @Override
    public void setWinXP(int xp) {
        this.winXP = Math.max(xp, 0);
        this.configuration.set("win_xp", (Object)this.winXP);
        this.arena.saveEditingStage();
    }

    @Override
    public void setWinSP(int sp) {
        this.winSP = Math.max(sp, 0);
        this.configuration.set("win_sp", (Object)this.winSP);
        this.arena.saveEditingStage();
    }

    @Override
    public void setWinMoney(int money) {
        this.winMoney = Math.max(money, 0);
        this.configuration.set("win_money", (Object)this.winMoney);
        this.arena.saveEditingStage();
    }

    public List<ArenaMobSpawner> getMobSpawners() {
        return this.mobs;
    }

    @Override
    public void setDuration(int duration) {
        this.duration = duration;
        this.configuration.set("duration", (Object)duration);
        this.arena.saveEditingStage();
    }

    @Override
    public void setRespawnDuration(int duration) {
        this.respawnDuration = duration;
        this.configuration.set("respawn_duration", (Object)this.respawnDuration);
        this.arena.saveEditingStage();
    }

    public long getRespawnDuration() {
        return this.respawnDuration;
    }

    public boolean isRespawnEnabled() {
        return this.respawnDuration > 0;
    }

    public void setForceTarget(boolean forceTarget) {
        this.forceTarget = forceTarget;
        this.configuration.set("aggro", (Object)forceTarget);
        this.arena.saveEditingStage();
    }

    public void setDefaultDrops(boolean defaultDrops) {
        this.defaultDrops = defaultDrops;
        this.configuration.set("drops", (Object)defaultDrops);
        this.arena.saveEditingStage();
    }

    public ConfigurationSection getConfiguration() {
        return this.configuration;
    }
}

