/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.CastContext;
import com.elmakers.mine.bukkit.action.CheckAction;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.requirements.Requirement;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import java.util.Collection;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;

public class CheckRequirementsAction
extends CheckAction {
    private Collection<Requirement> requirements;
    private boolean sendMessage;
    private boolean useTarget;

    @Override
    public void prepare(com.elmakers.mine.bukkit.api.action.CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.useTarget = parameters.getBoolean("use_target");
        this.sendMessage = parameters.getBoolean("send_message");
        this.requirements = ConfigurationUtils.getRequirements(parameters);
        if (this.requirements == null || this.requirements.isEmpty()) {
            context.getLogger().warning("CheckRequirements action missing requirements in spell " + context.getName());
        }
    }

    @Override
    protected boolean isAllowed(com.elmakers.mine.bukkit.api.action.CastContext context) {
        if (this.requirements == null) {
            return true;
        }
        if (this.useTarget) {
            Entity targetEntity = context.getTargetEntity();
            if (targetEntity == null) {
                return false;
            }
            Entity sourceEntity = context.getEntity();
            Location sourceLocation = context.getLocation();
            Mage targetMage = context.getController().getMage(targetEntity);
            context = new CastContext(context, targetMage, targetEntity, context.getTargetLocation());
            context.setTargetEntity(sourceEntity);
            context.setTargetLocation(sourceLocation);
        }
        String message = context.getController().checkRequirements(context, this.requirements);
        if (this.sendMessage && message != null) {
            context.getMage().sendMessage(message);
        }
        return message == null;
    }
}

