/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.magic.CasterProperties;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.magic.ProgressionPath;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.api.wand.Wand;
import com.elmakers.mine.bukkit.magic.MagicPlugin;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import com.elmakers.mine.bukkit.wand.WandUpgradePath;
import java.util.Arrays;
import java.util.Collection;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class AddSpellAction
extends BaseSpellAction {
    private String spellKey;
    private String requiredPath = null;
    private String requiresCompletedPath = null;
    private String exactPath = null;
    private String permissionNode = null;
    protected boolean autoUpgrade = false;
    private String addTarget;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.addTarget = parameters.getString("add_to", "wand");
        this.permissionNode = parameters.getString("permission", null);
        this.spellKey = parameters.getString("spell");
        this.requiredPath = parameters.getString("path", null);
        this.requiresCompletedPath = parameters.getString("path_end", null);
        this.exactPath = parameters.getString("path_exact", null);
        this.autoUpgrade = parameters.getBoolean("auto_upgrade", true);
        if (this.requiresCompletedPath != null) {
            this.requiredPath = this.requiresCompletedPath;
        }
    }

    @Override
    public SpellResult perform(CastContext context) {
        ProgressionPath path;
        String wandName;
        if (this.spellKey == null || this.spellKey.isEmpty()) {
            return SpellResult.FAIL;
        }
        Mage mage = context.getMage();
        Player player = mage.getPlayer();
        if (player == null) {
            return SpellResult.PLAYER_REQUIRED;
        }
        if (this.permissionNode != null && !player.hasPermission(this.permissionNode)) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        CasterProperties caster = null;
        caster = this.addTarget.equals("wand") ? context.getWand() : (this.addTarget.equals("active_wand") ? context.checkWand() : (this.addTarget.equals("player") ? mage.getProperties() : (this.addTarget.equals("class") ? mage.getActiveClass() : (this.addTarget.equals("active") ? mage.getActiveProperties() : mage.getClass(this.addTarget)))));
        if (caster == null || caster.hasSpell(this.spellKey)) {
            return SpellResult.NO_TARGET;
        }
        CasterProperties wand = caster instanceof Wand ? caster : null;
        String string = wandName = wand == null ? "" : wand.getName();
        if (this.requiredPath != null || this.exactPath != null) {
            path = caster.getPath();
            if (path == null) {
                context.showMessage(context.getMessage("no_upgrade", "You may not learn here").replace("$wand", wandName));
                return SpellResult.FAIL;
            }
            MageController controller = context.getController();
            if (this.requiredPath != null && !path.hasPath(this.requiredPath)) {
                com.elmakers.mine.bukkit.api.wand.WandUpgradePath requiresPath = controller.getPath(this.requiredPath);
                if (requiresPath != null) {
                    context.showMessage(context.getMessage("no_required_path", "You must be at least $path!").replace("$path", requiresPath.getName()));
                } else {
                    context.getLogger().warning("Invalid path specified in AddSpell action: " + this.requiredPath);
                }
                return SpellResult.FAIL;
            }
            if (this.exactPath != null && !this.exactPath.equals(path.getKey())) {
                com.elmakers.mine.bukkit.api.wand.WandUpgradePath requiresPath = controller.getPath(this.exactPath);
                if (requiresPath != null) {
                    context.showMessage(context.getMessage("no_path_exact", "You must be at $path!").replace("$path", requiresPath.getName()));
                } else {
                    context.getLogger().warning("Invalid path specified in AddSpell action: " + this.exactPath);
                }
                return SpellResult.FAIL;
            }
            if (this.requiresCompletedPath != null) {
                ProgressionPath pathUpgrade = path.getNextPath();
                if (pathUpgrade == null) {
                    context.showMessage(context.getMessage("no_upgrade", "There is nothing more for you here.").replace("$wand", wandName));
                    return SpellResult.FAIL;
                }
                if (path.canProgress(caster)) {
                    context.showMessage(context.getMessage("no_path_end", "You must be ready to advance to $path!").replace("$path", pathUpgrade.getName()));
                    return SpellResult.FAIL;
                }
            }
        }
        if (!caster.addSpell(this.spellKey)) {
            return SpellResult.NO_TARGET;
        }
        if (wand != null) {
            wand.setActiveSpell(this.spellKey);
        }
        if (this.autoUpgrade) {
            ProgressionPath nextPath;
            path = caster.getPath();
            ProgressionPath progressionPath = nextPath = path != null ? path.getNextPath() : null;
            if (nextPath != null && path.checkUpgradeRequirements(caster, true) && !path.canProgress(caster)) {
                path.upgrade(mage, (Wand)wand);
            }
        }
        return SpellResult.CAST;
    }

    @Override
    public void getParameterNames(Spell spell, Collection<String> parameters) {
        super.getParameterNames(spell, parameters);
        parameters.add("spell");
        parameters.add("path");
        parameters.add("path_end");
        parameters.add("path_exact");
        parameters.add("permission");
        parameters.add("auto_upgrade");
        parameters.add("add_to");
    }

    @Override
    public void getParameterOptions(Spell spell, String parameterKey, Collection<String> examples) {
        if (parameterKey.equals("spell")) {
            Collection<SpellTemplate> spellList = MagicPlugin.getAPI().getSpellTemplates();
            for (SpellTemplate spellTemplate : spellList) {
                examples.add(spellTemplate.getKey());
            }
        } else if (parameterKey.equals("path") || parameterKey.equals("path_exact") || parameterKey.equals("path_end")) {
            examples.addAll(WandUpgradePath.getPathKeys());
        } else if (parameterKey.equals("auto_upgrade")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_BOOLEANS));
        } else if (parameterKey.equals("add_to")) {
            examples.add("wand");
            examples.add("active_wand");
            examples.add("player");
            examples.add("class");
            examples.add("active");
        } else {
            super.getParameterOptions(spell, parameterKey, examples);
        }
    }
}

