/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action;

import com.elmakers.mine.bukkit.action.ActionHandler;
import com.elmakers.mine.bukkit.action.CompoundAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import org.bukkit.configuration.ConfigurationSection;

public abstract class CheckAction
extends CompoundAction {
    private boolean invert;
    private int timeout;
    private Long targetTime;

    protected abstract boolean isAllowed(CastContext var1);

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.invert = parameters.getBoolean("invert", false);
        this.timeout = parameters.getInt("timeout", 0);
    }

    @Override
    public void reset(CastContext context) {
        super.reset(context);
        this.targetTime = null;
    }

    @Override
    public SpellResult start(CastContext context) {
        if (this.timeout > 0 && this.targetTime == null) {
            this.targetTime = System.currentTimeMillis() + (long)this.timeout;
        }
        return super.start(context);
    }

    @Override
    protected void addHandlers(Spell spell, ConfigurationSection parameters) {
        this.addHandler(spell, "actions");
        this.addHandler(spell, "fail");
    }

    @Override
    public SpellResult step(CastContext context) {
        ActionHandler actions;
        boolean allowed = this.isAllowed(context);
        if (this.invert) {
            boolean bl = allowed = !allowed;
        }
        if (!allowed) {
            if (this.targetTime != null && System.currentTimeMillis() < this.targetTime) {
                return SpellResult.PENDING;
            }
            ActionHandler fail = this.getHandler("fail");
            if (fail != null && fail.size() != 0) {
                return this.startActions("fail");
            }
        }
        if ((actions = this.getHandler("actions")) == null || actions.size() == 0) {
            return allowed ? SpellResult.CAST : SpellResult.STOP;
        }
        if (!allowed) {
            return SpellResult.NO_TARGET;
        }
        return this.startActions();
    }
}

