/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility.platform.base.entity;

import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.entity.EntityExtraData;
import com.elmakers.mine.bukkit.entity.SpawnedEntityExtraData;
import com.elmakers.mine.bukkit.utility.platform.PlatformInterpreter;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Art;
import org.bukkit.Location;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Painting;

public class EntityPaintingData
extends EntityExtraData {
    protected Art art;
    protected BlockFace facing;

    public EntityPaintingData(Art art, BlockFace facing) {
        this.art = art;
        this.facing = facing;
    }

    public EntityPaintingData(ConfigurationSection parameters, MageController controller) {
        String facingString;
        Logger log = controller.getLogger();
        String artString = parameters.getString("art");
        if (artString != null && !artString.isEmpty()) {
            try {
                this.art = Art.valueOf((String)artString.toUpperCase());
            }
            catch (Exception ex) {
                log.log(Level.WARNING, "Invalid art: " + artString, ex);
            }
        }
        if ((facingString = parameters.getString("facing")) != null && !facingString.isEmpty()) {
            try {
                this.facing = BlockFace.valueOf((String)facingString.toUpperCase());
            }
            catch (Exception ex) {
                log.log(Level.WARNING, "Invalid facing: " + facingString, ex);
            }
        }
    }

    public EntityPaintingData(Entity entity) {
        if (entity instanceof Painting) {
            Painting painting = (Painting)entity;
            this.art = painting.getArt();
            this.facing = painting.getFacing();
        }
    }

    @Override
    public void apply(Entity entity) {
        if (entity instanceof Painting) {
            Painting painting = (Painting)entity;
            if (this.art != null) {
                painting.setArt(this.art);
            }
            if (this.facing != null) {
                painting.setFacingDirection(this.facing, true);
            }
        }
    }

    @Override
    public SpawnedEntityExtraData spawn(Location location) {
        Painting newEntity = PlatformInterpreter.getPlatform().getCompatibilityUtils().createPainting(location, this.facing, this.art);
        return new SpawnedEntityExtraData((Entity)newEntity, false);
    }

    @Override
    public boolean cycle(Entity entity) {
        Art oldArt;
        if (!(entity instanceof Painting)) {
            return false;
        }
        Painting painting = (Painting)entity;
        Art[] artValues = Art.values();
        Art newArt = oldArt = painting.getArt();
        int ordinal = oldArt.ordinal() + 1;
        for (int i = 0; i < artValues.length; ++i) {
            newArt = artValues[ordinal++ % artValues.length];
            painting.setArt(newArt);
            newArt = painting.getArt();
            if (oldArt != newArt) break;
        }
        return oldArt != newArt;
    }

    @Override
    public boolean canCycle(Entity entity) {
        return entity instanceof Painting;
    }
}

