/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.google.common.base.Verify;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;

public class SuperProtectionAction
extends BaseSpellAction {
    private int duration;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.duration = parameters.getInt("duration");
    }

    @Override
    public SpellResult perform(CastContext context) {
        Entity targetEntity = (Entity)Verify.verifyNotNull((Object)context.getTargetEntity());
        Mage mage = context.getController().getMage(targetEntity);
        mage.enableSuperProtection(this.duration);
        return SpellResult.CAST;
    }

    @Override
    public boolean requiresTarget() {
        return true;
    }

    @Override
    public boolean requiresTargetEntity() {
        return true;
    }
}

