/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic;

import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.magic.CustomTrigger;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import javax.annotation.Nonnull;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;

public class MobTrigger
extends CustomTrigger {
    boolean requiresTarget = false;
    boolean swingArm = false;

    public MobTrigger(@Nonnull MageController controller, @Nonnull String key, @Nonnull ConfigurationSection configuration) {
        super(controller, key, configuration);
        this.requiresTarget = configuration.getBoolean("requires_target");
        this.swingArm = configuration.getBoolean("swing_arm", this.spells != null && !this.spells.isEmpty());
    }

    @Override
    public boolean isValid(Mage mage) {
        Entity entity;
        if (!super.isValid(mage)) {
            return false;
        }
        if (this.requiresTarget && (entity = mage.getEntity()) instanceof Creature) {
            return ((Creature)entity).getTarget() != null;
        }
        return true;
    }

    @Override
    protected boolean cast(Mage mage, String castSpell, ConfigurationSection parameters) {
        boolean success = super.cast(mage, castSpell, parameters);
        if (success && this.swingArm) {
            CompatibilityLib.getCompatibilityUtils().swingMainHand(mage.getEntity());
        }
        return success;
    }
}

