/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.integration;

import com.google.common.base.Preconditions;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.OfflinePlayer;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;

public class VaultController {
    private static VaultController instance;
    private Economy economy;
    private NumberFormat formatter = new DecimalFormat("#0.00");

    public static VaultController getInstance() {
        return instance;
    }

    public static boolean initialize(Plugin callingPlugin, Plugin vaultPlugin) {
        try {
            Economy economy;
            RegisteredServiceProvider ecoProvider = vaultPlugin.getServer().getServicesManager().getRegistration(Economy.class);
            Economy economy2 = economy = ecoProvider == null ? null : (Economy)ecoProvider.getProvider();
            if (economy == null) {
                callingPlugin.getLogger().info("Vault found, but no economy found");
            } else {
                callingPlugin.getLogger().info("Vault found, 'currency' cost types available");
            }
            instance = new VaultController(callingPlugin, economy);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            instance = null;
            return false;
        }
        return true;
    }

    public static boolean hasEconomy() {
        if (instance == null) {
            return false;
        }
        return VaultController.instance.economy != null;
    }

    private VaultController(Plugin owner, Economy economy) {
        this.economy = economy;
    }

    public double getBalance(OfflinePlayer player) {
        if (this.economy == null || player == null) {
            return 0.0;
        }
        return this.economy.getBalance(player);
    }

    public boolean has(OfflinePlayer player, double amount) {
        if (this.economy == null || player == null) {
            return false;
        }
        return this.economy.has(player, amount);
    }

    public String format(double amount) {
        if (this.economy == null) {
            return this.formatter.format(amount);
        }
        return this.economy.format(amount);
    }

    public String getCurrency() {
        return this.economy == null ? "" : this.economy.currencyNameSingular();
    }

    public String getCurrencyPlural() {
        return this.economy == null ? "" : this.economy.currencyNamePlural();
    }

    public boolean withdrawPlayer(OfflinePlayer player, double amount) {
        Preconditions.checkArgument((amount >= 0.0 ? 1 : 0) != 0, (String)"Amount to withdraw must be non-negative, got: %s", (Object[])new Object[]{amount});
        if (this.economy == null || player == null) {
            return false;
        }
        if (amount == 0.0) {
            return true;
        }
        EconomyResponse response = this.economy.withdrawPlayer(player, amount);
        return response.transactionSuccess();
    }

    public boolean depositPlayer(OfflinePlayer player, double amount) {
        Preconditions.checkArgument((amount >= 0.0 ? 1 : 0) != 0, (String)"Amount to withdraw must be non-negative, got: %s", (Object[])new Object[]{amount});
        if (this.economy == null || player == null) {
            return false;
        }
        if (amount == 0.0) {
            return true;
        }
        EconomyResponse response = this.economy.depositPlayer(player, amount);
        return response.transactionSuccess();
    }
}

