/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.conversations.Conversable;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.ConversationFactory;
import org.bukkit.conversations.Prompt;
import org.bukkit.entity.Entity;

public class CommandAction
extends BaseSpellAction {
    public static final String[] PARAMETERS = new String[]{"command", "console", "op", "local_echo", "modal", "timeout", "escape_sequence", "equation", "as_target"};
    private List<String> commands = new ArrayList<String>();
    private boolean asTarget;
    private boolean asConsole;
    private boolean opPlayer;
    private boolean localEcho;
    private boolean modal;
    private int timeout;
    private String escapeSequence;
    private Map<String, String> variables;
    private Double equationValue;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.parseCommands(parameters);
        this.asTarget = parameters.getBoolean("as_target", false);
        this.asConsole = parameters.getBoolean("console", false);
        this.opPlayer = parameters.getBoolean("op", false);
        this.localEcho = parameters.getBoolean("local_echo", true);
        this.modal = parameters.getBoolean("modal", false);
        this.timeout = parameters.getInt("timeout", 0);
        this.escapeSequence = parameters.getString("escape_sequence", "");
        List<String> variableNames = ConfigurationUtils.getStringList(parameters, "variables");
        if (variableNames != null && !variableNames.isEmpty()) {
            this.variables = new HashMap<String, String>();
            for (String variable : variableNames) {
                this.variables.put(variable, parameters.getString(variable, ""));
            }
        }
        this.equationValue = parameters.contains("equation") ? Double.valueOf(parameters.getDouble("equation")) : null;
    }

    private void parseCommands(ConfigurationSection parameters) {
        this.commands.clear();
        if (parameters.contains("command")) {
            String command = parameters.getString("command");
            if (command != null && command.length() > 0) {
                this.commands.add(command);
            }
        } else {
            this.commands.addAll(parameters.getStringList("commands"));
        }
    }

    @Override
    public SpellResult perform(CastContext context) {
        Entity sender;
        MageController controller = context.getController();
        if (this.asTarget) {
            Entity target = context.getTargetEntity();
            if (target == null) {
                return SpellResult.NO_TARGET;
            }
            sender = target;
        } else {
            Mage mage = context.getMage();
            Object object = sender = this.asConsole ? Bukkit.getConsoleSender() : mage.getCommandSender();
        }
        if (sender == null) {
            return SpellResult.FAIL;
        }
        ArrayDeque<String> conversationCommands = new ArrayDeque<String>(this.commands.size());
        boolean isOp = sender.isOp();
        if (this.opPlayer && !isOp) {
            sender.setOp(true);
        }
        for (String command : this.commands) {
            try {
                String converted = context.parameterize(command);
                if (this.equationValue != null) {
                    converted = converted.replace("$equation", Double.toString(this.equationValue)).replace("@equation", Integer.toString((int)this.equationValue.doubleValue()));
                }
                if (this.variables != null) {
                    for (Map.Entry<String, String> variable : this.variables.entrySet()) {
                        converted = converted.replace("$" + variable.getKey(), variable.getValue());
                    }
                }
                if (converted.contains("@arg")) {
                    conversationCommands.add(converted);
                    continue;
                }
                controller.getPlugin().getServer().dispatchCommand((CommandSender)sender, converted);
            }
            catch (Exception ex) {
                controller.getLogger().log(Level.WARNING, "Error running command: " + command, ex);
            }
        }
        if (this.opPlayer && !isOp) {
            sender.setOp(false);
        }
        if (!conversationCommands.isEmpty()) {
            this.runConversations(context, conversationCommands, this.opPlayer);
        }
        return SpellResult.CAST;
    }

    @Override
    public void getParameterNames(Spell spell, Collection<String> parameters) {
        super.getParameterNames(spell, parameters);
        parameters.addAll(Arrays.asList(PARAMETERS));
    }

    @Override
    public void getParameterOptions(Spell spell, String parameterKey, Collection<String> examples) {
        if (parameterKey.equals("command")) {
            examples.add("spawn");
            examples.add("clear");
        } else if (parameterKey.equals("escape_sequence")) {
            examples.add("$$");
            examples.add("!");
            examples.add("cancel");
        } else if (parameterKey.equals("timeout")) {
            examples.add("5");
            examples.add("10");
        } else if (parameterKey.equals("op") || parameterKey.equals("console") || parameterKey.equals("local_echo") || parameterKey.contains("modal") || parameterKey.contains("as_target")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_BOOLEANS));
        } else {
            super.getParameterOptions(spell, parameterKey, examples);
        }
    }

    private void runConversations(CastContext context, Queue<String> commands, boolean opPlayer) {
        CommandSender sender = context.getMage().getCommandSender();
        if (!(sender instanceof Conversable)) {
            return;
        }
        Conversable conversable = (Conversable)sender;
        ArgumentsPrompt argumentsPrompt = new ArgumentsPrompt(context, sender, commands, opPlayer);
        ConversationFactory factory = new ConversationFactory(context.getController().getPlugin());
        factory.withLocalEcho(this.localEcho).withModality(this.modal).withFirstPrompt((Prompt)argumentsPrompt);
        if (this.timeout > 0) {
            factory.withTimeout(this.timeout);
        }
        if (!this.escapeSequence.isEmpty()) {
            factory.withEscapeSequence(this.escapeSequence);
        }
        conversable.beginConversation(factory.buildConversation(conversable));
    }

    private static class ArgumentsPrompt
    implements Prompt {
        private final CastContext context;
        private final CommandSender sender;
        private final String currentCommand;
        private final int argCount;
        private final String[] arguments;
        private final Queue<String> remainingCommands;
        private final boolean opPlayer;
        private Integer currentArg = 1;

        public ArgumentsPrompt(CastContext context, CommandSender sender, Queue<String> remainingCommands, boolean opPlayer) {
            this.context = context;
            this.sender = sender;
            this.currentCommand = remainingCommands.poll();
            this.argCount = StringUtils.countMatches((String)this.currentCommand, (String)"@arg");
            this.arguments = new String[this.argCount];
            this.remainingCommands = remainingCommands;
            this.opPlayer = opPlayer;
        }

        public String getPromptText(ConversationContext conversationContext) {
            return this.context.getMessage("command_prompt", "Input argument $argnum of /$command").replace("$argnum", this.currentArg.toString()).replace("$command", this.currentCommand);
        }

        public boolean blocksForInput(ConversationContext conversationContext) {
            return true;
        }

        public Prompt acceptInput(ConversationContext conversationContext, String s) {
            this.arguments[this.currentArg.intValue() - 1] = s;
            Integer n = this.currentArg;
            this.currentArg = this.currentArg + 1;
            if (this.currentArg > this.argCount) {
                this.runCommand(StringUtils.replaceEach((String)this.currentCommand, (String[])new String[]{"@arg"}, (String[])this.getArguments()));
                if (!this.remainingCommands.isEmpty()) {
                    return new ArgumentsPrompt(this.context, this.sender, this.remainingCommands, this.opPlayer);
                }
                return END_OF_CONVERSATION;
            }
            return this;
        }

        public String[] getArguments() {
            return this.arguments;
        }

        private void runCommand(String command) {
            boolean isOp = this.sender.isOp();
            if (!isOp && this.opPlayer) {
                this.sender.setOp(true);
            }
            this.context.getController().getPlugin().getServer().dispatchCommand(this.sender, command);
        }
    }
}

