/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.CompoundEntityAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.block.UndoList;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import com.elmakers.mine.bukkit.utility.Target;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;

public class AreaOfEffectAction
extends CompoundEntityAction {
    protected double radius;
    protected double yRadius;
    protected double minRadius;
    protected int targetCount;
    protected boolean targetSource;
    protected boolean ignoreModified;

    @Override
    public void reset(CastContext context) {
        super.reset(context);
        this.createActionContext(context, context.getTargetEntity(), context.getTargetLocation());
    }

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        this.radius = parameters.getDouble("radius", 8.0);
        this.minRadius = parameters.getDouble("min_radius", 0.0);
        this.yRadius = parameters.getDouble("y_radius", this.radius);
        this.targetCount = parameters.getInt("target_count", -1);
        this.targetSource = parameters.getBoolean("target_source", true);
        this.ignoreModified = parameters.getBoolean("ignore_modified", false);
        Mage mage = context.getMage();
        this.radius = (int)((double)mage.getRadiusMultiplier() * this.radius);
        super.prepare(context, parameters);
    }

    @Override
    public void addEntities(CastContext context, List<WeakReference<Entity>> entities) {
        Object filtered;
        HashSet<UUID> ignore = null;
        UndoList undoList = context.getUndoList();
        if (this.ignoreModified && undoList != null) {
            ignore = new HashSet<UUID>();
            for (Entity entity : undoList.getAllEntities()) {
                ignore.add(entity.getUniqueId());
            }
        }
        context.addWork((int)Math.ceil(this.radius) + 10);
        Mage mage = context.getMage();
        Location sourceLocation = context.getTargetLocation();
        if (mage.getDebugLevel() > 8) {
            mage.sendDebugMessage(ChatColor.GREEN + "AOE Targeting from " + ChatColor.GRAY + sourceLocation.getBlockX() + ChatColor.DARK_GRAY + "," + ChatColor.GRAY + sourceLocation.getBlockY() + ChatColor.DARK_GRAY + "," + ChatColor.GRAY + sourceLocation.getBlockZ() + ChatColor.DARK_GREEN + " with radius of " + ChatColor.GREEN + this.radius + ChatColor.GRAY + " self? " + ChatColor.DARK_GRAY + context.getTargetsCaster(), 14);
        }
        Object candidates = CompatibilityLib.getCompatibilityUtils().getNearbyEntities(sourceLocation, this.radius, this.yRadius, this.radius);
        if (this.minRadius > 0.0) {
            double minRadiusSquared = this.minRadius * this.minRadius;
            filtered = new ArrayList();
            Iterator<Entity> iterator = candidates.iterator();
            while (iterator.hasNext()) {
                Entity entity = iterator.next();
                if (!(entity.getLocation().distanceSquared(sourceLocation) >= minRadiusSquared)) continue;
                filtered.add(entity);
            }
            candidates = filtered;
        }
        Entity targetEntity = context.getTargetEntity();
        if (this.targetCount > 0) {
            ArrayList<Target> targets = new ArrayList<Target>();
            filtered = candidates.iterator();
            while (filtered.hasNext()) {
                Entity entity = (Entity)filtered.next();
                boolean canTarget = true;
                if (entity == targetEntity && !this.targetSource) {
                    canTarget = false;
                }
                if (ignore != null && ignore.contains(entity.getUniqueId())) {
                    mage.sendDebugMessage(ChatColor.DARK_RED + "Ignoring Modified Target " + ChatColor.GREEN + entity.getType(), 16);
                    continue;
                }
                if (canTarget && context.canTarget(entity)) {
                    Target target = new Target(sourceLocation, entity, (int)this.radius, 0.0);
                    targets.add(target);
                    mage.sendDebugMessage(ChatColor.DARK_GREEN + "Target " + ChatColor.GREEN + entity.getType() + ChatColor.DARK_GREEN + ": " + ChatColor.YELLOW + target.getScore(), 12);
                    continue;
                }
                if (mage.getDebugLevel() <= 7) continue;
                mage.sendDebugMessage(ChatColor.DARK_RED + "Skipped Target " + ChatColor.GREEN + entity.getType(), 16);
            }
            Collections.sort(targets);
            for (int i = 0; i < this.targetCount && i < targets.size(); ++i) {
                Target target = (Target)targets.get(i);
                entities.add(new WeakReference<Entity>(target.getEntity()));
            }
        } else {
            Iterator<Entity> iterator = candidates.iterator();
            while (iterator.hasNext()) {
                Entity entity = iterator.next();
                boolean canTarget = true;
                if (entity == targetEntity && !this.targetSource) {
                    canTarget = false;
                }
                if (ignore != null && ignore.contains(entity.getUniqueId())) {
                    mage.sendDebugMessage(ChatColor.DARK_RED + "Ignoring Modified Target " + ChatColor.GREEN + entity.getType(), 16);
                    continue;
                }
                if (canTarget && context.canTarget(entity)) {
                    entities.add(new WeakReference<Entity>(entity));
                    mage.sendDebugMessage(ChatColor.DARK_GREEN + "Target " + ChatColor.GREEN + entity.getType(), 12);
                    continue;
                }
                if (mage.getDebugLevel() <= 7) continue;
                mage.sendDebugMessage(ChatColor.DARK_RED + "Skipped Target " + ChatColor.GREEN + entity.getType(), 16);
            }
        }
    }

    @Override
    public void getParameterNames(Spell spell, Collection<String> parameters) {
        super.getParameterNames(spell, parameters);
        parameters.add("radius");
        parameters.add("target_count");
        parameters.add("target_source");
    }

    @Override
    public void getParameterOptions(Spell spell, String parameterKey, Collection<String> examples) {
        if (parameterKey.equals("target_count") || parameterKey.equals("radius")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_SIZES));
        } else {
            super.getParameterOptions(spell, parameterKey, examples);
        }
    }

    @Override
    public boolean requiresTarget() {
        return true;
    }
}

