/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic.command.config;

import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.magic.command.config.HttpPost;
import com.elmakers.mine.bukkit.magic.command.config.NewSessionCallback;
import com.elmakers.mine.bukkit.magic.command.config.NewSessionRequest;
import com.elmakers.mine.bukkit.magic.command.config.NewSessionResponse;
import com.google.gson.Gson;
import org.bukkit.command.CommandSender;

public class NewSessionRunnable
extends HttpPost {
    private final NewSessionCallback callback;

    public NewSessionRunnable(MagicController controller, Gson gson, CommandSender sender, NewSessionRequest request, NewSessionCallback callback) {
        super(controller, gson, sender, gson.toJson((Object)request), controller.getEditorURL() + "/session/new");
        this.callback = callback;
    }

    @Override
    public void processResponse(String response) {
        NewSessionResponse newSessionResponse = (NewSessionResponse)this.gson.fromJson(response, NewSessionResponse.class);
        if (!newSessionResponse.isSuccess()) {
            this.fail(this.controller.getMessages().get("commands.mconfig.editor.server_error").replace("$message", newSessionResponse.getMessage()));
        } else {
            String message = this.controller.getMessages().get("commands.mconfig.editor.new_session");
            String session = newSessionResponse.getSession();
            message = message.replace("$url", this.controller.getEditorURL() + "/" + session);
            this.success(message);
            if (this.callback != null) {
                this.callback.success(session);
            }
        }
    }
}

