/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic.command.config;

import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.magic.command.config.ExampleUpdatedCallback;
import com.elmakers.mine.bukkit.magic.command.config.HttpGet;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.lang.StringUtils;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class FetchExampleRunnable
extends HttpGet {
    private final String exampleKey;
    private final boolean quiet;
    private final ExampleUpdatedCallback callback;
    private final long startTime;
    private NumberFormat fileSizeFormatter = new DecimalFormat("#0.00");

    public FetchExampleRunnable(MagicController controller, CommandSender sender, String exampleKey, String url) {
        this(controller, sender, exampleKey, url, null, false);
    }

    public FetchExampleRunnable(MagicController controller, CommandSender sender, String exampleKey, String url, ExampleUpdatedCallback callback, boolean quiet) {
        super(controller, sender, url);
        this.exampleKey = exampleKey;
        this.quiet = quiet;
        this.callback = callback;
        this.startTime = System.currentTimeMillis();
    }

    @Override
    public void processResponse(InputStream response) {
        Plugin plugin = this.controller.getPlugin();
        if (response == null) {
            this.call(plugin, this.callback);
            return;
        }
        byte[] buffer = new byte[2048];
        File examplesFolder = new File(plugin.getDataFolder(), "examples");
        examplesFolder = new File(examplesFolder, this.exampleKey);
        ArrayList<String> messages = new ArrayList<String>();
        File buildFolder = new File(examplesFolder.getPath() + ".download");
        if (buildFolder.exists()) {
            ConfigurationUtils.deleteDirectory(buildFolder);
        }
        boolean success = true;
        String minRequiredVersion = "";
        int size = 0;
        try (ZipInputStream zip = new ZipInputStream(response);){
            ZipEntry entry;
            boolean empty = true;
            boolean testedForRootFolder = false;
            String rootFolder = null;
            while ((entry = zip.getNextEntry()) != null) {
                File filePath;
                File folder;
                String entryName = entry.getName();
                if (!testedForRootFolder) {
                    testedForRootFolder = true;
                    if (entryName.contains("/")) {
                        rootFolder = StringUtils.split((String)entryName, (String)"/")[0] + "/";
                    }
                }
                if (entry.isDirectory()) continue;
                if (rootFolder != null) {
                    entryName = entryName.replace(rootFolder, "");
                }
                if ((folder = (filePath = new File(buildFolder, entryName)).getParentFile()) != null) {
                    folder.mkdirs();
                }
                try (FileOutputStream fos = new FileOutputStream(filePath);
                     BufferedOutputStream outputBuffer = new BufferedOutputStream(fos, buffer.length);){
                    int len;
                    while ((len = zip.read(buffer)) > 0) {
                        outputBuffer.write(buffer, 0, len);
                        empty = false;
                        size += len;
                    }
                }
                if (!entryName.equals("example.yml")) continue;
                YamlConfiguration exampleConfiguration = new YamlConfiguration();
                exampleConfiguration.load(filePath);
                minRequiredVersion = exampleConfiguration.getString("min_version");
                String[] minVersion = StringUtils.split((String)minRequiredVersion, (String)".");
                try {
                    String[] pluginVersion = StringUtils.split((String)plugin.getDescription().getVersion(), (String)"-");
                    pluginVersion = StringUtils.split((String)pluginVersion[0], (String)".");
                    for (int i = 0; i < minVersion.length; ++i) {
                        if (i >= pluginVersion.length) {
                            success = false;
                        } else {
                            int pluginVersionNumber = Integer.parseInt(pluginVersion[i]);
                            int minVersionNumber = Integer.parseInt(minVersion[i]);
                            if (minVersionNumber > pluginVersionNumber) {
                                success = false;
                            } else if (pluginVersionNumber <= minVersionNumber) {
                                continue;
                            }
                        }
                        break;
                    }
                }
                catch (Exception ex) {
                    this.controller.getLogger().log(Level.WARNING, "Failed to parse plugin version requirements in example " + this.exampleKey, ex);
                }
                if (success) continue;
                break;
            }
            if (empty) {
                throw new IllegalArgumentException("Empty zip file");
            }
        }
        catch (Exception ex) {
            this.fail(messages, this.controller.getMessages().get("commands.mconfig.example.fetch.error"), "Error reading zip file", ex);
            ex.printStackTrace();
            this.call(plugin, this.callback);
            return;
        }
        if (success) {
            if (examplesFolder.exists()) {
                File backupFolder = new File(examplesFolder.getPath() + ".bak");
                if (backupFolder.exists()) {
                    if (!this.quiet) {
                        messages.add(this.controller.getMessages().get("commands.mconfig.example.fetch.overwrite_backup").replace("$backup", backupFolder.getName()));
                    }
                    ConfigurationUtils.deleteDirectory(backupFolder);
                    examplesFolder.renameTo(backupFolder);
                } else {
                    if (!this.quiet) {
                        messages.add(this.controller.getMessages().get("commands.mconfig.example.fetch.backup").replace("$backup", backupFolder.getName()));
                    }
                    examplesFolder.renameTo(backupFolder);
                }
            }
        } else {
            ConfigurationUtils.deleteDirectory(buildFolder);
            this.call(plugin, this.callback);
            String message = this.controller.getMessages().get("commands.mconfig.example.fetch.outdated").replace("$example", this.exampleKey).replace("$version", minRequiredVersion);
            this.message(messages, message);
            return;
        }
        buildFolder.renameTo(examplesFolder);
        try {
            response.close();
        }
        catch (IOException ex) {
            this.controller.getLogger().log(Level.WARNING, "Error closing http connection", ex);
        }
        File urlFile = new File(examplesFolder, "url.txt");
        if (urlFile.exists()) {
            messages.add(this.controller.getMessages().get("commands.mconfig.example.fetch.url_exists").replace("$example", this.exampleKey));
        } else {
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(urlFile), StandardCharsets.UTF_8);){
                writer.write(this.url);
                if (!this.quiet) {
                    messages.add(this.controller.getMessages().get("commands.mconfig.example.fetch.url_write").replace("$example", this.exampleKey));
                }
            }
            catch (IOException ex) {
                messages.add(this.controller.getMessages().get("commands.mconfig.example.fetch.url_write_failed").replace("$example", this.exampleKey));
                this.controller.getLogger().log(Level.WARNING, "Error writing url file to example " + urlFile.getAbsolutePath(), ex);
            }
        }
        String message = this.quiet ? this.controller.getMessages().get("commands.mconfig.example.fetch.success_quiet") : this.controller.getMessages().get("commands.mconfig.example.fetch.success");
        message = message.replace("$url", this.url).replace("$example", this.exampleKey);
        long timeSince = System.currentTimeMillis() - this.startTime;
        String sinceMessage = this.controller.getMessages().getTimeDescription(timeSince, "description", "cooldown");
        message = message.replace("$time", sinceMessage);
        String fileSize = "?";
        if (size > 0) {
            fileSize = this.fileSizeFormatter.format((double)size / 1024.0 / 1024.0);
        }
        message = message.replace("$size", fileSize);
        this.success(messages, message);
        this.call(plugin, this.callback);
    }

    private void call(Plugin plugin, final ExampleUpdatedCallback callback) {
        if (callback != null) {
            plugin.getServer().getScheduler().runTask(plugin, new Runnable(){

                @Override
                public void run() {
                    callback.updated(true, FetchExampleRunnable.this.exampleKey, FetchExampleRunnable.this.url);
                }
            });
        }
    }
}

