/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.integration.skript;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.skript.registrations.Classes;
import ch.njol.util.Kleenean;
import com.elmakers.mine.bukkit.api.event.CastEvent;
import javax.annotation.Nullable;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;

@Name(value="Targets")
@Description(value={"The targets of a spell event."})
@Examples(value={"on cast:", "  damage targets by 1 heart"})
public class ExprTargets
extends SimpleExpression<Entity> {
    private static final Entity[] templateArray = new Entity[0];

    public static void register() {
        Skript.registerExpression(ExprTargets.class, Entity.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[the] (targets)"});
    }

    public boolean init(Expression<?>[] vars, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        if (!ScriptLoader.isCurrentEvent(CastEvent.class)) {
            Skript.error((String)"Cannot use 'targets' outside of a cast event", (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
            return false;
        }
        return true;
    }

    protected Entity[] get(Event e) {
        return ExprTargets.getTargets(e);
    }

    private static Entity[] getTargets(Event e) {
        if (e != null && e instanceof CastEvent) {
            return ((CastEvent)e).getSpell().getCurrentCast().getTargetedEntities().toArray(templateArray);
        }
        return new Entity[0];
    }

    public Class<? extends Entity> getReturnType() {
        return Entity.class;
    }

    public String toString(@Nullable Event e, boolean debug) {
        if (e == null) {
            return "the targets";
        }
        return Classes.getDebugMessage((Object)e);
    }

    public boolean isSingle() {
        return false;
    }
}

