/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility.platform.v1_17_0;

import com.elmakers.mine.bukkit.utility.platform.Platform;
import com.elmakers.mine.bukkit.utility.platform.base.NBTUtilsBase;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.logging.Level;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTCompressedStreamTools;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import org.bukkit.inventory.ItemStack;

public class NBTUtils
extends NBTUtilsBase {
    public NBTUtils(Platform platform) {
        super(platform);
    }

    @Override
    public Object getTag(ItemStack stack, String tag) {
        if (this.platform.getItemUtils().isEmpty(stack)) {
            return null;
        }
        Object tagObject = this.platform.getItemUtils().getTag(stack);
        if (tagObject == null || !(tagObject instanceof NBTTagCompound)) {
            return null;
        }
        return ((NBTTagCompound)tagObject).get(tag);
    }

    @Override
    public Object getTag(Object nbtBase, String tag) {
        if (nbtBase == null || !(nbtBase instanceof NBTTagCompound)) {
            return null;
        }
        return ((NBTTagCompound)nbtBase).get(tag);
    }

    @Override
    public Set<String> getAllKeys(Object nbtBase) {
        if (nbtBase == null || !(nbtBase instanceof NBTTagCompound)) {
            return null;
        }
        return ((NBTTagCompound)nbtBase).getKeys();
    }

    @Override
    public boolean contains(Object nbtBase, String tag) {
        if (nbtBase == null || !(nbtBase instanceof NBTTagCompound)) {
            return false;
        }
        return ((NBTTagCompound)nbtBase).hasKey(tag);
    }

    @Override
    public Object createTag(Object nbtBase, String tag) {
        if (nbtBase == null || !(nbtBase instanceof NBTTagCompound)) {
            return null;
        }
        NBTTagCompound compoundTag = (NBTTagCompound)nbtBase;
        NBTTagCompound meta = compoundTag.getCompound(tag);
        compoundTag.set(tag, (NBTBase)meta);
        return meta;
    }

    @Override
    public Object createTag(ItemStack stack, String tag) {
        if (this.platform.getItemUtils().isEmpty(stack)) {
            return null;
        }
        Object outputObject = this.getTag(stack, tag);
        if (outputObject == null || !(outputObject instanceof NBTTagCompound)) {
            Object craft = this.platform.getItemUtils().getHandle(stack);
            if (craft == null) {
                return null;
            }
            NBTTagCompound tagObject = (NBTTagCompound)this.platform.getItemUtils().getTag(craft);
            if (tagObject == null) {
                tagObject = new NBTTagCompound();
                ((net.minecraft.world.item.ItemStack)craft).setTag(tagObject);
            }
            outputObject = new NBTTagCompound();
            tagObject.set(tag, (NBTBase)((NBTTagCompound)outputObject));
        }
        return outputObject;
    }

    @Override
    public String getString(Object node, String tag) {
        if (node == null || !(node instanceof NBTTagCompound)) {
            return null;
        }
        return ((NBTTagCompound)node).getString(tag);
    }

    @Override
    public String getString(ItemStack stack, String tag) {
        if (this.platform.getItemUtils().isEmpty(stack)) {
            return null;
        }
        String meta = null;
        Object tagObject = this.platform.getItemUtils().getTag(stack);
        if (tagObject == null || !(tagObject instanceof NBTTagCompound)) {
            return null;
        }
        meta = ((NBTTagCompound)tagObject).getString(tag);
        return meta;
    }

    @Override
    public Byte getOptionalByte(Object node, String tag) {
        if (node == null || !(node instanceof NBTTagCompound)) {
            return null;
        }
        return ((NBTTagCompound)node).getByte(tag);
    }

    @Override
    public Short getOptionalShort(Object node, String tag) {
        if (node == null || !(node instanceof NBTTagCompound)) {
            return null;
        }
        return ((NBTTagCompound)node).getShort(tag);
    }

    @Override
    public Integer getOptionalInt(Object node, String tag) {
        if (node == null || !(node instanceof NBTTagCompound)) {
            return null;
        }
        return ((NBTTagCompound)node).getInt(tag);
    }

    @Override
    public Double getOptionalDouble(Object node, String tag) {
        if (node == null || !(node instanceof NBTTagCompound)) {
            return null;
        }
        return ((NBTTagCompound)node).getDouble(tag);
    }

    @Override
    public Boolean getOptionalBoolean(Object node, String tag) {
        if (node == null || !(node instanceof NBTTagCompound)) {
            return null;
        }
        return ((NBTTagCompound)node).getBoolean(tag);
    }

    @Override
    public byte[] getByteArray(Object tag, String key) {
        if (tag == null || !(tag instanceof NBTTagCompound)) {
            return null;
        }
        return ((NBTTagCompound)tag).getByteArray(key);
    }

    @Override
    public int[] getIntArray(Object tag, String key) {
        if (tag == null || !(tag instanceof NBTTagCompound)) {
            return null;
        }
        return ((NBTTagCompound)tag).getIntArray(key);
    }

    @Override
    public void setLong(Object node, String tag, long value) {
        if (node == null || !(node instanceof NBTTagCompound)) {
            return;
        }
        ((NBTTagCompound)node).setLong(tag, value);
    }

    @Override
    public void setBoolean(Object node, String tag, boolean value) {
        if (node == null || !(node instanceof NBTTagCompound)) {
            return;
        }
        ((NBTTagCompound)node).setBoolean(tag, value);
    }

    @Override
    public void setDouble(Object node, String tag, double value) {
        if (node == null || !(node instanceof NBTTagCompound)) {
            return;
        }
        ((NBTTagCompound)node).setDouble(tag, value);
    }

    @Override
    public void setInt(Object node, String tag, int value) {
        if (node == null || !(node instanceof NBTTagCompound)) {
            return;
        }
        ((NBTTagCompound)node).setInt(tag, value);
    }

    @Override
    public void setMetaShort(Object node, String tag, short value) {
        if (node == null || !(node instanceof NBTTagCompound)) {
            return;
        }
        ((NBTTagCompound)node).setShort(tag, value);
    }

    @Override
    public void removeMeta(Object node, String tag) {
        if (node == null || !(node instanceof NBTTagCompound)) {
            return;
        }
        ((NBTTagCompound)node).remove(tag);
    }

    @Override
    public void setTag(Object node, String tag, Object child) {
        if (node == null || !(node instanceof NBTTagCompound)) {
            return;
        }
        if (child == null) {
            ((NBTTagCompound)node).remove(tag);
        } else if (child instanceof NBTBase) {
            ((NBTTagCompound)node).set(tag, (NBTBase)child);
        }
    }

    @Override
    public boolean setTag(ItemStack stack, String tag, Object child) {
        if (this.platform.getItemUtils().isEmpty(stack)) {
            return false;
        }
        Object craft = this.platform.getItemUtils().getHandle(stack);
        if (craft == null) {
            return false;
        }
        Object node = this.platform.getItemUtils().getTag(craft);
        if (node == null || !(node instanceof NBTTagCompound)) {
            return false;
        }
        if (child == null) {
            ((NBTTagCompound)node).remove(tag);
        } else {
            ((NBTTagCompound)node).set(tag, (NBTBase)child);
        }
        return true;
    }

    @Override
    public void setString(Object node, String tag, String value) {
        if (node == null || !(node instanceof NBTTagCompound)) {
            return;
        }
        ((NBTTagCompound)node).setString(tag, value);
    }

    @Override
    public void setString(ItemStack stack, String tag, String value) {
        if (this.platform.getItemUtils().isEmpty(stack)) {
            return;
        }
        Object craft = this.platform.getItemUtils().getHandle(stack);
        if (craft == null) {
            return;
        }
        Object tagObject = this.platform.getItemUtils().getTag(craft);
        if (tagObject == null || !(tagObject instanceof NBTTagCompound)) {
            return;
        }
        ((NBTTagCompound)tagObject).setString(tag, value);
    }

    @Override
    public void setIntArray(Object tag, String key, int[] value) {
        if (tag == null || !(tag instanceof NBTTagCompound)) {
            return;
        }
        ((NBTTagCompound)tag).set(key, (NBTBase)new NBTTagIntArray(value));
    }

    @Override
    public void setByteArray(Object tag, String key, byte[] value) {
        if (tag == null || !(tag instanceof NBTTagCompound)) {
            return;
        }
        ((NBTTagCompound)tag).set(key, (NBTBase)new NBTTagByteArray(value));
    }

    @Override
    public void setEmptyList(Object tag, String key) {
        if (tag == null || !(tag instanceof NBTTagCompound)) {
            return;
        }
        ((NBTTagCompound)tag).set(key, (NBTBase)new NBTTagList());
    }

    @Override
    public void addToList(Object listObject, Object node) {
        if (listObject == null || !(listObject instanceof NBTTagList) || !(node instanceof NBTBase)) {
            return;
        }
        NBTTagList list = (NBTTagList)listObject;
        list.add((Object)((NBTBase)node));
    }

    @Override
    public Object readTagFromStream(InputStream input) {
        NBTTagCompound tag = null;
        try {
            tag = NBTCompressedStreamTools.a((InputStream)input);
        }
        catch (Exception ex) {
            this.platform.getLogger().log(Level.WARNING, "Error reading from NBT input stream", ex);
        }
        return tag;
    }

    @Override
    public boolean writeTagToStream(Object tag, OutputStream output) {
        if (tag == null || !(tag instanceof NBTTagCompound)) {
            return false;
        }
        try {
            NBTCompressedStreamTools.a((NBTTagCompound)((NBTTagCompound)tag), (OutputStream)output);
        }
        catch (Exception ex) {
            this.platform.getLogger().log(Level.WARNING, "Error writing NBT output stream", ex);
            return false;
        }
        return true;
    }

    @Override
    public Collection<Object> getTagList(Object tag, String key) {
        ArrayList<Object> list = new ArrayList<Object>();
        if (tag == null || !(tag instanceof NBTTagCompound)) {
            return list;
        }
        NBTTagList listTag = ((NBTTagCompound)tag).getList(key, 10);
        if (listTag != null) {
            int size = listTag.size();
            for (int i = 0; i < size; ++i) {
                NBTBase entry = listTag.k(i);
                list.add(entry);
            }
        }
        return list;
    }

    @Override
    public Object newCompoundTag() {
        return new NBTTagCompound();
    }
}

