/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.slikey.effectlib;

import com.elmakers.mine.bukkit.slikey.effectlib.EffectManager;
import com.elmakers.mine.bukkit.slikey.effectlib.EffectType;
import com.elmakers.mine.bukkit.slikey.effectlib.util.DynamicLocation;
import com.elmakers.mine.bukkit.slikey.effectlib.util.ParticleOptions;
import com.elmakers.mine.bukkit.slikey.effectlib.util.RandomUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public abstract class Effect
implements Runnable {
    protected final EffectManager effectManager;
    protected String subEffectClass = null;
    protected DynamicLocation origin = null;
    protected DynamicLocation target = null;
    protected int maxIterations;
    private boolean done = false;
    private boolean playing = false;
    private long startTime;
    public EffectType type = EffectType.INSTANT;
    public Particle particle;
    public Color color = null;
    public List<Color> colorList = null;
    public String colors = null;
    public Color toColor = null;
    public List<Color> toColorList = null;
    public String toColors = null;
    public int shriekDelay;
    public float sculkChargeRotation;
    public int arrivalTime;
    public ConfigurationSection subEffect = null;
    public float speed = 0.0f;
    public float particleData = 0.0f;
    public int delay = 0;
    public int period = 1;
    public int iterations = 0;
    public Integer duration = null;
    public double probability = 1.0;
    public Runnable callback = null;
    public float visibleRange = 32.0f;
    public boolean autoOrient = false;
    public Vector offset = null;
    public Vector relativeOffset = null;
    public Vector targetOffset = null;
    public float yawOffset = 0.0f;
    public float pitchOffset = 0.0f;
    public Float yaw = null;
    public Float pitch = null;
    public boolean updateLocations = true;
    public boolean updateDirections = true;
    public List<Player> targetPlayers;
    public Material material;
    public byte materialData;
    public String blockData;
    public long blockDuration;
    public int particleCount = 1;
    public float particleOffsetX = 0.0f;
    public float particleOffsetY = 0.0f;
    public float particleOffsetZ = 0.0f;
    public float particleSize = 1.0f;
    public boolean asynchronous = true;
    public boolean disappearWithOriginEntity = false;
    public boolean disappearWithTargetEntity = false;

    public EffectManager getEffectManager() {
        return this.effectManager;
    }

    @Nonnull
    public EffectType getType() {
        return this.type;
    }

    @Nullable
    public Particle getParticle() {
        return this.particle;
    }

    @Nullable
    public Color getColor() {
        return this.color;
    }

    public List<Color> getColorList() {
        return this.colorList;
    }

    public String getColors() {
        return this.colors;
    }

    @Nullable
    public Color getToColor() {
        return this.toColor;
    }

    public List<Color> getToColorList() {
        return this.toColorList;
    }

    public String getToColors() {
        return this.toColors;
    }

    public int getShriekDelay() {
        return this.shriekDelay;
    }

    public float getSculkChargeRotation() {
        return this.sculkChargeRotation;
    }

    public int getArrivalTime() {
        return this.arrivalTime;
    }

    @Nullable
    public String getSubEffectClass() {
        return this.subEffectClass;
    }

    @Nullable
    public ConfigurationSection getSubEffect() {
        return this.subEffect;
    }

    @Deprecated
    public float getSpeed() {
        return this.speed;
    }

    public float getParticleData() {
        return this.particleData;
    }

    public int getDelay() {
        return this.delay;
    }

    public int getPeriod() {
        return this.period;
    }

    public int getIterations() {
        return this.iterations;
    }

    public Integer getDuration() {
        return this.duration;
    }

    public double getProbability() {
        return this.probability;
    }

    public Runnable getCallback() {
        return this.callback;
    }

    public float getVisibleRange() {
        return this.visibleRange;
    }

    public boolean isAutoOrient() {
        return this.autoOrient;
    }

    public Vector getOffset() {
        return this.offset;
    }

    public Vector getRelativeOffset() {
        return this.relativeOffset;
    }

    public Vector getTargetOffset() {
        return this.targetOffset;
    }

    public float getYawOffset() {
        return this.yawOffset;
    }

    public float getPitchOffset() {
        return this.pitchOffset;
    }

    public Float getYaw() {
        return this.yaw;
    }

    public Float getPitch() {
        return this.pitch;
    }

    public boolean isUpdateLocations() {
        return this.updateLocations;
    }

    public boolean canUpdateDirections() {
        return this.updateDirections;
    }

    public Player getTargetPlayer() {
        if (this.targetPlayers != null && !this.targetPlayers.isEmpty()) {
            return this.targetPlayers.get(0);
        }
        return null;
    }

    public void setTargetPlayer(Player targetPlayer) {
        if (targetPlayer == null) {
            this.targetPlayers = null;
        } else {
            ArrayList<Player> list = new ArrayList<Player>();
            list.add(targetPlayer);
            this.setTargetPlayers(list);
        }
    }

    public List<Player> getTargetPlayers() {
        return this.targetPlayers;
    }

    public void setTargetPlayers(List<Player> targetPlayers) {
        this.targetPlayers = targetPlayers;
    }

    public Material getMaterial() {
        return this.material;
    }

    public void setMaterial(Material material) {
        this.material = material;
    }

    public void setType(EffectType type) {
        this.type = type;
    }

    public byte getMaterialData() {
        return this.materialData;
    }

    public void setMaterialData(byte materialData) {
        this.materialData = materialData;
    }

    public String getBlockData() {
        return this.blockData;
    }

    public void setBlockData(String blockData) {
        this.blockData = blockData;
    }

    public long getBlockDuration() {
        return this.blockDuration;
    }

    public void setBlockDuration(long blockDuration) {
        this.blockDuration = blockDuration;
    }

    public int getParticleCount() {
        return this.particleCount;
    }

    public void setParticleCount(int particleCount) {
        this.particleCount = particleCount;
    }

    public float getParticleOffsetX() {
        return this.particleOffsetX;
    }

    public void setParticleOffsetX(float particleOffsetX) {
        this.particleOffsetX = particleOffsetX;
    }

    public float getParticleOffsetY() {
        return this.particleOffsetY;
    }

    public void setParticleOffsetY(float particleOffsetY) {
        this.particleOffsetY = particleOffsetY;
    }

    public float getParticleOffsetZ() {
        return this.particleOffsetZ;
    }

    public void setParticleOffsetZ(float particleOffsetZ) {
        this.particleOffsetZ = particleOffsetZ;
    }

    public float getParticleSize() {
        return this.particleSize;
    }

    public void setParticleSize(float particleSize) {
        this.particleSize = particleSize;
    }

    public boolean isAsynchronous() {
        return this.asynchronous;
    }

    public Entity getEntity() {
        return this.origin == null ? null : this.origin.getEntity();
    }

    public void setEntity(Entity entity) {
        this.setDynamicOrigin(new DynamicLocation(entity));
    }

    public Entity getTargetEntity() {
        return this.target == null ? null : this.target.getEntity();
    }

    public void setTargetEntity(Entity entity) {
        this.target = new DynamicLocation(entity);
    }

    public final Location getLocation() {
        return this.origin == null ? null : this.origin.getLocation();
    }

    public void setLocation(Location location) {
        this.setDynamicOrigin(new DynamicLocation(location));
    }

    public final Location getTarget() {
        return this.target == null ? null : this.target.getLocation();
    }

    public void setTarget(Location location) {
        this.target = new DynamicLocation(location);
    }

    public void setTargetLocation(Location location) {
        this.target = new DynamicLocation(location);
    }

    public DynamicLocation getDynamicOrigin() {
        return this.origin;
    }

    public void setDynamicOrigin(DynamicLocation location) {
        if (location == null) {
            throw new IllegalArgumentException("Origin Location cannot be null!");
        }
        this.origin = location;
        if (this.offset != null) {
            this.origin.addOffset(this.offset);
        }
        if (this.relativeOffset != null) {
            this.origin.addRelativeOffset(this.relativeOffset);
        }
        this.origin.setDirectionOffset(this.yawOffset, this.pitchOffset);
        this.origin.setYaw(this.yaw);
        this.origin.setPitch(this.pitch);
        this.origin.setUpdateLocation(this.updateLocations);
        this.origin.setUpdateDirection(this.updateDirections);
        this.origin.updateDirection();
    }

    public DynamicLocation getDynamicTarget() {
        return this.target;
    }

    public void setDynamicTarget(DynamicLocation location) {
        this.target = location;
        if (this.target != null && this.targetOffset != null) {
            this.target.addOffset(this.targetOffset);
        }
        if (this.target == null) {
            return;
        }
        this.target.setUpdateLocation(this.updateLocations);
        this.target.setUpdateDirection(this.updateDirections);
    }

    public DynamicLocation getOrigin() {
        return this.origin;
    }

    public void setOrigin(DynamicLocation origin) {
        this.origin = origin;
    }

    public int getMaxIterations() {
        return this.maxIterations;
    }

    public void setMaxIterations(int maxIterations) {
        this.maxIterations = maxIterations;
    }

    public boolean canDisappearWithOriginEntity() {
        return this.disappearWithOriginEntity;
    }

    public boolean canDisappearWithTargetEntity() {
        return this.disappearWithTargetEntity;
    }

    public final boolean isDone() {
        return this.done;
    }

    public boolean isPlaying() {
        return this.playing;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public Effect(EffectManager effectManager) {
        if (effectManager == null) {
            throw new IllegalArgumentException("EffectManager cannot be null!");
        }
        this.effectManager = effectManager;
        this.visibleRange = effectManager.getParticleRange();
    }

    protected List<Color> parseColorList(String colors) {
        ArrayList<Color> colorList = new ArrayList<Color>();
        String[] args = colors.split(",");
        if (args.length >= 1) {
            for (String str : args) {
                try {
                    int rgb = Integer.parseInt(str.trim().replace("#", ""), 16);
                    colorList.add(Color.fromRGB((int)rgb));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return colorList;
    }

    protected void initialize() {
        if (this.period < 1) {
            this.period = 1;
        }
        if (this.colors != null) {
            this.colorList = this.parseColorList(this.colors);
        }
        if (this.toColors != null) {
            this.toColorList = this.parseColorList(this.toColors);
        }
        if (this.subEffect != null) {
            this.subEffectClass = this.subEffect.getString("subEffectClass");
        }
    }

    public final void cancel() {
        this.cancel(true);
    }

    public final void cancel(boolean callback) {
        if (callback) {
            this.done();
        } else {
            this.done = true;
        }
    }

    public abstract void onRun();

    public void onDone() {
    }

    @Override
    public final void run() {
        if (!this.validate()) {
            this.cancel();
            return;
        }
        if (this.done) {
            this.effectManager.removeEffect(this);
            return;
        }
        try {
            if (RandomUtils.checkProbability(this.probability)) {
                this.onRun();
            }
        }
        catch (Exception ex) {
            this.done();
            this.effectManager.onError(ex);
        }
        if (this.type == EffectType.REPEATING) {
            if (this.iterations == -1) {
                return;
            }
            --this.iterations;
            if (this.iterations < 1) {
                this.done();
            }
        } else {
            this.done();
        }
    }

    protected void reset() {
        this.done = false;
    }

    public void prepare() {
        this.reset();
        this.updateDuration();
    }

    public final void start() {
        this.prepare();
        this.effectManager.start(this);
        this.playing = true;
    }

    public final void infinite() {
        this.type = EffectType.REPEATING;
        this.iterations = -1;
    }

    protected final boolean validate() {
        if (this.disappearWithOriginEntity && this.origin != null && !this.origin.hasValidEntity()) {
            return false;
        }
        if (this.disappearWithTargetEntity && this.target != null && !this.target.hasValidEntity()) {
            return false;
        }
        this.updateLocation();
        this.updateTarget();
        Location location = this.getLocation();
        if (location == null) {
            return false;
        }
        if (this.autoOrient) {
            Location targetLocation;
            Location location2 = targetLocation = this.target == null ? null : this.target.getLocation();
            if (targetLocation != null) {
                Vector direction = targetLocation.toVector().subtract(location.toVector());
                location.setDirection(direction);
                targetLocation.setDirection(direction.multiply(-1));
            }
        }
        return true;
    }

    protected void updateDuration() {
        if (this.duration != null) {
            if (this.period < 1) {
                this.period = 1;
            }
            this.iterations = this.duration / this.period / 50;
        }
        this.maxIterations = this.iterations;
    }

    protected void updateLocation() {
        if (this.origin != null) {
            this.origin.update();
        }
    }

    protected void updateTarget() {
        if (this.target != null) {
            this.target.update();
        }
    }

    protected void display(Particle effect, Location location) {
        this.display(effect, location, this.color);
    }

    protected void display(Particle particle, Location location, Color color) {
        this.display(particle, location, color, this.particleData != 0.0f ? this.particleData : this.speed, this.particleCount);
    }

    protected void display(Particle particle, Location location, float speed, int amount) {
        this.display(particle, location, this.color, speed, amount);
    }

    protected void display(Particle particle, Location location, Color color, float speed, int amount) {
        this.display(particle, location, color, this.toColor, speed, amount);
    }

    protected void display(Particle particle, Location location, Color color, Color toColor, float speed, int amount) {
        if (this.particleCount >= 0) {
            Color currentColor = color;
            if (this.colorList != null && !this.colorList.isEmpty()) {
                currentColor = this.colorList.get(ThreadLocalRandom.current().nextInt(this.colorList.size()));
            }
            Color currentToColor = toColor;
            if (this.toColorList != null && !this.toColorList.isEmpty()) {
                currentToColor = this.toColorList.get(ThreadLocalRandom.current().nextInt(this.colorList.size()));
            }
            ParticleOptions options = new ParticleOptions(this.particleOffsetX, this.particleOffsetY, this.particleOffsetZ, speed, amount, this.particleSize, currentColor, currentToColor, this.arrivalTime, this.material, this.materialData, this.blockData, this.blockDuration, this.shriekDelay, this.sculkChargeRotation);
            options.target = this.target;
            this.effectManager.display(particle, options, location, this.visibleRange, this.targetPlayers);
        }
        if (this.subEffectClass != null) {
            this.effectManager.start(this.subEffectClass, this.subEffect, location);
        }
    }

    private void done() {
        this.playing = false;
        this.done = true;
        this.effectManager.done(this);
        this.onDone();
    }

    public void reloadParameters() {
    }
}

