/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.arena;

import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.arena.Arena;
import com.elmakers.mine.bukkit.arena.ArenaPlayer;
import com.elmakers.mine.bukkit.arena.ArenaTemplate;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;

public class ArenaController
implements Runnable {
    private final Map<String, ArenaTemplate> templates = new HashMap<String, ArenaTemplate>();
    private final Map<String, Arena> arenas = new HashMap<String, Arena>();
    private final Map<Player, ArenaPlayer> arenaPlayers = new WeakHashMap<Player, ArenaPlayer>();
    private final Map<Entity, Arena> arenaMobs = new WeakHashMap<Entity, Arena>();
    private final Plugin plugin;
    private final MageController magic;

    public ArenaController(MageController magic) {
        this.magic = magic;
        this.plugin = magic.getPlugin();
    }

    public void start() {
        BukkitScheduler scheduler = this.plugin.getServer().getScheduler();
        scheduler.runTaskTimer(this.plugin, (Runnable)this, 1L, 10L);
    }

    public Arena addArena(String arenaName, ArenaTemplate template, Location location) {
        Arena arena = new Arena(arenaName, template, this, location);
        this.arenas.put(arenaName, arena);
        return arena;
    }

    @Nullable
    public ArenaTemplate getTemplate(String templateKey) {
        return this.templates.get(templateKey);
    }

    public void saveData(ConfigurationSection configuration) {
        Set oldKeys = configuration.getKeys(false);
        for (String oldKey : oldKeys) {
            configuration.set(oldKey, null);
        }
        for (Arena arena : this.arenas.values()) {
            ConfigurationSection arenaConfig = configuration.createSection(arena.getKey());
            arena.save(arenaConfig);
        }
    }

    public void loadTemplates(ConfigurationSection configuration) {
        if (configuration == null) {
            return;
        }
        Set templateKeys = configuration.getKeys(false);
        this.templates.clear();
        for (String templateKey : templateKeys) {
            this.templates.put(templateKey, new ArenaTemplate(templateKey, configuration.getConfigurationSection(templateKey)));
        }
        for (Arena arena : this.arenas.values()) {
            arena.reload();
        }
    }

    public void loadArenas(ConfigurationSection configuration) {
        if (configuration == null) {
            return;
        }
        Set arenaKeys = configuration.getKeys(false);
        for (String arenaKey : arenaKeys) {
            ConfigurationSection arenaConfiguration = configuration.getConfigurationSection(arenaKey);
            String templateKey = configuration.getString("template", arenaKey);
            ArenaTemplate template = this.getTemplate(templateKey);
            Arena arena = new Arena(arenaKey, template, this);
            arena.load(arenaConfiguration);
            this.arenas.put(arenaKey, arena);
        }
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public Arena getMobArena(Entity entity) {
        return this.arenaMobs.get(entity);
    }

    public Arena getArena(String arenaName) {
        return this.arenas.get(arenaName);
    }

    public Arena getArena(Player player) {
        ArenaPlayer arenaPlayer = this.getArenaPlayer(player);
        return arenaPlayer == null || !arenaPlayer.isBattling() ? null : arenaPlayer.getArena();
    }

    public Arena getQueuedArena(Player player) {
        ArenaPlayer arenaPlayer = this.getArenaPlayer(player);
        return arenaPlayer == null ? null : arenaPlayer.getArena();
    }

    public ArenaPlayer getArenaPlayer(Player player) {
        return this.arenaPlayers.get(player);
    }

    public void unregister(Player player) {
        this.arenaPlayers.remove(player);
    }

    public void unregister(Entity entity) {
        this.arenaMobs.remove(entity);
    }

    public void register(Player player, ArenaPlayer arenaPlayer) {
        this.arenaPlayers.put(player, arenaPlayer);
    }

    public void register(Entity entity, Arena arena) {
        this.arenaMobs.put(entity, arena);
    }

    protected File getDataFile(String fileName) {
        return new File(this.plugin.getDataFolder(), fileName + ".yml");
    }

    public void remove(String arenaName) {
        Arena arena = this.arenas.remove(arenaName);
        if (arena != null) {
            arena.remove();
        }
    }

    public Collection<Arena> getArenas() {
        return this.arenas.values();
    }

    public Collection<String> getArenaKeys() {
        return this.arenas.keySet();
    }

    public Collection<String> getArenaTemplateKeys() {
        return this.templates.keySet();
    }

    public ArenaPlayer leave(Player player) {
        ArenaPlayer arenaPlayer = this.getArenaPlayer(player);
        if (arenaPlayer != null) {
            Arena arena = arenaPlayer.getArena();
            arena.remove(player);
            player.sendMessage("You have left " + arena.getName());
            arenaPlayer.teleport(arena.getExit());
            arena.check();
        }
        return arenaPlayer;
    }

    public void reset(Player player) {
        for (Arena arena : this.arenas.values()) {
            arena.reset(player);
        }
    }

    public void reset() {
        for (Arena arena : this.arenas.values()) {
            arena.reset();
        }
    }

    public MageController getMagic() {
        return this.magic;
    }

    @Override
    public void run() {
        for (Arena arena : this.arenas.values()) {
            if (!arena.isStarted()) continue;
            arena.tick();
        }
    }

    public void cancel() {
        for (Arena arena : this.arenas.values()) {
            if (!arena.isStarted()) continue;
            arena.stop();
        }
    }

    public void importArenas(CommandSender sender) {
        File saveFile;
        File pluginFolder = this.plugin.getDataFolder().getParentFile();
        File magicArenasFolder = new File(pluginFolder, "MagicArenas");
        if (!magicArenasFolder.exists()) {
            sender.sendMessage("\u00a7cCould not find MagicArenas folder, did you have it installed?");
            return;
        }
        YamlConfiguration saveConfiguration = new YamlConfiguration();
        YamlConfiguration arenaConfiguration = new YamlConfiguration();
        File arenaFile = new File(magicArenasFolder, "arenas.yml");
        if (arenaFile.exists()) {
            try {
                arenaConfiguration.load(arenaFile);
            }
            catch (IOException | InvalidConfigurationException ex) {
                sender.sendMessage("\u00a7cCould not read arena config file, please see console for errors");
                this.plugin.getLogger().log(Level.SEVERE, "Error loading " + arenaFile.getAbsolutePath(), ex);
            }
        }
        if ((saveFile = new File(magicArenasFolder, "data.yml")).exists()) {
            try {
                saveConfiguration.load(saveFile);
            }
            catch (IOException | InvalidConfigurationException ex) {
                sender.sendMessage("\u00a7cCould not read arena config file, please see console for errors");
                this.plugin.getLogger().log(Level.SEVERE, "Error loading " + arenaFile.getAbsolutePath(), ex);
            }
        }
        Set arenaKeys = arenaConfiguration.getKeys(false);
        for (String arenaKey : arenaKeys) {
            ArenaTemplate template;
            if (this.arenas.containsKey(arenaKey) || this.templates.containsKey(arenaKey)) {
                sender.sendMessage("\u00a7eSkipping " + arenaKey + ", that arena already exists");
                continue;
            }
            ConfigurationSection templateConfiguration = arenaConfiguration.getConfigurationSection(arenaKey);
            ConfigurationSection saveData = saveConfiguration.getConfigurationSection(arenaKey);
            if (saveData == null) {
                saveData = ConfigurationUtils.newConfigurationSection();
            }
            templateConfiguration.set("min_players", templateConfiguration.get("minplayers"));
            templateConfiguration.set("minplayers", null);
            templateConfiguration.set("max_players", templateConfiguration.get("maxplayers"));
            templateConfiguration.set("maxplayers", null);
            saveData.set("location", templateConfiguration.get("center"));
            Location center = ConfigurationUtils.toLocation(templateConfiguration.getString("center"));
            if (center != null) {
                templateConfiguration.set("center", null);
                templateConfiguration.set("leaderboard_sign_location", (Object)ConfigurationUtils.fromLocation(ConfigurationUtils.toLocation(templateConfiguration.getString("leaderboard_sign_location"), center), center));
                templateConfiguration.set("lose", (Object)ConfigurationUtils.fromLocation(ConfigurationUtils.toLocation(templateConfiguration.getString("lose"), center), center));
                templateConfiguration.set("win", (Object)ConfigurationUtils.fromLocation(ConfigurationUtils.toLocation(templateConfiguration.getString("win"), center), center));
                templateConfiguration.set("lobby", (Object)ConfigurationUtils.fromLocation(ConfigurationUtils.toLocation(templateConfiguration.getString("lobby"), center), center));
                templateConfiguration.set("exit", (Object)ConfigurationUtils.fromLocation(ConfigurationUtils.toLocation(templateConfiguration.getString("exit"), center), center));
                List<String> spawnList = ConfigurationUtils.getStringList(templateConfiguration, "spawns");
                if (spawnList != null) {
                    ArrayList<String> converted = new ArrayList<String>();
                    for (String spawnLocation : spawnList) {
                        converted.add(ConfigurationUtils.fromLocation(ConfigurationUtils.toLocation(spawnLocation, center), center));
                    }
                    templateConfiguration.set("spawns", converted);
                }
            }
            if ((template = this.templates.get(arenaKey)) != null) {
                sender.sendMessage("\u00a7eNot replacing existing template " + arenaKey + ", imported arena will use existing template");
            } else {
                template = new ArenaTemplate(arenaKey, templateConfiguration);
                this.templates.put(arenaKey, template);
                File templateFile = new File(this.magic.getPlugin().getDataFolder(), "arenas/" + arenaKey + ".yml");
                if (templateFile.exists()) {
                    sender.sendMessage("\u00a7eSkipping " + arenaKey + ", the template file exists already but isn't loaded, don't know what to do");
                    continue;
                }
                YamlConfiguration yaml = new YamlConfiguration();
                yaml.set(arenaKey, (Object)templateConfiguration);
                try {
                    yaml.save(templateFile);
                }
                catch (Exception ex) {
                    this.magic.getLogger().log(Level.SEVERE, "Error saving to " + templateFile.getAbsolutePath(), ex);
                    sender.sendMessage("\u00a7eSkipping " + arenaKey + ", the template file could not be written to, check logs");
                    continue;
                }
            }
            Arena arena = new Arena(arenaKey, template, this);
            arena.load(saveData);
            this.arenas.put(arenaKey, arena);
            sender.sendMessage("\u00a7bImported " + arenaKey);
        }
        this.magic.getAPI().save();
    }
}

