/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility.platform.v1_11.entity;

import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.utility.ConfigUtils;
import com.elmakers.mine.bukkit.utility.platform.v1_11.entity.EntityChestedHorseData;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Llama;

public class EntityLlamaData
extends EntityChestedHorseData {
    private Llama.Color color;
    private Integer strength;

    public EntityLlamaData(ConfigurationSection parameters, MageController controller) {
        super(parameters, controller);
        Logger log = controller.getLogger();
        String colorString = parameters.getString("llama_color");
        if (colorString != null && !colorString.isEmpty()) {
            try {
                this.color = Llama.Color.valueOf((String)colorString.toUpperCase());
            }
            catch (Exception ex) {
                log.log(Level.WARNING, "Invalid llama_color: " + colorString, ex);
            }
        }
        this.strength = ConfigUtils.getOptionalInteger(parameters, "llama_strength");
    }

    public EntityLlamaData(Entity entity, MageController controller) {
        super(entity, controller);
        if (entity instanceof Llama) {
            Llama llama = (Llama)entity;
            this.color = llama.getColor();
            this.strength = llama.getStrength();
        }
    }

    @Override
    public void apply(Entity entity) {
        super.apply(entity);
        if (entity instanceof Llama) {
            Llama llama = (Llama)entity;
            if (this.color != null) {
                llama.setColor(this.color);
            }
            if (this.strength != null && this.strength > 0 && this.strength < 6) {
                llama.setStrength(this.strength.intValue());
            }
        }
    }

    @Override
    public boolean cycle(Entity entity) {
        if (!this.canCycle(entity)) {
            return false;
        }
        Llama llama = (Llama)entity;
        Llama.Color type = llama.getColor();
        Llama.Color[] typeValues = Llama.Color.values();
        int typeOrdinal = (type.ordinal() + 1) % typeValues.length;
        type = typeValues[typeOrdinal];
        llama.setColor(type);
        return true;
    }

    @Override
    public boolean canCycle(Entity entity) {
        return entity instanceof Llama;
    }
}

