/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility.platform.modern;

import com.elmakers.mine.bukkit.utility.Base64Coder;
import com.elmakers.mine.bukkit.utility.platform.Platform;
import com.elmakers.mine.bukkit.utility.platform.base.SkinUtilsBase;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.entity.Player;

public class ModernSkinUtils
extends SkinUtilsBase {
    public ModernSkinUtils(Platform platform) {
        super(platform);
    }

    protected String getValue(Property property) {
        return property.getValue();
    }

    protected String getSignature(Property property) {
        return property.getSignature();
    }

    @Override
    public String getProfileURL(Object profile) {
        String url = null;
        if (profile == null || !(profile instanceof GameProfile)) {
            return null;
        }
        GameProfile gameProfile = (GameProfile)profile;
        PropertyMap properties = gameProfile.getProperties();
        if (properties == null) {
            return null;
        }
        Collection textures = properties.get((Object)"textures");
        if (textures != null && textures.size() > 0) {
            Property textureProperty = (Property)textures.iterator().next();
            String texture = this.getValue(textureProperty);
            try {
                String decoded = Base64Coder.decodeString(texture);
                url = this.getTextureURL(decoded);
            }
            catch (Exception ex) {
                this.platform.getLogger().log(Level.WARNING, "Could not parse textures in profile", ex);
            }
        }
        return url;
    }

    @Override
    public Object getProfile(Player player) {
        return this.platform.getCompatibilityUtils().getProfile(player);
    }

    @Override
    public JsonElement getProfileJson(Object profile) {
        if (!(profile instanceof GameProfile)) {
            return null;
        }
        GameProfile gameProfile = (GameProfile)profile;
        JsonElement profileJson = this.getGson().toJsonTree((Object)gameProfile);
        if (profileJson.isJsonObject()) {
            JsonObject profileObject = (JsonObject)profileJson;
            PropertyMap properties = gameProfile.getProperties();
            JsonArray propertiesArray = new JsonArray();
            for (Map.Entry entry : properties.entries()) {
                JsonObject newObject = new JsonObject();
                newObject.addProperty("name", (String)entry.getKey());
                String value = this.getValue((Property)entry.getValue());
                newObject.addProperty("value", value);
                String signature = this.getSignature((Property)entry.getValue());
                newObject.addProperty("signature", signature);
                propertiesArray.add((JsonElement)newObject);
            }
            profileObject.add("properties", (JsonElement)propertiesArray);
        }
        return profileJson;
    }

    @Override
    public Object getGameProfile(UUID uuid, String playerName, String profileJSON) {
        GameProfile gameProfile = null;
        try {
            JsonObject profile;
            gameProfile = new GameProfile(uuid, playerName);
            PropertyMap properties = gameProfile.getProperties();
            JsonElement json = new JsonParser().parse(profileJSON);
            if (json != null && json.isJsonObject() && (profile = json.getAsJsonObject()).has("properties")) {
                JsonArray propertiesJson = profile.getAsJsonArray("properties");
                for (int i = 0; i < propertiesJson.size(); ++i) {
                    JsonObject property = propertiesJson.get(i).getAsJsonObject();
                    if (property == null || !property.has("name") || !property.has("value")) continue;
                    String name = property.get("name").getAsString();
                    String value = property.get("value").getAsString();
                    String signature = property.has("signature") ? property.get("signature").getAsString() : null;
                    Property newProperty = new Property(name, value, signature);
                    properties.put((Object)name, (Object)newProperty);
                }
            }
        }
        catch (Exception ex) {
            this.platform.getLogger().log(Level.WARNING, "Error creating GameProfile", ex);
        }
        return gameProfile;
    }
}

