/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility.help;

import com.elmakers.mine.bukkit.ChatUtils;
import com.elmakers.mine.bukkit.utility.help.Help;
import com.elmakers.mine.bukkit.utility.help.HelpTopic;
import com.elmakers.mine.bukkit.utility.help.HelpTopicKeywordMatch;
import com.elmakers.mine.bukkit.utility.help.SearchFactors;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

public class HelpTopicMatch
implements Comparable<HelpTopicMatch> {
    private static final int MAX_WIDTH = 50;
    private final double relevance;
    private final HelpTopic topic;
    private final Map<String, HelpTopicKeywordMatch> wordMatches = new HashMap<String, HelpTopicKeywordMatch>();
    private final Map<String, HelpTopicKeywordMatch> setMatches = new HashMap<String, HelpTopicKeywordMatch>();
    private double wordsRelevance;
    private double titleRelevance;
    private double tagRelevance;
    private double extraRelevance;

    @Nonnull
    public static HelpTopicMatch match(Help help, HelpTopic topic, Collection<String> keywords) {
        return new HelpTopicMatch(help, topic, keywords);
    }

    private HelpTopicMatch(Help help, HelpTopic topic, Collection<String> keywords) {
        this.topic = topic;
        double relevance = 0.0;
        for (String keyword : keywords) {
            relevance += this.computeRelevance(help, keyword);
        }
        if (!keywords.isEmpty()) {
            relevance /= (double)keywords.size();
            this.wordsRelevance /= (double)keywords.size();
            this.titleRelevance /= (double)keywords.size();
            this.tagRelevance /= (double)keywords.size();
            this.extraRelevance /= (double)keywords.size();
        }
        this.relevance = relevance * topic.getWeight();
    }

    public String getDebugText() {
        String debugText = "Topic: " + ChatUtils.printPercentage(this.topic.getWeight());
        if (this.wordsRelevance > 0.0) {
            debugText = debugText + " Word: " + ChatUtils.printPercentage(this.wordsRelevance) + "x" + SearchFactors.CONTENT_WEIGHT;
        }
        if (this.titleRelevance > 0.0) {
            debugText = debugText + " Title: " + ChatUtils.printPercentage(this.titleRelevance) + "x" + SearchFactors.TITLE_WEIGHT;
        }
        if (this.tagRelevance > 0.0) {
            debugText = debugText + " Tags: " + ChatUtils.printPercentage(this.tagRelevance) + "x" + SearchFactors.TAG_WEIGHT;
        }
        if (this.extraRelevance > 0.0) {
            debugText = debugText + " Extra: " + ChatUtils.printPercentage(this.extraRelevance) + "x" + SearchFactors.EXTRA_WEIGHT;
        }
        return debugText;
    }

    private double computeRelevance(Help help, String keyword) {
        double extraRelevance;
        double tagRelevance;
        double titleRelevance;
        double maxRelevance = 0.0;
        double wordsRelevance = this.computeWordsRelevance(help, keyword);
        if (wordsRelevance > 0.0) {
            wordsRelevance = Math.pow(wordsRelevance, SearchFactors.CONTENT_FACTOR) * SearchFactors.CONTENT_WEIGHT;
            this.wordsRelevance += wordsRelevance;
            maxRelevance = Math.max(wordsRelevance, maxRelevance);
        }
        if ((titleRelevance = this.computeSetRelevance(help, this.topic.titleWords, keyword, SearchFactors.MIN_TITLE_SIMILARITY)) > 0.0) {
            titleRelevance = Math.pow(titleRelevance, SearchFactors.TITLE_FACTOR) * SearchFactors.TITLE_WEIGHT;
            this.titleRelevance += titleRelevance;
            maxRelevance = Math.max(titleRelevance, maxRelevance);
        }
        if ((tagRelevance = this.computeSetRelevance(help, this.topic.tagWords, keyword, SearchFactors.MIN_TAG_SIMILARITY)) > 0.0) {
            tagRelevance = Math.pow(tagRelevance, SearchFactors.TAG_FACTOR) * SearchFactors.TAG_WEIGHT;
            this.tagRelevance += tagRelevance;
            maxRelevance = Math.max(tagRelevance, maxRelevance);
        }
        if ((extraRelevance = this.computeSetRelevance(help, this.topic.extraWords, keyword, SearchFactors.MIN_EXTRA_SIMILARITY)) > 0.0) {
            extraRelevance = Math.pow(extraRelevance, SearchFactors.EXTRA_FACTOR) * SearchFactors.EXTRA_WEIGHT;
            this.extraRelevance += extraRelevance;
            maxRelevance = Math.max(extraRelevance, maxRelevance);
        }
        return maxRelevance / SearchFactors.MAX_WEIGHT;
    }

    private double computeSetRelevance(Help help, Set<String> words, String keyword, double minSimilarity) {
        HelpTopicKeywordMatch match = HelpTopicKeywordMatch.match(keyword, words, help, minSimilarity);
        if (match != null) {
            this.setMatches.put(keyword, match);
        }
        return match == null ? 0.0 : match.getRelevance();
    }

    private HelpTopicKeywordMatch getWordMatch(Help help, String keyword) {
        HelpTopicKeywordMatch match = this.wordMatches.get(keyword);
        if (match == null && (match = HelpTopicKeywordMatch.match(keyword, this.topic, help)) != null) {
            this.wordMatches.put(keyword, match);
        }
        return match;
    }

    private double computeWordsRelevance(Help help, String keyword) {
        HelpTopicKeywordMatch match = this.getWordMatch(help, keyword);
        if (match == null) {
            return 0.0;
        }
        return match.getRelevance();
    }

    @Override
    public int compareTo(HelpTopicMatch o) {
        return o.relevance > this.relevance ? 1 : (o.relevance < this.relevance ? -1 : 0);
    }

    @Nonnull
    public HelpTopic getTopic() {
        return this.topic;
    }

    public String getSummary(boolean forConsole) {
        return this.getSummary(50, "\u00a7b", "\u00a7r", !forConsole);
    }

    public String getSummary(int maxWidth, String matchPrefix, String matchSuffix) {
        return this.getSummary(maxWidth, matchPrefix, matchSuffix, false);
    }

    public String getSummary(int maxWidth, String matchPrefix, String matchSuffix, boolean addTooltips) {
        String title = this.getTopic().getTitle();
        int titleLength = title.length();
        if (titleLength > maxWidth - 4) {
            return "";
        }
        int remainingLength = maxWidth - titleLength;
        String[] lines = this.topic.getLines();
        if (lines.length == 0) {
            return "";
        }
        double mostRelevant = 0.0;
        String summary = null;
        for (String line : lines) {
            if (line.trim().isEmpty()) continue;
            String matchLine = line.toLowerCase();
            int firstMatchIndex = -1;
            int lastMatchEnd = -1;
            double relevance = 0.0;
            int matchCount = 0;
            for (HelpTopicKeywordMatch match : this.wordMatches.values()) {
                String keyword;
                int startIndex;
                if (!match.allowHighlight(this.topic) || (startIndex = matchLine.indexOf(keyword = match.getWord())) < 0) continue;
                double matchRelevance = match.getRelevance();
                if (matchRelevance > 0.0) {
                    relevance += matchRelevance;
                    ++matchCount;
                }
                int endIndex = startIndex + keyword.length();
                if (firstMatchIndex == -1) {
                    firstMatchIndex = startIndex;
                    lastMatchEnd = endIndex;
                    continue;
                }
                firstMatchIndex = Math.min(firstMatchIndex, startIndex);
                lastMatchEnd = Math.max(lastMatchEnd, endIndex);
            }
            if (!(relevance > 0.0) || !(relevance > mostRelevant)) continue;
            boolean fitAllMatches = true;
            mostRelevant = relevance;
            if (line.length() > remainingLength) {
                if (lastMatchEnd < remainingLength) {
                    line = line.substring(0, remainingLength) + "\u00a77" + "...";
                } else if (line.length() - firstMatchIndex < remainingLength) {
                    line = "\u00a77...\u00a7r" + line.substring(line.length() - remainingLength);
                } else if (lastMatchEnd - firstMatchIndex < remainingLength) {
                    int padding = remainingLength - (lastMatchEnd - firstMatchIndex);
                    int startIndex = firstMatchIndex - padding / 2;
                    line = "\u00a77...\u00a7r" + line.substring(startIndex, startIndex + remainingLength) + "\u00a77" + "...";
                } else {
                    line = "\u00a77..." + line.substring(firstMatchIndex, firstMatchIndex + remainingLength) + "\u00a77" + "...";
                    fitAllMatches = false;
                }
            }
            summary = line;
            if (fitAllMatches && matchCount == this.wordMatches.size()) break;
        }
        if (summary == null && (summary = lines[0]).length() > remainingLength) {
            summary = summary.substring(0, remainingLength) + "\u00a77" + "...";
        }
        ArrayList<String> replacements = new ArrayList<String>();
        for (HelpTopicKeywordMatch match : this.wordMatches.values()) {
            if (!match.allowHighlight(this.topic)) continue;
            String keyword = match.getWord();
            Pattern pattern = Pattern.compile("((?i)" + Pattern.quote(keyword) + ")");
            Matcher matcher = pattern.matcher(summary);
            StringBuffer highlighted = new StringBuffer();
            while (matcher.find()) {
                String replacement = matcher.group(1);
                if (addTooltips) {
                    String hover = "Matched " + match.getKeyword() + " at " + ChatUtils.printPercentage(match.getSimilarity()) + " with " + ChatUtils.printPercentage(match.getRelevance()) + " relevance";
                    replacement = "`{\"text\":\"" + replacement.replace("\"", "\\\"") + "\",";
                    replacement = replacement + "\"hoverEvent\":{\"action\":\"show_text\",\"contents\":\"" + hover + "\"}}`";
                }
                replacement = matchPrefix + replacement + matchSuffix;
                matcher.appendReplacement(highlighted, "@|" + replacements.size() + "|@");
                replacements.add(replacement);
            }
            matcher.appendTail(highlighted);
            summary = highlighted.toString();
        }
        for (int i = 0; i < replacements.size(); ++i) {
            summary = summary.replace("@|" + i + "|@", (CharSequence)replacements.get(i));
        }
        return summary;
    }

    public HelpTopicKeywordMatch getKeywordMatch(String keyword) {
        HelpTopicKeywordMatch match = this.setMatches.get(keyword);
        if (match == null) {
            match = this.wordMatches.get(keyword);
        }
        return match;
    }

    public double getRelevance() {
        return this.relevance;
    }

    public boolean isRelevant() {
        return this.relevance > 0.0;
    }
}

