/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility.platform.v1_18_2.goal;

import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.requirements.Requirement;
import com.elmakers.mine.bukkit.utility.platform.v1_18_2.goal.MagicGoal;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import org.apache.commons.lang.StringUtils;
import org.bukkit.ChatColor;

public class RequirementsGoal
extends MagicGoal {
    private final Collection<Requirement> requirements;
    private final Mage mage;

    public RequirementsGoal(Mage mage, Collection<PathfinderGoal> goals, boolean interruptable, Collection<Requirement> requirements) {
        super(goals, interruptable);
        this.mage = mage;
        this.requirements = requirements;
    }

    @Override
    public boolean a() {
        return super.a() && this.checkRequirements();
    }

    @Override
    public boolean b() {
        return super.b() && this.checkRequirements();
    }

    protected boolean checkRequirements() {
        MageController controller = this.mage.getController();
        return controller.checkRequirements(this.mage.getContext(), this.requirements) == null;
    }

    @Override
    protected String getDescription() {
        ArrayList<String> requirementDescriptions = new ArrayList<String>();
        for (Requirement requirement : this.requirements) {
            requirementDescriptions.add(requirement.toString());
        }
        return "Requirements" + ChatColor.GRAY + "(" + ChatColor.DARK_AQUA + StringUtils.join(requirementDescriptions, (String)" ") + ChatColor.GRAY + ")";
    }
}

