/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.protection;

import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.api.wand.Wand;
import com.elmakers.mine.bukkit.protection.WGCustomFlagsManager;
import com.elmakers.mine.bukkit.protection.WorldGuardFlags;
import com.elmakers.mine.bukkit.protection.WorldGuardFlagsManager;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.domains.Association;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.association.Associables;
import com.sk89q.worldguard.protection.association.RegionAssociable;
import com.sk89q.worldguard.protection.events.DisallowedPVPEvent;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.managers.RegionManager;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class WorldGuardAPI {
    private final Plugin owningPlugin;
    private Object worldGuard = null;
    private WorldGuardPlugin worldGuardPlugin = null;
    private WorldGuardFlags customFlags = null;
    private Object regionContainer = null;
    private Method regionContainerGetMethod = null;
    private Method createQueryMethod = null;
    private Method regionQueryTestStateMethod = null;
    private Method locationAdaptMethod = null;
    private Method worldAdaptMethod = null;
    private Method regionManagerGetMethod = null;
    private Constructor<?> vectorConstructor = null;
    private Method vectorConstructorAsAMethodBecauseWhyNot = null;
    private StateFlag buildFlag;
    private StateFlag pvpFlag;
    private StateFlag exitFlag;
    private boolean initialized = false;
    private int cacheDuration;
    private long lastCacheClear;
    private Map<Location, ApplicableRegionSet> cachedSets = new HashMap<Location, ApplicableRegionSet>();

    public boolean isEnabled() {
        return this.worldGuardPlugin != null;
    }

    public WorldGuardAPI(Plugin plugin, Plugin owningPlugin) {
        this.owningPlugin = owningPlugin;
        if (plugin instanceof WorldGuardPlugin) {
            this.worldGuardPlugin = (WorldGuardPlugin)plugin;
            try {
                Class<?> worldGuardClass = Class.forName("com.sk89q.worldguard.WorldGuard");
                Method getInstanceMethod = worldGuardClass.getMethod("getInstance", new Class[0]);
                this.worldGuard = getInstanceMethod.invoke(null, new Object[0]);
                owningPlugin.getLogger().info("Found WorldGuard 7+");
            }
            catch (Exception ex) {
                owningPlugin.getLogger().info("Found WorldGuard <7");
            }
            try {
                owningPlugin.getLogger().info("Pre-check for WorldGuard custom flag registration");
                this.customFlags = new WorldGuardFlagsManager(owningPlugin, this.worldGuardPlugin, this.worldGuard);
            }
            catch (NoSuchMethodError incompatible) {
                owningPlugin.getLogger().log(Level.WARNING, "NOFLAGS", incompatible);
            }
            catch (Throwable ex) {
                owningPlugin.getLogger().log(Level.WARNING, "Unexpected error setting up custom flags, please make sure you are on WorldGuard 6.2 or above", ex);
            }
        }
    }

    public void configurePvpListener(Plugin owningPlugin) {
        if (this.worldGuard == null) {
            Bukkit.getPluginManager().registerEvents((Listener)new AllowPvpWhenDamagingController(), owningPlugin);
        }
    }

    public void checkFlagSupport() {
        if (this.customFlags == null) {
            try {
                Plugin customFlagsPlugin = this.owningPlugin.getServer().getPluginManager().getPlugin("WGCustomFlags");
                if (customFlagsPlugin != null) {
                    this.customFlags = new WGCustomFlagsManager(customFlagsPlugin);
                }
            }
            catch (Throwable ex) {
                this.owningPlugin.getLogger().log(Level.WARNING, "Error integration with WGCustomFlags", ex);
            }
            if (this.customFlags != null) {
                this.owningPlugin.getLogger().info("WGCustomFlags found, added custom flags");
            } else {
                this.owningPlugin.getLogger().log(Level.WARNING, "Failed to set up custom flags, please make sure you are on WorldGuard 6.2 or above, or use the WGCustomFlags plugin");
            }
        }
    }

    protected RegionAssociable getAssociable(Player player) {
        Object associable = player == null ? Associables.constant((Association)Association.NON_MEMBER) : this.worldGuardPlugin.wrapPlayer(player);
        return associable;
    }

    private void initialize() {
        if (!this.initialized) {
            this.initialized = true;
            if (this.worldGuard != null) {
                try {
                    Method getPlatFormMethod = this.worldGuard.getClass().getMethod("getPlatform", new Class[0]);
                    Object platform = getPlatFormMethod.invoke(this.worldGuard, new Object[0]);
                    Method getRegionContainerMethod = platform.getClass().getMethod("getRegionContainer", new Class[0]);
                    this.regionContainer = getRegionContainerMethod.invoke(platform, new Object[0]);
                    this.createQueryMethod = this.regionContainer.getClass().getMethod("createQuery", new Class[0]);
                    Class<?> worldEditLocationClass = Class.forName("com.sk89q.worldedit.util.Location");
                    Class<?> worldEditWorldClass = Class.forName("com.sk89q.worldedit.world.World");
                    Class<?> worldEditAdapterClass = Class.forName("com.sk89q.worldedit.bukkit.BukkitAdapter");
                    this.worldAdaptMethod = worldEditAdapterClass.getMethod("adapt", World.class);
                    this.locationAdaptMethod = worldEditAdapterClass.getMethod("adapt", Location.class);
                    this.regionContainerGetMethod = this.regionContainer.getClass().getMethod("get", worldEditWorldClass);
                    Class<?> regionQueryClass = Class.forName("com.sk89q.worldguard.protection.regions.RegionQuery");
                    this.regionQueryTestStateMethod = regionQueryClass.getMethod("testState", worldEditLocationClass, RegionAssociable.class, StateFlag[].class);
                    Class<?> flagsClass = Class.forName("com.sk89q.worldguard.protection.flags.Flags");
                    this.buildFlag = (StateFlag)flagsClass.getField("BUILD").get(null);
                    this.pvpFlag = (StateFlag)flagsClass.getField("PVP").get(null);
                    this.exitFlag = (StateFlag)flagsClass.getField("EXIT").get(null);
                }
                catch (Exception ex) {
                    this.owningPlugin.getLogger().log(Level.WARNING, "Failed to bind to WorldGuard, integration will not work!", ex);
                    this.regionContainer = null;
                    return;
                }
            }
            this.regionContainer = this.worldGuardPlugin.getRegionContainer();
            try {
                this.createQueryMethod = this.regionContainer.getClass().getMethod("createQuery", new Class[0]);
                this.regionContainerGetMethod = this.regionContainer.getClass().getMethod("get", World.class);
                Class<?> regionQueryClass = Class.forName("com.sk89q.worldguard.bukkit.RegionQuery");
                this.regionQueryTestStateMethod = regionQueryClass.getMethod("testState", Location.class, RegionAssociable.class, StateFlag[].class);
                Class<?> flagsClass = Class.forName("com.sk89q.worldguard.protection.flags.DefaultFlag");
                this.buildFlag = (StateFlag)flagsClass.getField("BUILD").get(null);
                this.pvpFlag = (StateFlag)flagsClass.getField("PVP").get(null);
                this.exitFlag = (StateFlag)flagsClass.getField("EXIT").get(null);
            }
            catch (Exception ex) {
                this.owningPlugin.getLogger().log(Level.WARNING, "Failed to bind to WorldGuard, integration will not work!", ex);
                this.regionContainer = null;
                return;
            }
            try {
                Class<?> vectorClass = Class.forName("com.sk89q.worldedit.Vector");
                this.vectorConstructor = vectorClass.getConstructor(Double.TYPE, Double.TYPE, Double.TYPE);
                this.regionManagerGetMethod = RegionManager.class.getMethod("getApplicableRegions", vectorClass);
            }
            catch (Exception ex) {
                try {
                    Class<?> vectorClass = Class.forName("com.sk89q.worldedit.math.BlockVector3");
                    this.vectorConstructorAsAMethodBecauseWhyNot = vectorClass.getMethod("at", Double.TYPE, Double.TYPE, Double.TYPE);
                    this.regionManagerGetMethod = RegionManager.class.getMethod("getApplicableRegions", vectorClass);
                }
                catch (Exception sodonewiththis) {
                    this.owningPlugin.getLogger().log(Level.WARNING, "Failed to bind to WorldGuard (no Vector class?), integration will not work!", ex);
                    this.regionContainer = null;
                    return;
                }
            }
            if (this.regionContainer == null) {
                this.owningPlugin.getLogger().warning("Failed to find RegionContainer, WorldGuard integration will not function!");
            }
        }
    }

    @Nullable
    private RegionManager getRegionManager(World world) {
        this.initialize();
        if (this.regionContainer == null || this.regionContainerGetMethod == null) {
            return null;
        }
        RegionManager regionManager = null;
        try {
            if (this.worldAdaptMethod != null) {
                Object worldEditWorld = this.worldAdaptMethod.invoke(null, world);
                regionManager = (RegionManager)this.regionContainerGetMethod.invoke(this.regionContainer, worldEditWorld);
            } else {
                regionManager = (RegionManager)this.regionContainerGetMethod.invoke(this.regionContainer, world);
            }
        }
        catch (Exception ex) {
            this.owningPlugin.getLogger().log(Level.WARNING, "An error occurred looking up a WorldGuard RegionManager", ex);
        }
        return regionManager;
    }

    @Nullable
    private ApplicableRegionSet getRegionSet(Location location) {
        RegionManager regionManager;
        long now = System.currentTimeMillis();
        if (this.cacheDuration > 0) {
            ApplicableRegionSet regionSet;
            if (now > this.lastCacheClear + (long)this.cacheDuration) {
                this.cachedSets.clear();
                this.lastCacheClear = now;
            }
            if ((regionSet = this.cachedSets.get(location)) != null) {
                return regionSet;
            }
        }
        if ((regionManager = this.getRegionManager(location.getWorld())) == null) {
            return null;
        }
        try {
            Object vector = this.vectorConstructorAsAMethodBecauseWhyNot == null ? this.vectorConstructor.newInstance(location.getX(), location.getY(), location.getZ()) : this.vectorConstructorAsAMethodBecauseWhyNot.invoke(null, location.getX(), location.getY(), location.getZ());
            ApplicableRegionSet regionSet = (ApplicableRegionSet)this.regionManagerGetMethod.invoke((Object)regionManager, vector);
            if (this.cacheDuration > 0) {
                this.cachedSets.put(location, regionSet);
            }
            return regionSet;
        }
        catch (Exception ex) {
            this.owningPlugin.getLogger().log(Level.WARNING, "An error occurred looking up a WorldGuard ApplicableRegionSet", ex);
            return null;
        }
    }

    public boolean isPVPAllowed(Player player, Location location) {
        if (this.worldGuardPlugin == null || location == null) {
            return true;
        }
        ApplicableRegionSet checkSet = this.getRegionSet(location);
        if (checkSet == null) {
            return true;
        }
        return checkSet.queryState(this.getAssociable(player), new StateFlag[]{this.pvpFlag}) != StateFlag.State.DENY;
    }

    public boolean isExitAllowed(Player player, Location location) {
        if (this.worldGuardPlugin == null || location == null) {
            return true;
        }
        ApplicableRegionSet checkSet = this.getRegionSet(location);
        if (checkSet == null) {
            return true;
        }
        return checkSet.queryState(this.getAssociable(player), new StateFlag[]{this.exitFlag}) != StateFlag.State.DENY;
    }

    public boolean hasBuildPermission(Player player, Block block) {
        this.initialize();
        if (block != null && this.createQueryMethod != null && this.regionContainer != null) {
            try {
                boolean result;
                Object query = this.createQueryMethod.invoke(this.regionContainer, new Object[0]);
                if (this.locationAdaptMethod != null) {
                    Object location = this.locationAdaptMethod.invoke(null, block.getLocation());
                    result = (Boolean)this.regionQueryTestStateMethod.invoke(query, location, this.getAssociable(player), new StateFlag[]{this.buildFlag});
                } else {
                    result = (Boolean)this.regionQueryTestStateMethod.invoke(query, block.getLocation(), this.getAssociable(player), new StateFlag[]{this.buildFlag});
                }
                return result;
            }
            catch (Exception ex) {
                this.owningPlugin.getLogger().log(Level.WARNING, "An error occurred querying WorldGuard", ex);
            }
        }
        return true;
    }

    @Nullable
    public Boolean getCastPermission(Player player, SpellTemplate spell, Location location) {
        if (location != null && this.worldGuardPlugin != null && this.customFlags != null) {
            ApplicableRegionSet checkSet = this.getRegionSet(location);
            if (checkSet == null) {
                return null;
            }
            return this.customFlags.getCastPermission(this.getAssociable(player), checkSet, spell);
        }
        return null;
    }

    @Nullable
    public Boolean getWandPermission(Player player, Wand wand, Location location) {
        if (location != null && this.worldGuardPlugin != null && this.customFlags != null) {
            ApplicableRegionSet checkSet = this.getRegionSet(location);
            if (checkSet == null) {
                return null;
            }
            return this.customFlags.getWandPermission(this.getAssociable(player), checkSet, wand);
        }
        return null;
    }

    @Nullable
    public String getReflective(Player player, Location location) {
        if (location != null && this.worldGuardPlugin != null && this.customFlags != null) {
            ApplicableRegionSet checkSet = this.getRegionSet(location);
            if (checkSet == null) {
                return null;
            }
            return this.customFlags.getReflective(this.getAssociable(player), checkSet);
        }
        return null;
    }

    @Nullable
    public Set<String> getSpellOverrides(Player player, Location location) {
        if (location != null && this.worldGuardPlugin != null && this.customFlags != null) {
            ApplicableRegionSet checkSet = this.getRegionSet(location);
            if (checkSet == null) {
                return null;
            }
            return this.customFlags.getSpellOverrides(this.getAssociable(player), checkSet);
        }
        return null;
    }

    @Nullable
    public String getDestructible(Player player, Location location) {
        if (location != null && this.worldGuardPlugin != null && this.customFlags != null) {
            ApplicableRegionSet checkSet = this.getRegionSet(location);
            if (checkSet == null) {
                return null;
            }
            return this.customFlags.getDestructible(this.getAssociable(player), checkSet);
        }
        return null;
    }

    @Nullable
    public String getPortalSpell(Player player, Location location) {
        if (location != null && this.worldGuardPlugin != null && this.customFlags != null) {
            ApplicableRegionSet checkSet = this.getRegionSet(location);
            if (checkSet == null) {
                return null;
            }
            return this.customFlags.getPortalSpell(this.getAssociable(player), checkSet);
        }
        return null;
    }

    @Nullable
    public String getPortalWarp(Player player, Location location) {
        if (location != null && this.worldGuardPlugin != null && this.customFlags != null) {
            ApplicableRegionSet checkSet = this.getRegionSet(location);
            if (checkSet == null) {
                return null;
            }
            return this.customFlags.getPortalWarp(this.getAssociable(player), checkSet);
        }
        return null;
    }

    public boolean inTaggedRegion(Location location, Set<String> tags) {
        if (location != null && this.worldGuardPlugin != null && this.customFlags != null) {
            ApplicableRegionSet checkSet = this.getRegionSet(location);
            if (checkSet == null) {
                return false;
            }
            return this.customFlags.inTaggedRegion(Associables.constant((Association)Association.NON_MEMBER), checkSet, tags);
        }
        return false;
    }

    public void setCacheDuration(int cacheDuration) {
        this.cacheDuration = cacheDuration;
        this.cachedSets.clear();
    }

    private static final class AllowPvpWhenDamagingController
    implements Listener {
        private AllowPvpWhenDamagingController() {
        }

        @EventHandler
        public void onDisallowedPVPEvent(DisallowedPVPEvent ev) {
            if (CompatibilityLib.getCompatibilityUtils().isDamaging()) {
                ev.setCancelled(true);
            }
        }
    }
}

