/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.google.common.collect.Iterators;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;

public class ModifyWalkSpeedAction
extends BaseSpellAction
implements Listener {
    private static final String INITIAL_MOVEMENT_SPEED_META = "InitialMovementSpeed";
    private float speed = 0.0f;

    @Override
    public void initialize(Spell spell, ConfigurationSection parameters) {
        super.initialize(spell, parameters);
        if (parameters.contains("speed")) {
            this.speed = (float)parameters.getDouble("speed", 0.0);
        }
    }

    @Override
    public SpellResult perform(CastContext context) {
        SpeedDataStack stack;
        Player player = context.getMage().getPlayer();
        if (player == null) {
            return SpellResult.PLAYER_REQUIRED;
        }
        List meta = player.getMetadata(INITIAL_MOVEMENT_SPEED_META);
        if (meta.isEmpty()) {
            stack = new SpeedDataStack();
            stack.initialSpeed = player.getWalkSpeed();
            player.setMetadata(INITIAL_MOVEMENT_SPEED_META, (MetadataValue)new FixedMetadataValue(context.getPlugin(), (Object)stack));
        } else {
            stack = (SpeedDataStack)((MetadataValue)meta.get(0)).value();
        }
        stack.map.put(this, Float.valueOf(this.speed));
        player.setWalkSpeed(this.speed);
        return SpellResult.CAST;
    }

    @Override
    public void finish(CastContext context) {
        float oldSpeed;
        Player player = context.getMage().getPlayer();
        List meta = player.getMetadata(INITIAL_MOVEMENT_SPEED_META);
        if (meta.isEmpty()) {
            return;
        }
        SpeedDataStack stack = (SpeedDataStack)((MetadataValue)meta.get(0)).value();
        stack.map.remove(this);
        if (stack.map.isEmpty()) {
            oldSpeed = stack.initialSpeed;
            player.removeMetadata(INITIAL_MOVEMENT_SPEED_META, context.getPlugin());
        } else {
            oldSpeed = ((Float)Iterators.getLast(stack.map.values().iterator())).floatValue();
        }
        player.setWalkSpeed(oldSpeed);
    }

    private static final class SpeedDataStack {
        private float initialSpeed = 0.2f;
        private Map<ModifyWalkSpeedAction, Float> map = new LinkedHashMap<ModifyWalkSpeedAction, Float>();

        private SpeedDataStack() {
        }
    }
}

