/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.builtin.ModifyBlockAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.block.MaterialBrush;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.block.DefaultMaterials;
import com.elmakers.mine.bukkit.block.MaterialAndData;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import java.util.Arrays;
import java.util.Collection;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.configuration.ConfigurationSection;

public class BreakBlockAction
extends ModifyBlockAction {
    private double durabilityAmount;
    private double durabilityPercent;
    private double maxDistanceSquared;
    private Material breakMaterial = Material.AIR;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.durabilityPercent = parameters.getDouble("break_percent", 0.0);
        this.durabilityAmount = parameters.getDouble("break_durability", this.durabilityPercent > 0.0 ? 0.0 : 1.0);
        double maxDistance = parameters.getDouble("durability_max_distance");
        this.maxDistanceSquared = maxDistance * maxDistance;
        String breakMaterialKey = parameters.getString("break_material");
        if (breakMaterialKey != null && !breakMaterialKey.isEmpty()) {
            try {
                this.breakMaterial = Material.valueOf((String)breakMaterialKey.toUpperCase());
            }
            catch (Exception ex) {
                context.getLogger().warning("Invalid material for break_material: " + breakMaterialKey);
                this.breakMaterial = Material.AIR;
            }
        }
    }

    @Override
    public SpellResult perform(CastContext context) {
        Block block = context.getTargetBlock();
        if (DefaultMaterials.isAir(block.getType()) || !context.isDestructible(block)) {
            return SpellResult.NO_TARGET;
        }
        context.registerForUndo(block);
        MageController controller = context.getController();
        double durability = controller.getBlockDurability(block);
        double scaledAmount = this.durabilityAmount + this.durabilityPercent * durability;
        if (this.maxDistanceSquared > 0.0) {
            double distanceSquared = context.getTargetCenterLocation().distanceSquared(block.getLocation());
            if (distanceSquared > this.maxDistanceSquared) {
                return SpellResult.NO_TARGET;
            }
            if (distanceSquared > 0.0) {
                scaledAmount *= 1.0 - distanceSquared / this.maxDistanceSquared;
            }
        }
        double breakAmount = 1.0;
        if (durability > 0.0) {
            double breakPercentage = scaledAmount / durability;
            breakAmount = context.registerBreaking(block, breakPercentage);
        }
        if (breakAmount >= 1.0 && context.hasBreakPermission(block)) {
            MaterialBrush brush;
            context.playEffects("break");
            CompatibilityLib.getCompatibilityUtils().clearBreaking(block);
            BlockState blockState = block.getState();
            if (blockState != null && MaterialAndData.shouldClearItemsIn(blockState)) {
                CompatibilityLib.getCompatibilityUtils().clearItems(blockState.getLocation());
            }
            if ((brush = context.getBrush()) == null) {
                brush = new com.elmakers.mine.bukkit.block.MaterialBrush(context.getMage(), this.breakMaterial, 0);
                context.setBrush(brush);
            } else {
                brush.setMaterial(this.breakMaterial);
            }
            super.perform(context);
            context.unregisterBreaking(block);
            context.playEffects("broken");
        } else {
            CompatibilityLib.getCompatibilityUtils().setBreaking(block, breakAmount);
        }
        return SpellResult.CAST;
    }

    @Override
    public void getParameterNames(Spell spell, Collection<String> parameters) {
        super.getParameterNames(spell, parameters);
        parameters.add("durability");
        parameters.add("durability_max_distance");
    }

    @Override
    public void getParameterOptions(Spell spell, String parameterKey, Collection<String> examples) {
        if (parameterKey.equals("durability") || parameterKey.equals("durability_max_distance")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_SIZES));
        } else {
            super.getParameterOptions(spell, parameterKey, examples);
        }
    }

    @Override
    public boolean usesBrush() {
        return false;
    }

    @Override
    public boolean requiresBuildPermission() {
        return false;
    }
}

