/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic.command;

import com.elmakers.mine.bukkit.api.item.ItemData;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.magic.MagicAPI;
import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.block.MaterialAndData;
import com.elmakers.mine.bukkit.integration.VaultController;
import com.elmakers.mine.bukkit.magic.command.MagicTabExecutor;
import com.elmakers.mine.bukkit.utility.Base64Coder;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.platform.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.platform.DeprecatedUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.logging.Level;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class MagicItemCommandExecutor
extends MagicTabExecutor {
    public MagicItemCommandExecutor(MagicAPI api) {
        super(api, "mitem");
    }

    public boolean onCommand(CommandSender sender, Command command, String commandLabel, String[] args) {
        Player findPlayer;
        Player player;
        if (args.length == 0) {
            return false;
        }
        if (args[0].equalsIgnoreCase("delete")) {
            if (!this.api.hasPermission(sender, "magic.commands.mitem.delete")) {
                this.sendNoPermission(sender);
                return true;
            }
            if (args.length < 2) {
                sender.sendMessage("Usage: /mitem delete <itemkey>");
                return true;
            }
            this.onItemDelete(sender, args[1]);
            return true;
        }
        if (args[0].equalsIgnoreCase("spawn")) {
            if (!this.api.hasPermission(sender, "magic.commands.mitem.spawn")) {
                this.sendNoPermission(sender);
                return true;
            }
            if (args.length < 2) {
                sender.sendMessage("Usage: /mitem spawn <itemkey>");
                return true;
            }
            String[] args2 = Arrays.copyOfRange(args, 1, args.length);
            this.onItemSpawn(sender, args2);
            return true;
        }
        String subCommand = args[0];
        String[] args2 = Arrays.copyOfRange(args, 1, args.length);
        Player player2 = player = sender instanceof Player ? (Player)sender : null;
        if (args2.length > 0 && (findPlayer = CompatibilityLib.getDeprecatedUtils().getPlayer(args2[0])) != null) {
            player = findPlayer;
            args2 = Arrays.copyOfRange(args2, 1, args2.length);
        }
        if (player == null) {
            return false;
        }
        if (!this.checkItem(sender, player)) {
            return true;
        }
        ItemStack itemInHand = player.getInventory().getItemInMainHand();
        return this.processItemCommand(sender, player, itemInHand, subCommand, args2);
    }

    @Override
    public Collection<String> onTabComplete(CommandSender sender, String commandName, String[] args) {
        String subCommand2;
        int n;
        String subCommand;
        ArrayList<String> options = new ArrayList<String>();
        if (args.length == 1) {
            this.addIfPermissible(sender, options, "magic.commands.mitem.", "add");
            this.addIfPermissible(sender, options, "magic.commands.mitem.", "remove");
            this.addIfPermissible(sender, options, "magic.commands.mitem.", "name");
            this.addIfPermissible(sender, options, "magic.commands.mitem.", "configure");
            this.addIfPermissible(sender, options, "magic.commands.mitem.", "describe");
            this.addIfPermissible(sender, options, "magic.commands.mitem.", "desc");
            this.addIfPermissible(sender, options, "magic.commands.mitem.", "duplicate");
            this.addIfPermissible(sender, options, "magic.commands.mitem.", "amount");
            this.addIfPermissible(sender, options, "magic.commands.mitem.", "save");
            this.addIfPermissible(sender, options, "magic.commands.mitem.", "delete");
            this.addIfPermissible(sender, options, "magic.commands.mitem.", "destroy");
            this.addIfPermissible(sender, options, "magic.commands.mitem.", "clean");
            this.addIfPermissible(sender, options, "magic.commands.mitem.", "worth");
            this.addIfPermissible(sender, options, "magic.commands.mitem.", "earns");
            this.addIfPermissible(sender, options, "magic.commands.mitem.", "type");
            this.addIfPermissible(sender, options, "magic.commands.mitem.", "damage");
            this.addIfPermissible(sender, options, "magic.commands.mitem.", "skull");
            this.addIfPermissible(sender, options, "magic.commands.mitem.", "spawn");
        }
        if (args.length == 2) {
            File itemFolder;
            subCommand = args[0];
            String subCommandPNode = "magic.commands.mitem." + subCommand;
            if (!this.api.hasPermission(sender, subCommandPNode)) {
                return options;
            }
            if (subCommand.equalsIgnoreCase("add")) {
                options.add("enchant");
                options.add("attribute");
                options.add("lore");
                options.add("flag");
                options.add("unbreakable");
                options.add("unplaceable");
            }
            if (subCommand.equalsIgnoreCase("remove")) {
                options.add("enchant");
                options.add("attribute");
                options.add("lore");
                options.add("flag");
                options.add("unbreakable");
                options.add("unplaceable");
            }
            if (subCommand.equalsIgnoreCase("type")) {
                for (AttributeModifier.Operation operation : Material.values()) {
                    options.add(operation.name().toLowerCase());
                }
            }
            if (subCommand.equalsIgnoreCase("spawn")) {
                Collection<SpellTemplate> spellList = this.api.getSpellTemplates(sender.hasPermission("magic.bypass_hidden"));
                for (SpellTemplate spell : spellList) {
                    this.addIfPermissible(sender, options, "magic.create.", spell.getKey());
                }
                Collection<String> allWands = this.api.getWandKeys();
                for (String string : allWands) {
                    this.addIfPermissible(sender, options, "magic.create.", string);
                }
                Material[] spell = Material.values();
                int n2 = spell.length;
                for (n = 0; n < n2; ++n) {
                    Material material = spell[n];
                    this.addIfPermissible(sender, options, "magic.create.", material.name().toLowerCase());
                }
                Set<String> allItems = this.api.getController().getItemKeys();
                for (String itemKey : allItems) {
                    this.addIfPermissible(sender, options, "magic.create.", itemKey);
                }
                this.addIfPermissible(sender, options, "magic.create.", "sp");
            }
            if (subCommand.equalsIgnoreCase("damage")) {
                options.add("0");
                options.add("100");
            }
            if (subCommand.equalsIgnoreCase("delete") && (itemFolder = new File(this.api.getController().getConfigFolder(), "items")).exists()) {
                File[] files;
                File[] fileArray = files = itemFolder.listFiles();
                int n3 = fileArray.length;
                for (n = 0; n < n3; ++n) {
                    File file = fileArray[n];
                    if (!file.getName().endsWith(".yml")) continue;
                    options.add(file.getName().replace(".yml", ""));
                }
            }
        }
        if (args.length == 3) {
            boolean isAddRemove;
            subCommand = args[0];
            subCommand2 = args[1];
            String commandPNode = "magic.commands.mitem." + subCommand;
            if (!this.api.hasPermission(sender, commandPNode)) {
                return options;
            }
            boolean bl = isAddRemove = subCommand.equalsIgnoreCase("remove") || subCommand.equalsIgnoreCase("add");
            if (isAddRemove && subCommand2.equalsIgnoreCase("enchant")) {
                Enchantment[] enchantmentArray = Enchantment.values();
                int n4 = enchantmentArray.length;
                for (n = 0; n < n4; ++n) {
                    Enchantment enchantment = enchantmentArray[n];
                    options.add(CompatibilityLib.getCompatibilityUtils().getEnchantmentKey(enchantment));
                }
            }
            if (isAddRemove && subCommand2.equalsIgnoreCase("attribute")) {
                Attribute[] attributeArray = Attribute.values();
                int n5 = attributeArray.length;
                for (n = 0; n < n5; ++n) {
                    Attribute attribute = attributeArray[n];
                    options.add(attribute.name().toLowerCase());
                }
            }
            if (isAddRemove && subCommand2.equalsIgnoreCase("flag")) {
                for (ItemFlag flag : ItemFlag.values()) {
                    options.add(flag.name().toLowerCase());
                }
            }
            if (subCommand.equalsIgnoreCase("remove") && subCommand2.equalsIgnoreCase("lore")) {
                options.add("1");
                options.add("2");
                options.add("3");
            }
        }
        if (args.length == 5) {
            subCommand = args[0];
            subCommand2 = args[1];
            if (subCommand.equalsIgnoreCase("add") && subCommand2.equalsIgnoreCase("attribute")) {
                options.add("mainhand");
                options.add("offhand");
                options.add("feet");
                options.add("legs");
                options.add("chest");
                options.add("head");
            }
        }
        if (args.length == 6) {
            subCommand = args[0];
            subCommand2 = args[1];
            if (subCommand.equalsIgnoreCase("add") && subCommand2.equalsIgnoreCase("attribute")) {
                for (AttributeModifier.Operation operation : AttributeModifier.Operation.values()) {
                    options.add(operation.name().toLowerCase());
                }
            }
        }
        return options;
    }

    protected boolean processItemCommand(CommandSender sender, Player player, ItemStack item, String subCommand, String[] args) {
        if (!this.api.hasPermission(sender, "magic.commands.mitem." + subCommand)) {
            this.sendNoPermission(sender);
            return true;
        }
        if (subCommand.equalsIgnoreCase("add")) {
            return this.onItemAdd(sender, player, item, args);
        }
        if (subCommand.equalsIgnoreCase("remove")) {
            return this.onItemRemove(sender, player, item, args);
        }
        if (subCommand.equalsIgnoreCase("destroy")) {
            return this.onItemDestroy(sender, player);
        }
        if (subCommand.equalsIgnoreCase("clean")) {
            return this.onItemClean(sender, player);
        }
        if (subCommand.equalsIgnoreCase("worth")) {
            return this.onItemWorth(sender, player, item);
        }
        if (subCommand.equalsIgnoreCase("earns")) {
            return this.onItemEarns(sender, player, item);
        }
        if (subCommand.equalsIgnoreCase("type")) {
            return this.onItemType(sender, player, item, args);
        }
        if (subCommand.equalsIgnoreCase("damage")) {
            return this.onItemDurability(sender, player, item, args);
        }
        if (subCommand.equalsIgnoreCase("duplicate")) {
            return this.onItemDuplicate(sender, player, item);
        }
        if (subCommand.equalsIgnoreCase("amount")) {
            return this.onItemAmount(sender, item, args);
        }
        if (subCommand.equalsIgnoreCase("save")) {
            return this.onItemSave(sender, player, item, args);
        }
        if (subCommand.equalsIgnoreCase("describe") || subCommand.equalsIgnoreCase("desc")) {
            return this.onItemDescribe(sender, player, item, args);
        }
        if (subCommand.equalsIgnoreCase("configure")) {
            return this.onItemConfigure(sender, player, item, args);
        }
        if (subCommand.equalsIgnoreCase("name")) {
            return this.onItemName(sender, player, item, args);
        }
        if (subCommand.equalsIgnoreCase("export")) {
            return this.onItemExport(sender, player, item, args);
        }
        if (subCommand.equalsIgnoreCase("skull")) {
            return this.onItemSkull(sender, player, item);
        }
        return false;
    }

    public boolean onItemConfigure(CommandSender sender, Player player, ItemStack item, String[] args) {
        if (args.length == 0) {
            sender.sendMessage(ChatColor.RED + "Usage: /mitem configure <key> [value]");
            return true;
        }
        String tag = args[0];
        String[] path = StringUtils.split((String)tag, (char)'.');
        ItemStack newItem = CompatibilityLib.getItemUtils().makeReal(item);
        Object node = CompatibilityLib.getItemUtils().getTag(item);
        if (args.length == 1) {
            for (int i = 0; node != null && i < path.length - 1; ++i) {
                node = CompatibilityLib.getNBTUtils().getTag(node, path[i]);
            }
            if (node == null) {
                sender.sendMessage(ChatColor.RED + "Item does not have path: " + ChatColor.DARK_RED + tag);
                return true;
            }
            if (!CompatibilityLib.getNBTUtils().contains(node, path[path.length - 1])) {
                sender.sendMessage(ChatColor.RED + "Item does not have tag: " + ChatColor.DARK_RED + tag);
                return true;
            }
            CompatibilityLib.getNBTUtils().removeMeta(node, path[path.length - 1]);
            item.setItemMeta(newItem.getItemMeta());
            sender.sendMessage(ChatColor.GREEN + "Removed: " + ChatColor.DARK_GREEN + tag);
            return true;
        }
        String value = CompatibilityLib.getCompatibilityUtils().translateColors(args[1]);
        for (int i = 0; i < path.length; ++i) {
            String key = path[i];
            if (node == null) {
                sender.sendMessage(ChatColor.RED + "Failed to set item data");
                return true;
            }
            if (i < path.length - 1) {
                node = CompatibilityLib.getNBTUtils().createTag(node, key);
                continue;
            }
            CompatibilityLib.getNBTUtils().parseAndSet(node, key, value);
        }
        item.setItemMeta(newItem.getItemMeta());
        sender.sendMessage(ChatColor.GREEN + "Set: " + ChatColor.DARK_GREEN + tag + " to " + ChatColor.AQUA + value);
        return true;
    }

    public boolean onItemDescribe(CommandSender sender, Player player, ItemStack item, String[] args) {
        ItemData itemData;
        MaterialAndData material = new MaterialAndData(item);
        sender.sendMessage(ChatColor.GOLD + material.getKey());
        YamlConfiguration configuration = new YamlConfiguration();
        if (ConfigurationUtils.loadAllTagsFromNBT((ConfigurationSection)configuration, item)) {
            String itemString = null;
            if (args.length > 0) {
                Object target = configuration.get(args[0]);
                if (target == null) {
                    itemString = ChatColor.AQUA + args[0] + ChatColor.GRAY + ": " + ChatColor.RED + "(Not Set)";
                } else {
                    configuration = new YamlConfiguration();
                    configuration.set(args[0], target);
                    itemString = configuration.saveToString().replace('\u00a7', '&');
                }
            } else {
                itemString = configuration.saveToString().replace('\u00a7', '&');
            }
            sender.sendMessage(itemString);
        }
        if (args.length == 0 && (itemData = this.api.getController().getItem(item)) != null) {
            sender.sendMessage(ChatColor.AQUA + "Give with: " + ChatColor.GRAY + "/mgive " + ChatColor.YELLOW + itemData.getKey());
            double worth = itemData.getWorth();
            if (worth > 0.0) {
                double earns = itemData.getEarns();
                String message = ChatColor.AQUA + " Worth " + ChatColor.GREEN + worth;
                if (earns != worth) {
                    message = message + " " + ChatColor.GRAY + "(" + ChatColor.DARK_GREEN + earns + ChatColor.DARK_AQUA + " when selling" + ChatColor.GRAY + ")";
                }
                sender.sendMessage(message);
            }
        }
        return true;
    }

    public boolean onItemExport(CommandSender sender, Player player, ItemStack item, String[] parameters) {
        if (parameters.length == 0) {
            sender.sendMessage(ChatColor.RED + "Usage: /mitem export filename");
            return true;
        }
        PlayerInventory inventory = player.getInventory();
        int itemSlot = inventory.getHeldItemSlot();
        TreeMap<String, MaterialAndData> items = new TreeMap<String, MaterialAndData>();
        block7: for (Material material : Material.values()) {
            ItemStack testItem = new ItemStack(material, 1);
            inventory.setItem(itemSlot, testItem);
            ItemStack setItem = inventory.getItem(itemSlot);
            if (setItem == null || setItem.getType() != testItem.getType()) {
                sender.sendMessage("Skipped: " + material.name());
                continue;
            }
            MaterialAndData mat = new MaterialAndData(material);
            items.put(mat.getKey(), mat);
            String baseName = mat.getName(this.controller.getMessages());
            DeprecatedUtils deprecatedUtils = CompatibilityLib.getDeprecatedUtils();
            for (short data = 1; data < 32; data = (short)(data + 1)) {
                testItem = CompatibilityLib.getDeprecatedUtils().createItemStack(material, 1, data);
                inventory.setItem(itemSlot, testItem);
                setItem = inventory.getItem(itemSlot);
                if (setItem == null || setItem.getType() != testItem.getType() || deprecatedUtils.getItemDamage(setItem) != deprecatedUtils.getItemDamage(testItem) || (mat = new MaterialAndData(material, data)).getName().equals(baseName)) continue block7;
                items.put(mat.getKey(), mat);
            }
        }
        File file = new File(this.api.getPlugin().getDataFolder(), parameters[0] + ".csv");
        try (OutputStreamWriter output = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");){
            ((Writer)output).append("Name,Key,Cost,Earns\n");
            for (MaterialAndData materialAndData : items.values()) {
                Double worth = this.api.getController().getWorth(materialAndData.getItemStack(1));
                String worthString = worth == null ? "" : worth.toString();
                Double earns = this.api.getController().getEarns(materialAndData.getItemStack(1));
                String earnsString = earns == null ? "" : earns.toString();
                ((Writer)output).append(materialAndData.getName() + "," + materialAndData.getKey() + "," + worthString + "," + earnsString + "\n");
            }
        }
        catch (Exception ex) {
            sender.sendMessage(ChatColor.RED + "Error exporting data: " + ex.getMessage());
            ex.printStackTrace();
        }
        inventory.setItem(itemSlot, item);
        return true;
    }

    public boolean onItemSerialize(CommandSender sender, Player player, ItemStack item) {
        YamlConfiguration configuration = new YamlConfiguration();
        configuration.set("item", (Object)item);
        String itemString = configuration.saveToString().replace("item:", "").replace('\u00a7', '&');
        sender.sendMessage(itemString);
        return true;
    }

    public boolean onItemWorth(CommandSender sender, Player player, ItemStack item) {
        MageController controller = this.api.getController();
        Double worth = controller.getWorth(item);
        if (worth == null) {
            sender.sendMessage(ChatColor.RED + "No worth defined for that item");
            return true;
        }
        String worthDescription = null;
        int amount = item.getAmount();
        double totalWorth = worth * (double)amount;
        if (VaultController.hasEconomy()) {
            VaultController vault = VaultController.getInstance();
            worthDescription = vault.format(totalWorth);
            if (amount > 1) {
                worthDescription = worthDescription + ChatColor.WHITE + " (" + ChatColor.GOLD + vault.format(worth) + ChatColor.WHITE + " each)";
            }
        } else {
            worthDescription = Double.toString(totalWorth);
            if (amount > 1) {
                worthDescription = worthDescription + ChatColor.WHITE + " (" + ChatColor.GOLD + Double.toString(worth) + ChatColor.WHITE + " each)";
            }
        }
        sender.sendMessage("That item is worth " + ChatColor.GOLD + worthDescription);
        return true;
    }

    public boolean onItemEarns(CommandSender sender, Player player, ItemStack item) {
        MageController controller = this.api.getController();
        Double earns = controller.getEarns(item);
        if (earns == null) {
            sender.sendMessage(ChatColor.RED + "No earns defined for that item");
            return true;
        }
        String earnsDescription = null;
        int amount = item.getAmount();
        double totalWorth = earns * (double)amount;
        if (VaultController.hasEconomy()) {
            VaultController vault = VaultController.getInstance();
            earnsDescription = vault.format(totalWorth);
            if (amount > 1) {
                earnsDescription = earnsDescription + ChatColor.WHITE + " (" + ChatColor.GOLD + vault.format(earns) + ChatColor.WHITE + " each)";
            }
        } else {
            earnsDescription = Double.toString(totalWorth);
            if (amount > 1) {
                earnsDescription = earnsDescription + ChatColor.WHITE + " (" + ChatColor.GOLD + Double.toString(earns) + ChatColor.WHITE + " each)";
            }
        }
        sender.sendMessage("That item can be sold for " + ChatColor.GOLD + earnsDescription);
        return true;
    }

    public boolean onItemDuplicate(CommandSender sender, Player player, ItemStack item) {
        ItemStack newItem = CompatibilityLib.getItemUtils().getCopy(item);
        this.api.giveItemToPlayer(player, newItem);
        sender.sendMessage(this.api.getMessages().get("item.duplicated"));
        return true;
    }

    public boolean onItemSkull(CommandSender sender, Player player, ItemStack item) {
        ItemStack skullItem;
        ItemMeta meta = item.getItemMeta();
        if (meta == null || !(meta instanceof BookMeta)) {
            sender.sendMessage(this.api.getMessages().get("item.skull_no_book"));
            return true;
        }
        BookMeta bookMeta = (BookMeta)meta;
        List pages = bookMeta.getPages();
        if (pages.isEmpty()) {
            sender.sendMessage(this.api.getMessages().get("item.skull_invalid_book"));
            return true;
        }
        String pageText = (String)pages.get(0);
        try {
            String decoded = Base64Coder.decodeString(pageText);
            if (decoded == null || decoded.isEmpty()) {
                sender.sendMessage(this.api.getMessages().get("item.skull_invalid_book"));
                return true;
            }
            String url = decoded.replace("\"", "").replace("{textures:{SKIN:{url:", "").replace("}}}", "").trim();
            skullItem = this.controller.getURLSkull(url);
            if (CompatibilityLib.getItemUtils().isEmpty(skullItem)) {
                sender.sendMessage(this.api.getMessages().get("item.skull_invalid_book"));
                return true;
            }
        }
        catch (Exception ex) {
            sender.sendMessage(this.api.getMessages().get("item.skull_invalid_book"));
            return true;
        }
        if (pages.size() > 1) {
            String secondPageText = (String)pages.get(1);
            String[] pieces = StringUtils.split((String)(secondPageText = secondPageText.replace("\u00a70", "")), (char)'\n');
            if (pieces.length > 0) {
                ItemMeta skullMeta = skullItem.getItemMeta();
                skullMeta.setDisplayName(CompatibilityLib.getCompatibilityUtils().translateColors(pieces[0]));
                if (pieces.length > 1) {
                    ArrayList<String> lore = new ArrayList<String>();
                    for (int i = 1; i < pieces.length; ++i) {
                        lore.add(CompatibilityLib.getCompatibilityUtils().translateColors(pieces[i]));
                    }
                    skullMeta.setLore(lore);
                }
                skullItem.setItemMeta(skullMeta);
            }
        }
        sender.sendMessage(this.api.getMessages().get("item.skull"));
        player.getInventory().setItemInMainHand(skullItem);
        return true;
    }

    protected boolean checkItem(CommandSender sender, Player player) {
        ItemStack itemInHand = player.getInventory().getItemInMainHand();
        if (itemInHand == null || itemInHand.getType() == Material.AIR) {
            sender.sendMessage(this.api.getMessages().get("item.no_item"));
            return false;
        }
        return true;
    }

    public boolean onItemSpawn(CommandSender sender, String[] args) {
        if (!(sender instanceof Player) && args.length < 2) {
            sender.sendMessage(ChatColor.RED + "Usage: " + ChatColor.WHITE + "mitem spawn <item> <x> <y> <z> <world>");
            return true;
        }
        String itemType = args[0];
        ItemStack item = this.controller.createItem(itemType);
        if (item == null) {
            sender.sendMessage(ChatColor.RED + "Invalid item: " + ChatColor.WHITE + itemType);
            return true;
        }
        Location location = null;
        if (args.length == 2) {
            Entity target = CompatibilityLib.getCompatibilityUtils().getEntity(UUID.fromString(args[1]));
            if (target == null) {
                sender.sendMessage(ChatColor.RED + "Could not find entity with UUID: " + ChatColor.WHITE + args[1]);
                return true;
            }
            location = target.getLocation();
        } else {
            if (sender instanceof Player) {
                location = ((Player)sender).getLocation();
                if (args.length > 4) {
                    location.setWorld(Bukkit.getWorld((String)args[4]));
                }
            } else {
                location = new Location(Bukkit.getWorld((String)args[4]), 0.0, 0.0, 0.0);
            }
            if (args.length > 4 && location.getWorld() == null) {
                sender.sendMessage(ChatColor.RED + "Invalid world: " + ChatColor.WHITE + args[4]);
                return true;
            }
            try {
                if (args.length > 1) {
                    location.setX(Double.parseDouble(args[1]));
                    if (args.length > 2) {
                        location.setY(Double.parseDouble(args[2]));
                        if (args.length > 3) {
                            location.setZ(Double.parseDouble(args[3]));
                        }
                    }
                }
            }
            catch (Exception ex) {
                sender.sendMessage(ChatColor.RED + "Usage: " + ChatColor.WHITE + "mitem spawn <item> <x> <y> <z> <world>");
                return true;
            }
        }
        location.getWorld().dropItem(location, item);
        return true;
    }

    public boolean onItemDelete(CommandSender sender, String itemKey) {
        Player player;
        MageController controller = this.api.getController();
        ItemData existing = controller.getItem(itemKey);
        if (existing == null) {
            sender.sendMessage(ChatColor.RED + "Unknown item: " + itemKey);
            return true;
        }
        boolean hasPermission = true;
        if (sender instanceof Player && !(player = (Player)sender).hasPermission("magic.item.overwrite")) {
            String creatorId;
            hasPermission = player.hasPermission("magic.item.overwrite_own") ? (creatorId = existing.getCreatorId()) != null && creatorId.equalsIgnoreCase(player.getUniqueId().toString()) : false;
        }
        if (!hasPermission) {
            sender.sendMessage(ChatColor.RED + "You don't have permission to delete " + itemKey);
            return true;
        }
        File itemFolder = new File(controller.getConfigFolder(), "items");
        File itemFile = new File(itemFolder, itemKey + ".yml");
        if (!itemFile.exists()) {
            sender.sendMessage(ChatColor.RED + "File doesn't exist: " + itemFile.getName());
            return true;
        }
        itemFile.delete();
        controller.unloadItemTemplate(itemKey);
        sender.sendMessage("Deleted item " + itemKey);
        return true;
    }

    public boolean onItemSave(CommandSender sender, Player player, ItemStack item, String[] parameters) {
        String creatorId;
        String template;
        if (parameters.length < 1) {
            sender.sendMessage("Use: /mitem save <filename> [worth] [earns]");
            return true;
        }
        MageController controller = this.api.getController();
        ItemData existing = controller.getItem(template = parameters[0]);
        String string = creatorId = existing == null ? null : existing.getCreatorId();
        if (creatorId != null && !player.hasPermission("magic.item.overwrite")) {
            boolean isCreator = creatorId.equalsIgnoreCase(player.getUniqueId().toString());
            if (!player.hasPermission("magic.item.overwrite_own") || !isCreator) {
                sender.sendMessage(ChatColor.RED + "The " + template + " item already exists and you don't have permission (Magic.item.overwrite) to overwrite it.");
                return true;
            }
        }
        double worth = 0.0;
        if (parameters.length > 1) {
            try {
                worth = Double.parseDouble(parameters[1]);
            }
            catch (Exception ex) {
                sender.sendMessage("Invalid worth, expecting a number but got: " + parameters[1]);
                sender.sendMessage("Use: /mitem save <filename> [worth]");
                return true;
            }
        } else if (existing != null) {
            worth = existing.getWorth();
        }
        item.setAmount(1);
        YamlConfiguration itemConfig = new YamlConfiguration();
        ConfigurationSection itemSection = itemConfig.createSection(template);
        itemSection.set("creator_id", (Object)player.getUniqueId().toString());
        itemSection.set("creator", (Object)player.getName());
        itemSection.set("worth", (Object)worth);
        Double earns = null;
        if (parameters.length > 2) {
            try {
                earns = Double.parseDouble(parameters[2]);
                itemSection.set("earns", (Object)earns);
            }
            catch (Exception ex) {
                sender.sendMessage("Invalid earns, expecting a number but got: " + parameters[2]);
                sender.sendMessage("Use: /mitem save <filename> [worth] [earns]");
                return true;
            }
        } else if (existing != null && existing.hasCustomEarns()) {
            itemSection.set("earns", (Object)existing.getEarns());
        }
        itemSection.set("item", (Object)item);
        File itemFolder = new File(controller.getConfigFolder(), "items");
        File itemFile = new File(itemFolder, template + ".yml");
        itemFolder.mkdirs();
        try {
            itemConfig.save(itemFile);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            sender.sendMessage(ChatColor.RED + "Can't write to file " + itemFile.getName());
            return true;
        }
        controller.loadItemTemplate(template, itemSection);
        String message = ChatColor.WHITE + "Item saved as " + ChatColor.GOLD + template + " worth " + ChatColor.GREEN + worth;
        if (earns != null) {
            message = message + " " + ChatColor.GRAY + "(" + ChatColor.DARK_GREEN + earns + ChatColor.DARK_AQUA + " when selling" + ChatColor.GRAY + ")";
        }
        sender.sendMessage(message);
        if (existing != null) {
            message = ChatColor.YELLOW + " Replaced Worth " + ChatColor.DARK_GREEN + existing.getWorth();
            if (existing.hasCustomEarns()) {
                message = message + " " + ChatColor.GRAY + "(" + ChatColor.DARK_GREEN + existing.getEarns() + ChatColor.DARK_AQUA + " when selling" + ChatColor.GRAY + ")";
            }
            sender.sendMessage(message);
        }
        return true;
    }

    public boolean onItemName(CommandSender sender, Player player, ItemStack item, String[] parameters) {
        String displayName = null;
        if (parameters.length < 1) {
            sender.sendMessage(this.api.getMessages().get("item.rename_clear"));
        } else {
            displayName = CompatibilityLib.getCompatibilityUtils().translateColors(StringUtils.join((Object[])parameters, (String)" "));
            sender.sendMessage(this.api.getMessages().get("item.renamed"));
        }
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(displayName);
        item.setItemMeta(meta);
        return true;
    }

    public boolean onItemAddFlag(CommandSender sender, Player player, ItemStack item, String flagName) {
        ItemFlag flag = null;
        try {
            flag = ItemFlag.valueOf((String)flagName.toUpperCase());
        }
        catch (Exception ex) {
            sender.sendMessage(ChatColor.RED + "Invalid flag: " + ChatColor.WHITE + flagName);
            return true;
        }
        ItemMeta itemMeta = item.getItemMeta();
        itemMeta.addItemFlags(new ItemFlag[]{flag});
        item.setItemMeta(itemMeta);
        sender.sendMessage(this.api.getMessages().get("item.flag_added").replace("$flag", flag.name()));
        return true;
    }

    public boolean onItemRemoveFlag(CommandSender sender, Player player, ItemStack item, String flagName) {
        ItemFlag flag = null;
        ItemMeta itemMeta = item.getItemMeta();
        if (flagName == null) {
            Set flags = itemMeta.getItemFlags();
            if (flags == null || flags.size() == 0) {
                sender.sendMessage(this.api.getMessages().get("item.no_flags"));
                return true;
            }
            flag = (ItemFlag)flags.iterator().next();
        } else {
            try {
                flag = ItemFlag.valueOf((String)flagName.toUpperCase());
            }
            catch (Exception ex) {
                sender.sendMessage(ChatColor.RED + "Invalid flag: " + ChatColor.WHITE + flagName);
                return true;
            }
        }
        if (!itemMeta.hasItemFlag(flag)) {
            sender.sendMessage(this.api.getMessages().get("item.no_flag").replace("$flag", flag.name()));
        } else {
            itemMeta.removeItemFlags(new ItemFlag[]{flag});
            item.setItemMeta(itemMeta);
            sender.sendMessage(this.api.getMessages().get("item.flag_removed").replace("$flag", flag.name()));
        }
        return true;
    }

    public boolean onItemAddEnchant(CommandSender sender, Player player, ItemStack item, String enchantName, String enchantValue) {
        boolean allowUnsafe;
        Enchantment enchantment = null;
        CompatibilityUtils compatibilityUtils = CompatibilityLib.getCompatibilityUtils();
        try {
            enchantment = compatibilityUtils.getEnchantmentByKey(enchantName);
        }
        catch (Exception ex) {
            sender.sendMessage(ChatColor.RED + "Error adding enchantment: " + ChatColor.WHITE + enchantName);
            this.controller.getLogger().log(Level.SEVERE, "Error adding enchantment ", ex);
            return true;
        }
        if (enchantment == null) {
            sender.sendMessage(ChatColor.RED + "Invalid enchantment: " + ChatColor.WHITE + enchantName);
            return true;
        }
        int level = 0;
        try {
            level = Integer.parseInt(enchantValue);
        }
        catch (Exception ex) {
            sender.sendMessage(ChatColor.RED + "Invalid enchantment level: " + ChatColor.WHITE + enchantValue);
            return true;
        }
        if (!(player.hasPermission("magic.item.enchant.extreme") || level >= 0 && level <= 10)) {
            sender.sendMessage(ChatColor.RED + "Invalid enchantment level: " + ChatColor.WHITE + enchantValue);
            return true;
        }
        ItemMeta itemMeta = item.getItemMeta();
        if (itemMeta.addEnchant(enchantment, level, allowUnsafe = player.hasPermission("magic.item.enchant.unsafe"))) {
            item.setItemMeta(itemMeta);
            sender.sendMessage(this.api.getMessages().get("item.enchant_added").replace("$enchant", compatibilityUtils.getEnchantmentKey(enchantment)));
        } else if (!allowUnsafe && level > 5) {
            sender.sendMessage(this.api.getMessages().get("item.enchant_unsafe"));
        } else {
            sender.sendMessage(this.api.getMessages().get("item.enchant_not_added").replace("$enchant", compatibilityUtils.getEnchantmentKey(enchantment)));
        }
        return true;
    }

    public boolean onItemRemoveEnchant(CommandSender sender, Player player, ItemStack item, String enchantName) {
        Enchantment enchantment = null;
        ItemMeta itemMeta = item.getItemMeta();
        CompatibilityUtils compatibilityUtils = CompatibilityLib.getCompatibilityUtils();
        if (enchantName == null) {
            Map enchants = itemMeta.getEnchants();
            if (enchants == null || enchants.size() == 0) {
                sender.sendMessage(this.api.getMessages().get("item.no_enchants"));
                return true;
            }
            enchantment = (Enchantment)enchants.keySet().iterator().next();
        } else {
            try {
                enchantment = compatibilityUtils.getEnchantmentByKey(enchantName);
            }
            catch (Exception ex) {
                sender.sendMessage(ChatColor.RED + "Error adding enchantment: " + ChatColor.WHITE + enchantName);
                this.controller.getLogger().log(Level.SEVERE, "Error adding enchantment ", ex);
                return true;
            }
            if (enchantment == null) {
                sender.sendMessage(ChatColor.RED + "Invalid enchantment: " + ChatColor.WHITE + enchantName);
                return true;
            }
        }
        if (!itemMeta.hasEnchant(enchantment)) {
            sender.sendMessage(this.api.getMessages().get("item.no_enchant").replace("$enchant", compatibilityUtils.getEnchantmentKey(enchantment)));
        } else {
            itemMeta.removeEnchant(enchantment);
            item.setItemMeta(itemMeta);
            sender.sendMessage(this.api.getMessages().get("item.enchant_removed").replace("$enchant", compatibilityUtils.getEnchantmentKey(enchantment)));
        }
        return true;
    }

    public boolean onItemAddAttribute(CommandSender sender, Player player, ItemStack item, String attributeName, String attributeValue, String attributeSlot, AttributeModifier.Operation operation) {
        Attribute attribute = null;
        if (attributeName == null) {
            return false;
        }
        try {
            attribute = Attribute.valueOf((String)attributeName.toUpperCase());
        }
        catch (Exception ex) {
            sender.sendMessage(ChatColor.RED + "Invalid attribute: " + ChatColor.WHITE + attributeName);
            return true;
        }
        double value = 0.0;
        try {
            value = Double.parseDouble(attributeValue);
        }
        catch (Exception ex) {
            sender.sendMessage(ChatColor.RED + "Invalid attribute value: " + ChatColor.WHITE + attributeValue);
            return true;
        }
        ItemStack newItem = CompatibilityLib.getItemUtils().makeReal(item);
        CompatibilityLib.getCompatibilityUtils().removeItemAttribute(newItem, attribute);
        if (CompatibilityLib.getCompatibilityUtils().setItemAttribute(newItem, attribute, value, attributeSlot, operation.ordinal(), UUID.randomUUID())) {
            if (attributeSlot == null) {
                attributeSlot = "(All Slots)";
            }
            item.setItemMeta(newItem.getItemMeta());
            sender.sendMessage(this.api.getMessages().get("item.attribute_added").replace("$attribute", attribute.name()).replace("$value", Double.toString(value)).replace("$slot", attributeSlot).replace("$operation", operation.name().toLowerCase()));
        } else {
            sender.sendMessage(this.api.getMessages().get("item.attribute_not_added").replace("$attribute", attribute.name()));
        }
        return true;
    }

    public boolean onItemRemoveAttribute(CommandSender sender, Player player, ItemStack item, String attributeName) {
        Attribute attribute = null;
        if (attributeName == null) {
            return false;
        }
        try {
            attribute = Attribute.valueOf((String)attributeName.toUpperCase());
        }
        catch (Exception ex) {
            sender.sendMessage(ChatColor.RED + "Invalid attribute: " + ChatColor.WHITE + attributeName);
            return true;
        }
        if (!CompatibilityLib.getCompatibilityUtils().removeItemAttribute(item, attribute)) {
            sender.sendMessage(this.api.getMessages().get("item.no_attribute").replace("$attribute", attribute.name()));
        } else {
            sender.sendMessage(this.api.getMessages().get("item.attribute_removed").replace("$attribute", attribute.name()));
        }
        return true;
    }

    public boolean onItemAddUnplaceable(CommandSender sender, Player player, ItemStack item) {
        if (CompatibilityLib.getItemUtils().isUnplaceable(item)) {
            sender.sendMessage(this.api.getMessages().get("item.already_unplaceable"));
        } else {
            ItemStack newItem = CompatibilityLib.getItemUtils().makeReal(item);
            CompatibilityLib.getItemUtils().makeUnplaceable(newItem);
            item.setItemMeta(newItem.getItemMeta());
            sender.sendMessage(this.api.getMessages().get("item.add_unplaceable"));
        }
        return true;
    }

    public boolean onItemRemoveUnplaceable(CommandSender sender, Player player, ItemStack item) {
        if (!CompatibilityLib.getItemUtils().isUnplaceable(item)) {
            sender.sendMessage(this.api.getMessages().get("item.not_unplaceable"));
        } else {
            CompatibilityLib.getItemUtils().removeUnplaceable(item);
            sender.sendMessage(this.api.getMessages().get("item.remove_unplaceable"));
        }
        return true;
    }

    public boolean onItemAddUnbreakable(CommandSender sender, Player player, ItemStack item) {
        if (CompatibilityLib.getItemUtils().isUnbreakable(item)) {
            sender.sendMessage(this.api.getMessages().get("item.already_unbreakable"));
        } else {
            ItemStack newItem = CompatibilityLib.getItemUtils().makeReal(item);
            CompatibilityLib.getItemUtils().makeUnbreakable(newItem);
            item.setItemMeta(newItem.getItemMeta());
            sender.sendMessage(this.api.getMessages().get("item.add_unbreakable"));
        }
        return true;
    }

    public boolean onItemRemoveUnbreakable(CommandSender sender, Player player, ItemStack item) {
        if (!CompatibilityLib.getItemUtils().isUnbreakable(item)) {
            sender.sendMessage(this.api.getMessages().get("item.not_unbreakable"));
        } else {
            CompatibilityLib.getItemUtils().removeUnbreakable(item);
            sender.sendMessage(this.api.getMessages().get("item.remove_unbreakable"));
        }
        return true;
    }

    public boolean onItemAddLore(CommandSender sender, Player player, ItemStack item, String loreLine) {
        ItemMeta itemMeta = item.getItemMeta();
        ArrayList<String> lore = itemMeta.getLore();
        if (lore == null) {
            lore = new ArrayList<String>();
        }
        lore.add(loreLine);
        itemMeta.setLore(lore);
        item.setItemMeta(itemMeta);
        sender.sendMessage(this.api.getMessages().get("item.lore_added").replace("$lore", loreLine));
        return true;
    }

    public boolean onItemRemoveLore(CommandSender sender, Player player, ItemStack item, String loreIndex) {
        ItemMeta itemMeta = item.getItemMeta();
        List lore = itemMeta.getLore();
        if (lore == null || lore.isEmpty()) {
            sender.sendMessage(this.api.getMessages().get("item.no_lore"));
            return true;
        }
        int index = 0;
        if (loreIndex != null) {
            try {
                index = Integer.parseInt(loreIndex);
            }
            catch (Exception ex) {
                sender.sendMessage(ChatColor.RED + "Invalid lore line: " + loreIndex);
                return true;
            }
        }
        if (index < 0 || index >= lore.size()) {
            sender.sendMessage(ChatColor.RED + "Invalid lore line: " + loreIndex);
            return true;
        }
        String line = (String)lore.remove(index);
        itemMeta.setLore(lore);
        item.setItemMeta(itemMeta);
        sender.sendMessage(this.api.getMessages().get("item.lore_removed").replace("$lore", line));
        return true;
    }

    public boolean onItemType(CommandSender sender, Player player, ItemStack item, String[] parameters) {
        if (parameters.length < 1) {
            return false;
        }
        String materialKey = parameters[0];
        MaterialAndData material = new MaterialAndData(materialKey);
        if (!material.isValid() || material.getMaterial() == Material.AIR) {
            sender.sendMessage(ChatColor.RED + "Invalid material key: " + ChatColor.DARK_RED + materialKey);
            return true;
        }
        material.applyToItem(item);
        return true;
    }

    public boolean onItemDurability(CommandSender sender, Player player, ItemStack item, String[] parameters) {
        if (parameters.length < 1) {
            return false;
        }
        short durability = 0;
        try {
            durability = (short)Integer.parseInt(parameters[0]);
        }
        catch (NumberFormatException ex) {
            sender.sendMessage("Invalid damage value: " + parameters[0]);
            return true;
        }
        CompatibilityLib.getDeprecatedUtils().setItemDamage(item, durability);
        return true;
    }

    public boolean onItemAmount(CommandSender sender, ItemStack item, String[] parameters) {
        if (parameters.length < 1) {
            return false;
        }
        short amount = 0;
        try {
            amount = (short)Integer.parseInt(parameters[0]);
        }
        catch (NumberFormatException ex) {
            sender.sendMessage("Invalid amount: " + parameters[0]);
            return true;
        }
        item.setAmount((int)amount);
        return true;
    }

    public boolean onItemAdd(CommandSender sender, Player player, ItemStack item, String[] parameters) {
        if (parameters.length < 1) {
            return false;
        }
        String addCommand = parameters[0];
        if (addCommand.equalsIgnoreCase("unbreakable")) {
            return this.onItemAddUnbreakable(sender, player, item);
        }
        if (addCommand.equalsIgnoreCase("unplaceable")) {
            return this.onItemAddUnplaceable(sender, player, item);
        }
        if (parameters.length < 2) {
            return false;
        }
        if (addCommand.equalsIgnoreCase("flag")) {
            return this.onItemAddFlag(sender, player, item, parameters[1]);
        }
        if (addCommand.equalsIgnoreCase("lore")) {
            Object[] loreLines = Arrays.copyOfRange(parameters, 1, parameters.length);
            String loreLine = CompatibilityLib.getCompatibilityUtils().translateColors(StringUtils.join((Object[])loreLines, (String)" "));
            return this.onItemAddLore(sender, player, item, loreLine);
        }
        if (addCommand.equalsIgnoreCase("enchant")) {
            return this.onItemAddEnchant(sender, player, item, parameters[1], parameters.length >= 3 ? parameters[2] : "1");
        }
        if (parameters.length < 3) {
            return false;
        }
        if (addCommand.equalsIgnoreCase("attribute")) {
            String slot = parameters.length > 3 ? parameters[3] : null;
            AttributeModifier.Operation operation = AttributeModifier.Operation.ADD_NUMBER;
            if (parameters.length > 4) {
                try {
                    operation = AttributeModifier.Operation.valueOf((String)parameters[4].toUpperCase());
                }
                catch (Exception ex) {
                    sender.sendMessage(ChatColor.RED + "Invalid operation: " + parameters[4]);
                }
            }
            return this.onItemAddAttribute(sender, player, item, parameters[1], parameters[2], slot, operation);
        }
        return false;
    }

    public boolean onItemDestroy(CommandSender sender, Player player) {
        player.getInventory().setItemInMainHand(null);
        sender.sendMessage(this.api.getMessages().get("item.destroyed"));
        return true;
    }

    public boolean onItemClean(CommandSender sender, Player player) {
        this.api.getController().cleanItem(player.getInventory().getItemInMainHand());
        sender.sendMessage(this.api.getMessages().get("item.cleaned"));
        return true;
    }

    public boolean onItemRemove(CommandSender sender, Player player, ItemStack item, String[] parameters) {
        String firstParameter;
        if (parameters.length < 1) {
            return false;
        }
        String removeCommand = parameters[0];
        if (removeCommand.equalsIgnoreCase("unbreakable")) {
            return this.onItemRemoveUnbreakable(sender, player, item);
        }
        if (removeCommand.equalsIgnoreCase("unplaceable")) {
            return this.onItemRemoveUnplaceable(sender, player, item);
        }
        String string = firstParameter = parameters.length > 1 ? parameters[1] : null;
        if (removeCommand.equalsIgnoreCase("flag")) {
            return this.onItemRemoveFlag(sender, player, item, firstParameter);
        }
        if (removeCommand.equalsIgnoreCase("lore")) {
            return this.onItemRemoveLore(sender, player, item, firstParameter);
        }
        if (removeCommand.equalsIgnoreCase("enchant")) {
            return this.onItemRemoveEnchant(sender, player, item, firstParameter);
        }
        if (removeCommand.equalsIgnoreCase("attribute")) {
            return this.onItemRemoveAttribute(sender, player, item, firstParameter);
        }
        return false;
    }
}

