/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.economy;

import com.elmakers.mine.bukkit.api.magic.CasterProperties;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.magic.Messages;
import com.elmakers.mine.bukkit.economy.BaseMagicCurrency;
import com.elmakers.mine.bukkit.integration.VaultController;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;

public class VaultCurrency
extends BaseMagicCurrency {
    private final MageController controller;
    private final boolean customFormatting;

    public VaultCurrency(MageController controller, ConfigurationSection configuration) {
        super(controller, "currency", configuration);
        this.customFormatting = configuration.getBoolean("custom_formatting");
        this.controller = controller;
    }

    @Override
    public double getBalance(Mage mage, CasterProperties caster) {
        double balance = 0.0;
        VaultController vault = VaultController.getInstance();
        if (vault != null) {
            balance = vault.getBalance((OfflinePlayer)mage.getPlayer());
        }
        return balance;
    }

    @Override
    public boolean has(Mage mage, CasterProperties caster, double amount) {
        VaultController vault = VaultController.getInstance();
        return vault != null && vault.has((OfflinePlayer)mage.getPlayer(), amount);
    }

    @Override
    public void deduct(Mage mage, CasterProperties caster, double amount) {
        VaultController vault = VaultController.getInstance();
        if (vault != null) {
            vault.withdrawPlayer((OfflinePlayer)mage.getPlayer(), amount);
        }
    }

    @Override
    public boolean give(Mage mage, CasterProperties caster, double amount) {
        VaultController vault = VaultController.getInstance();
        if (vault != null) {
            vault.depositPlayer((OfflinePlayer)mage.getPlayer(), amount);
            return true;
        }
        return false;
    }

    @Override
    public boolean isValid() {
        return this.controller.isVaultCurrencyEnabled();
    }

    @Override
    protected boolean hasDecimals() {
        return true;
    }

    @Override
    public String getName(Messages messages) {
        VaultController vault = VaultController.getInstance();
        if (this.customFormatting || vault == null) {
            return super.getName(messages);
        }
        return vault.getCurrencyPlural();
    }

    @Override
    public String getShortName(Messages messages) {
        VaultController vault = VaultController.getInstance();
        if (this.customFormatting || vault == null) {
            return super.getShortName(messages);
        }
        return vault.getCurrency();
    }

    @Override
    public String getSingularName(Messages messages) {
        VaultController vault = VaultController.getInstance();
        if (this.customFormatting || vault == null) {
            return super.getSingularName(messages);
        }
        return vault.getCurrency();
    }

    @Override
    public String formatAmount(double amount, Messages messages) {
        VaultController vault = VaultController.getInstance();
        if (this.customFormatting || vault == null) {
            return super.formatAmount(amount, messages);
        }
        return vault.format(amount);
    }
}

