/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.block;

import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.batch.Batch;
import com.elmakers.mine.bukkit.api.block.ModifyType;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.magic.MageModifier;
import com.elmakers.mine.bukkit.api.magic.MaterialSet;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.batch.UndoBatch;
import com.elmakers.mine.bukkit.block.BlockComparator;
import com.elmakers.mine.bukkit.block.BlockData;
import com.elmakers.mine.bukkit.block.BlockList;
import com.elmakers.mine.bukkit.block.BoundingBox;
import com.elmakers.mine.bukkit.block.DefaultMaterials;
import com.elmakers.mine.bukkit.block.MaterialAndData;
import com.elmakers.mine.bukkit.block.UndoQueue;
import com.elmakers.mine.bukkit.block.UndoRegistry;
import com.elmakers.mine.bukkit.entity.EntityData;
import com.elmakers.mine.bukkit.entity.SpawnedEntity;
import com.elmakers.mine.bukkit.magic.MagicMetaKeys;
import com.elmakers.mine.bukkit.materials.MaterialSets;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import com.elmakers.mine.bukkit.utility.TextUtils;
import com.google.common.base.Preconditions;
import java.lang.ref.WeakReference;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffectType;

public class UndoList
extends BlockList
implements com.elmakers.mine.bukkit.api.block.UndoList {
    @Nonnull
    public static MaterialSet attachables = MaterialSets.empty();
    @Nonnull
    public static MaterialSet attachablesWall = MaterialSets.empty();
    @Nonnull
    public static MaterialSet attachablesDouble = MaterialSets.empty();
    protected static final UndoRegistry registry = new UndoRegistry();
    protected static final Map<Entity, com.elmakers.mine.bukkit.api.block.UndoList> watchedEntities = new WeakHashMap<Entity, com.elmakers.mine.bukkit.api.block.UndoList>();
    protected static BlockComparator blockComparator = new BlockComparator();
    protected Map<Long, com.elmakers.mine.bukkit.api.block.BlockData> watching;
    private Set<String> worlds = new HashSet<String>();
    private boolean loading = false;
    protected Deque<Runnable> runnables;
    protected Map<UUID, SpawnedEntity> spawnedEntities;
    protected Map<UUID, EntityData> modifiedEntities;
    protected WeakReference<CastContext> context;
    protected WeakReference<Mage> owner;
    protected MageController controller;
    protected Plugin plugin;
    protected boolean undone = false;
    protected boolean finished = false;
    protected int timeToLive = 0;
    protected ModifyType modifyType = ModifyType.NO_PHYSICS;
    protected boolean lockChunks = false;
    protected boolean forceSynchronous = false;
    protected boolean bypass = false;
    protected boolean hasBeenScheduled = false;
    protected final long createdTime;
    protected long modifiedTime;
    protected long scheduledTime;
    protected double speed = 0.0;
    protected WeakReference<Spell> spell;
    protected WeakReference<Batch> batch;
    protected UndoQueue undoQueue;
    protected UndoList next;
    protected UndoList previous;
    protected String name;
    private boolean consumed = false;
    private boolean undoEntityEffects = true;
    private Set<EntityType> undoEntityTypes = null;
    protected boolean undoBreakable = false;
    protected boolean undoReflective = false;
    protected boolean sorted = true;
    protected boolean reverse = true;
    protected boolean unbreakable = false;

    public UndoList(Mage mage, String name) {
        this(mage);
        this.name = name;
    }

    public UndoList(@Nonnull MageController controller) {
        this.controller = controller;
        this.plugin = controller.getPlugin();
        this.modifiedTime = this.createdTime = System.currentTimeMillis();
    }

    public UndoList(Mage mage) {
        this.setMage(mage);
        this.modifiedTime = this.createdTime = System.currentTimeMillis();
    }

    public void setMage(Mage mage) {
        WeakReference<Mage> weakReference = this.owner = mage == null ? null : new WeakReference<Mage>(mage);
        if (mage != null) {
            this.plugin = mage.getController().getPlugin();
            this.controller = mage.getController();
        }
    }

    @Override
    public void setBatch(Batch batch) {
        this.batch = batch == null ? null : new WeakReference<Batch>(batch);
    }

    @Override
    public void setSpell(Spell spell) {
        this.spell = spell == null ? null : new WeakReference<Spell>(spell);
        this.context = spell == null ? null : new WeakReference<CastContext>(spell.getCurrentCast());
    }

    @Override
    public boolean isEmpty() {
        return !(this.blockQueue != null && !this.blockQueue.isEmpty() || this.spawnedEntities != null && !this.spawnedEntities.isEmpty() || this.runnables != null && !this.runnables.isEmpty());
    }

    @Override
    public void setScheduleUndo(int ttl) {
        this.timeToLive = ttl;
        this.updateScheduledUndo();
    }

    @Override
    public void updateScheduledUndo() {
        if (this.timeToLive > 0) {
            this.scheduledTime = System.currentTimeMillis() + (long)this.timeToLive;
        }
    }

    @Override
    public int getScheduledUndo() {
        return this.timeToLive;
    }

    @Override
    public boolean hasChanges() {
        return this.size() > 0 || this.runnables != null && !this.runnables.isEmpty() || this.spawnedEntities != null && !this.spawnedEntities.isEmpty() || this.undoEntityEffects && this.modifiedEntities != null && !this.modifiedEntities.isEmpty();
    }

    @Override
    public void clearAttachables(Block block) {
        this.clearAttachables(block, BlockFace.NORTH, attachablesWall);
        this.clearAttachables(block, BlockFace.SOUTH, attachablesWall);
        this.clearAttachables(block, BlockFace.EAST, attachablesWall);
        this.clearAttachables(block, BlockFace.WEST, attachablesWall);
        this.clearAttachables(block, BlockFace.UP, attachables);
        this.clearAttachables(block, BlockFace.DOWN, attachablesDouble);
    }

    protected boolean clearAttachables(Block block, BlockFace direction, @Nonnull MaterialSet materials) {
        Block testBlock = block.getRelative(direction);
        if (!materials.testBlock(testBlock) || this.isIndestructible(block)) {
            return false;
        }
        this.add(testBlock);
        MaterialAndData.clearItems(testBlock.getState());
        CompatibilityLib.getDeprecatedUtils().setTypeAndData(testBlock, Material.AIR, (byte)0, false);
        if (direction == BlockFace.DOWN || direction == BlockFace.UP) {
            this.clearAttachables(testBlock, direction, materials);
        }
        return true;
    }

    @Override
    public boolean isIndestructible(Block block) {
        CastContext context = this.getContext();
        if (context != null && context.isIndestructible(block)) {
            return true;
        }
        Mage owner = this.getOwner();
        return owner != null && owner.isIndestructible(block);
    }

    @Override
    public boolean add(com.elmakers.mine.bukkit.api.block.BlockData blockData) {
        com.elmakers.mine.bukkit.api.block.BlockData attachedBlock;
        if (this.finished) {
            this.controller.getLogger().warning("Trying to add to a finished UndoList, this may result in blocks that don't get cleaned up: " + this.name);
            Thread.dumpStack();
        }
        if (this.bypass) {
            return true;
        }
        Material mat = blockData.getMaterial();
        if (mat != null && !this.controller.isUndoable(mat)) {
            return false;
        }
        if (!super.add(blockData)) {
            return false;
        }
        this.worlds.add(blockData.getWorldName());
        this.modifiedTime = System.currentTimeMillis();
        if (this.watching != null && (attachedBlock = this.watching.remove(blockData.getId())) != null) {
            UndoList.removeFromWatched(attachedBlock);
        }
        UndoList.register(blockData);
        blockData.setUndoList(this);
        if (this.loading) {
            return true;
        }
        this.addAttachable(blockData, BlockFace.NORTH, attachablesWall);
        this.addAttachable(blockData, BlockFace.SOUTH, attachablesWall);
        this.addAttachable(blockData, BlockFace.EAST, attachablesWall);
        this.addAttachable(blockData, BlockFace.WEST, attachablesWall);
        this.addAttachable(blockData, BlockFace.UP, attachables);
        this.addAttachable(blockData, BlockFace.DOWN, attachablesDouble);
        return true;
    }

    @Override
    public void add(Entity entity) {
        if (entity == null) {
            return;
        }
        if (this.spawnedEntities == null) {
            this.spawnedEntities = new HashMap<UUID, SpawnedEntity>();
        }
        if (entity instanceof Item) {
            this.controller.info("** Dropped item " + TextUtils.nameItem(((Item)entity).getItemStack()) + " added to undo queue of " + this.getName(), 15);
        }
        this.spawnedEntities.put(entity.getUniqueId(), new SpawnedEntity(entity));
        if (this.isScheduled()) {
            CompatibilityLib.getEntityMetadataUtils().setBoolean(entity, MagicMetaKeys.MAGIC_SPAWNED, true);
        }
        this.watch(entity);
        this.contain(entity.getLocation());
        this.modifiedTime = System.currentTimeMillis();
    }

    @Override
    public void add(Runnable runnable) {
        if (runnable == null) {
            return;
        }
        if (this.runnables == null) {
            this.runnables = new ArrayDeque<Runnable>();
        }
        this.runnables.add(runnable);
        this.modifiedTime = System.currentTimeMillis();
    }

    protected boolean addAttachable(com.elmakers.mine.bukkit.api.block.BlockData block, BlockFace direction, @Nonnull MaterialSet materials) {
        BlockData newBlock;
        boolean isDifferentChunk;
        Preconditions.checkNotNull((Object)block, (Object)"block");
        Preconditions.checkNotNull((Object)direction, (Object)"direction");
        Block baseBlock = block.getBlock();
        if (baseBlock == null) {
            return false;
        }
        Block testBlock = baseBlock.getRelative(direction);
        Long blockId = BlockData.getBlockId(testBlock);
        if (this.blockQueue != null && this.blockQueue.containsKey(blockId)) {
            return false;
        }
        if (this.watching != null && this.watching.containsKey(blockId)) {
            return false;
        }
        boolean bl = isDifferentChunk = baseBlock.getX() >> 4 != testBlock.getX() >> 4 || baseBlock.getZ() >> 4 != testBlock.getZ() >> 4;
        if (isDifferentChunk && !CompatibilityLib.getCompatibilityUtils().isChunkLoaded(testBlock.getLocation())) {
            return false;
        }
        if (materials.testBlock(testBlock) && this.contain(newBlock = new BlockData(testBlock))) {
            this.registerWatched(newBlock);
            newBlock.setUndoList(this);
            if (attachablesDouble.testBlock(testBlock)) {
                if (direction != BlockFace.UP) {
                    this.add(newBlock);
                    this.addAttachable(newBlock, BlockFace.DOWN, materials);
                } else if (direction != BlockFace.DOWN) {
                    this.add(newBlock);
                    this.addAttachable(newBlock, BlockFace.UP, materials);
                }
            }
            return true;
        }
        return false;
    }

    public static com.elmakers.mine.bukkit.api.block.BlockData register(Block block) {
        BlockData blockData = new BlockData(block);
        registry.registerModified(blockData);
        return blockData;
    }

    public static void register(com.elmakers.mine.bukkit.api.block.BlockData blockData) {
        registry.registerModified(blockData);
    }

    public void registerWatched(com.elmakers.mine.bukkit.api.block.BlockData blockData) {
        registry.registerWatched(blockData);
        if (this.watching == null) {
            this.watching = new HashMap<Long, com.elmakers.mine.bukkit.api.block.BlockData>();
        }
        this.watching.put(blockData.getId(), blockData);
    }

    protected static void committed(com.elmakers.mine.bukkit.api.block.BlockData block) {
        registry.committed(block);
    }

    @Override
    public void commit() {
        this.unlink();
        this.unregisterWatched();
        if (this.blockQueue == null) {
            return;
        }
        ArrayList staticList = new ArrayList(this.blockQueue.values());
        for (com.elmakers.mine.bukkit.api.block.BlockData block : staticList) {
            block.commit();
        }
        this.clear();
    }

    public static void commitAll() {
        registry.commitAll();
    }

    @Override
    public boolean commitNext() {
        if (this.blockQueue == null || this.blockQueue.isEmpty()) {
            this.unlink();
            this.unregisterWatched();
            this.clear();
            return false;
        }
        com.elmakers.mine.bukkit.api.block.BlockData block = this.removeFirst();
        if (block != null) {
            block.commit();
        }
        return true;
    }

    @Nullable
    private com.elmakers.mine.bukkit.api.block.BlockData removeFirst() {
        Iterator iterator = this.blockQueue.entrySet().iterator();
        if (iterator.hasNext()) {
            com.elmakers.mine.bukkit.api.block.BlockData block = (com.elmakers.mine.bukkit.api.block.BlockData)iterator.next().getValue();
            iterator.remove();
            return block;
        }
        return null;
    }

    @Nullable
    private com.elmakers.mine.bukkit.api.block.BlockData getFirst() {
        Iterator iterator = this.blockQueue.entrySet().iterator();
        if (iterator.hasNext()) {
            com.elmakers.mine.bukkit.api.block.BlockData block = (com.elmakers.mine.bukkit.api.block.BlockData)iterator.next().getValue();
            return block;
        }
        return null;
    }

    @Override
    public boolean remove(Object o) {
        if (o instanceof com.elmakers.mine.bukkit.api.block.BlockData) {
            com.elmakers.mine.bukkit.api.block.BlockData block = (com.elmakers.mine.bukkit.api.block.BlockData)o;
            this.unregister(block, null);
        }
        return super.remove(o);
    }

    @Override
    public void remove(Entity entity) {
        watchedEntities.remove(entity);
        UUID entityId = entity.getUniqueId();
        if (this.spawnedEntities != null) {
            this.spawnedEntities.remove(entityId);
        }
        if (this.modifiedEntities != null) {
            this.modifiedEntities.remove(entityId);
        }
        this.modifiedTime = System.currentTimeMillis();
    }

    public boolean remove(com.elmakers.mine.bukkit.api.block.BlockData blockData, com.elmakers.mine.bukkit.api.block.BlockData prior) {
        this.unregister(blockData, prior);
        return super.remove(blockData);
    }

    private void unregister(com.elmakers.mine.bukkit.api.block.BlockData block, com.elmakers.mine.bukkit.api.block.BlockData prior) {
        Double remainingDamage;
        com.elmakers.mine.bukkit.api.block.BlockData next;
        if (block == null) {
            return;
        }
        if (prior == null) {
            prior = block.getPriorState();
        }
        UndoList.removeFromModified(block, prior);
        if (prior != null) {
            prior.setNextState(block.getNextState());
        }
        if ((next = block.getNextState()) != null) {
            next.setPriorState(prior);
        }
        if ((remainingDamage = registry.removeDamage(block)) != null) {
            if (remainingDamage <= 0.0) {
                CompatibilityLib.getCompatibilityUtils().clearBreaking(block.getBlock());
            } else {
                CompatibilityLib.getCompatibilityUtils().setBreaking(block.getBlock(), remainingDamage);
            }
        }
        if (this.undoBreakable) {
            registry.removeBreakable(block);
        }
        if (this.undoReflective) {
            registry.removeReflective(block);
        }
    }

    protected static void removeFromModified(com.elmakers.mine.bukkit.api.block.BlockData block) {
        registry.removeFromModified(block);
    }

    protected static void removeFromModified(com.elmakers.mine.bukkit.api.block.BlockData block, com.elmakers.mine.bukkit.api.block.BlockData priorState) {
        registry.removeFromModified(block, priorState);
    }

    protected static void removeFromWatched(com.elmakers.mine.bukkit.api.block.BlockData block) {
        registry.removeFromWatched(block);
    }

    @Override
    @Nullable
    public com.elmakers.mine.bukkit.api.block.BlockData undoNext(boolean applyPhysics) {
        if (this.blockQueue.size() == 0) {
            return null;
        }
        com.elmakers.mine.bukkit.api.block.BlockData blockData = this.getFirst();
        Block block = blockData.getBlock();
        if (this.forceSynchronous && !CompatibilityLib.getCompatibilityUtils().isChunkLoaded(block)) {
            block.getChunk().load();
        } else if (!CompatibilityLib.getCompatibilityUtils().checkChunk(blockData.getWorldLocation())) {
            this.speed = 0.0;
            return null;
        }
        if (this.undo(blockData, applyPhysics)) {
            return blockData;
        }
        return null;
    }

    public void undone(com.elmakers.mine.bukkit.api.block.BlockData blockData, BlockState currentState) {
        Block block;
        CastContext context;
        Mage owner = this.getOwner();
        if (this.consumed && !this.isScheduled() && currentState.getType() != Material.AIR && owner != null) {
            owner.refundBlock(new MaterialAndData(currentState.getType()));
        }
        if ((context = this.getContext()) != null && context.hasEffects("undo_block") && (block = blockData.getBlock()).getType() != currentState.getType()) {
            context.playEffects("undo_block", 1.0f, null, null, block.getLocation(), null, block);
        }
    }

    private boolean undo(com.elmakers.mine.bukkit.api.block.BlockData undoBlock, boolean applyPhysics) {
        return undoBlock.undo(applyPhysics ? ModifyType.NORMAL : this.modifyType);
    }

    @Override
    public void undo() {
        this.undo(false);
    }

    @Override
    public void undo(boolean blocking) {
        Spell spell = this.getSpell();
        if (spell != null) {
            spell.stop();
        }
        this.undo(blocking, true);
    }

    public void undo(boolean blocking, boolean undoEntities) {
        Batch batch;
        if (this.undone) {
            return;
        }
        this.undone = true;
        if (blocking) {
            this.forceSynchronous = true;
            this.speed = 0.0;
        }
        if ((batch = this.getBatch()) != null && !batch.isFinished()) {
            batch.finish();
        }
        if (undoEntities) {
            this.speed = 0.0;
        }
        this.undoEntityEffects = this.undoEntityEffects || undoEntities;
        this.unlink();
        CastContext context = this.getContext();
        if (context != null) {
            context.cancelEffects();
        }
        if (this.runnables != null) {
            for (Runnable runnable : this.runnables) {
                runnable.run();
            }
            this.runnables = null;
        }
        if (this.blockQueue == null) {
            this.undoEntityEffects();
            return;
        }
        this.undoEntityEffects();
        UndoBatch undoBatch = new UndoBatch(this);
        Mage owner = this.getOwner();
        if (blocking || owner == null) {
            while (!undoBatch.isFinished()) {
                undoBatch.process(1000);
            }
        } else {
            owner.addUndoBatch(undoBatch);
        }
    }

    public void undoEntityEffects() {
        if (this.spawnedEntities != null || this.modifiedEntities != null) {
            if (this.spawnedEntities != null) {
                for (SpawnedEntity entity : this.spawnedEntities.values()) {
                    entity.despawn(this.controller, this.getContext());
                }
                this.spawnedEntities = null;
            }
            if (this.modifiedEntities != null) {
                for (EntityData data : this.modifiedEntities.values()) {
                    Entity entity = data.getEntity();
                    if (entity != null) {
                        UndoList.setUndoList(entity, null);
                    }
                    if (!this.undoEntityEffects && this.undoEntityTypes != null && !this.undoEntityTypes.contains(data.getType())) continue;
                    CastContext context = this.getContext();
                    if (context != null && entity != null && context.hasEffects("undo_entity")) {
                        context.playEffects("undo_entity", 1.0f, null, null, entity.getLocation(), entity, null);
                    }
                    try {
                        data.undo();
                    }
                    catch (Exception ex) {
                        if (context != null) {
                            context.getLogger().log(Level.WARNING, "Error restoring entity on undo", ex);
                        }
                        ex.printStackTrace();
                    }
                    if (entity != null || context == null || (entity = data.getEntity()) == null || !context.hasEffects("undo_entity")) continue;
                    context.playEffects("undo_entity", 1.0f, null, null, entity.getLocation(), entity, null);
                }
                this.modifiedEntities = null;
            }
        }
    }

    @Override
    public boolean isUndone() {
        return this.undone;
    }

    @Override
    public boolean isUnbreakable() {
        return this.unbreakable;
    }

    @Override
    public void setUnbreakable(boolean unbreakable) {
        this.unbreakable = unbreakable;
    }

    @Override
    public void undoScheduled(boolean blocking) {
        this.undo(blocking, false);
        Mage owner = this.getOwner();
        if (this.isScheduled() && owner != null) {
            owner.getController().cancelScheduledUndo(this);
        }
    }

    @Override
    public void undoScheduled() {
        this.undo(false, false);
    }

    public void unregisterWatched() {
        if (this.watching != null) {
            for (com.elmakers.mine.bukkit.api.block.BlockData block : this.watching.values()) {
                UndoList.removeFromWatched(block);
            }
            this.watching = null;
        }
    }

    public void unregisterWatched(com.elmakers.mine.bukkit.api.block.BlockData blockData) {
        if (this.watching != null) {
            this.watching.remove(blockData.getId());
        }
        registry.removeFromWatched(blockData);
    }

    public void finish() {
        this.finished = true;
    }

    @Override
    public void load(ConfigurationSection node) {
        this.loading = true;
        super.load(node);
        this.loading = false;
        this.timeToLive = node.getInt("time_to_live", this.timeToLive);
        this.name = node.getString("name", this.name);
        String typeName = node.getString("mode", "");
        if (!typeName.isEmpty()) {
            try {
                this.modifyType = ModifyType.valueOf(typeName);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.consumed = node.getBoolean("consumed", this.consumed);
    }

    @Override
    public void save(ConfigurationSection node) {
        super.save(node);
        node.set("time_to_live", (Object)this.timeToLive);
        node.set("name", (Object)this.name);
        if (this.modifyType != ModifyType.NORMAL) {
            node.set("mode", (Object)this.modifyType.name());
        }
        if (this.consumed) {
            node.set("consumed", (Object)true);
        }
    }

    public void watch(Entity entity) {
        if (entity == null) {
            return;
        }
        com.elmakers.mine.bukkit.api.block.UndoList list = watchedEntities.get(entity);
        if (list == null) {
            UndoList.setUndoList(entity, this);
        }
        this.modifiedTime = System.currentTimeMillis();
    }

    @Override
    @Nullable
    public EntityData modify(Entity entity) {
        EntityData entityData = null;
        if (entity == null || CompatibilityLib.getEntityMetadataUtils().getBoolean(entity, MagicMetaKeys.NO_TARGET)) {
            return entityData;
        }
        UUID entityId = entity.getUniqueId();
        if (this.spawnedEntities != null && this.spawnedEntities.containsKey(entityId) && !entity.isValid()) {
            this.spawnedEntities.remove(entityId);
        } else if (entity.isValid()) {
            if (this.modifiedEntities == null) {
                this.modifiedEntities = new HashMap<UUID, EntityData>();
            }
            if ((entityData = this.modifiedEntities.get(entityId)) == null) {
                entityData = new EntityData(this.controller, entity);
                this.modifiedEntities.put(entityId, entityData);
                this.watch(entity);
            }
        }
        this.modifiedTime = System.currentTimeMillis();
        return entityData;
    }

    @Override
    @Nullable
    public EntityData damage(Entity entity) {
        com.elmakers.mine.bukkit.api.block.UndoList undoList;
        Item item;
        ItemStack itemStack;
        EntityData data = this.modify(entity);
        if (entity instanceof Item && (itemStack = (item = (Item)entity).getItemStack()) != null && DefaultMaterials.isShulkerBox(itemStack.getType()) && (undoList = this.controller.getEntityUndo(entity)) != null) {
            CompatibilityLib.getNBTUtils().removeMeta(itemStack, "BlockEntityTag");
        }
        if (this.undoEntityTypes != null && this.undoEntityTypes.contains(entity.getType()) && entity instanceof Hanging) {
            entity.remove();
        }
        if (data != null) {
            data.setRespawn(true);
            data.setDamaged(true);
        }
        return data;
    }

    @Override
    public void move(Entity entity) {
        EntityData entityData = this.modify(entity);
        if (entityData != null) {
            entityData.setHasMoved(true);
        }
    }

    @Override
    public void modifyVelocity(Entity entity) {
        EntityData entityData = this.modify(entity);
        if (entityData != null) {
            entityData.setHasVelocity(true);
        }
    }

    @Override
    public void addPotionEffects(Entity entity) {
        EntityData entityData = this.modify(entity);
        if (entityData != null) {
            entityData.setHasPotionEffects(true);
        }
    }

    @Override
    public void addPotionEffectForRemoval(Entity entity, PotionEffectType potionEffectType) {
        EntityData entityData = this.modify(entity);
        if (entityData != null) {
            entityData.addPotionEffectForRemoval(potionEffectType);
        }
    }

    @Override
    public void addModifier(Entity entity, MageModifier modifier) {
        EntityData entityData = this.modify(entity);
        if (entityData != null) {
            entityData.addModifier(modifier);
        }
    }

    @Override
    public void addModifierForRemoval(Entity entity, String modifierKey) {
        EntityData entityData = this.modify(entity);
        if (entityData != null) {
            entityData.addModifierForRemoval(modifierKey);
        }
    }

    @Override
    public void convert(Entity fallingBlock, Block block) {
        this.remove(fallingBlock);
        this.add(block);
    }

    @Override
    public void fall(Entity fallingBlock, Block block) {
        if (this.isScheduled() && fallingBlock instanceof FallingBlock) {
            ((FallingBlock)fallingBlock).setDropItem(false);
        }
        this.add(fallingBlock);
        this.add(block);
        this.modifiedTime = System.currentTimeMillis();
    }

    @Override
    public void explode(Entity explodingEntity, List<Block> blocks) {
        for (Block block : blocks) {
            this.add(block);
        }
        this.modifiedTime = System.currentTimeMillis();
    }

    @Override
    public void finalizeExplosion(Entity explodingEntity, List<Block> blocks) {
        this.remove(explodingEntity);
        if (this.isScheduled()) {
            for (Block block : blocks) {
                BlockState state = block.getState();
                if (state instanceof InventoryHolder) {
                    InventoryHolder holder = (InventoryHolder)state;
                    holder.getInventory().clear();
                    state.update();
                }
                block.setType(Material.AIR);
            }
        }
        this.modifiedTime = System.currentTimeMillis();
    }

    @Override
    public void cancelExplosion(Entity explodingEntity) {
        this.remove(explodingEntity);
    }

    @Override
    public boolean bypass() {
        return this.bypass;
    }

    @Override
    public void setBypass(boolean bypass) {
        this.bypass = bypass;
    }

    @Override
    public boolean isBypass() {
        return this.bypass;
    }

    @Override
    public long getCreatedTime() {
        return this.createdTime;
    }

    @Override
    public long getModifiedTime() {
        return this.modifiedTime;
    }

    @Override
    public boolean contains(Location location, int threshold) {
        BoundingBox area = (BoundingBox)this.areas.get(location.getWorld().getName());
        return area != null && area.contains(location.toVector(), threshold);
    }

    @Override
    public void prune() {
        if (this.blockQueue == null) {
            return;
        }
        Iterator<com.elmakers.mine.bukkit.api.block.BlockData> iterator = this.iterator();
        while (iterator.hasNext()) {
            com.elmakers.mine.bukkit.api.block.BlockData block = iterator.next();
            if (block.isDifferent()) continue;
            iterator.remove();
            this.remove(block);
        }
        this.modifiedTime = System.currentTimeMillis();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Nullable
    public Spell getSpell() {
        return this.spell == null ? null : (Spell)this.spell.get();
    }

    @Nullable
    public Batch getBatch() {
        return this.batch == null ? null : (Batch)this.batch.get();
    }

    @Override
    @Nullable
    public Mage getOwner() {
        return this.owner == null ? null : (Mage)this.owner.get();
    }

    public MageController getController() {
        return this.controller;
    }

    @Override
    @Nullable
    public CastContext getContext() {
        return this.context == null ? null : (CastContext)this.context.get();
    }

    @Override
    public long getScheduledTime() {
        return this.scheduledTime;
    }

    @Override
    public boolean isScheduled() {
        return this.timeToLive > 0;
    }

    @Override
    public int compareTo(com.elmakers.mine.bukkit.api.block.UndoList o) {
        return Long.compare(this.scheduledTime, o.getScheduledTime());
    }

    @Override
    public boolean hasBeenScheduled() {
        return this.hasBeenScheduled;
    }

    @Override
    public void setHasBeenScheduled() {
        this.hasBeenScheduled = true;
    }

    @Override
    public void setEntityUndo(boolean undoEntityEffects) {
        this.undoEntityEffects = undoEntityEffects;
    }

    @Override
    public void setSorted(boolean sorted) {
        this.sorted = sorted;
    }

    @Override
    public void setReversed(boolean reverse) {
        this.reverse = reverse;
    }

    @Override
    public void setEntityUndoTypes(Set<EntityType> undoTypes) {
        this.undoEntityTypes = undoTypes;
    }

    public void setNext(UndoList next) {
        this.next = next;
    }

    public void setPrevious(UndoList previous) {
        this.previous = previous;
    }

    public void setUndoQueue(com.elmakers.mine.bukkit.api.block.UndoQueue undoQueue) {
        if (undoQueue != null && undoQueue instanceof UndoQueue) {
            this.undoQueue = (UndoQueue)undoQueue;
        }
    }

    public boolean hasUndoQueue() {
        return this.undoQueue != null;
    }

    public void unlink() {
        if (this.undoQueue != null) {
            this.undoQueue.removed(this);
            this.undoQueue = null;
        }
        if (this.next != null) {
            this.next.previous = this.previous;
        }
        if (this.previous != null) {
            this.previous.next = this.next;
        }
        this.previous = null;
        this.next = null;
    }

    public UndoList getNext() {
        return this.next;
    }

    public UndoList getPrevious() {
        return this.previous;
    }

    @Override
    public void setApplyPhysics(boolean applyPhysics) {
        if (applyPhysics) {
            this.modifyType = ModifyType.NORMAL;
        } else if (this.modifyType != ModifyType.FAST) {
            this.modifyType = ModifyType.NO_PHYSICS;
        }
    }

    @Override
    public boolean getApplyPhysics() {
        return this.modifyType == ModifyType.NORMAL;
    }

    @Override
    public void setLockChunks(boolean lockChunks) {
        this.lockChunks = lockChunks;
    }

    public boolean getLockChunks() {
        return this.lockChunks;
    }

    @Override
    public void setModifyType(ModifyType modifyType) {
        this.modifyType = modifyType;
    }

    @Override
    public ModifyType getModifyType() {
        return this.modifyType;
    }

    @Nullable
    public static com.elmakers.mine.bukkit.api.block.UndoList getUndoList(Entity entity) {
        Location entityLocation;
        com.elmakers.mine.bukkit.api.block.UndoList blockList;
        com.elmakers.mine.bukkit.api.block.UndoList undoList = blockList = entity != null ? watchedEntities.get(entity) : null;
        if (entity != null && blockList == null && entity instanceof FallingBlock && (blockList = UndoList.getUndoList(entityLocation = entity.getLocation())) == null) {
            entityLocation.setY(entityLocation.getY() - 1.0);
            blockList = UndoList.getUndoList(entityLocation);
        }
        return blockList;
    }

    @Nullable
    public static com.elmakers.mine.bukkit.api.block.UndoList getUndoList(Location location) {
        com.elmakers.mine.bukkit.api.block.BlockData blockData = UndoList.getBlockData(location);
        return blockData == null ? null : blockData.getUndoList();
    }

    public static void setUndoList(Entity entity, com.elmakers.mine.bukkit.api.block.UndoList list) {
        if (entity != null) {
            if (list != null) {
                watchedEntities.put(entity, list);
            } else {
                watchedEntities.remove(entity);
            }
        }
    }

    @Override
    public EntityData getEntityData(Entity entity) {
        return this.modifiedEntities.get(entity.getUniqueId());
    }

    @Nullable
    public static com.elmakers.mine.bukkit.api.block.BlockData getBlockData(Location location) {
        return registry.getBlockData(location);
    }

    @Nullable
    public static com.elmakers.mine.bukkit.api.block.BlockData getModified(Location location) {
        return registry.getModifiedBlock(location);
    }

    public static UndoRegistry getRegistry() {
        return registry;
    }

    @Override
    public void setUndoBreakable(boolean breakable) {
        this.undoBreakable = breakable;
    }

    @Override
    public void setUndoReflective(boolean reflective) {
        this.undoReflective = reflective;
    }

    @Override
    @Deprecated
    public void setUndoBreaking(boolean breaking) {
    }

    @Override
    public void addDamage(Block block, double damage) {
        com.elmakers.mine.bukkit.api.block.BlockData blockData = this.get(block);
        blockData.addDamage(damage);
    }

    @Override
    public void registerFakeBlock(Block block, Collection<WeakReference<Player>> players) {
        if (this.contains(block)) {
            return;
        }
        com.elmakers.mine.bukkit.api.block.BlockData blockData = this.get(block);
        blockData.setFake(players);
    }

    @Override
    public Collection<Entity> getAllEntities() {
        Entity entity;
        ArrayList<Entity> entities = new ArrayList<Entity>();
        if (this.spawnedEntities != null) {
            for (SpawnedEntity spawnedEntity : this.spawnedEntities.values()) {
                entity = spawnedEntity.getEntity();
                if (entity == null) continue;
                entities.add(entity);
            }
        }
        if (this.modifiedEntities != null) {
            for (EntityData entityData : this.modifiedEntities.values()) {
                entity = entityData.getEntity();
                if (entity == null) continue;
                entities.add(entity);
            }
        }
        return entities;
    }

    public void sort(MaterialSet attachables) {
        if (this.blockQueue == null) {
            return;
        }
        ArrayList sortedList = new ArrayList(this.blockQueue.values());
        this.blockQueue.clear();
        if (this.reverse) {
            Collections.reverse(sortedList);
        }
        if (attachables != null && this.sorted) {
            blockComparator.setAttachables(attachables);
            Collections.sort(sortedList, blockComparator);
        }
        for (com.elmakers.mine.bukkit.api.block.BlockData block : sortedList) {
            this.blockQueue.put(block.getId(), block);
        }
    }

    public double getUndoSpeed() {
        return this.speed;
    }

    @Override
    public void setUndoSpeed(double speed) {
        this.speed = speed;
    }

    @Override
    public boolean isConsumed() {
        return this.consumed;
    }

    @Override
    public void setConsumed(boolean consumed) {
        this.consumed = consumed;
    }

    @Override
    public int getRunnableCount() {
        return this.runnables == null ? 0 : this.runnables.size();
    }

    @Override
    @Nullable
    public Runnable undoNextRunnable() {
        Runnable undone = null;
        if (this.runnables != null && !this.runnables.isEmpty()) {
            undone = this.runnables.pop();
            undone.run();
        }
        return undone;
    }

    @Override
    public boolean isUndoType(EntityType entityType) {
        return this.undoEntityTypes != null && this.undoEntityTypes.contains(entityType);
    }

    @Override
    public boolean affectsWorld(@Nonnull World world) {
        Preconditions.checkNotNull((Object)world);
        return this.worlds.contains(world.getName());
    }

    public void setSynchronous(boolean sync) {
        this.forceSynchronous = sync;
        if (sync) {
            this.speed = 0.0;
        }
    }

    @Override
    public boolean isSynchronous() {
        return this.forceSynchronous;
    }
}

