/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility.platform.base.entity;

import com.elmakers.mine.bukkit.entity.EntityExtraData;
import com.elmakers.mine.bukkit.utility.ConfigUtils;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.EulerAngle;

public class EntityArmorStandData
extends EntityExtraData {
    public ItemStack itemInHand;
    public ItemStack boots;
    public ItemStack leggings;
    public ItemStack chestplate;
    public ItemStack helmet;
    public EulerAngle bodyPose;
    public EulerAngle leftArmPose;
    public EulerAngle rightArmPose;
    public EulerAngle leftLegPose;
    public EulerAngle rightLegPose;
    public EulerAngle headPose;
    public Boolean isMarker;
    public Boolean hasGravity;
    public Boolean isInvisible;
    public Boolean hasArms;
    public Boolean isSmall;
    public Boolean hasBasePlate;
    public Integer disabledSlots;

    public EntityArmorStandData(ArmorStand armorStand) {
        EntityEquipment equipment = armorStand.getEquipment();
        this.itemInHand = equipment.getItemInMainHand();
        if (this.itemInHand != null) {
            this.itemInHand = this.itemInHand.clone();
        }
        this.boots = equipment.getBoots();
        if (this.boots != null) {
            this.boots = this.boots.clone();
        }
        this.leggings = equipment.getLeggings();
        if (this.leggings != null) {
            this.leggings = this.leggings.clone();
        }
        this.chestplate = equipment.getChestplate();
        if (this.chestplate != null) {
            this.chestplate = this.chestplate.clone();
        }
        this.helmet = equipment.getHelmet();
        if (this.helmet != null) {
            this.helmet = this.helmet.clone();
        }
        this.bodyPose = armorStand.getBodyPose();
        this.leftArmPose = armorStand.getLeftArmPose();
        this.rightArmPose = armorStand.getRightArmPose();
        this.leftLegPose = armorStand.getLeftLegPose();
        this.rightLegPose = armorStand.getRightLegPose();
        this.headPose = armorStand.getHeadPose();
        this.hasGravity = armorStand.hasGravity();
        this.isInvisible = !armorStand.isVisible();
        this.hasArms = armorStand.hasArms();
        this.isSmall = armorStand.isSmall();
        this.hasBasePlate = armorStand.hasBasePlate();
        this.isMarker = armorStand.isMarker();
        this.disabledSlots = EntityArmorStandData.getPlatform().getCompatibilityUtils().getDisabledSlots(armorStand);
    }

    public EntityArmorStandData(ConfigurationSection parameters) {
        this.isSmall = ConfigUtils.getOptionalBoolean(parameters, "small");
        this.isInvisible = ConfigUtils.getOptionalBoolean(parameters, "invisible");
        this.hasBasePlate = ConfigUtils.getOptionalBoolean(parameters, "baseplate");
        this.hasGravity = ConfigUtils.getOptionalBoolean(parameters, "gravity");
        this.isMarker = ConfigUtils.getOptionalBoolean(parameters, "marker");
        this.hasArms = ConfigUtils.getOptionalBoolean(parameters, "arms");
        this.disabledSlots = ConfigUtils.getOptionalInteger(parameters, "disabled_slots");
        this.bodyPose = ConfigUtils.getEulerAngle(parameters, "body_pose");
        this.leftArmPose = ConfigUtils.getEulerAngle(parameters, "left_arm_pose");
        this.rightArmPose = ConfigUtils.getEulerAngle(parameters, "right_arm_pose");
        this.leftLegPose = ConfigUtils.getEulerAngle(parameters, "left_leg_pose");
        this.rightLegPose = ConfigUtils.getEulerAngle(parameters, "right_leg_pose");
        this.headPose = ConfigUtils.getEulerAngle(parameters, "head_pose");
    }

    @Override
    public void apply(Entity entity) {
        if (!(entity instanceof ArmorStand)) {
            return;
        }
        ArmorStand armorStand = (ArmorStand)entity;
        EntityEquipment equipment = armorStand.getEquipment();
        if (this.itemInHand != null) {
            equipment.setItemInMainHand(this.itemInHand);
        }
        if (this.boots != null) {
            equipment.setBoots(this.boots);
        }
        if (this.leggings != null) {
            equipment.setLeggings(this.leggings);
        }
        if (this.chestplate != null) {
            equipment.setChestplate(this.chestplate);
        }
        if (this.helmet != null) {
            equipment.setHelmet(this.helmet);
        }
        if (this.bodyPose != null) {
            armorStand.setBodyPose(this.bodyPose);
        }
        if (this.leftArmPose != null) {
            armorStand.setLeftArmPose(this.leftArmPose);
        }
        if (this.rightArmPose != null) {
            armorStand.setRightArmPose(this.rightArmPose);
        }
        if (this.leftLegPose != null) {
            armorStand.setLeftLegPose(this.leftLegPose);
        }
        if (this.rightLegPose != null) {
            armorStand.setRightLegPose(this.rightLegPose);
        }
        if (this.headPose != null) {
            armorStand.setHeadPose(this.headPose);
        }
        if (this.hasGravity != null) {
            armorStand.setGravity(this.hasGravity.booleanValue());
        }
        if (this.isInvisible != null) {
            armorStand.setVisible(this.isInvisible.booleanValue());
        }
        if (this.hasArms != null) {
            armorStand.setArms(this.hasArms.booleanValue());
        }
        if (this.isSmall != null) {
            armorStand.setSmall(this.isSmall.booleanValue());
        }
        if (this.hasBasePlate != null) {
            armorStand.setBasePlate(this.hasBasePlate.booleanValue());
        }
        if (this.isMarker != null) {
            armorStand.setMarker(this.isMarker.booleanValue());
        }
        if (this.disabledSlots != null) {
            EntityArmorStandData.getPlatform().getCompatibilityUtils().setDisabledSlots(armorStand, this.disabledSlots);
        }
    }
}

