/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility.help;

import com.elmakers.mine.bukkit.ChatUtils;
import com.elmakers.mine.bukkit.utility.help.Help;
import com.elmakers.mine.bukkit.utility.help.SearchFactors;

public class HelpTopicWord {
    private final String word;
    private int count;
    private int topicCount;
    private Double weight;

    public HelpTopicWord(String word) {
        this.word = word;
    }

    public int getCount() {
        return this.count;
    }

    public int getTopicCount() {
        return this.topicCount;
    }

    public void addTopic(int count) {
        ++this.topicCount;
        this.count += count;
    }

    public double getWeight(Help help) {
        if (this.weight == null) {
            this.weight = this.computeWeight(help);
        }
        return this.weight;
    }

    private double computeWeight(Help help) {
        double rarityWeight = this.getRarityWeight(help.maxCount) * SearchFactors.RARITY_WEIGHT;
        double topicRarityWeight = this.getTopicWeight(help.maxTopicCount) * SearchFactors.TOPIC_RARITY_WEIGHT;
        double lengthWeight = this.getLengthWeight(this.word, help.maxLength) * SearchFactors.LENGTH_WEIGHT;
        double totalWeight = SearchFactors.RARITY_WEIGHT + SearchFactors.TOPIC_RARITY_WEIGHT + SearchFactors.LENGTH_WEIGHT;
        return (rarityWeight + topicRarityWeight + lengthWeight) / totalWeight;
    }

    protected double getRarityWeight(int maxCount) {
        double rarityWeight = 1.0 - (double)this.count / (double)(maxCount + 1);
        return Math.pow(rarityWeight, SearchFactors.RARITY_FACTOR);
    }

    protected double getLengthWeight(String word, int maxLength) {
        double lengthWeight = (double)word.length() / (double)maxLength;
        return Math.pow(lengthWeight, SearchFactors.LENGTH_FACTOR);
    }

    protected double getTopicWeight(int maxTopicCount) {
        double topicRarityWeight = 1.0 - (double)this.topicCount / (double)(maxTopicCount + 1);
        return Math.pow(topicRarityWeight, SearchFactors.TOPIC_RARITY_FACTOR);
    }

    public String getDebugText(Help help) {
        double rarityWeight = this.getRarityWeight(help.maxCount);
        double topicRarityWeight = this.getTopicWeight(help.maxTopicCount);
        double lengthWeight = this.getLengthWeight(this.word, help.maxLength);
        return "Rare: " + ChatUtils.printPercentage(rarityWeight) + "x" + (int)SearchFactors.RARITY_WEIGHT + " + TRare: " + ChatUtils.printPercentage(topicRarityWeight) + "x" + (int)SearchFactors.TOPIC_RARITY_WEIGHT + " + Len: " + ChatUtils.printPercentage(lengthWeight) + "x" + (int)SearchFactors.LENGTH_WEIGHT;
    }

    public void reset() {
        this.weight = null;
    }
}

