/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic.listener;

import com.elmakers.mine.bukkit.api.event.MagicMobDeathEvent;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.entity.EntityData;
import com.elmakers.mine.bukkit.magic.Mage;
import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.magic.MagicMetaKeys;
import com.elmakers.mine.bukkit.magic.listener.ChunkLoadListener;
import com.elmakers.mine.bukkit.npc.MagicNPC;
import com.elmakers.mine.bukkit.tasks.CheckChunkTask;
import com.elmakers.mine.bukkit.tasks.CheckEntitySpawnTask;
import com.elmakers.mine.bukkit.tasks.ModifyEntityTask;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Slime;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import org.bukkit.event.entity.EntityTeleportEvent;
import org.bukkit.event.entity.SlimeSplitEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.plugin.Plugin;
import org.spigotmc.event.entity.EntityDismountEvent;

public class MobController
implements Listener,
ChunkLoadListener {
    public static boolean REMOVE_INVULNERABLE = false;
    private MagicController controller;
    private final Map<String, EntityData> mobs = new HashMap<String, EntityData>();
    private final Map<String, EntityData> mobsByName = new HashMap<String, EntityData>();
    private final Map<EntityType, EntityData> defaultMobs = new HashMap<EntityType, EntityData>();
    private final Map<Entity, EntityData> activeMobs = new WeakHashMap<Entity, EntityData>();

    public MobController(MagicController controller) {
        this.controller = controller;
    }

    public void clear() {
        this.mobs.clear();
        this.mobsByName.clear();
    }

    public void load(String mobKey, ConfigurationSection mobConfiguration) {
        if (!ConfigurationUtils.isEnabled(mobConfiguration)) {
            return;
        }
        EntityData mob = new EntityData(this.controller, mobKey, mobConfiguration);
        try {
            EntityType defaultType = EntityType.valueOf((String)mobKey.toUpperCase());
            this.defaultMobs.put(defaultType, mob);
            return;
        }
        catch (Exception defaultType) {
            this.mobs.put(mobKey, mob);
            String mobName = mob.getName();
            if (mobName != null && !mobName.isEmpty() && mob.isRegisterByName()) {
                this.mobsByName.put(mobName, mob);
            }
            return;
        }
    }

    public void registerMythicMobs(Collection<String> mythicMobKeys) {
        for (String mythicMobKey : mythicMobKeys) {
            EntityData existing = this.mobs.get(mythicMobKey);
            if (existing != null) {
                existing.setMythicMobKey(mythicMobKey);
                continue;
            }
            EntityData wrapper = EntityData.wrapMythicMob(this.controller, mythicMobKey);
            this.mobs.put(mythicMobKey, wrapper);
        }
    }

    public void validate() {
        for (EntityData mob : this.mobs.values()) {
            mob.validate();
        }
    }

    public void checkMagicMob(Entity entity, String mobKey) {
        EntityData storedMob = this.controller.getMob(mobKey);
        if (storedMob != null) {
            storedMob.modify(entity);
        }
    }

    public void updateAllMobs() {
        HashMap<Entity, EntityData> currentMobs = new HashMap<Entity, EntityData>(this.activeMobs);
        for (Map.Entry entry : currentMobs.entrySet()) {
            EntityData mob = (EntityData)entry.getValue();
            String key = mob.getKey();
            if (key == null || key.isEmpty() || (mob = this.controller.getMob(key)) == null) continue;
            mob.modify((Entity)entry.getKey());
        }
    }

    public void checkNPC(Entity entity, String npcId) {
        try {
            MagicNPC npc = this.controller.getNPC(npcId);
            if (npc == null || !npc.isEntity(entity)) {
                Location location = entity.getLocation();
                this.controller.info("Removing an invalid NPC (id=" + npcId + ") entity of type " + entity.getType() + " at [" + location.getWorld().getName() + "] " + location.getBlockX() + "," + location.getBlockY() + "," + location.getBlockZ(), 5);
                entity.remove();
            }
        }
        catch (Exception ex) {
            this.controller.getLogger().log(Level.SEVERE, "Error reading entity NPC id", ex);
        }
    }

    @Override
    public void onEntitiesLoaded(Chunk chunk, List<Entity> entities) {
        for (Entity entity : entities) {
            String magicMobKey;
            if (entity instanceof Player) continue;
            boolean removed = false;
            String npcId = CompatibilityLib.getEntityMetadataUtils().getString(entity, MagicMetaKeys.NPC_ID);
            if (npcId != null) {
                this.checkNPC(entity, npcId);
            } else if (REMOVE_INVULNERABLE && entity.getType() != EntityType.DROPPED_ITEM && CompatibilityLib.getCompatibilityUtils().isInvulnerable(entity)) {
                Location location = entity.getLocation();
                this.controller.getLogger().warning("Removing an invulnerable entity of type " + entity.getType() + " at [" + location.getWorld().getName() + "] " + location.getBlockX() + "," + location.getBlockY() + "," + location.getBlockZ());
                entity.remove();
                removed = true;
            }
            if (removed || npcId != null || (magicMobKey = CompatibilityLib.getEntityMetadataUtils().getString(entity, MagicMetaKeys.MAGIC_MOB)) == null) continue;
            this.checkMagicMob(entity, magicMobKey);
        }
    }

    @EventHandler(ignoreCancelled=false, priority=EventPriority.HIGH)
    public void onChunkLoad(ChunkLoadEvent event) {
        CheckChunkTask.process(this.controller, this, event.getChunk());
    }

    @EventHandler(ignoreCancelled=false, priority=EventPriority.HIGHEST)
    public void onCreatureSpawn(CreatureSpawnEvent event) {
        if (EntityData.isSpawning) {
            return;
        }
        LivingEntity entity = event.getEntity();
        if (entity.getType() == EntityType.PLAYER) {
            return;
        }
        Plugin plugin = this.controller.getPlugin();
        CreatureSpawnEvent.SpawnReason reason = event.getSpawnReason();
        if (reason == CreatureSpawnEvent.SpawnReason.CUSTOM) {
            plugin.getServer().getScheduler().runTaskLater(plugin, (Runnable)new CheckEntitySpawnTask(this, (Entity)entity), 1L);
            return;
        }
        if (this.checkDefaultSpawn((Entity)entity, true)) {
            return;
        }
        if (reason != CreatureSpawnEvent.SpawnReason.SPAWNER && reason != CreatureSpawnEvent.SpawnReason.SPAWNER_EGG && reason != CreatureSpawnEvent.SpawnReason.DISPENSE_EGG) {
            return;
        }
        this.checkEntitySpawn((Entity)entity, true);
    }

    public boolean checkDefaultSpawn(Entity entity, boolean defer) {
        String customName = entity.getCustomName();
        EntityData customMob = this.defaultMobs.get(entity.getType());
        if (customName == null && customMob != null) {
            if (defer) {
                Plugin plugin = this.controller.getPlugin();
                plugin.getServer().getScheduler().runTaskLater(plugin, (Runnable)new ModifyEntityTask(this.controller, customMob, entity), 1L);
            } else {
                customMob.modify(entity);
            }
            return true;
        }
        return false;
    }

    public boolean checkEntitySpawn(Entity entity, boolean defer) {
        EntityData mythicMob;
        String mythicMobKey = this.controller.getMythicMobKey(entity);
        if (mythicMobKey != null && (mythicMob = this.controller.getMob(mythicMobKey)) != null) {
            mythicMob.modify(entity);
            return true;
        }
        String customName = entity.getCustomName();
        if (customName == null || customName.isEmpty()) {
            return false;
        }
        EntityData namedMob = this.mobsByName.get(customName);
        if (namedMob == null) {
            return false;
        }
        if (defer) {
            Plugin plugin = this.controller.getPlugin();
            plugin.getServer().getScheduler().runTaskLater(plugin, (Runnable)new ModifyEntityTask(this.controller, namedMob, entity), 1L);
        } else {
            namedMob.modify(entity);
        }
        return true;
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onEntityTarget(EntityTargetEvent event) {
        com.elmakers.mine.bukkit.api.entity.EntityData entityData;
        Entity entity = event.getEntity();
        if (this.controller.isMagicNPC(entity)) {
            event.setCancelled(true);
        } else if (event.getReason() != EntityTargetEvent.TargetReason.CUSTOM && event.getReason() != EntityTargetEvent.TargetReason.UNKNOWN && (entityData = this.controller.getMob(entity)) != null && entityData.isDocile()) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onEntityTargetEntity(EntityTargetLivingEntityEvent event) {
        com.elmakers.mine.bukkit.api.entity.EntityData mageMob;
        Mage mage;
        Entity source = event.getEntity();
        if (source instanceof Player || event.isCancelled()) {
            return;
        }
        LivingEntity target = event.getTarget();
        if (target != null) {
            UUID ownerId = CompatibilityLib.getCompatibilityUtils().getOwnerId(source);
            if (ownerId != null && ownerId.equals(target.getUniqueId())) {
                event.setCancelled(true);
                return;
            }
            Mage targetMage = this.controller.getRegisteredMage((Entity)target);
            if (targetMage != null && targetMage.isIgnoredByMobs()) {
                event.setCancelled(true);
                return;
            }
            com.elmakers.mine.bukkit.api.entity.EntityData entityData = this.controller.getMob(source);
            if (entityData != null && !entityData.canTarget((Entity)target)) {
                event.setCancelled(true);
            }
        }
        if ((mage = this.controller.getRegisteredMage(source)) == null) {
            return;
        }
        if (target == null && (mageMob = mage.getEntityData()) != null && !mageMob.isRelentless()) {
            return;
        }
        Entity currentTarget = mage.getTopDamager();
        if (currentTarget != null && currentTarget != target) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onSlimeSplit(SlimeSplitEvent event) {
        Slime entity = event.getEntity();
        if (CompatibilityLib.getEntityMetadataUtils().getBoolean((Entity)entity, MagicMetaKeys.NOSPLIT)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEntityDeath(EntityDeathEvent event) {
        LivingEntity entity = event.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        EntityData mob = this.activeMobs.get(entity);
        if (mob == null) {
            return;
        }
        if (entity instanceof Player) {
            this.controller.getLogger().warning("A player has magic mob data on death, this shouldn't happen");
            return;
        }
        this.activeMobs.remove(entity);
        MagicMobDeathEvent deathEvent = new MagicMobDeathEvent(this.controller, mob, event);
        Bukkit.getPluginManager().callEvent((Event)deathEvent);
        mob.onDeath((Entity)entity);
        if (!mob.isSplittable()) {
            CompatibilityLib.getEntityMetadataUtils().setBoolean((Entity)entity, MagicMetaKeys.NOSPLIT, true);
        }
        if (!CompatibilityLib.getEntityMetadataUtils().getBoolean((Entity)entity, MagicMetaKeys.NO_DROPS)) {
            mob.modifyDrops(event);
        }
    }

    public int getCount() {
        return this.mobs.size();
    }

    public Set<String> getKeys() {
        return this.mobs.keySet();
    }

    public Collection<EntityData> getMobs() {
        return this.mobs.values();
    }

    public EntityData get(String key) {
        return this.mobs.get(key);
    }

    public EntityData getByName(String name) {
        return this.mobsByName.get(name);
    }

    public void register(@Nonnull Entity entity, @Nonnull EntityData entityData) {
        EntityData existing = this.activeMobs.get(entity);
        if (existing != null && existing != entityData) {
            entityData = existing.createVariant(entityData.getConfiguration());
        }
        this.activeMobs.put(entity, entityData);
    }

    @Nullable
    public EntityData getEntityData(Entity entity) {
        return this.activeMobs.get(entity);
    }

    @Nonnull
    public Collection<Entity> getActiveMobs() {
        return new ArrayList<Entity>(this.activeMobs.keySet());
    }

    @Nonnull
    public EntityData getDefaultMob(EntityType entityType) {
        EntityData defaultMob = this.defaultMobs.get(entityType);
        if (defaultMob == null) {
            defaultMob = new EntityData((MageController)this.controller, entityType);
        }
        return defaultMob;
    }

    @EventHandler
    public void onChunkUnload(ChunkUnloadEvent event) {
        Chunk chunk = event.getChunk();
        if (this.controller.isDespawnMagicMobs()) {
            Collection<com.elmakers.mine.bukkit.api.magic.Mage> magicMobs = this.controller.getMobMages();
            for (com.elmakers.mine.bukkit.api.magic.Mage mage : magicMobs) {
                Entity entity = mage.getEntity();
                if (entity == null) continue;
                Location location = entity.getLocation();
                if (chunk.getWorld() != location.getWorld()) continue;
                int chunkX = chunk.getX();
                int chunkZ = chunk.getZ();
                if (chunkZ != location.getBlockZ() >> 4 || chunkX != location.getBlockX() >> 4) continue;
                mage.sendDebugMessage(ChatColor.RED + "Despawned", 4);
                entity.remove();
            }
        }
    }

    @EventHandler
    public void onEntityDismount(EntityDismountEvent event) {
        if (CompatibilityLib.getCompatibilityUtils().isTeleporting()) {
            return;
        }
        EntityData entityData = this.getEntityData(event.getEntity());
        if (entityData != null && entityData.isPreventDismount()) {
            CompatibilityLib.getCompatibilityUtils().cancelDismount(event);
        }
    }

    @EventHandler
    public void onEntityTeleport(EntityTeleportEvent event) {
        EntityData entityData = this.getEntityData(event.getEntity());
        if (entityData != null && entityData.isPreventTeleport()) {
            event.setCancelled(true);
        }
    }
}

