/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.block.DefaultMaterials;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import java.util.Arrays;
import java.util.Collection;
import org.bukkit.block.Block;
import org.bukkit.block.CommandBlock;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;

public class DebuggerAction
extends BaseSpellAction {
    private int debugLevel;
    private boolean check;
    private boolean checkBrain;
    private boolean forceMage;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.debugLevel = parameters.getInt("level", 1);
        this.check = parameters.getBoolean("check", false);
        this.checkBrain = parameters.getBoolean("check_brain", false);
        this.forceMage = parameters.getBoolean("force", false);
    }

    @Override
    public SpellResult perform(CastContext context) {
        int currentLevel;
        Entity entity = context.getTargetEntity();
        MageController controller = context.getController();
        Mage mage = null;
        if (entity != null && (controller.isMage(entity) || this.forceMage)) {
            mage = controller.getMage(entity);
        } else {
            Block block = context.getTargetBlock();
            if (DefaultMaterials.isCommand(block.getType())) {
                CommandBlock commandBlock = (CommandBlock)block.getState();
                String commandName = commandBlock.getName();
                String mageId = "COMMAND";
                if (commandName != null && commandName.length() > 0) {
                    mageId = "COMMAND-" + commandBlock.getName();
                }
                mage = controller.getRegisteredMage(mageId);
            }
        }
        if (mage == null) {
            return SpellResult.NO_TARGET;
        }
        if (this.check) {
            mage.debugPermissions(context.getMage().getCommandSender(), null);
        }
        if (this.checkBrain) {
            mage.debugBrain(context.getMage().getCommandSender());
        }
        if ((currentLevel = mage.getDebugLevel()) == this.debugLevel || this.debugLevel == 0) {
            mage.setDebugLevel(0);
            mage.setDebugger(null);
            return SpellResult.DEACTIVATE;
        }
        mage.setDebugLevel(this.debugLevel);
        mage.setDebugger(context.getMage().getCommandSender());
        return SpellResult.CAST;
    }

    @Override
    public boolean isUndoable() {
        return false;
    }

    @Override
    public boolean requiresTarget() {
        return true;
    }

    @Override
    public void getParameterNames(Spell spell, Collection<String> parameters) {
        super.getParameterNames(spell, parameters);
        parameters.add("level");
    }

    @Override
    public void getParameterOptions(Spell spell, String parameterKey, Collection<String> examples) {
        if (parameterKey.equals("level")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_SIZES));
        } else {
            super.getParameterOptions(spell, parameterKey, examples);
        }
    }
}

