/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.CompoundLocationAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.configuration.ConfigurationSection;

public class FindTileEntitiesAction
extends CompoundLocationAction {
    protected int radius;

    @Override
    public void reset(CastContext context) {
        super.reset(context);
        this.createActionContext(context, context.getTargetEntity(), context.getTargetLocation());
    }

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        this.radius = parameters.getInt("radius", 0);
        Mage mage = context.getMage();
        this.radius = (int)(mage.getRadiusMultiplier() * (float)this.radius);
        super.prepare(context, parameters);
    }

    @Override
    public void addLocations(CastContext context, List<Location> locations) {
        context.addWork(20);
        Mage mage = context.getMage();
        Location sourceLocation = context.getTargetLocation();
        if (mage.getDebugLevel() > 8) {
            mage.sendDebugMessage(ChatColor.GREEN + "Finding tile entities from " + ChatColor.GRAY + sourceLocation.getBlockX() + ChatColor.DARK_GRAY + "," + ChatColor.GRAY + sourceLocation.getBlockY() + ChatColor.DARK_GRAY + "," + ChatColor.GRAY + sourceLocation.getBlockZ() + ChatColor.DARK_GREEN + " with radius of " + ChatColor.GREEN + this.radius, 14);
        }
        World world = context.getWorld();
        int baseX = sourceLocation.getChunk().getX();
        int baseZ = sourceLocation.getChunk().getZ();
        int chunkRadius = (int)Math.ceil((double)this.radius / 16.0);
        for (int x = -chunkRadius; x <= chunkRadius; ++x) {
            for (int z = -chunkRadius; z <= chunkRadius; ++z) {
                BlockState[] blocks;
                Chunk chunk = world.getChunkAt(baseX + x, baseZ + z);
                for (BlockState blockState : blocks = chunk.getTileEntities()) {
                    Block block = blockState.getBlock();
                    if (!context.isDestructible(block)) continue;
                    locations.add(block.getLocation());
                }
            }
        }
    }

    @Override
    public void getParameterNames(Spell spell, Collection<String> parameters) {
        super.getParameterNames(spell, parameters);
        parameters.add("radius");
    }

    @Override
    public void getParameterOptions(Spell spell, String parameterKey, Collection<String> examples) {
        if (parameterKey.equals("radius")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_SIZES));
        } else {
            super.getParameterOptions(spell, parameterKey, examples);
        }
    }

    @Override
    public boolean requiresTarget() {
        return true;
    }
}

