/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility.platform.legacy;

import com.elmakers.mine.bukkit.utility.platform.Platform;
import com.elmakers.mine.bukkit.utility.platform.base.SchematicUtilsBase;
import com.elmakers.mine.bukkit.utility.platform.legacy.NMSUtils;
import com.elmakers.mine.bukkit.utility.schematic.LoadableSchematic;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.util.Vector;

public class SchematicUtils
extends SchematicUtilsBase {
    public SchematicUtils(Platform platform) {
        super(platform);
    }

    @Override
    public boolean loadSchematic(InputStream input, LoadableSchematic schematic, Logger log) {
        if (input == null || schematic == null || NMSUtils.class_NBTCompressedStreamTools_loadFileMethod == null) {
            return false;
        }
        try {
            int i;
            int size;
            Object nbtData = NMSUtils.class_NBTCompressedStreamTools_loadFileMethod.invoke(null, input);
            if (nbtData == null) {
                return false;
            }
            short width = (Short)NMSUtils.class_NBTTagCompound_getShortMethod.invoke(nbtData, "Width");
            short height = (Short)NMSUtils.class_NBTTagCompound_getShortMethod.invoke(nbtData, "Height");
            short length = (Short)NMSUtils.class_NBTTagCompound_getShortMethod.invoke(nbtData, "Length");
            Object palette = NMSUtils.class_NBTTagCompound_getCompoundMethod.invoke(nbtData, "Palette");
            byte[] blockData = (byte[])NMSUtils.class_NBTTagCompound_getByteArrayMethod.invoke(nbtData, "BlockData");
            int[] blockMap = null;
            HashMap<Integer, String> paletteMap = null;
            if (palette != null) {
                paletteMap = new HashMap<Integer, String>();
                Set keys = (Set)NMSUtils.class_NBTTagCompound_getKeysMethod.invoke(palette, new Object[0]);
                for (String key : keys) {
                    int index = (Integer)NMSUtils.class_NBTTagCompound_getIntMethod.invoke(palette, key);
                    paletteMap.put(index, key);
                }
            }
            if (blockData != null) {
                int varInt = 0;
                int varIntLength = 0;
                int index = 0;
                blockMap = new int[width * height * length];
                for (int i2 = 0; i2 < blockData.length; ++i2) {
                    varInt |= (blockData[i2] & 0x7F) << varIntLength++ * 7;
                    if ((blockData[i2] & 0x80) == 128) continue;
                    blockMap[index++] = varInt;
                    varIntLength = 0;
                    varInt = 0;
                }
                if (index != blockMap.length) {
                    log.warning("Block data array length does not match dimensions in schematic");
                }
            }
            ArrayList<Object> tileEntityData = new ArrayList<Object>();
            ArrayList<Object> entityData = new ArrayList<Object>();
            Object entityList = NMSUtils.class_NBTTagCompound_getListMethod.invoke(nbtData, "Entities", 10);
            Object tileEntityList = null;
            if (((Boolean)NMSUtils.class_NBTTagCompound_hasKeyMethod.invoke(nbtData, "BlockEntities")).booleanValue()) {
                tileEntityList = NMSUtils.class_NBTTagCompound_getListMethod.invoke(nbtData, "BlockEntities", 10);
            } else {
                NMSUtils.class_NBTTagCompound_getListMethod.invoke(nbtData, "TileEntities", 10);
            }
            if (entityList != null) {
                size = (Integer)NMSUtils.class_NBTTagList_sizeMethod.invoke(entityList, new Object[0]);
                for (i = 0; i < size; ++i) {
                    Object entity = NMSUtils.class_NBTTagList_getMethod.invoke(entityList, i);
                    entityData.add(entity);
                }
            }
            if (tileEntityList != null) {
                size = (Integer)NMSUtils.class_NBTTagList_sizeMethod.invoke(tileEntityList, new Object[0]);
                for (i = 0; i < size; ++i) {
                    Object tileEntity = NMSUtils.class_NBTTagList_getMethod.invoke(tileEntityList, i);
                    tileEntityData.add(tileEntity);
                }
            }
            Vector origin = new Vector(0, 0, 0);
            int[] offset = (int[])NMSUtils.class_NBTTagCompound_getIntArrayMethod.invoke(nbtData, "Offset");
            if (offset != null && offset.length == 3) {
                origin.setX(offset[0]);
                origin.setY(offset[1]);
                origin.setZ(offset[2]);
            }
            schematic.load(width, height, length, blockMap, null, paletteMap, tileEntityData, entityData, origin);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public boolean loadLegacySchematic(InputStream input, LoadableSchematic schematic) {
        if (input == null || schematic == null || NMSUtils.class_NBTCompressedStreamTools_loadFileMethod == null) {
            return false;
        }
        try {
            int i;
            int size;
            Object nbtData = NMSUtils.class_NBTCompressedStreamTools_loadFileMethod.invoke(null, input);
            if (nbtData == null) {
                return false;
            }
            String materials = (String)NMSUtils.class_NBTTagCompound_getStringMethod.invoke(nbtData, "Materials");
            if (!materials.equals("Alpha")) {
                Bukkit.getLogger().warning("Schematic is not in Alpha format");
                return false;
            }
            short width = (Short)NMSUtils.class_NBTTagCompound_getShortMethod.invoke(nbtData, "Width");
            short height = (Short)NMSUtils.class_NBTTagCompound_getShortMethod.invoke(nbtData, "Height");
            short length = (Short)NMSUtils.class_NBTTagCompound_getShortMethod.invoke(nbtData, "Length");
            byte[] blockIds = (byte[])NMSUtils.class_NBTTagCompound_getByteArrayMethod.invoke(nbtData, "Blocks");
            int[] blocks = new int[blockIds.length];
            byte[] addBlocks = new byte[]{};
            if (((Boolean)NMSUtils.class_NBTTagCompound_hasKeyMethod.invoke(nbtData, "AddBlocks")).booleanValue()) {
                addBlocks = (byte[])NMSUtils.class_NBTTagCompound_getByteArrayMethod.invoke(nbtData, "AddBlocks");
            }
            for (int index = 0; index < blocks.length; ++index) {
                blocks[index] = index >> 1 >= addBlocks.length ? (int)((short)(blockIds[index] & 0xFF)) : ((index & 1) == 0 ? (int)((short)(((addBlocks[index >> 1] & 0xF) << 8) + (blockIds[index] & 0xFF))) : (int)((short)(((addBlocks[index >> 1] & 0xF0) << 4) + (blockIds[index] & 0xFF))));
            }
            byte[] data = (byte[])NMSUtils.class_NBTTagCompound_getByteArrayMethod.invoke(nbtData, "Data");
            ArrayList<Object> tileEntityData = new ArrayList<Object>();
            ArrayList<Object> entityData = new ArrayList<Object>();
            Object entityList = NMSUtils.class_NBTTagCompound_getListMethod.invoke(nbtData, "Entities", 10);
            Object tileEntityList = NMSUtils.class_NBTTagCompound_getListMethod.invoke(nbtData, "TileEntities", 10);
            if (entityList != null) {
                size = (Integer)NMSUtils.class_NBTTagList_sizeMethod.invoke(entityList, new Object[0]);
                for (i = 0; i < size; ++i) {
                    Object entity = NMSUtils.class_NBTTagList_getMethod.invoke(entityList, i);
                    entityData.add(entity);
                }
            }
            if (tileEntityList != null) {
                size = (Integer)NMSUtils.class_NBTTagList_sizeMethod.invoke(tileEntityList, new Object[0]);
                for (i = 0; i < size; ++i) {
                    Object tileEntity = NMSUtils.class_NBTTagList_getMethod.invoke(tileEntityList, i);
                    tileEntityData.add(tileEntity);
                }
            }
            int originX = (Integer)NMSUtils.class_NBTTagCompound_getIntMethod.invoke(nbtData, "WEOriginX");
            int originY = (Integer)NMSUtils.class_NBTTagCompound_getIntMethod.invoke(nbtData, "WEOriginY");
            int originZ = (Integer)NMSUtils.class_NBTTagCompound_getIntMethod.invoke(nbtData, "WEOriginZ");
            schematic.load(width, height, length, blocks, data, null, tileEntityData, entityData, new Vector(originX, originY, originZ));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }
}

