/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.tasks;

import com.elmakers.mine.bukkit.api.data.MageData;
import com.elmakers.mine.bukkit.api.event.MageLoadEvent;
import com.elmakers.mine.bukkit.magic.Mage;
import com.elmakers.mine.bukkit.magic.MagicController;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;

public class MageFinishLoadTask
implements Runnable {
    private final Mage mage;
    private final MageData data;

    public MageFinishLoadTask(Mage mage, MageData data) {
        this.mage = mage;
        this.data = data;
    }

    @Override
    public void run() {
        try {
            this.mage.onLoad(this.data);
            this.mage.setLoading(false);
            if (this.mage.isValid() && this.mage.isPlayer()) {
                MagicController controller = this.mage.getController();
                controller.onPlayerJoin(this.mage);
            }
            MageLoadEvent event = new MageLoadEvent(this.mage, this.data == null);
            Bukkit.getPluginManager().callEvent((Event)event);
        }
        catch (Exception ex) {
            this.mage.getController().getLogger().warning("Failed to load mage data for player " + this.mage.getName());
            this.mage.setLoading(true);
        }
    }
}

