/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.tasks;

import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.magic.listener.ChunkLoadListener;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Chunk;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;

public class CheckChunkTask
implements Runnable {
    private final ChunkLoadListener listener;
    private final Chunk chunk;

    public CheckChunkTask(ChunkLoadListener listener, Chunk chunk) {
        this.listener = listener;
        this.chunk = chunk;
    }

    @Override
    public void run() {
        if (this.chunk.isLoaded()) {
            CheckChunkTask.call(this.listener, this.chunk);
        }
    }

    protected static void call(ChunkLoadListener listener, Chunk chunk) {
        CheckChunkTask.call(listener, chunk, true);
    }

    protected static void call(ChunkLoadListener listener, Chunk chunk, boolean checkEntities) {
        List<Entity> entityList;
        listener.onChunkLoad(chunk);
        if (checkEntities && (entityList = CheckChunkTask.getEntityList(chunk)) != null) {
            listener.onEntitiesLoaded(chunk, entityList);
        }
    }

    private static List<Entity> getEntityList(Chunk chunk) {
        Entity[] entities = chunk.getEntities();
        List<Entity> entityList = null;
        if (entities.length > 0) {
            entityList = Arrays.asList(entities);
        }
        return entityList;
    }

    public static void process(MagicController controller, ChunkLoadListener listener, Chunk chunk) {
        if (!controller.isDataLoaded()) {
            CheckChunkTask.defer(controller.getPlugin(), listener, chunk, 5);
        } else if (CompatibilityLib.hasDeferredEntityLoad()) {
            if (!CompatibilityLib.hasEntityLoadEvent()) {
                CheckChunkTask.defer(controller.getPlugin(), listener, chunk, 40);
            } else {
                CheckChunkTask.call(listener, chunk, false);
            }
        } else {
            CheckChunkTask.call(listener, chunk);
        }
    }

    private static void defer(Plugin plugin, ChunkLoadListener listener, Chunk chunk, int delay) {
        plugin.getServer().getScheduler().runTaskLater(plugin, (Runnable)new CheckChunkTask(listener, chunk), (long)delay);
    }
}

