/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.spell.builtin;

import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.automata.AutomatonLevel;
import com.elmakers.mine.bukkit.batch.SimulateBatch;
import com.elmakers.mine.bukkit.block.MaterialAndData;
import com.elmakers.mine.bukkit.boss.BossBarConfiguration;
import com.elmakers.mine.bukkit.spell.BlockSpell;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.Target;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeMap;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class SimulateSpell
extends BlockSpell {
    public static final String[] SIMULATE_PARAMETERS = new String[]{"radius", "yradius", "material", "omx", "omy", "omz", "death_material", "olcx", "olcy", "olcz", "obcx", "obcy", "obcz", "live_rules", "birth_rules", "target_mode", "target_types", "move", "target_min_range", "target_max_range", "cast", "death_cast", "cast_probability", "diagonal_live_rules", "diagonal_birth_rules", "boss_bar"};
    private static final int DEFAULT_RADIUS = 32;
    private TreeMap<Integer, AutomatonLevel> levelMap = null;
    static final Integer[] emptyList = new Integer[0];

    @Override
    public SpellResult onCast(ConfigurationSection parameters) {
        boolean success;
        Target t = this.getTarget();
        if (t == null) {
            return SpellResult.NO_TARGET;
        }
        Block target = t.getBlock();
        if (target == null) {
            return SpellResult.NO_TARGET;
        }
        if (!this.hasBuildPermission(target)) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        int radius = parameters.getInt("radius", 32);
        radius = parameters.getInt("r", radius);
        int yRadius = parameters.getInt("yradius", 0);
        MaterialAndData birthMaterial = new MaterialAndData(target);
        birthMaterial = ConfigurationUtils.getMaterialAndData(parameters, "material", birthMaterial);
        birthMaterial = ConfigurationUtils.getMaterialAndData(parameters, "m", birthMaterial);
        Double dmxValue = ConfigurationUtils.getDouble(parameters, "obx", null);
        Double dmyValue = ConfigurationUtils.getDouble(parameters, "oby", null);
        Double dmzValue = ConfigurationUtils.getDouble(parameters, "obz", null);
        if (dmxValue != null || dmyValue != null || dmzValue != null) {
            Vector offset = new Vector(dmxValue == null ? 0.0 : dmxValue, dmyValue == null ? 0.0 : dmyValue, dmzValue == null ? 0.0 : dmzValue);
            Location targetLocation = target.getLocation().add(offset);
            if (!CompatibilityLib.getCompatibilityUtils().isChunkLoaded(targetLocation)) {
                return SpellResult.FAIL;
            }
            birthMaterial = new MaterialAndData(targetLocation.getBlock());
        }
        Material deathMaterial = ConfigurationUtils.getMaterial(parameters, "death_material", Material.AIR);
        Location location = this.getLocation();
        Location targetLocation = target.getLocation();
        targetLocation.setPitch(location.getPitch());
        targetLocation.setYaw(location.getYaw());
        HashSet<Integer> birthCounts = new HashSet<Integer>();
        HashSet<Integer> liveCounts = new HashSet<Integer>();
        Double dlcxValue = ConfigurationUtils.getDouble(parameters, "olcx", null);
        Double dlcyValue = ConfigurationUtils.getDouble(parameters, "olcy", null);
        Double dlczValue = ConfigurationUtils.getDouble(parameters, "olcz", null);
        if (dlcxValue != null || dlcyValue != null || dlczValue != null) {
            Location liveChestLocation = targetLocation.clone().add(new Vector(dlcxValue == null ? 0.0 : dlcxValue, dlcyValue == null ? 0.0 : dlcyValue, dlczValue == null ? 0.0 : dlczValue));
            Block chestBlock = liveChestLocation.getBlock();
            BlockState chestState = chestBlock.getState();
            if (chestState instanceof InventoryHolder) {
                ItemStack[] items = ((InventoryHolder)chestState).getInventory().getContents();
                for (int index = 0; index < items.length; ++index) {
                    if (items[index] == null || items[index].getType() == Material.AIR) continue;
                    liveCounts.add(index + 1);
                }
            } else {
                this.controller.getLogger().warning("SimulateSpell: Chest for live rules not found at " + liveChestLocation.toVector());
            }
        } else if (parameters.contains("live_rules")) {
            liveCounts.addAll(ConfigurationUtils.getIntegerList(parameters, "live_rules"));
        } else {
            liveCounts.add(2);
            liveCounts.add(3);
        }
        Double dbcxValue = ConfigurationUtils.getDouble(parameters, "obcx", null);
        Double dbcyValue = ConfigurationUtils.getDouble(parameters, "obcy", null);
        Double dbczValue = ConfigurationUtils.getDouble(parameters, "obcz", null);
        if (dbcxValue != null || dbcyValue != null || dbczValue != null) {
            Location birthChestLocation = targetLocation.clone().add(new Vector(dbcxValue == null ? 0.0 : dbcxValue, dbcyValue == null ? 0.0 : dbcyValue, dbczValue == null ? 0.0 : dbczValue));
            Block chestBlock = birthChestLocation.getBlock();
            BlockState chestState = chestBlock.getState();
            if (chestState instanceof InventoryHolder) {
                ItemStack[] items = ((InventoryHolder)chestState).getInventory().getContents();
                for (int index = 0; index < items.length; ++index) {
                    if (items[index] == null || items[index].getType() == Material.AIR) continue;
                    birthCounts.add(index + 1);
                }
            } else {
                this.controller.getLogger().warning("SimulateSpell: Chest for birth rules not found at " + birthChestLocation.toVector());
            }
        } else if (parameters.contains("birth_rules")) {
            birthCounts.addAll(ConfigurationUtils.getIntegerList(parameters, "birth_rules"));
        } else {
            birthCounts.add(3);
        }
        if (liveCounts.size() == 0 || birthCounts.size() == 0) {
            return SpellResult.FAIL;
        }
        String automataName = parameters.getString("animate", null);
        boolean isAutomata = automataName != null;
        SimulateBatch batch = new SimulateBatch(this, targetLocation, radius, yRadius, birthMaterial, deathMaterial, liveCounts, birthCounts, automataName);
        if (parameters.contains("diagonal_live_rules")) {
            batch.setDiagonalLiveRules(ConfigurationUtils.getIntegerList(parameters, "diagonal_live_rules"));
        }
        if (parameters.contains("diagonal_birth_rules")) {
            batch.setDiagonalBirthRules(ConfigurationUtils.getIntegerList(parameters, "diagonal_birth_rules"));
        }
        batch.setBossBar(BossBarConfiguration.parse(this.controller, parameters, "$p"));
        batch.setReflectChange(parameters.getDouble("reflect_chance", 0.0));
        batch.setBirthRange(parameters.getInt("birth_range", 0));
        batch.setLiveRange(parameters.getInt("live_range", 0));
        batch.setConcurrent(parameters.getBoolean("concurrent", false));
        batch.setCastRange(parameters.getInt("cast_range", 16));
        int delay = parameters.getInt("delay", 0);
        if (isAutomata) {
            int level;
            SimulateBatch.TargetMode targetMode = null;
            String targetModeString = parameters.getString("target_mode", "");
            if (targetModeString.length() > 0) {
                try {
                    targetMode = SimulateBatch.TargetMode.valueOf(targetModeString.toUpperCase());
                }
                catch (Exception ex) {
                    this.controller.getLogger().warning(ex.getMessage());
                }
            }
            SimulateBatch.TargetMode backupTargetMode = null;
            String backupTargetModeString = parameters.getString("backup_target_mode", "");
            if (backupTargetModeString.length() > 0) {
                try {
                    backupTargetMode = SimulateBatch.TargetMode.valueOf(backupTargetModeString.toUpperCase());
                }
                catch (Exception ex) {
                    this.controller.getLogger().warning(ex.getMessage());
                }
            }
            batch.setMoveRange(parameters.getInt("move", 3));
            SimulateBatch.TargetType targetType = null;
            String targetTypeString = parameters.getString("targets", "");
            if (targetTypeString.length() > 0) {
                try {
                    targetType = SimulateBatch.TargetType.valueOf(targetTypeString.toUpperCase());
                }
                catch (Exception ex) {
                    this.controller.getLogger().warning(ex.getMessage());
                }
            }
            batch.setTargetType(targetType);
            batch.setMinHuntRange(parameters.getInt("target_min_range", 4));
            batch.setMaxHuntRange(parameters.getInt("target_max_range", 128));
            batch.setDrop(parameters.getString("drop"), parameters.getInt("drop_xp", 0), ConfigurationUtils.getStringList(parameters, "drops"));
            int maxBlocks = parameters.getInt("max_blocks");
            batch.setMaxBlocks(maxBlocks);
            batch.setMinBlocks(parameters.getInt("min_blocks", maxBlocks));
            batch.setKeepTarget(parameters.getBoolean("keep_target", false));
            batch.setArena(parameters.getString("arena"));
            String deathMaterialsKeys = parameters.getString("death_materials");
            if (deathMaterialsKeys != null && !deathMaterialsKeys.isEmpty()) {
                batch.setDeathMaterials(this.controller.getMaterialSetManager().fromConfig(deathMaterialsKeys));
            }
            if ((level = parameters.getInt("level", 1)) < 1) {
                level = 1;
            }
            if (this.levelMap != null) {
                AutomatonLevel automatonLevel = this.levelMap.get(level);
                batch.setLevel(automatonLevel);
                delay = automatonLevel.getDelay(delay);
            }
            batch.setDelay(delay);
            if (targetMode != null) {
                batch.setTargetMode(targetMode);
            }
            if (backupTargetMode != null) {
                batch.setBackupTargetMode(backupTargetMode);
            }
        }
        return (success = this.mage.addBatch(batch)) ? SpellResult.CAST : SpellResult.FAIL;
    }

    @Override
    protected boolean isBatched() {
        return true;
    }

    @Override
    public void getParameters(Collection<String> parameters) {
        super.getParameters(parameters);
        parameters.addAll(Arrays.asList(SIMULATE_PARAMETERS));
    }

    @Override
    public void getParameterOptions(Collection<String> examples, String parameterKey) {
        super.getParameterOptions(examples, parameterKey);
        if (parameterKey.equals("material")) {
            examples.addAll(this.controller.getBrushKeys());
        } else if (parameterKey.equals("radius") || parameterKey.equals("yradis")) {
            examples.addAll(Arrays.asList(EXAMPLE_SIZES));
        } else if (parameterKey.equals("target_mode")) {
            SimulateBatch.TargetMode[] targetModes;
            for (SimulateBatch.TargetMode targetMode : targetModes = SimulateBatch.TargetMode.values()) {
                examples.add(targetMode.name().toLowerCase());
            }
        } else if (parameterKey.equals("target_types")) {
            SimulateBatch.TargetType[] targetTypes;
            for (SimulateBatch.TargetType targetType : targetTypes = SimulateBatch.TargetType.values()) {
                examples.add(targetType.name().toLowerCase());
            }
        } else if (parameterKey.equals("cast_probability")) {
            examples.addAll(Arrays.asList(EXAMPLE_PERCENTAGES));
        }
    }

    @Override
    protected void loadTemplate(ConfigurationSection template) {
        super.loadTemplate(template);
        if (template.contains("levels")) {
            ConfigurationSection levelTemplate = template.getConfigurationSection("levels");
            Set levelKeys = levelTemplate.getKeys(false);
            ArrayList<Integer> levels = new ArrayList<Integer>(levelKeys.size());
            for (String levelString : levelKeys) {
                levels.add(Integer.parseInt(levelString));
            }
            if (levels.size() == 0) {
                return;
            }
            this.levelMap = new TreeMap();
            Collections.sort(levels);
            Integer[] levelsArray = levels.toArray(emptyList);
            for (int level = 1; level <= levelsArray[levelsArray.length - 1]; ++level) {
                this.levelMap.put(level, new AutomatonLevel(level, levelsArray, template));
            }
        } else {
            this.levelMap = new TreeMap();
            this.levelMap.put(1, new AutomatonLevel(1, null, template));
        }
    }
}

