/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.requirements;

import com.elmakers.mine.bukkit.requirements.RangedRequirement;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import java.util.logging.Logger;
import org.bukkit.configuration.ConfigurationSection;

class TimeRequirement
extends RangedRequirement {
    public TimeRequirement(String value, Logger logger) {
        try {
            if (value.startsWith("<")) {
                if (value.startsWith("<=")) {
                    this.max = (double)ConfigurationUtils.parseTime(value.substring(2), logger, "time requirement");
                    this.inclusive = true;
                } else {
                    this.max = (double)ConfigurationUtils.parseTime(value.substring(1), logger, "time requirement");
                }
            } else if (value.startsWith(">")) {
                if (value.startsWith(">=")) {
                    this.min = (double)ConfigurationUtils.parseTime(value.substring(2), logger, "time requirement");
                    this.inclusive = true;
                } else {
                    this.min = (double)ConfigurationUtils.parseTime(value.substring(1), logger, "time requirement");
                }
            } else if (value.startsWith("=")) {
                this.value = (double)ConfigurationUtils.parseTime(value.substring(1), logger, "time requirement");
            } else {
                this.min = (double)ConfigurationUtils.parseTime(value, logger, "time requirement");
                this.inclusive = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public TimeRequirement(ConfigurationSection configuration, Logger logger) {
        if (configuration.contains("min")) {
            this.min = (double)ConfigurationUtils.parseTime(configuration.getString("min"), logger, "time requirement");
        }
        if (configuration.contains("max")) {
            this.max = (double)ConfigurationUtils.parseTime(configuration.getString("max"), logger, "time requirement");
        }
        if (configuration.contains("value")) {
            this.value = (double)ConfigurationUtils.parseTime(configuration.getString("value"), logger, "time requirement");
        }
        this.inclusive = configuration.getBoolean("inclusive");
    }
}

