/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.requirements;

import com.elmakers.mine.bukkit.requirements.RangedRequirement;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import java.util.logging.Logger;
import org.bukkit.configuration.ConfigurationSection;

class MoonRequirement
extends RangedRequirement {
    public MoonRequirement(String value, Logger logger) {
        try {
            if (value.startsWith("<")) {
                if (value.startsWith("<=")) {
                    this.max = (double)ConfigurationUtils.parseMoonPhase(value.substring(2), logger, "moon requirement");
                    this.inclusive = true;
                } else {
                    this.max = (double)ConfigurationUtils.parseMoonPhase(value.substring(1), logger, "moon requirement");
                }
            } else if (value.startsWith(">")) {
                if (value.startsWith(">=")) {
                    this.min = (double)ConfigurationUtils.parseMoonPhase(value.substring(2), logger, "moon requirement");
                    this.inclusive = true;
                } else {
                    this.min = (double)ConfigurationUtils.parseMoonPhase(value.substring(1), logger, "moon requirement");
                }
            } else if (value.startsWith("=")) {
                this.value = (double)ConfigurationUtils.parseMoonPhase(value.substring(1), logger, "moon requirement");
            } else {
                this.min = (double)ConfigurationUtils.parseMoonPhase(value, logger, "moon requirement");
                this.inclusive = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public MoonRequirement(ConfigurationSection configuration, Logger logger) {
        if (configuration.contains("min")) {
            this.min = (double)ConfigurationUtils.parseMoonPhase(configuration.getString("min"), logger, "moon requirement");
        }
        if (configuration.contains("max")) {
            this.max = (double)ConfigurationUtils.parseMoonPhase(configuration.getString("max"), logger, "moon requirement");
        }
        if (configuration.contains("value")) {
            this.value = (double)ConfigurationUtils.parseMoonPhase(configuration.getString("value"), logger, "moon requirement");
        }
        this.inclusive = configuration.getBoolean("inclusive");
    }
}

