/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic.command;

import com.elmakers.mine.bukkit.api.batch.Batch;
import com.elmakers.mine.bukkit.api.block.BlockData;
import com.elmakers.mine.bukkit.api.magic.MagicAPI;
import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.api.wand.LostWand;
import com.elmakers.mine.bukkit.api.wand.Wand;
import com.elmakers.mine.bukkit.block.UndoList;
import com.elmakers.mine.bukkit.magic.Mage;
import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.magic.command.MagicHelpCommandExecutor;
import com.elmakers.mine.bukkit.magic.command.MagicMapCommandExecutor;
import com.elmakers.mine.bukkit.magic.command.RegisterTask;
import com.elmakers.mine.bukkit.utility.BoundingBox;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import com.elmakers.mine.bukkit.utility.HitboxUtils;
import com.elmakers.mine.bukkit.utility.LogMessage;
import com.elmakers.mine.bukkit.utility.MagicLogger;
import com.elmakers.mine.bukkit.utility.RunnableJob;
import com.elmakers.mine.bukkit.wand.WandCleanupRunnable;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.security.CodeSource;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.BlockVector;
import org.bukkit.util.Vector;

public class MagicCommandExecutor
extends MagicHelpCommandExecutor {
    private RunnableJob runningTask = null;

    public MagicCommandExecutor(MagicAPI api) {
        super(api, "magic");
    }

    @Override
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        Player player;
        if (args.length == 0) {
            if (!this.api.hasPermission(sender, this.getPermissionNode())) {
                this.sendNoPermission(sender);
                return true;
            }
            sender.sendMessage("Magic " + this.getMagicVersion());
            MagicController controller = (MagicController)this.api.getController();
            if (!controller.isLoaded()) {
                sender.sendMessage(ChatColor.RED + " Plugin did not load correctly");
            }
            if (!controller.isDataLoaded()) {
                sender.sendMessage(ChatColor.RED + " Plugin did not load data correctly");
            }
            if (controller.isShuttingDown()) {
                sender.sendMessage(ChatColor.RED + " Plugin is shutting down");
            }
            sender.sendMessage(this.api.getMessages().get("commands.magic.help"));
            return true;
        }
        String subCommand = args[0];
        if (sender instanceof Player && !this.api.hasPermission(sender, "magic.commands.magic." + subCommand)) {
            this.sendNoPermission(sender);
            return true;
        }
        if (subCommand.equalsIgnoreCase("help")) {
            String[] args2 = Arrays.copyOfRange(args, 1, args.length);
            this.onMagicHelp(sender, args2);
            return true;
        }
        if (subCommand.equalsIgnoreCase("rpcheck")) {
            this.api.getController().checkResourcePack(sender);
            return true;
        }
        if (subCommand.equalsIgnoreCase("rpsend")) {
            this.api.getController().sendResourcePackToAllPlayers(sender);
            return true;
        }
        if (subCommand.equalsIgnoreCase("save")) {
            this.api.save();
            sender.sendMessage("Data saved.");
            return true;
        }
        if (subCommand.equalsIgnoreCase("load") || subCommand.equalsIgnoreCase("reload")) {
            this.api.getController().updateConfiguration(sender);
            return true;
        }
        if (subCommand.equalsIgnoreCase("clearcache")) {
            this.api.clearCache();
            sender.sendMessage("Image map and schematic caches cleared.");
            return true;
        }
        if (subCommand.equalsIgnoreCase("commit")) {
            if (this.api.commit()) {
                sender.sendMessage("All changes committed");
            } else {
                sender.sendMessage("Nothing to commit");
            }
            return true;
        }
        if (subCommand.equalsIgnoreCase("give") || subCommand.equalsIgnoreCase("sell")) {
            player = null;
            int argStart = 1;
            if (sender instanceof Player) {
                if (args.length > 1) {
                    player = CompatibilityLib.getDeprecatedUtils().getPlayer(args[1]);
                }
                if (player == null) {
                    player = (Player)sender;
                } else {
                    argStart = 2;
                }
            } else {
                if (args.length <= 1) {
                    sender.sendMessage("Must specify a player name");
                    return true;
                }
                argStart = 2;
                player = CompatibilityLib.getDeprecatedUtils().getPlayer(args[1]);
                if (player == null) {
                    sender.sendMessage("Can't find player " + args[1]);
                    return true;
                }
                if (!player.isOnline()) {
                    sender.sendMessage("Player " + args[1] + " is not online");
                    return true;
                }
            }
            String[] args2 = Arrays.copyOfRange(args, argStart, args.length);
            if (subCommand.equalsIgnoreCase("give") || subCommand.equalsIgnoreCase("sell")) {
                return this.onMagicGive(sender, player, subCommand, args2);
            }
        }
        if (subCommand.equalsIgnoreCase("worth")) {
            if (!(sender instanceof Player)) {
                sender.sendMessage("This command may only be used in-game");
                return true;
            }
            player = (Player)sender;
            ItemStack item = player.getInventory().getItemInMainHand();
            if (item == null || item.getType() == Material.AIR) {
                player.sendMessage("You must be holding an item");
                return true;
            }
            this.showWorth((CommandSender)player, item);
            return true;
        }
        if (subCommand.equalsIgnoreCase("list")) {
            return this.onMagicList(sender, subCommand, args);
        }
        if (subCommand.equalsIgnoreCase("register")) {
            if (!(sender instanceof Player)) {
                sender.sendMessage("This command may only be used in-game");
                return true;
            }
            if (args.length != 2 || args[1].isEmpty()) {
                sender.sendMessage(ChatColor.RED + "Usage: " + ChatColor.WHITE + "/magic register <code>");
                return true;
            }
            return this.onMagicRegister((Player)sender, args[1]);
        }
        if (subCommand.equalsIgnoreCase("migrate")) {
            this.controller.migratePlayerData(sender);
            return true;
        }
        if (subCommand.equalsIgnoreCase("cancel")) {
            this.checkRunningTask();
            if (this.runningTask != null) {
                this.runningTask.cancel();
                this.runningTask = null;
                sender.sendMessage("Job cancelled");
            }
            int stoppedPending = 0;
            for (com.elmakers.mine.bukkit.api.magic.Mage mage : this.controller.getMages()) {
                while (mage.cancelPending() != null) {
                    ++stoppedPending;
                }
            }
            for (com.elmakers.mine.bukkit.api.magic.Mage mage : this.api.getMagesWithPendingBatches()) {
                while (mage.cancelPending() != null) {
                    ++stoppedPending;
                }
            }
            sender.sendMessage("Stopped " + stoppedPending + " pending spell casts");
            return true;
        }
        if (subCommand.equalsIgnoreCase("clean")) {
            String ownerName;
            this.checkRunningTask();
            if (this.runningTask != null) {
                sender.sendMessage("Cancel current job first");
                return true;
            }
            World world = null;
            String owner = null;
            if (args.length > 1) {
                owner = args[1];
            }
            if (sender instanceof Player) {
                world = ((Player)sender).getWorld();
            } else if (args.length > 2) {
                String worldName = args[2];
                world = Bukkit.getWorld((String)worldName);
            }
            boolean check = false;
            if (owner != null && owner.equals("check")) {
                check = true;
                owner = "ALL";
            }
            String description = check ? "Checking for" : "Cleaning up";
            String string = ownerName = owner == null ? "(Unowned)" : owner;
            if (world == null) {
                sender.sendMessage(description + " lost wands in all worlds for owner: " + ownerName);
            } else if (ownerName.equals("ALL")) {
                sender.sendMessage(description + " lost wands in world '" + world.getName() + "' for ALL owners");
            } else {
                sender.sendMessage(description + " lost wands in world '" + world.getName() + "' for owner " + ownerName);
            }
            this.runningTask = new WandCleanupRunnable(this.api, world, owner, check);
            this.runningTask.runTaskTimer(this.api.getPlugin(), 5L, 5L);
            return true;
        }
        if (subCommand.equalsIgnoreCase("logs")) {
            String type;
            MagicLogger magicLogger = this.controller.getLogger();
            ArrayList<LogMessage> logs = new ArrayList<LogMessage>();
            String string = type = args.length >= 2 ? args[1] : subCommand.toLowerCase();
            if (type.equalsIgnoreCase("errors")) {
                logs.addAll(magicLogger.getErrors());
            } else if (type.equalsIgnoreCase("warnings")) {
                logs.addAll(magicLogger.getWarnings());
            } else {
                logs.addAll(magicLogger.getErrors());
                logs.addAll(magicLogger.getWarnings());
            }
            if (logs.isEmpty()) {
                sender.sendMessage("There have been no logs since the config has loaded");
                return true;
            }
            sender.sendMessage(ChatColor.AQUA + "There are " + logs.size() + " " + type.toLowerCase() + " from Magic:");
            for (LogMessage logMessage : logs) {
                sender.sendMessage(logMessage.getMessage());
            }
            return true;
        }
        sender.sendMessage("Unknown magic command: " + subCommand);
        return true;
    }

    protected boolean onMagicRegister(Player player, String code) {
        Plugin plugin = this.controller.getPlugin();
        Bukkit.getScheduler().runTaskAsynchronously(this.controller.getPlugin(), (Runnable)new RegisterTask(plugin, player, code));
        player.sendMessage(ChatColor.AQUA + "Sending registration code...");
        return true;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean onMagicList(CommandSender sender, String subCommand, String[] args) {
        String usage = "Usage: magic list <wands|map|automata|tasks|schematics|entities|blocks>";
        String listCommand = "";
        if (args.length > 1) {
            listCommand = args[1];
            if (!this.api.hasPermission(sender, "magic.commands.magic." + subCommand + "." + listCommand)) {
                this.sendNoPermission(sender);
                return false;
            }
        } else {
            int lightCount;
            int reflectiveCount;
            int n;
            int chunkSpawnsProcessed;
            int spawnsProcessed;
            sender.sendMessage(ChatColor.GRAY + "For more specific information, add 'tasks', 'wands', 'maps', 'schematics', 'entities', 'blocks' or 'automata' parameter.");
            long timeout = this.controller.getPhysicsTimeout();
            if (timeout > 0L) {
                long seconds = (timeout - System.currentTimeMillis()) / 1000L;
                sender.sendMessage(ChatColor.GREEN + "Physics handler active for another " + ChatColor.DARK_GREEN + seconds + ChatColor.GREEN + " seconds");
            }
            if ((spawnsProcessed = this.controller.getWorlds().getSpawnListener().getProcessedSpawns()) > 0) {
                sender.sendMessage(ChatColor.AQUA + "Spawns Replaced: " + ChatColor.LIGHT_PURPLE + spawnsProcessed);
            }
            if ((chunkSpawnsProcessed = this.controller.getWorlds().getSpawnListener().getProcessedChunkSpawns()) > 0) {
                sender.sendMessage(ChatColor.AQUA + "Chunk Gen Spawns Replaced: " + ChatColor.LIGHT_PURPLE + chunkSpawnsProcessed);
            }
            Collection<com.elmakers.mine.bukkit.api.magic.Mage> collection = this.controller.getMages();
            int lockedChunks = this.controller.getLockedChunks().size();
            if (lockedChunks > 0) {
                sender.sendMessage(ChatColor.AQUA + "Locked Chunks: " + ChatColor.LIGHT_PURPLE + lockedChunks);
            }
            sender.sendMessage(ChatColor.AQUA + "Modified blocks: " + ChatColor.LIGHT_PURPLE + UndoList.getRegistry().getModified().size());
            sender.sendMessage(ChatColor.AQUA + "Watching blocks: " + ChatColor.LIGHT_PURPLE + UndoList.getRegistry().getWatching().size());
            int breakingCount = UndoList.getRegistry().getBreaking().size();
            if (breakingCount > 0) {
                sender.sendMessage(ChatColor.AQUA + "Registered breaking: " + ChatColor.LIGHT_PURPLE + breakingCount);
            }
            if ((n = UndoList.getRegistry().getBreakable().size()) > 0) {
                sender.sendMessage(ChatColor.AQUA + "Registered breakable: " + ChatColor.LIGHT_PURPLE + n);
            }
            if ((reflectiveCount = UndoList.getRegistry().getReflective().size()) > 0) {
                sender.sendMessage(ChatColor.AQUA + "Registered reflective: " + ChatColor.LIGHT_PURPLE + reflectiveCount);
            }
            if ((lightCount = this.controller.getLightCount()) > 0) {
                sender.sendMessage(ChatColor.AQUA + "Registered lights: " + ChatColor.LIGHT_PURPLE + lightCount);
            }
            sender.sendMessage(ChatColor.LIGHT_PURPLE + "Active mages: " + ChatColor.LIGHT_PURPLE + collection.size());
            Collection<com.elmakers.mine.bukkit.api.block.UndoList> pendingUndo = this.api.getPendingUndo();
            sender.sendMessage(ChatColor.AQUA + "Pending undo (" + ChatColor.LIGHT_PURPLE + pendingUndo.size() + ChatColor.AQUA + "): ");
            long now = System.currentTimeMillis();
            for (com.elmakers.mine.bukkit.api.block.UndoList undo : pendingUndo) {
                long remainingTime = (undo.getScheduledTime() - now) / 1000L;
                sender.sendMessage(ChatColor.AQUA + undo.getName() + ChatColor.GRAY + " will undo in " + ChatColor.WHITE + "" + remainingTime + "" + ChatColor.GRAY + " seconds");
            }
            Collection<com.elmakers.mine.bukkit.api.magic.Mage> pending = this.api.getMagesWithPendingBatches();
            sender.sendMessage(ChatColor.AQUA + "Pending casts (" + ChatColor.LIGHT_PURPLE + pending.size() + ChatColor.AQUA + "): ");
            for (com.elmakers.mine.bukkit.api.magic.Mage mage : pending) {
                int totalSize = 0;
                int totalRemaining = 0;
                Collection<Batch> pendingBatches = mage.getPendingBatches();
                String names = "";
                if (pendingBatches.size() > 0) {
                    ArrayList<String> nameList = new ArrayList<String>();
                    for (Batch batch : pendingBatches) {
                        nameList.add(batch.getName());
                        totalSize += batch.size();
                        totalRemaining += batch.remaining();
                    }
                    names = StringUtils.join(nameList, (String)(ChatColor.GRAY + "," + ChatColor.YELLOW));
                }
                int percent = totalSize > 0 ? totalRemaining * 100 / totalSize : 100;
                percent = 100 - Math.min(100, percent);
                sender.sendMessage(ChatColor.AQUA + mage.getName() + ChatColor.GRAY + " has " + ChatColor.WHITE + "" + pendingBatches.size() + "" + ChatColor.GRAY + " pending (" + ChatColor.GOLD + percent + ChatColor.WHITE + "%" + ChatColor.GRAY + ") (" + ChatColor.YELLOW + names + ChatColor.GRAY + ")");
            }
            this.controller.checkLogs(sender);
            return true;
        }
        if (listCommand.equalsIgnoreCase("schematics")) {
            ArrayList<String> schematics = new ArrayList<String>();
            try {
                File schematicFolder;
                String extraSchematicFilePath;
                File configFolder;
                File file;
                File[] zip;
                Plugin plugin = (Plugin)this.api;
                CodeSource src = MagicAPI.class.getProtectionDomain().getCodeSource();
                if (src != null) {
                    URL jar = src.getLocation();
                    try (InputStream inputStream = jar.openStream();){
                        zip = new ZipInputStream(inputStream);
                        try {
                            ZipEntry e;
                            while ((e = zip.getNextEntry()) != null) {
                                String string = e.getName();
                                if (!string.startsWith("schematics/")) continue;
                                schematics.add(string.replace("schematics/", ""));
                            }
                        }
                        finally {
                            zip.close();
                        }
                    }
                }
                if ((file = new File(configFolder = plugin.getDataFolder(), "schematics")).exists()) {
                    void var13_71;
                    zip = file.listFiles();
                    int e = zip.length;
                    boolean bl = false;
                    while (var13_71 < e) {
                        File nextFile = zip[var13_71];
                        schematics.add(nextFile.getName());
                        ++var13_71;
                    }
                }
                if ((extraSchematicFilePath = this.controller.getExtraSchematicFilePath()) != null && extraSchematicFilePath.length() > 0 && (schematicFolder = new File(configFolder, "../" + extraSchematicFilePath)).exists() && !schematicFolder.equals(file)) {
                    for (File nextFile : schematicFolder.listFiles()) {
                        schematics.add(nextFile.getName());
                    }
                }
            }
            catch (Exception ex) {
                sender.sendMessage("Error loading schematics: " + ex.getMessage());
                ex.printStackTrace();
            }
            sender.sendMessage(ChatColor.DARK_AQUA + "Found " + ChatColor.LIGHT_PURPLE + schematics.size() + ChatColor.DARK_AQUA + " schematics");
            Collections.sort(schematics);
            for (String schematic : schematics) {
                if (schematic.indexOf(".schematic") <= 0) continue;
                sender.sendMessage(ChatColor.AQUA + schematic.replace(".schematic", ""));
            }
            return true;
        }
        if (listCommand.equalsIgnoreCase("tasks")) {
            String pluginName;
            List tasks = Bukkit.getScheduler().getPendingTasks();
            HashMap<String, Integer> pluginCounts = new HashMap<String, Integer>();
            HashMap taskCounts = new HashMap();
            for (BukkitTask bukkitTask : tasks) {
                void var13_73;
                Integer count;
                pluginName = bukkitTask.getOwner().getName();
                HashMap<void, Integer> pluginTaskCounts = (HashMap<void, Integer>)taskCounts.get(pluginName);
                if (pluginTaskCounts == null) {
                    pluginTaskCounts = new HashMap<void, Integer>();
                    taskCounts.put(pluginName, pluginTaskCounts);
                }
                String string = "(Unknown)";
                Runnable taskRunnable = CompatibilityLib.getCompatibilityUtils().getTaskRunnable(bukkitTask);
                if (taskRunnable != null) {
                    Class<?> taskClass = taskRunnable.getClass();
                    String string2 = taskClass.getName();
                }
                if ((count = (Integer)pluginTaskCounts.get(var13_73)) == null) {
                    count = 0;
                }
                Integer nextFile = count;
                count = count + 1;
                pluginTaskCounts.put(var13_73, count);
                Integer totalCount = (Integer)pluginCounts.get(pluginName);
                if (totalCount == null) {
                    totalCount = 0;
                }
                Integer n = totalCount;
                totalCount = totalCount + 1;
                pluginCounts.put(pluginName, totalCount);
            }
            sender.sendMessage(ChatColor.LIGHT_PURPLE + "Active tasks: " + tasks.size());
            for (Map.Entry entry : taskCounts.entrySet()) {
                pluginName = (String)entry.getKey();
                sender.sendMessage(" " + ChatColor.DARK_PURPLE + pluginName + ": " + ChatColor.LIGHT_PURPLE + pluginCounts.get(pluginName));
                for (Map.Entry entry2 : ((HashMap)entry.getValue()).entrySet()) {
                    sender.sendMessage("  " + ChatColor.DARK_PURPLE + (String)entry2.getKey() + ": " + ChatColor.LIGHT_PURPLE + entry2.getValue());
                }
            }
            return true;
        }
        if (listCommand.equalsIgnoreCase("wands")) {
            String owner = "";
            if (args.length > 2) {
                owner = args[2];
            }
            Collection<LostWand> lostWands = this.api.getLostWands();
            int shown = 0;
            for (LostWand lostWand : lostWands) {
                Location location = lostWand.getLocation();
                if (location == null || owner.length() > 0 && !owner.equalsIgnoreCase(lostWand.getOwner())) continue;
                ++shown;
                sender.sendMessage(ChatColor.AQUA + lostWand.getName() + ChatColor.WHITE + " (" + lostWand.getOwner() + ") @ " + ChatColor.BLUE + location.getWorld().getName() + " " + location.getBlockX() + " " + location.getBlockY() + " " + location.getBlockZ());
            }
            sender.sendMessage(shown + " lost wands found" + (owner.length() > 0 ? " for " + owner : ""));
            return true;
        }
        if (listCommand.equalsIgnoreCase("automata")) {
            Collection<com.elmakers.mine.bukkit.api.magic.Mage> automata = this.api.getAutomata();
            for (com.elmakers.mine.bukkit.api.magic.Mage automaton : automata) {
                Location location = automaton.getLocation();
                String string = location.getWorld().getName();
                boolean isOnline = false;
                World world = Bukkit.getWorld((String)string);
                if (string != null) {
                    isOnline = world.isChunkLoaded(location.getBlockX() >> 4, location.getBlockZ() >> 4);
                }
                ChatColor chatColor = isOnline ? ChatColor.AQUA : ChatColor.GRAY;
                sender.sendMessage(chatColor + automaton.getName() + ChatColor.WHITE + " @ " + ChatColor.BLUE + string + " " + location.getBlockX() + " " + location.getBlockY() + " " + location.getBlockZ());
            }
            sender.sendMessage(automata.size() + " automata active");
            return true;
        }
        if (listCommand.equalsIgnoreCase("maps")) {
            String keyword = "";
            for (int i = 2; i < args.length; ++i) {
                if (i != 2) {
                    keyword = keyword + " ";
                }
                keyword = keyword + args[i];
            }
            MagicMapCommandExecutor.onMapList(this.api.getController(), sender, keyword);
            return true;
        }
        if (listCommand.equalsIgnoreCase("blocks")) {
            for (BlockData blockData : UndoList.getRegistry().getModified().values()) {
                BlockVector blockLocation = blockData.getLocation();
                Block block = blockData.getBlock();
                com.elmakers.mine.bukkit.api.block.UndoList undoList = blockData.getUndoList();
                String listName = undoList == null ? "Unknown" : undoList.getName();
                String blockDescription = block == null ? "Unloaded" : block.getType().toString();
                sender.sendMessage(ChatColor.BLUE + "Block at " + ChatColor.GRAY + blockLocation.getBlockX() + ChatColor.DARK_GRAY + "," + ChatColor.GRAY + blockLocation.getBlockY() + ChatColor.DARK_GRAY + "," + ChatColor.GRAY + blockLocation.getBlockZ() + ChatColor.BLUE + " stored as " + ChatColor.AQUA + blockData.getMaterial() + ChatColor.BLUE + " is currently " + ChatColor.AQUA + blockDescription + ChatColor.BLUE + " from " + ChatColor.GOLD + listName);
            }
            return true;
        }
        if (listCommand.equalsIgnoreCase("mages")) {
            for (com.elmakers.mine.bukkit.api.magic.Mage mage : this.api.getController().getMages()) {
                void var10_41;
                Entity mageEntity = mage.getEntity();
                Location location = mage.getLocation();
                ChatColor chatColor = ChatColor.YELLOW;
                if (mage instanceof Mage && ((Mage)mage).isForget()) {
                    ChatColor chatColor2 = ChatColor.RED;
                } else if (mage.isAutomaton()) {
                    ChatColor chatColor3 = ChatColor.GOLD;
                }
                String mageType = mageEntity == null ? "Non-Entity" : mageEntity.getType().name();
                String message = ChatColor.AQUA + "Mage " + var10_41 + mage.getId() + ChatColor.GRAY + " (" + mage.getName() + ")" + ChatColor.AQUA + " of type " + ChatColor.DARK_AQUA + mageType + ChatColor.AQUA;
                if (location != null) {
                    String string = location.getWorld() != null ? location.getWorld().getName() : "(Unknown world)";
                    message = message + " is at " + ChatColor.BLUE + string + " " + ChatColor.DARK_PURPLE + " " + location.getBlockX() + " " + location.getBlockY() + " " + location.getBlockZ();
                }
                sender.sendMessage(message);
            }
            return true;
        }
        if (listCommand.equalsIgnoreCase("entities")) {
            World world = (World)Bukkit.getWorlds().get(0);
            if (sender instanceof Player) {
                world = ((Player)sender).getLocation().getWorld();
            }
            DecimalFormat formatter = new DecimalFormat("#0.0");
            List<EntityType> types = Arrays.asList(EntityType.values());
            Collections.sort(types, new Comparator<EntityType>(){

                @Override
                public int compare(EntityType o1, EntityType o2) {
                    return o1.name().compareTo(o2.name());
                }
            });
            Collection players = Bukkit.getServer().getOnlinePlayers();
            Iterator iterator = players.iterator();
            if (iterator.hasNext()) {
                Player player = (Player)iterator.next();
                this.showEntityInfo(sender, (Entity)player, EntityType.PLAYER.name() + ChatColor.GRAY + " (" + player.getName() + " [" + (player.isSneaking() ? "sneaking" : "standing") + "])", formatter);
            }
            List list = world.getEntities();
            for (Entity entity : list) {
                this.showEntityInfo(sender, entity, entity.getType().name(), formatter);
            }
            return true;
        }
        sender.sendMessage(usage);
        return true;
    }

    private void showEntityInfo(CommandSender sender, Entity entity, String label, NumberFormat formatter) {
        BoundingBox hitbox = HitboxUtils.getHitbox(entity);
        Vector size = hitbox.size();
        String message = ChatColor.BLACK + label + ": " + ChatColor.AQUA + formatter.format(size.getX()) + ChatColor.DARK_GRAY + "x" + ChatColor.AQUA + formatter.format(size.getY()) + ChatColor.DARK_GRAY + "x" + ChatColor.AQUA + formatter.format(size.getZ());
        if (entity instanceof LivingEntity) {
            LivingEntity li = (LivingEntity)entity;
            message = message + ChatColor.DARK_GRAY + ", " + ChatColor.GREEN + (int)CompatibilityLib.getCompatibilityUtils().getMaxHealth((Damageable)li) + "hp";
        }
        sender.sendMessage(message);
    }

    protected boolean onMagicGive(CommandSender sender, Player player, String command, String[] args) {
        String playerCommand = sender instanceof Player ? "" : "<player> ";
        String usageString = "Usage: /magic give " + playerCommand + "<spellname|'material'|'upgrade'|'wand'> [materialname|wandname]";
        if (args.length == 0) {
            sender.sendMessage(usageString);
            return true;
        }
        String key = "";
        boolean isMaterial = false;
        boolean isWand = false;
        boolean isUpgrade = false;
        if (!(args.length <= 1 || args[0].equals("material") || args[0].equals("wand") || args[0].equals("upgrade"))) {
            sender.sendMessage(usageString);
            return true;
        }
        if (args[0].equals("wand")) {
            isWand = true;
            key = args.length > 1 ? args[1] : "";
        } else if (args[0].equals("upgrade")) {
            isUpgrade = true;
            key = args.length > 1 ? args[1] : "";
        } else if (args[0].equals("material")) {
            if (args.length < 2) {
                sender.sendMessage(usageString);
                return true;
            }
            isMaterial = true;
            key = args[1];
        } else {
            key = args[0];
        }
        boolean giveItem = command.equals("give") || command.equals("sell");
        boolean showWorth = command.equals("worth") || command.equals("sell");
        boolean giveValue = command.equals("sell");
        if (isWand) {
            this.giveWand(sender, player, key, false, giveItem, giveValue, showWorth);
        } else if (isMaterial) {
            this.onGiveBrush(sender, player, key, false, giveItem, giveValue, showWorth);
        } else if (isUpgrade) {
            this.onGiveUpgrade(sender, player, key, false, giveItem, giveValue, showWorth);
        } else {
            this.onGive(sender, player, key, giveItem, giveValue, showWorth);
        }
        return true;
    }

    protected void onGive(CommandSender sender, Player player, String key, boolean giveItem, boolean giveValue, boolean showWorth) {
        if (!(this.onGiveSpell(sender, player, key, true, giveItem, giveValue, showWorth) || this.onGiveBrush(sender, player, key, true, giveItem, giveValue, showWorth) || this.giveWand(sender, player, key, true, giveItem, giveValue, showWorth))) {
            sender.sendMessage("Failed to create a spell, brush or wand item for " + key);
        }
    }

    protected boolean onGiveSpell(CommandSender sender, Player player, String spellKey, boolean quiet, boolean giveItem, boolean giveValue, boolean showWorth) {
        ItemStack itemStack = this.api.createSpellItem(spellKey);
        if (itemStack == null) {
            if (!quiet) {
                sender.sendMessage("Failed to create spell item for " + spellKey);
            }
            return false;
        }
        if (giveItem) {
            this.api.giveItemToPlayer(player, itemStack);
            if (sender != player && !quiet) {
                sender.sendMessage("Gave spell " + spellKey + " to " + player.getName());
            }
        }
        if (showWorth) {
            this.showWorth(sender, itemStack);
        }
        return true;
    }

    protected boolean onGiveBrush(CommandSender sender, Player player, String materialKey, boolean quiet, boolean giveItem, boolean giveValue, boolean showWorth) {
        ItemStack itemStack = this.api.createBrushItem(materialKey);
        if (itemStack == null) {
            if (!quiet) {
                sender.sendMessage("Failed to create material item for " + materialKey);
            }
            return false;
        }
        if (giveItem) {
            this.api.giveItemToPlayer(player, itemStack);
            if (sender != player && !quiet) {
                sender.sendMessage("Gave brush " + materialKey + " to " + player.getName());
            }
        }
        if (showWorth) {
            this.showWorth(sender, itemStack);
        }
        return true;
    }

    protected boolean onGiveUpgrade(CommandSender sender, Player player, String wandKey, boolean quiet, boolean giveItem, boolean giveValue, boolean showWorth) {
        Wand wand;
        Mage mage = this.controller.getMage(player);
        Wand currentWand = mage.getActiveWand();
        if (currentWand != null) {
            currentWand.closeInventory();
        }
        if ((wand = this.api.createWand(wandKey)) != null) {
            wand.makeUpgrade();
            if (giveItem) {
                this.api.giveItemToPlayer(player, wand.getItem());
                if (sender != player && !quiet) {
                    sender.sendMessage("Gave upgrade " + wand.getName() + " to " + player.getName());
                }
            }
            if (showWorth) {
                this.showWorth(sender, wand.getItem());
            }
        } else {
            if (!quiet) {
                sender.sendMessage(this.api.getMessages().getParameterized("wand.unknown_template", "$name", wandKey));
            }
            return false;
        }
        return true;
    }

    protected void checkRunningTask() {
        if (this.runningTask != null && this.runningTask.isFinished()) {
            this.runningTask = null;
        }
    }

    @Override
    public Collection<String> onTabComplete(CommandSender sender, String commandName, String[] args) {
        ArrayList<String> options = new ArrayList<String>();
        if (args.length == 1) {
            this.addIfPermissible(sender, options, "magic.commands.magic.", "clean");
            this.addIfPermissible(sender, options, "magic.commands.magic.", "clearcache");
            this.addIfPermissible(sender, options, "magic.commands.magic.", "cancel");
            this.addIfPermissible(sender, options, "magic.commands.magic.", "load");
            this.addIfPermissible(sender, options, "magic.commands.magic.", "save");
            this.addIfPermissible(sender, options, "magic.commands.magic.", "commit");
            this.addIfPermissible(sender, options, "magic.commands.magic.", "give");
            this.addIfPermissible(sender, options, "magic.commands.magic.", "worth");
            this.addIfPermissible(sender, options, "magic.commands.magic.", "sell");
            this.addIfPermissible(sender, options, "magic.commands.magic.", "list");
            this.addIfPermissible(sender, options, "magic.commands.magic.", "rpcheck");
            this.addIfPermissible(sender, options, "magic.commands.magic.", "rpsend");
            this.addIfPermissible(sender, options, "magic.commands.magic.", "register");
            this.addIfPermissible(sender, options, "magic.commands.magic.", "logs");
            this.addIfPermissible(sender, options, "magic.commands.magic.", "help");
        } else if (args.length > 1 && args[0].equals("help")) {
            super.onTabComplete(sender, "mhelp", args);
        } else if (args.length == 2) {
            if (args[0].equalsIgnoreCase("list")) {
                this.addIfPermissible(sender, options, "magic.commands.magic.list", "maps");
                this.addIfPermissible(sender, options, "magic.commands.magic.list", "wands");
                this.addIfPermissible(sender, options, "magic.commands.magic.list", "automata");
                this.addIfPermissible(sender, options, "magic.commands.magic.list", "schematics");
                this.addIfPermissible(sender, options, "magic.commands.magic.list", "entities");
                this.addIfPermissible(sender, options, "magic.commands.magic.list", "tasks");
                this.addIfPermissible(sender, options, "magic.commands.magic.list", "blocks");
                this.addIfPermissible(sender, options, "magic.commands.magic.list", "mages");
            } else if (args[0].equalsIgnoreCase("logs")) {
                options.add("errors");
                options.add("warnings");
            } else if (args[0].equalsIgnoreCase("give") || args[0].equalsIgnoreCase("worth") || args[0].equalsIgnoreCase("sell")) {
                options.add("wand");
                options.add("material");
                options.add("upgrade");
                Collection<SpellTemplate> spellList = this.api.getSpellTemplates(sender.hasPermission("magic.bypass_hidden"));
                for (SpellTemplate spellTemplate : spellList) {
                    options.add(spellTemplate.getKey());
                }
                Collection<String> allWands = this.api.getWandKeys();
                for (String wandKey : allWands) {
                    options.add(wandKey);
                }
                options.addAll(this.api.getBrushes());
            }
        } else if (args.length == 3) {
            Player player;
            if (args[0].equalsIgnoreCase("give") || args[0].equalsIgnoreCase("sell")) {
                if (args[1].equalsIgnoreCase("upgrade") || args[1].equalsIgnoreCase("wand")) {
                    Collection<String> allWands = this.api.getWandKeys();
                    for (String string : allWands) {
                        options.add(string);
                    }
                } else if (args[1].equalsIgnoreCase("material")) {
                    options.addAll(this.api.getBrushes());
                }
            } else if ((args[0].equalsIgnoreCase("configure") || args[0].equalsIgnoreCase("describe") || args[0].equalsIgnoreCase("desc")) && (player = CompatibilityLib.getDeprecatedUtils().getPlayer(args[1])) != null) {
                Mage mage = this.controller.getMage(player);
                ConfigurationSection configurationSection = mage.getData();
                options.addAll(configurationSection.getKeys(false));
            }
        }
        return options;
    }
}

