/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.effect.SoundEffect;
import com.elmakers.mine.bukkit.magic.MagicMetaKeys;
import com.elmakers.mine.bukkit.slikey.effectlib.util.VectorUtils;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.SafetyUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.util.Vector;

public class RideEntityAction
extends BaseSpellAction {
    private double moveDistance = 0.0;
    private double startSpeed = 0.0;
    private double minSpeed = 0.0;
    private double maxSpeed = 0.0;
    private double maxAcceleration = 0.0;
    private double maxDeceleration = 0.0;
    private double liftoffThrust = 0.0;
    private double crashDistance = 0.0;
    private double crashSpeed = 0.0;
    private int duration = 0;
    private int durationWarning = 0;
    private int liftoffDuration = 0;
    private int maxAscend;
    private int maxHeightAboveGround;
    private int heightCheckRadius;
    private int maxHeight;
    private int exemptionDuration;
    private double gravity;
    private double terminalVelocity;
    private boolean airControllable = false;
    private boolean controllable = false;
    private boolean pitchControllable = true;
    private double strafeControllable = 0.0;
    private double steerControllable = 0.0;
    private double jumpControllable = 0.0;
    private double jumpVelocity = 0.0;
    private double braking = 0.0;
    private double pitchOffset = 0.0;
    private double yawOffset = 0.0;
    private Double yDirection = null;
    private Collection<PotionEffect> crashEffects;
    private Collection<PotionEffect> warningEffects;
    private Collection<PotionEffect> ridingEffects;
    private SoundEffect sound = null;
    private int soundInterval = 1000;
    private float soundMaxVolume = 1.0f;
    private float soundMinVolume = 1.0f;
    private float soundMaxPitch = 1.0f;
    private float soundMinPitch = 1.0f;
    private long liftoffTime;
    private double speed;
    private boolean warningEffectsApplied;
    private long nextSoundPlay;
    protected boolean noTarget = true;
    protected boolean noDrops = true;
    private boolean noTargetPlayer = false;
    private Class<?> crashEntityType;
    private double crashDismountSpeed;
    private double crashEntityDistance;
    private double crashVelocityYOffset = 0.0;
    private double crashVelocity = 0.0;
    private double crashDamage = 0.0;
    private double crashVehicleDamage = 0.0;
    private double crashEntityVehicleDamage = 0.0;
    private double crashEntityDamage = 0.0;
    private double crashBraking = 0.0;
    private double crashEntityFOV = 0.0;
    private int fallProtection = 0;
    private boolean isPassenger;
    private Spell jumpSpell;
    private String[] jumpSpellParameters;
    private Vector gravityVelocity = new Vector();
    protected Vector direction;
    protected Entity mount;
    protected Location targetLocation;
    private boolean isAscending;
    private boolean isInAir;

    @Override
    public void initialize(Spell spell, ConfigurationSection parameters) {
        super.initialize(spell, parameters);
        this.crashEffects = ConfigurationUtils.getPotionEffects(parameters.getConfigurationSection("crash_effects"));
        this.durationWarning = parameters.getInt("duration_warning", 0);
        this.warningEffects = ConfigurationUtils.getPotionEffects(parameters.getConfigurationSection("warning_effects"), this.durationWarning);
        this.ridingEffects = ConfigurationUtils.getPotionEffects(parameters.getConfigurationSection("riding_effects"), Integer.MAX_VALUE, true, false);
        if (parameters.contains("crash_into")) {
            String entityTypeName = parameters.getString("crash_into");
            try {
                this.crashEntityType = Class.forName("org.bukkit.entity." + entityTypeName);
            }
            catch (Throwable ex) {
                spell.getController().getLogger().warning("Unknown entity type in crash_into: " + entityTypeName);
                this.crashEntityType = null;
            }
        }
    }

    @Override
    public void reset(CastContext context) {
        super.reset(context);
        if (this.mount != null) {
            this.mount.eject();
        }
        this.mount = null;
        this.warningEffectsApplied = false;
        this.nextSoundPlay = 0L;
    }

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.moveDistance = parameters.getDouble("steer_speed", 0.0);
        this.startSpeed = parameters.getDouble("start_speed", 0.0);
        this.minSpeed = parameters.getDouble("min_speed", 0.0);
        this.maxSpeed = parameters.getDouble("max_speed", 0.0);
        this.maxAcceleration = parameters.getDouble("max_acceleration", 0.0);
        this.maxDeceleration = parameters.getDouble("max_deceleration", 0.0);
        this.liftoffThrust = parameters.getDouble("liftoff_thrust", 0.0);
        this.liftoffDuration = parameters.getInt("liftoff_duration", 0);
        this.crashDistance = parameters.getDouble("crash_distance", 0.0);
        this.crashSpeed = parameters.getDouble("crash_speed", 0.0);
        this.maxHeight = parameters.getInt("max_height", 0);
        this.maxHeightAboveGround = parameters.getInt("max_height_above_ground", -1);
        this.heightCheckRadius = parameters.getInt("height_check_radius", 0);
        this.gravity = parameters.getDouble("gravity", 0.0);
        this.terminalVelocity = parameters.getDouble("terminal_velocity", 0.0);
        this.maxAscend = parameters.getInt("max_ascend", 0);
        this.duration = parameters.getInt("duration", 0);
        this.durationWarning = parameters.getInt("duration_warning", 0);
        this.pitchOffset = parameters.getDouble("pitch_offset", 0.0);
        this.yawOffset = parameters.getDouble("yaw_offset", 0.0);
        this.noTarget = parameters.getBoolean("mount_untargetable", false);
        this.noDrops = parameters.getBoolean("mount_no_drops", true);
        this.noTargetPlayer = parameters.getBoolean("rider_untargetable", false);
        this.controllable = parameters.getBoolean("controllable", false);
        this.pitchControllable = parameters.getBoolean("pitch_controllable", true);
        this.airControllable = parameters.getBoolean("air_controllable", true);
        this.strafeControllable = parameters.getDouble("strafe_controllable", 0.0);
        this.steerControllable = parameters.getDouble("steer_controllable", 0.0);
        this.jumpControllable = parameters.getDouble("jump_controllable", 0.0);
        this.jumpVelocity = parameters.getDouble("jump_velocity", 0.0);
        this.braking = parameters.getDouble("braking", 0.0);
        this.crashEntityDistance = parameters.getDouble("crash_entity_distance", 2.0);
        this.crashVelocityYOffset = parameters.getDouble("crash_velocity_y_offset", 0.0);
        this.crashVelocity = parameters.getDouble("crash_velocity", 0.0);
        this.crashDamage = parameters.getDouble("crash_damage", 0.0);
        this.crashVehicleDamage = parameters.getDouble("crash_vehicle_damage", 0.0);
        this.crashEntityVehicleDamage = parameters.getDouble("crash_entity_vehicle_damage", 0.0);
        this.crashEntityDamage = parameters.getDouble("crash_entity_damage", 0.0);
        this.crashBraking = parameters.getDouble("crash_braking", 0.0);
        this.crashEntityFOV = parameters.getDouble("crash_entity_fov", 0.3);
        this.crashDismountSpeed = parameters.getDouble("crash_dismount_speed", 0.0);
        this.fallProtection = parameters.getInt("fall_protection", 0);
        this.exemptionDuration = parameters.getInt("exemption_duration", 0);
        this.yDirection = parameters.contains("direction_y") ? Double.valueOf(parameters.getDouble("direction_y")) : null;
        this.isPassenger = parameters.getBoolean("passenger", false);
        this.sound = null;
        String soundKey = parameters.getString("sound");
        if (soundKey != null && !soundKey.isEmpty()) {
            this.sound = new SoundEffect(soundKey);
        }
        this.soundInterval = parameters.getInt("sound_interval", 1000);
        this.soundMaxVolume = (float)parameters.getDouble("sound_volume", 1.0);
        this.soundMaxPitch = (float)parameters.getDouble("sound_pitch", 1.0);
        this.soundMinVolume = (float)parameters.getDouble("sound_volume", 1.0);
        this.soundMinPitch = (float)parameters.getDouble("sound_pitch", 1.0);
        this.soundMaxVolume = (float)parameters.getDouble("sound_max_volume", (double)this.soundMaxVolume);
        this.soundMaxPitch = (float)parameters.getDouble("sound_max_pitch", (double)this.soundMaxPitch);
        this.soundMinVolume = (float)parameters.getDouble("sound_min_volume", (double)this.soundMinVolume);
        this.soundMinPitch = (float)parameters.getDouble("sound_min_pitch", (double)this.soundMinPitch);
        String jumpCast = parameters.getString("jump_cast", "");
        if (!jumpCast.isEmpty()) {
            String[] pieces = StringUtils.split((String)jumpCast, (String)" ");
            this.jumpSpell = context.getMage().getSpell(pieces[0]);
            this.jumpSpellParameters = Arrays.copyOfRange(pieces, 1, pieces.length);
            if (this.jumpSpell == null) {
                context.getLogger().warning("Unknown jump_cast spell: " + jumpCast);
            }
        }
    }

    protected void remount(CastContext context) {
    }

    @Override
    public SpellResult perform(CastContext context) {
        long flightTime;
        Entity currentMount;
        if (this.mount == null) {
            return this.mount(context);
        }
        Entity mounted = context.getEntity();
        if (mounted == null) {
            return SpellResult.ENTITY_REQUIRED;
        }
        Entity entity = currentMount = this.isPassenger ? CompatibilityLib.getDeprecatedUtils().getPassenger(mounted) : mounted.getVehicle();
        if (currentMount == null) {
            return SpellResult.CAST;
        }
        if (this.duration > 0 && (flightTime = System.currentTimeMillis() - this.liftoffTime) > (long)this.duration) {
            return SpellResult.CAST;
        }
        if (!this.mount.isValid() || this.mount != currentMount) {
            this.remount(context);
            if (this.mount == null) {
                return SpellResult.CAST;
            }
            if (this.isPassenger) {
                CompatibilityLib.getDeprecatedUtils().setPassenger(mounted, this.mount);
            } else {
                CompatibilityLib.getDeprecatedUtils().setPassenger(this.mount, mounted);
            }
        }
        if (this.sound != null && this.nextSoundPlay < System.currentTimeMillis()) {
            this.nextSoundPlay = System.currentTimeMillis() + (long)this.soundInterval;
            double speedRatio = 1.0;
            if (this.speed > 0.0) {
                double minForwardSpeed = Math.max(0.0, this.minSpeed);
                speedRatio = this.minSpeed >= this.maxSpeed ? 1.0 : (this.speed - minForwardSpeed) / (this.maxSpeed - minForwardSpeed);
            } else if (this.minSpeed < 0.0) {
                double maxBackwardSpeed = Math.max(Math.abs(this.minSpeed), this.maxSpeed);
                double backwardSpeed = Math.abs(this.speed);
                speedRatio = backwardSpeed / maxBackwardSpeed;
            }
            this.sound.setPitch((float)((double)(this.soundMaxPitch - this.soundMinPitch) * speedRatio) + this.soundMinPitch);
            this.sound.setVolume((float)((double)(this.soundMaxVolume - this.soundMinVolume) * speedRatio) + this.soundMinVolume);
            this.sound.play(context.getPlugin(), context.getController().getLogger(), mounted);
        }
        if (this.crashDistance > 0.0 && Math.abs(this.speed) >= this.crashSpeed && System.currentTimeMillis() > this.liftoffTime + (long)this.liftoffDuration) {
            Vector threshold = this.direction.clone().multiply(this.speed * this.crashDistance);
            if (this.checkForCrash(context, mounted.getLocation(), threshold) && this.crash(context)) {
                return SpellResult.CAST;
            }
        }
        if (!context.isPassthrough(mounted.getLocation().getBlock()) && this.crash(context)) {
            return SpellResult.CAST;
        }
        if (this.crashEntityType != null && this.speed > 0.0 && this.crashEntityDistance > 0.0 && this.maxSpeed > 0.0) {
            List nearby = mounted.getNearbyEntities(this.crashEntityDistance, this.crashEntityDistance, this.crashEntityDistance);
            Vector crashDirection = this.direction.clone();
            if (this.crashVelocityYOffset > 0.0) {
                crashDirection.setY(crashDirection.getY() + this.crashVelocityYOffset).normalize();
            }
            Vector velocity = crashDirection.multiply(this.crashVelocity * this.speed / this.maxSpeed);
            for (Entity entity2 : nearby) {
                Vector targetDirection;
                double angle;
                if (entity2 == mounted || entity2 == this.mount || !entity2.isValid() || !context.canTarget(entity2, this.crashEntityType) || (angle = (double)(targetDirection = entity2.getLocation().subtract(mounted.getLocation()).toVector()).angle(this.direction)) > this.crashEntityFOV) continue;
                if (this.crashEntityDamage > 0.0 && entity2 instanceof Damageable) {
                    Damageable damageable = (Damageable)entity2;
                    double crashDamage = this.maxSpeed > 0.0 ? this.crashEntityDamage * this.speed / this.maxSpeed : this.crashEntityDamage;
                    CompatibilityLib.getCompatibilityUtils().damage(damageable, crashDamage, mounted);
                }
                SafetyUtils.setVelocity(entity2, velocity);
                this.speed = Math.max(0.0, this.speed - this.crashBraking);
                if (this.mount instanceof Damageable && this.crashEntityVehicleDamage > 0.0) {
                    double crashDamage = this.maxSpeed > 0.0 ? this.crashEntityVehicleDamage * this.speed / this.maxSpeed : this.crashEntityVehicleDamage;
                    CompatibilityLib.getCompatibilityUtils().damage((Damageable)this.mount, crashDamage, mounted);
                }
                context.playEffects("crash_entity", 1.0f, null, mounted, null, entity2);
            }
        }
        if (this.exemptionDuration > 0 && mounted instanceof Player) {
            context.getController().addFlightExemption((Player)mounted, this.exemptionDuration);
        }
        if (!this.isInAir || this.airControllable) {
            this.adjustHeading(context);
        }
        if (System.currentTimeMillis() > this.liftoffTime + (long)this.liftoffDuration) {
            this.applyThrust(context);
        }
        if (this.fallProtection > 0) {
            context.getMage().enableFallProtection(this.fallProtection, Integer.MAX_VALUE, context.getSpell());
        }
        if (this.jumpSpell != null && context.getMage().isVehicleJumping()) {
            this.jumpSpell.cast(this.jumpSpellParameters);
        }
        return SpellResult.PENDING;
    }

    protected void adjustHeading(CastContext context) {
        if (this.mount == null) {
            return;
        }
        this.targetLocation = context.getEntity().getLocation();
        if (this.steerControllable != 0.0) {
            this.targetLocation.setDirection(this.direction);
            double strafeDirection = context.getMage().getVehicleStrafeDirection();
            if (strafeDirection != 0.0) {
                strafeDirection = -strafeDirection * this.steerControllable;
                this.targetLocation.setYaw(this.targetLocation.getYaw() + (float)strafeDirection);
            }
        }
        Vector targetDirection = this.targetLocation.getDirection();
        if (this.jumpControllable != 0.0 && context.getMage().isVehicleJumping()) {
            targetDirection.setY(this.jumpControllable);
        }
        if (this.maxAscend > 0) {
            targetDirection.setY(0);
            Location checkLocation = this.targetLocation;
            Block checkBlock = checkLocation.getBlock();
            Block oneDown = checkBlock.getRelative(BlockFace.DOWN);
            if (context.isPassthrough(checkBlock) && context.isPassthrough(oneDown)) {
                Block twoDown = oneDown.getRelative(BlockFace.DOWN);
                if (context.isPassthrough(twoDown)) {
                    if (this.isAscending) {
                        checkBlock = twoDown;
                        checkLocation.setY(checkLocation.getY() - 2.0);
                    }
                } else {
                    checkBlock = oneDown;
                    checkLocation.setY(checkLocation.getY() - 1.0);
                }
            }
            this.isAscending = false;
            if (!context.isPassthrough(checkBlock) && context.isPassthrough(checkBlock.getRelative(BlockFace.UP))) {
                targetDirection.setY(10);
                this.isAscending = true;
            } else {
                Vector ahead = targetDirection.clone().multiply(0.75);
                Location checkSlope = checkLocation.clone().add(ahead);
                if (checkSlope.equals((Object)checkLocation)) {
                    checkSlope = checkSlope.add(ahead);
                }
                if (!context.isPassthrough(checkBlock = checkSlope.getBlock()) && context.isPassthrough(checkBlock.getRelative(BlockFace.UP))) {
                    targetDirection.setY(10);
                    this.isAscending = true;
                }
            }
        }
        if (this.moveDistance == 0.0) {
            this.direction = targetDirection;
        } else {
            double moveDistanceSquared = this.moveDistance * this.moveDistance;
            double distanceSquared = this.direction.distanceSquared(targetDirection);
            if (distanceSquared <= moveDistanceSquared) {
                this.direction = targetDirection;
            } else {
                targetDirection = targetDirection.subtract(this.direction).normalize().multiply(this.moveDistance);
                this.direction.add(targetDirection).normalize();
            }
        }
        this.targetLocation.setDirection(this.direction);
        CompatibilityLib.getCompatibilityUtils().setYawPitch(this.mount, this.targetLocation.getYaw() + (float)this.yawOffset, this.targetLocation.getPitch());
    }

    protected void applyThrust(CastContext context) {
        double strafeDirection;
        Entity mountedEntity = context.getEntity();
        if (this.duration > 0) {
            long flightTime = System.currentTimeMillis() - this.liftoffTime;
            if (!this.warningEffectsApplied && this.warningEffects != null && mountedEntity instanceof LivingEntity && this.durationWarning > 0 && flightTime > (long)(this.duration - this.durationWarning)) {
                CompatibilityLib.getCompatibilityUtils().applyPotionEffects((LivingEntity)mountedEntity, this.warningEffects);
                this.warningEffectsApplied = true;
            }
            if (flightTime > (long)this.duration) {
                return;
            }
        }
        double minBrakingSpeed = Math.max(0.0, this.minSpeed);
        if (this.pitchControllable) {
            if (this.direction.getY() < 0.0 && this.maxAcceleration > 0.0) {
                this.speed -= this.direction.getY() * this.maxAcceleration;
                if (this.maxSpeed > 0.0 && this.speed > this.maxSpeed) {
                    this.speed = this.maxSpeed;
                }
            } else if (this.direction.getY() > 0.0 && this.maxDeceleration > 0.0) {
                this.speed -= this.direction.getY() * this.maxDeceleration;
                this.speed = Math.max(minBrakingSpeed, this.speed);
            }
        }
        if (this.jumpVelocity != 0.0 && context.getMage().isVehicleJumping()) {
            this.speed += this.jumpVelocity;
        }
        if (this.controllable) {
            double direction = context.getMage().getVehicleMovementDirection();
            if (direction > 0.0) {
                this.speed += this.maxAcceleration;
                if (this.maxSpeed > 0.0 && this.speed > this.maxSpeed) {
                    this.speed = this.maxSpeed;
                }
            } else if (direction < 0.0) {
                this.speed -= this.maxDeceleration;
                this.speed = Math.max(this.minSpeed, this.speed);
            } else {
                this.speed -= this.braking;
                this.speed = Math.max(minBrakingSpeed, this.speed);
            }
        }
        if (this.yDirection != null) {
            this.direction.setY(this.yDirection.doubleValue()).normalize();
        }
        if (this.pitchOffset != 0.0) {
            this.direction.setY(this.direction.getY() + this.pitchOffset).normalize();
        }
        double blocksAbove = 0.0;
        boolean first = true;
        Location currentLocation = mountedEntity.getLocation();
        if (this.maxHeight > 0 && currentLocation.getY() >= (double)this.maxHeight) {
            blocksAbove = currentLocation.getY() - (double)this.maxHeight + 1.0;
        } else if (this.maxHeightAboveGround >= 0) {
            for (int x = -this.heightCheckRadius; x <= this.heightCheckRadius && (first || blocksAbove > 0.0); ++x) {
                for (int z = -this.heightCheckRadius; z <= this.heightCheckRadius && (first || blocksAbove > 0.0); ++z) {
                    int thisBlocksAbove;
                    Block block = currentLocation.getBlock().getRelative(x, 0, z);
                    for (thisBlocksAbove = 0; thisBlocksAbove < this.maxHeightAboveGround + 5 && context.isPassthrough(block); ++thisBlocksAbove) {
                        block = block.getRelative(BlockFace.DOWN);
                    }
                    if (first) {
                        first = false;
                        blocksAbove = thisBlocksAbove;
                        continue;
                    }
                    blocksAbove = Math.min((double)thisBlocksAbove, blocksAbove);
                }
            }
            blocksAbove = blocksAbove - (double)this.maxHeightAboveGround - 1.0;
        }
        if (this.isAscending) {
            blocksAbove -= (double)(this.maxAscend + 1);
        }
        int multiplier = this.speed < 0.0 ? -1 : 1;
        boolean bl = this.isInAir = blocksAbove > 1.0;
        if (blocksAbove > 0.0 && (double)multiplier * this.direction.getY() >= 0.0) {
            if (blocksAbove > 1.0) {
                this.direction.setY((double)multiplier * -blocksAbove / 5.0).normalize();
            } else {
                this.direction.setY(0).normalize();
            }
        }
        Vector velocity = this.direction.clone();
        if (this.strafeControllable != 0.0 && (strafeDirection = context.getMage().getVehicleStrafeDirection()) != 0.0) {
            Vector strafeVector = new Vector(0.0, 0.0, -strafeDirection * this.strafeControllable);
            strafeVector = VectorUtils.rotateVector(strafeVector, mountedEntity.getLocation());
            velocity.add(strafeVector).normalize();
        }
        if (this.isInAir && this.gravity > 0.0) {
            double terminalSpeed;
            double gravitySpeed = Math.abs(this.gravityVelocity.getY()) + this.gravity / 20.0 / 20.0;
            if (this.terminalVelocity > 0.0 && gravitySpeed > (terminalSpeed = this.terminalVelocity / 20.0)) {
                gravitySpeed = terminalSpeed;
            }
            this.gravityVelocity.setY(-gravitySpeed);
            Vector totalVelocity = this.gravityVelocity;
            if (this.speed != 0.0 && this.airControllable) {
                totalVelocity = totalVelocity.clone();
                totalVelocity.add(velocity.multiply(this.speed));
            }
            SafetyUtils.setVelocity(this.getMount(context), totalVelocity);
        } else {
            this.gravityVelocity.setY(0);
            if (this.speed != 0.0) {
                velocity = velocity.multiply(this.speed);
                SafetyUtils.setVelocity(this.getMount(context), velocity);
            }
        }
    }

    @Nullable
    protected Entity getMount(CastContext context) {
        return this.isPassenger ? context.getEntity() : this.mount;
    }

    protected SpellResult mount(CastContext context) {
        Entity entity = context.getEntity();
        if (entity == null) {
            return SpellResult.NO_TARGET;
        }
        this.mount = context.getTargetEntity();
        if (this.mount == null) {
            return SpellResult.NO_TARGET;
        }
        if (this.noTarget) {
            CompatibilityLib.getEntityMetadataUtils().setBoolean(this.mount, MagicMetaKeys.NO_TARGET, true);
        }
        if (this.noDrops) {
            CompatibilityLib.getEntityMetadataUtils().setBoolean(this.mount, MagicMetaKeys.NO_DROPS, true);
        }
        if (this.isPassenger) {
            CompatibilityLib.getDeprecatedUtils().setPassenger(entity, this.mount);
        } else {
            CompatibilityLib.getDeprecatedUtils().setPassenger(this.mount, entity);
        }
        this.direction = this.mount.getLocation().getDirection();
        this.adjustHeading(context);
        this.liftoffTime = System.currentTimeMillis();
        this.speed = this.startSpeed;
        if (this.liftoffThrust > 0.0) {
            SafetyUtils.setVelocity(this.getMount(context), new Vector(0.0, this.liftoffThrust, 0.0));
        }
        if (this.sound != null) {
            this.nextSoundPlay = System.currentTimeMillis();
        }
        if (this.noTargetPlayer) {
            CompatibilityLib.getEntityMetadataUtils().setBoolean(entity, MagicMetaKeys.NO_TARGET, true);
        }
        if (this.ridingEffects != null && entity instanceof LivingEntity) {
            CompatibilityLib.getCompatibilityUtils().applyPotionEffects((LivingEntity)entity, this.ridingEffects);
        }
        return SpellResult.PENDING;
    }

    @Override
    public void finish(CastContext context) {
        if (this.noTarget && this.mount != null) {
            CompatibilityLib.getEntityMetadataUtils().setBoolean(this.mount, MagicMetaKeys.NO_TARGET, false);
        }
        if (this.mount != null) {
            this.mount.eject();
            this.mount = null;
        }
        Entity mountedEntity = context.getEntity();
        if (this.noTargetPlayer && mountedEntity != null) {
            CompatibilityLib.getEntityMetadataUtils().setBoolean(mountedEntity, MagicMetaKeys.NO_TARGET, false);
        }
        if (this.warningEffectsApplied && this.warningEffects != null && mountedEntity != null && mountedEntity instanceof LivingEntity) {
            for (PotionEffect effect : this.warningEffects) {
                ((LivingEntity)mountedEntity).removePotionEffect(effect.getType());
            }
        }
        if (this.ridingEffects != null && mountedEntity != null && mountedEntity instanceof LivingEntity) {
            for (PotionEffect effect : this.ridingEffects) {
                ((LivingEntity)mountedEntity).removePotionEffect(effect.getType());
            }
        }
    }

    protected boolean crash(CastContext context) {
        boolean dismount;
        double damage;
        context.sendMessageKey("crash");
        context.playEffects("crash");
        Entity mountedEntity = context.getEntity();
        if (this.crashDamage > 0.0) {
            double d = damage = this.maxSpeed > 0.0 ? this.crashDamage * this.speed / this.maxSpeed : this.crashDamage;
            if (mountedEntity.isValid() && mountedEntity instanceof Damageable) {
                CompatibilityLib.getCompatibilityUtils().damage((Damageable)mountedEntity, damage, this.mount);
            }
        }
        if (this.crashVehicleDamage > 0.0) {
            double d = damage = this.maxSpeed > 0.0 ? this.crashVehicleDamage * this.speed / this.maxSpeed : this.crashVehicleDamage;
            if (this.mount != null && this.mount.isValid() && this.mount instanceof Damageable) {
                CompatibilityLib.getCompatibilityUtils().damage((Damageable)this.mount, damage, mountedEntity);
            }
        }
        boolean bl = dismount = this.speed >= this.crashDismountSpeed;
        if (dismount) {
            if (this.crashVelocity > 0.0 && this.maxSpeed > 0.0) {
                this.mount.eject();
                Vector crashDirection = this.direction.clone();
                if (this.crashVelocityYOffset > 0.0) {
                    crashDirection.setY(crashDirection.getY() + this.crashVelocityYOffset).normalize();
                }
                Vector velocity = crashDirection.multiply(this.crashVelocity * this.speed / this.maxSpeed);
                SafetyUtils.setVelocity(mountedEntity, velocity);
            }
            if (this.crashEffects != null && mountedEntity != null && this.crashEffects.size() > 0 && mountedEntity instanceof LivingEntity) {
                CompatibilityLib.getCompatibilityUtils().applyPotionEffects((LivingEntity)mountedEntity, this.crashEffects);
            }
            this.warningEffectsApplied = false;
        }
        this.speed = 0.0;
        return dismount;
    }

    protected boolean checkForCrash(CastContext context, Location source, Vector threshold) {
        if (this.maxAscend > 0) {
            source.setY(source.getY() + (double)this.maxAscend);
        }
        Block facingBlock = source.getBlock();
        Block targetBlock = source.add(threshold).getBlock();
        return !targetBlock.equals(facingBlock) && !context.isPassthrough(targetBlock);
    }

    @Override
    public boolean isUndoable() {
        return false;
    }

    @Override
    public void getParameterNames(Spell spell, Collection<String> parameters) {
        super.getParameterNames(spell, parameters);
        parameters.add("steer_speed");
        parameters.add("liftoff_duration");
        parameters.add("liftoff_thrust");
        parameters.add("crash_distance");
        parameters.add("max_height");
        parameters.add("max_height_above_ground");
        parameters.add("duration");
        parameters.add("duration_warning");
        parameters.add("start_speed");
        parameters.add("min_speed");
        parameters.add("max_speed");
        parameters.add("max_acceleration");
        parameters.add("max_deceleration");
        parameters.add("pitch_offset");
        parameters.add("yaw_offset");
        parameters.add("braking");
        parameters.add("controllable");
        parameters.add("strafe_controllable");
        parameters.add("pitch_controllable");
        parameters.add("jump_controllable");
        parameters.add("gravity");
        parameters.add("air_controllable");
        parameters.add("height_check_radius");
        parameters.add("mount_no_drops");
    }

    @Override
    public void getParameterOptions(Spell spell, String parameterKey, Collection<String> examples) {
        if (parameterKey.equals("crash_distance") || parameterKey.equals("max_height") || parameterKey.equals("height_check_radius") || parameterKey.equals("max_height_above_ground")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_SIZES));
        } else if (parameterKey.equals("steer_speed") || parameterKey.equals("start_speed") || parameterKey.equals("min_speed") || parameterKey.equals("max_speed") || parameterKey.equals("max_acceleration") || parameterKey.equals("max_deceleration") || parameterKey.equals("braking") || parameterKey.equals("pitch_offset") || parameterKey.equals("yaw_offset") || parameterKey.equals("gravity") || parameterKey.equals("liftoff_thrust") || parameterKey.equals("jump_controllable") || parameterKey.equals("strafe_controllable")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_VECTOR_COMPONENTS));
        } else if (parameterKey.equals("liftoff_duration") || parameterKey.equals("duration") || parameterKey.equals("duration_warning")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_DURATIONS));
        } else if (parameterKey.equals("air_controllable") || parameterKey.equals("controllable") || parameterKey.equals("mount_no_drops") || parameterKey.equals("pitch_controllable")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_BOOLEANS));
        } else {
            super.getParameterOptions(spell, parameterKey, examples);
        }
    }
}

