/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.requirements;

import com.elmakers.mine.bukkit.api.economy.Currency;
import com.elmakers.mine.bukkit.api.integration.ClientPlatform;
import com.elmakers.mine.bukkit.api.magic.CasterProperties;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageClass;
import com.elmakers.mine.bukkit.api.magic.MageContext;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.magic.ModifierTemplate;
import com.elmakers.mine.bukkit.api.magic.ProgressionPath;
import com.elmakers.mine.bukkit.api.requirements.Requirement;
import com.elmakers.mine.bukkit.api.spell.MageSpell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.api.wand.Wand;
import com.elmakers.mine.bukkit.api.wand.WandUpgradePath;
import com.elmakers.mine.bukkit.magic.MagicMetaKeys;
import com.elmakers.mine.bukkit.requirements.CurrencyRequirement;
import com.elmakers.mine.bukkit.requirements.ItemRequirement;
import com.elmakers.mine.bukkit.requirements.MoonRequirement;
import com.elmakers.mine.bukkit.requirements.PropertyRequirement;
import com.elmakers.mine.bukkit.requirements.RangedRequirement;
import com.elmakers.mine.bukkit.requirements.TimeRequirement;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class MagicRequirement {
    @Nonnull
    private final MageController controller;
    @Nullable
    private String permissionNode = null;
    @Nullable
    private String notPermissionNode = null;
    @Nullable
    private String requiredPath = null;
    @Nullable
    private String requiredTemplate = null;
    @Nullable
    private Set<String> requiredTemplates = null;
    @Nullable
    private List<String> requiredModifiers = null;
    @Nullable
    private List<String> wandTags = null;
    @Nullable
    private List<String> wandSlots = null;
    private boolean openSpellInventory = false;
    @Nullable
    private String requiresCompletedPath = null;
    @Nullable
    private String exactPath = null;
    @Nullable
    private List<String> mageClass = null;
    @Nullable
    private List<String> activeClass = null;
    @Nullable
    private List<PropertyRequirement> wandProperties = null;
    @Nullable
    private List<PropertyRequirement> classProperties = null;
    @Nullable
    private List<PropertyRequirement> attributes = null;
    @Nullable
    private List<PropertyRequirement> variables = null;
    @Nullable
    private Set<String> regionTags = null;
    @Nullable
    private RangedRequirement lightLevel = null;
    @Nullable
    private TimeRequirement timeOfDay = null;
    @Nullable
    private MoonRequirement moonPhase = null;
    @Nullable
    private RangedRequirement height = null;
    @Nullable
    private RangedRequirement serverVersion = null;
    @Nullable
    private CurrencyRequirement currency = null;
    @Nullable
    private ItemRequirement item = null;
    @Nullable
    private String weather = null;
    @Nullable
    private String castSpell = null;
    @Nullable
    private ClientPlatform clientPlatform = null;
    private String messageSection = "";
    private int castTimeout = 0;
    private boolean requireResourcePack = false;
    private boolean requireWand = false;
    private boolean ignoreMissing = false;
    private Boolean indoors;
    private Boolean stay;
    private Boolean owned;

    public MagicRequirement(@Nonnull MageController controller, @Nonnull Requirement requirement) {
        String clientPlatformKey;
        List<String> regionTagList;
        this.controller = controller;
        ConfigurationSection configuration = requirement.getConfiguration();
        this.messageSection = configuration.getString("message_section", "");
        if (!this.messageSection.isEmpty()) {
            this.messageSection = this.messageSection + ".";
        }
        this.permissionNode = configuration.getString("permission");
        this.notPermissionNode = configuration.getString("not_permission");
        this.requiredPath = configuration.getString("path");
        this.exactPath = configuration.getString("path_exact");
        this.requiresCompletedPath = configuration.getString("path_end");
        this.requiredTemplate = configuration.getString("wand");
        this.requireWand = configuration.getBoolean("holding_wand");
        this.requireResourcePack = configuration.getBoolean("resource_pack");
        this.mageClass = ConfigurationUtils.getStringList(configuration, "class");
        this.activeClass = ConfigurationUtils.getStringList(configuration, "active_class");
        this.wandTags = ConfigurationUtils.getStringList(configuration, "wand_tags");
        this.wandSlots = ConfigurationUtils.getStringList(configuration, "wand_slots");
        this.openSpellInventory = configuration.getBoolean("spell_inventory_open");
        this.ignoreMissing = configuration.getBoolean("ignore_missing", false);
        this.indoors = ConfigurationUtils.getOptionalBoolean(configuration, "indoors");
        this.stay = ConfigurationUtils.getOptionalBoolean(configuration, "stay");
        this.owned = ConfigurationUtils.getOptionalBoolean(configuration, "owned");
        if (this.activeClass != null && this.mageClass == null) {
            this.mageClass = this.activeClass;
        }
        if ((regionTagList = ConfigurationUtils.getStringList(configuration, "region_tags")) != null && !regionTagList.isEmpty()) {
            this.regionTags = new HashSet<String>(regionTagList);
        }
        if (configuration.contains("wands")) {
            this.requiredTemplates = new HashSet<String>(ConfigurationUtils.getStringList(configuration, "wands"));
        }
        if (configuration.contains("modifiers")) {
            this.requiredModifiers = ConfigurationUtils.getStringList(configuration, "modifiers");
        }
        this.wandProperties = this.parsePropertyRequirements(configuration, "wand_properties", "wand_property", "property");
        this.classProperties = this.parsePropertyRequirements(configuration, "class_properties", "class_property", "property");
        this.attributes = this.parsePropertyRequirements(configuration, "attributes", "attribute", "attribute");
        this.variables = this.parsePropertyRequirements(configuration, "variables", "variable", "variable");
        this.lightLevel = this.parseRangedRequirement(configuration, "light");
        this.timeOfDay = this.parseTimeRequirement(configuration, "time");
        this.moonPhase = this.parseMoonRequirement(configuration, "moon");
        this.weather = configuration.getString("weather");
        this.height = this.parseRangedRequirement(configuration, "height");
        this.serverVersion = this.parseRangedRequirement(configuration, "server_version");
        String defaultCurrencyType = configuration.getString("currency_type", "currency");
        this.currency = CurrencyRequirement.parse(configuration, "currency", defaultCurrencyType);
        this.item = ItemRequirement.parse(configuration, "item");
        this.castSpell = configuration.getString("cast_spell");
        this.castTimeout = configuration.getInt("cast_timeout", 0);
        if (this.requiresCompletedPath != null) {
            this.requiredPath = this.requiresCompletedPath;
            this.exactPath = this.requiresCompletedPath;
        }
        if (this.requiredTemplate != null || this.requiredTemplates != null || this.wandProperties != null || this.wandTags != null || this.wandSlots != null || this.openSpellInventory) {
            this.requireWand = true;
        }
        if ((clientPlatformKey = configuration.getString("client_platform")) != null && !clientPlatformKey.isEmpty()) {
            try {
                this.clientPlatform = ClientPlatform.valueOf(clientPlatformKey.toUpperCase());
            }
            catch (Exception ex) {
                controller.getLogger().warning("Invalid client_platform in requirement: " + clientPlatformKey);
            }
        }
    }

    @Nullable
    private RangedRequirement parseRangedRequirement(ConfigurationSection configuration, String key) {
        ConfigurationSection rangedConfig = ConfigurationUtils.getConfigurationSection(configuration, key);
        if (rangedConfig != null) {
            return new RangedRequirement(rangedConfig);
        }
        if (configuration.contains(key)) {
            return new RangedRequirement(configuration.getString(key));
        }
        return null;
    }

    @Nullable
    private TimeRequirement parseTimeRequirement(ConfigurationSection configuration, String key) {
        ConfigurationSection rangedConfig = ConfigurationUtils.getConfigurationSection(configuration, key);
        if (rangedConfig != null) {
            return new TimeRequirement(rangedConfig, this.controller.getLogger());
        }
        if (configuration.contains(key)) {
            return new TimeRequirement(configuration.getString(key), this.controller.getLogger());
        }
        return null;
    }

    @Nullable
    private MoonRequirement parseMoonRequirement(ConfigurationSection configuration, String key) {
        ConfigurationSection rangedConfig = ConfigurationUtils.getConfigurationSection(configuration, key);
        if (rangedConfig != null) {
            return new MoonRequirement(rangedConfig, this.controller.getLogger());
        }
        if (configuration.contains(key)) {
            return new MoonRequirement(configuration.getString(key), this.controller.getLogger());
        }
        return null;
    }

    @Nullable
    private List<PropertyRequirement> parsePropertyRequirements(ConfigurationSection configuration, String section, String singleSection, String type) {
        ArrayList<PropertyRequirement> requirements = null;
        if (configuration.isList(section)) {
            requirements = new ArrayList<PropertyRequirement>();
            List<ConfigurationSection> propertyConfigs = ConfigurationUtils.getNodeList(configuration, section);
            for (ConfigurationSection propertyConfig : propertyConfigs) {
                if (!propertyConfig.contains(type)) {
                    this.controller.getLogger().warning("Property requirement missing " + type + " parameter");
                    continue;
                }
                PropertyRequirement requirement = new PropertyRequirement(type, propertyConfig);
                requirements.add(requirement);
            }
        }
        Object singleConfigObject = configuration.get(singleSection);
        ConfigurationSection propertyConfig = null;
        if (singleConfigObject != null) {
            if (singleConfigObject instanceof Map) {
                propertyConfig = ConfigurationUtils.toConfigurationSection(configuration, (Map)singleConfigObject);
            } else if (singleConfigObject instanceof ConfigurationSection) {
                propertyConfig = (ConfigurationSection)singleConfigObject;
            }
        }
        if (propertyConfig != null) {
            if (!propertyConfig.contains(type)) {
                this.controller.getLogger().warning("Property requirement missing " + type + " parameter");
                return null;
            }
            if (requirements == null) {
                requirements = new ArrayList();
            }
            PropertyRequirement requirement = new PropertyRequirement(type, propertyConfig);
            requirements.add(requirement);
        }
        return requirements;
    }

    public boolean checkRequirement(@Nonnull MageContext context) {
        Double value;
        String template;
        Object ownerId;
        int[] versionPieces;
        Mage mage = context.getMage();
        Player player = mage.getPlayer();
        if (!(this.permissionNode == null || player != null && player.hasPermission(this.permissionNode))) {
            return false;
        }
        if (this.notPermissionNode != null && player != null && player.hasPermission(this.notPermissionNode)) {
            return false;
        }
        if (this.clientPlatform != null && mage.getClientPlatform() != this.clientPlatform) {
            return false;
        }
        if (!(this.serverVersion == null || (versionPieces = CompatibilityLib.getServerVersion(this.controller.getPlugin())).length >= 2 && this.serverVersion.check(Double.valueOf(versionPieces[1])))) {
            return false;
        }
        Wand wand = context.getWand();
        if (wand == null && this.requireWand) {
            return false;
        }
        if (this.requireResourcePack && !mage.hasResourcePack()) {
            return false;
        }
        Location location = mage.getLocation();
        if (this.indoors != null) {
            Block highest = location.getWorld().getHighestBlockAt(location.getBlockX(), location.getBlockZ());
            if (location.getBlockY() < highest.getY() != this.indoors) {
                return false;
            }
        }
        Entity entity = mage.getEntity();
        if (this.stay != null && CompatibilityLib.getEntityMetadataUtils().getBoolean(entity, MagicMetaKeys.STAY) != this.stay.booleanValue()) {
            return false;
        }
        if (this.owned != null && (ownerId = CompatibilityLib.getCompatibilityUtils().getOwnerId(entity)) != null != this.owned) {
            return false;
        }
        if (this.weather != null) {
            switch (this.weather) {
                case "storm": {
                    if (location != null && location.getWorld().hasStorm()) break;
                    return false;
                }
                case "thunder": {
                    if (location != null && location.getWorld().isThundering()) break;
                    return false;
                }
                case "clear": {
                    if (location != null && !location.getWorld().isThundering() && !location.getWorld().hasStorm()) break;
                    return false;
                }
                default: {
                    context.getLogger().warning("Invalid weather specified in requirement " + this.weather + ", looking for clear/storm/thunder");
                }
            }
        }
        if (!(this.timeOfDay == null || location != null && this.timeOfDay.check(Double.valueOf(location.getWorld().getTime())))) {
            return false;
        }
        if (this.moonPhase != null) {
            int phase = (int)(location.getWorld().getFullTime() / 24000L % 8L);
            if (location == null || !this.moonPhase.check(Double.valueOf(phase))) {
                return false;
            }
        }
        if (!(this.lightLevel == null || location != null && this.lightLevel.check(Double.valueOf(location.getBlock().getLightLevel())))) {
            return false;
        }
        if (!(this.height == null || location != null && this.height.check(location.getY()))) {
            return false;
        }
        if (!(this.currency == null || location != null && this.currency.check(mage))) {
            return false;
        }
        if (!(this.item == null || location != null && this.item.check(mage))) {
            return false;
        }
        if (this.castSpell != null && !this.castSpell.isEmpty()) {
            MageSpell spell = mage.getSpell(this.castSpell);
            if (spell == null) {
                return false;
            }
            long lastCast = spell.getLastCast();
            if (lastCast == 0L) {
                return false;
            }
            if (this.castTimeout > 0 && System.currentTimeMillis() - lastCast > (long)this.castTimeout) {
                return false;
            }
        }
        if (this.wandTags != null && !this.hasTags(wand)) {
            return false;
        }
        if (this.wandSlots != null && !this.hasSlots(wand)) {
            return false;
        }
        if (this.openSpellInventory && !wand.isInventoryOpen()) {
            return false;
        }
        if (this.regionTags != null && !this.controller.inTaggedRegion(location, this.regionTags)) {
            return false;
        }
        if (!(this.requiredTemplate == null || (template = wand.getTemplateKey()) != null && template.equals(this.requiredTemplate))) {
            return false;
        }
        if (!(this.requiredTemplates == null || this.requiredModifiers.isEmpty() || (template = wand.getTemplateKey()) != null && this.requiredTemplates.contains(template))) {
            return false;
        }
        if (this.requiredModifiers != null) {
            boolean hasAny = false;
            for (String modifierKey : this.requiredModifiers) {
                if (!mage.hasModifier(modifierKey)) continue;
                hasAny = true;
                break;
            }
            if (!hasAny) {
                return false;
            }
        }
        CasterProperties checkProperties = context.getActiveProperties();
        ProgressionPath path = checkProperties.getPath();
        if (this.mageClass != null && !this.mageClass.isEmpty()) {
            boolean hasAny = false;
            for (String string : this.mageClass) {
                if (!mage.hasClassUnlocked(string)) continue;
                hasAny = true;
                break;
            }
            if (!hasAny) {
                return false;
            }
        }
        if (this.activeClass != null && !this.activeClass.isEmpty()) {
            MageClass currentClass = mage.getActiveClass();
            boolean hasAny = false;
            if (currentClass != null) {
                for (String testClass : this.activeClass) {
                    if (!currentClass.getKey().equals(testClass)) continue;
                    hasAny = true;
                    break;
                }
            }
            if (!hasAny) {
                return false;
            }
        }
        if (this.requiredPath != null || this.exactPath != null) {
            if (path == null) {
                return false;
            }
            if (this.requiredPath != null && !path.hasPath(this.requiredPath)) {
                return false;
            }
            if (this.exactPath != null && !this.exactPath.equals(path.getKey())) {
                return false;
            }
            if (this.requiresCompletedPath != null) {
                boolean hasPathCompleted = false;
                if (path.hasPath(this.requiresCompletedPath)) {
                    hasPathCompleted = path.getKey().equals(this.requiresCompletedPath) ? !path.canProgress(checkProperties) : true;
                }
                if (!hasPathCompleted) {
                    return false;
                }
            }
        }
        if (this.wandProperties != null && !this.checkProperties(wand, this.wandProperties)) {
            return false;
        }
        if (this.classProperties != null) {
            MageClass activeClass = mage.getActiveClass();
            if (this.mageClass != null) {
                String string;
                Iterator<String> hasAny = this.mageClass.iterator();
                while (hasAny.hasNext() && (activeClass = mage.getClass(string = hasAny.next())) == null) {
                }
            }
            if (activeClass == null) {
                return false;
            }
            if (!this.checkProperties(activeClass, this.classProperties)) {
                return false;
            }
        }
        if (this.attributes != null) {
            for (PropertyRequirement requirement : this.attributes) {
                String string;
                if (requirement.check(value = context.getAttribute(string = requirement.key))) continue;
                return false;
            }
        }
        if (this.variables != null) {
            for (PropertyRequirement requirement : this.variables) {
                String string;
                if (requirement.check(value = context.getVariable(string = requirement.key))) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean checkProperties(CasterProperties properties, List<PropertyRequirement> requirements) {
        for (PropertyRequirement requirement : requirements) {
            String key;
            Double value;
            if (requirement.check(value = properties.hasProperty(key = requirement.key) ? properties.getProperty(key, 0.0) : null)) continue;
            return false;
        }
        return true;
    }

    protected String getMessage(MageContext context, String key) {
        return context.getMessage(this.messageSection + key, this.getDefaultMessage(context, key));
    }

    protected String getDefaultMessage(MageContext context, String key) {
        return context.getController().getMessages().get("requirements." + key);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public String getRequirementDescription(@Nonnull MageContext context) {
        String message;
        Double value;
        String key;
        String string;
        String template;
        String message2;
        String message3;
        Object ownerId;
        Wand wand;
        Mage mage = context.getMage();
        MageController controller = mage.getController();
        Player player = mage.getPlayer();
        if (!(this.permissionNode == null || player != null && player.hasPermission(this.permissionNode))) {
            return context.getMessage(SpellResult.INSUFFICIENT_PERMISSION.name().toLowerCase());
        }
        if (this.notPermissionNode != null && player != null && player.hasPermission(this.notPermissionNode)) {
            return context.getMessage(SpellResult.INSUFFICIENT_PERMISSION.name().toLowerCase());
        }
        if (this.clientPlatform != null && mage.getClientPlatform() != this.clientPlatform) {
            return context.getMessage("no_client_platform");
        }
        if (this.serverVersion != null) {
            String message4;
            Double majorVersion = null;
            int[] versionPieces = CompatibilityLib.getServerVersion(controller.getPlugin());
            if (versionPieces.length > 1) {
                majorVersion = versionPieces[1];
            }
            if ((message4 = this.checkRequiredProperty(context, this.serverVersion, this.getMessage(context, "server_version"), majorVersion)) != null) {
                return message4;
            }
        }
        if ((wand = context.getWand()) == null && this.requireWand) {
            return this.getMessage(context, "no_wand");
        }
        if (this.requireResourcePack && !mage.hasResourcePack()) {
            return this.getMessage(context, "no_resource_pack");
        }
        Location location = mage.getLocation();
        if (this.indoors != null) {
            Block highest = location.getWorld().getHighestBlockAt(location.getBlockX(), location.getBlockZ());
            if (location.getBlockY() < highest.getY() != this.indoors) {
                return this.getMessage(context, this.indoors != false ? "no_indoors" : "indoors");
            }
        }
        Entity entity = mage.getEntity();
        if (this.stay != null && CompatibilityLib.getEntityMetadataUtils().getBoolean(entity, MagicMetaKeys.STAY) != this.stay.booleanValue()) {
            return this.getMessage(context, this.stay != false ? "no_stay" : "stay");
        }
        if (this.owned != null && (ownerId = CompatibilityLib.getCompatibilityUtils().getOwnerId(entity)) != null != this.owned) {
            return this.getMessage(context, this.owned != false ? "no_owned" : "owned");
        }
        if (this.weather != null) {
            switch (this.weather) {
                case "storm": {
                    if (location != null && location.getWorld().hasStorm()) break;
                    return this.getMessage(context, "no_weather");
                }
                case "thunder": {
                    if (location != null && location.getWorld().isThundering()) break;
                    return this.getMessage(context, "no_weather");
                }
                case "clear": {
                    if (location != null && !location.getWorld().isThundering() && !location.getWorld().hasStorm()) break;
                    return this.getMessage(context, "no_weather");
                }
                default: {
                    context.getLogger().warning("Invalid weather specified in requirement " + this.weather + ", looking for clear/storm/thunder");
                }
            }
        }
        if (this.moonPhase != null) {
            int phase = (int)(location.getWorld().getFullTime() / 24000L % 8L);
            String message5 = this.checkRequiredProperty(context, this.moonPhase, this.getMessage(context, "moon"), location == null ? null : Double.valueOf(phase));
            if (message5 != null) {
                return message5;
            }
        }
        if (this.timeOfDay != null && (message3 = this.checkRequiredProperty(context, this.timeOfDay, this.getMessage(context, "time"), location == null ? null : Double.valueOf(location.getWorld().getTime()))) != null) {
            return message3;
        }
        if (this.lightLevel != null && (message2 = this.checkRequiredProperty(context, this.lightLevel, this.getMessage(context, "light"), location == null ? null : Double.valueOf(location.getBlock().getLightLevel()))) != null) {
            return message2;
        }
        if (this.height != null && (message = this.checkRequiredProperty(context, this.height, this.getMessage(context, "height"), location == null ? null : Double.valueOf(location.getY()))) != null) {
            return message;
        }
        if (this.currency != null) {
            String currencyMessage = this.getMessage(context, "currency");
            String currencyKey = this.currency.getKey();
            Currency currency = controller.getCurrency(currencyKey);
            currencyKey = currency == null ? "?" : currency.getName(controller.getMessages());
            String message6 = this.checkRequiredProperty(context, this.currency, currencyMessage = currencyMessage.replace("$currency", currencyKey), mage.getCurrency(currencyKey));
            if (message6 != null) {
                return message6;
            }
        }
        if (this.item != null) {
            Double count;
            String itemMessage = this.getMessage(context, "item");
            ItemStack itemStack = this.item.getItemStack(controller);
            String string2 = itemStack == null ? "?" : controller.describeItem(itemStack);
            String message7 = this.checkRequiredProperty(context, this.item, itemMessage = itemMessage.replace("$item", string2), count = itemStack == null ? null : Double.valueOf(mage.getItemCount(itemStack)));
            if (message7 != null) {
                return message7;
            }
        }
        if (this.castSpell != null) {
            MageSpell mageSpell;
            String spellName = "Unknown";
            SpellTemplate template2 = controller.getSpellTemplate(this.castSpell);
            if (template2 != null) {
                spellName = template2.getName();
            }
            if ((mageSpell = mage.getSpell(this.castSpell)) == null) {
                return this.getMessage(context, "no_cast").replace("$spell", spellName);
            }
            long lastCast = mageSpell.getLastCast();
            if (lastCast == 0L) {
                return this.getMessage(context, "no_cast").replace("$spell", spellName);
            }
            if (this.castTimeout > 0 && System.currentTimeMillis() - lastCast > (long)this.castTimeout) {
                return this.getMessage(context, "no_cast").replace("$spell", spellName);
            }
        }
        if (!(this.requiredTemplate == null || (template = wand.getTemplateKey()) != null && template.equals(this.requiredTemplate))) {
            return this.getMessage(context, "no_template").replace("$wand", wand.getName());
        }
        if (!(this.requiredTemplates == null || (template = wand.getTemplateKey()) != null && this.requiredTemplates.contains(template))) {
            return this.getMessage(context, "no_template").replace("$wand", wand.getName());
        }
        if (this.requiredModifiers != null && !this.requiredModifiers.isEmpty()) {
            boolean hasAny = false;
            for (String string3 : this.requiredModifiers) {
                if (!mage.hasModifier(string3)) continue;
                hasAny = true;
                break;
            }
            if (!hasAny) {
                ModifierTemplate modifier = controller.getModifierTemplate(this.requiredModifiers.get(0));
                String string4 = modifier == null ? "?" : modifier.getName();
                return this.getMessage(context, "no_modifier").replace("$modifier", string4);
            }
        }
        if (this.wandTags != null && !this.hasTags(wand)) {
            return this.getMessage(context, "no_template").replace("$wand", wand.getName());
        }
        if (this.wandSlots != null && !this.hasSlots(wand)) {
            return this.getMessage(context, "no_template").replace("$wand", wand.getName());
        }
        if (this.openSpellInventory && !wand.isInventoryOpen()) {
            return this.getMessage(context, "no_spell_inventory").replace("$wand", wand.getName());
        }
        if (this.regionTags != null && !controller.inTaggedRegion(location, this.regionTags)) {
            return this.getMessage(context, "no_region");
        }
        if (this.mageClass != null && !this.mageClass.isEmpty()) {
            boolean hasAny = false;
            for (String string5 : this.mageClass) {
                if (!mage.hasClassUnlocked(string5)) continue;
                hasAny = true;
                break;
            }
            if (!hasAny) {
                return this.getMessage(context, "no_class").replace("$class", this.mageClass.get(0));
            }
        }
        if (this.activeClass != null && !this.activeClass.isEmpty()) {
            MageClass currentClass = mage.getActiveClass();
            boolean hasAny = false;
            if (currentClass != null) {
                for (String testClass : this.activeClass) {
                    if (!currentClass.getKey().equals(testClass)) continue;
                    hasAny = true;
                    break;
                }
            }
            if (!hasAny) {
                return this.getMessage(context, "no_class").replace("$class", this.activeClass.get(0));
            }
        }
        CasterProperties checkProperties = context.getActiveProperties();
        ProgressionPath path = checkProperties.getPath();
        if (this.requiredPath != null || this.exactPath != null) {
            if (path == null) {
                return this.getMessage(context, "no_path");
            }
            if (this.requiredPath != null && !path.hasPath(this.requiredPath)) {
                WandUpgradePath wandUpgradePath = controller.getPath(this.requiredPath);
                String pathName = this.requiredPath;
                if (wandUpgradePath != null) {
                    pathName = wandUpgradePath.getName();
                } else if (!this.ignoreMissing) {
                    context.getLogger().warning("Invalid path specified in requirement " + this.requiredPath);
                }
                return this.getMessage(context, "no_required_path").replace("$path", pathName);
            }
            if (this.exactPath != null && !this.exactPath.equals(path.getKey())) {
                WandUpgradePath wandUpgradePath = controller.getPath(this.exactPath);
                String pathName = this.exactPath;
                if (wandUpgradePath != null) {
                    pathName = wandUpgradePath.getName();
                } else if (!this.ignoreMissing) {
                    context.getLogger().warning("Invalid path specified in requirement: " + this.exactPath);
                }
                return this.getMessage(context, "no_path_exact").replace("$path", pathName);
            }
            if (this.requiresCompletedPath != null) {
                void var10_48;
                boolean bl = false;
                if (path.hasPath(this.requiresCompletedPath)) {
                    if (path.getKey().equals(this.requiresCompletedPath)) {
                        boolean bl2 = !path.canProgress(checkProperties);
                    } else {
                        boolean bl3 = true;
                    }
                }
                if (var10_48 == false) {
                    WandUpgradePath requiresPath2 = controller.getPath(this.requiresCompletedPath);
                    String pathName = this.requiresCompletedPath;
                    if (requiresPath2 != null) {
                        pathName = requiresPath2.getName();
                    } else if (!this.ignoreMissing) {
                        context.getLogger().warning("Invalid path specified in requirement: " + this.exactPath);
                    }
                    return this.getMessage(context, "no_path_end").replace("$path", pathName);
                }
            }
        }
        if (this.wandProperties != null && (string = this.getRequiredProperty(context, wand, this.wandProperties)) != null) {
            return string;
        }
        if (this.classProperties != null) {
            void var10_51;
            MageClass mageClass = mage.getActiveClass();
            if (this.mageClass != null) {
                String tryClass;
                MageClass mageClass2;
                Iterator<String> requiresPath2 = this.mageClass.iterator();
                while (requiresPath2.hasNext() && (mageClass2 = mage.getClass(tryClass = requiresPath2.next())) == null) {
                }
            }
            if (var10_51 == null) {
                return this.getMessage(context, "no_path");
            }
            String message8 = this.getRequiredProperty(context, (CasterProperties)var10_51, this.classProperties);
            if (message8 != null) {
                return message8;
            }
        }
        if (this.attributes != null) {
            for (PropertyRequirement requirement : this.attributes) {
                message = this.checkRequiredProperty(context, requirement, key = requirement.key, value = context.getAttribute(key));
                if (message == null) continue;
                return message;
            }
        }
        if (this.variables != null) {
            for (PropertyRequirement requirement : this.variables) {
                message = this.checkRequiredProperty(context, requirement, key = requirement.key, value = context.getVariable(key));
                if (message == null) continue;
                return message;
            }
        }
        return null;
    }

    @Nullable
    protected String getRequiredProperty(MageContext context, CasterProperties properties, List<PropertyRequirement> requirements) {
        for (PropertyRequirement requirement : requirements) {
            String message;
            String key = requirement.key;
            Double value = properties.hasProperty(key) ? properties.getProperty(key, 0.0) : null;
            String messageKey = "wand." + key;
            String name = key;
            if (this.controller.getMessages().containsKey(messageKey)) {
                name = this.controller.getMessages().getLevelString(messageKey, value == null ? 0.0f : (float)value.doubleValue());
            }
            if ((message = this.checkRequiredProperty(context, requirement, name, value)) == null) continue;
            return message;
        }
        return null;
    }

    @Nullable
    protected String checkRequiredProperty(MageContext context, RangedRequirement requirement, String name, Double value) {
        if (!(requirement.value == null || value != null && value.equals(requirement.value))) {
            return this.getMessage(context, "property_requirement").replace("$property", name).replace("$value", Double.toString(requirement.value).replace("@value", Integer.toString((int)requirement.value.doubleValue())));
        }
        if (requirement.min != null) {
            if (requirement.inclusive) {
                if (value == null || value < requirement.min) {
                    return this.getMessage(context, "property_min_inclusive").replace("$property", name).replace("$value", Double.toString(requirement.min)).replace("@value", Integer.toString((int)requirement.min.doubleValue()));
                }
            } else if (value == null || value <= requirement.min) {
                return this.getMessage(context, "property_min").replace("$property", name).replace("$value", Double.toString(requirement.min)).replace("@value", Integer.toString((int)requirement.min.doubleValue()));
            }
        }
        if (requirement.max != null) {
            if (requirement.inclusive) {
                if (value != null && value > requirement.max) {
                    return this.getMessage(context, "property_max_inclusve").replace("$property", name).replace("$value", Double.toString(requirement.max)).replace("value", Integer.toString((int)requirement.max.doubleValue()));
                }
            } else if (value != null && value >= requirement.max) {
                return this.getMessage(context, "property_max").replace("$property", name).replace("$value", Double.toString(requirement.max)).replace("@value", Integer.toString((int)requirement.max.doubleValue()));
            }
        }
        return null;
    }

    protected boolean hasTags(Wand wand) {
        for (String checkTag : this.wandTags) {
            if (!wand.hasTag(checkTag)) continue;
            return true;
        }
        return false;
    }

    protected boolean hasSlots(Wand wand) {
        for (String checkSlot : this.wandSlots) {
            if (!wand.hasSlot(checkSlot)) continue;
            return true;
        }
        return false;
    }
}

