/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic.listener;

import com.elmakers.mine.bukkit.api.action.GUIAction;
import com.elmakers.mine.bukkit.api.spell.MageSpell;
import com.elmakers.mine.bukkit.magic.Mage;
import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.tasks.ActivateIconTask;
import com.elmakers.mine.bukkit.tasks.WandCastTask;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import com.elmakers.mine.bukkit.utility.CompleteDragTask;
import com.elmakers.mine.bukkit.utility.CurrencyAmount;
import com.elmakers.mine.bukkit.utility.SafetyUtils;
import com.elmakers.mine.bukkit.wand.Wand;
import com.elmakers.mine.bukkit.wand.WandInventory;
import com.elmakers.mine.bukkit.wand.WandMode;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryCreativeEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class InventoryController
implements Listener {
    private static final int DEBUG_LEVEL = 80;
    private final MagicController controller;
    private boolean enableItemHacks = true;
    private boolean dropChangesPages = false;
    private long openCooldown = 0L;
    private boolean enableInventoryCasting = true;
    private boolean enableInventoryDropCasting = false;
    private boolean enableInventorySelection = true;
    private Set<InventoryType> unstashableTypes = new HashSet<InventoryType>();
    private static final Integer[] armorSlotList = new Integer[]{39, 38, 37, 36};
    private static final Set<Integer> armorSlots = new HashSet<Integer>(Arrays.asList(armorSlotList));
    private static final int OFFHAND_SLOT = 40;

    public InventoryController(MagicController controller) {
        this.controller = controller;
    }

    public void loadProperties(ConfigurationSection properties) {
        this.enableItemHacks = properties.getBoolean("enable_custom_item_hacks", false);
        this.dropChangesPages = properties.getBoolean("drop_changes_pages", false);
        this.enableInventoryCasting = properties.getBoolean("allow_inventory_casting", true);
        this.enableInventoryDropCasting = properties.getBoolean("allow_inventory_drop_casting", false);
        this.enableInventorySelection = properties.getBoolean("allow_inventory_selection", true);
        this.openCooldown = properties.getInt("open_cooldown", 0);
        List unstashableTypeKeys = properties.getStringList("unstashable_containers");
        this.unstashableTypes.clear();
        if (unstashableTypeKeys != null) {
            for (String typeKey : unstashableTypeKeys) {
                try {
                    InventoryType type = InventoryType.valueOf((String)typeKey.toUpperCase());
                    this.unstashableTypes.add(type);
                }
                catch (Exception ex) {
                    this.controller.getLogger().info("Unknown container type in unstashable_containers list: " + typeKey);
                }
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onInventoryCreative(InventoryCreativeEvent event) {
        HumanEntity clicked = event.getWhoClicked();
        Mage mage = this.controller.getRegisteredMage((Entity)clicked);
        if (mage == null) {
            return;
        }
        if (mage.getDebugLevel() >= 80) {
            ItemStack cursor = event.getCursor();
            ItemStack current = event.getCurrentItem();
            mage.sendDebugMessage("CREATIVE: " + event.getAction() + " of " + event.getClick() + " cursor: " + (cursor == null ? "(Nothing)" : cursor.getType().name()) + (current == null ? "(Current" : current.getType().name()));
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onInventoryDrag(InventoryDragEvent event) {
        boolean isSkillInventory;
        Wand activeWand;
        boolean isSpellInventory;
        GUIAction activeGUI;
        HumanEntity clicked = event.getWhoClicked();
        Mage mage = this.controller.getMage((Entity)clicked);
        if (mage.getDebugLevel() >= 80) {
            mage.sendDebugMessage("DRAG: " + event.getType() + " in " + event.getInventory().getType() + " slots: " + StringUtils.join((Collection)event.getInventorySlots(), (String)",") + " raw: " + StringUtils.join((Collection)event.getRawSlots(), (String)","));
        }
        if ((activeGUI = mage.getActiveGUI()) != null) {
            activeGUI.dragged(event);
            return;
        }
        if (event.getInventory().getType().name().equals("GRINDSTONE")) {
            ItemStack oldCursor = event.getOldCursor();
            ItemStack itemStack = oldCursor = oldCursor.hasItemMeta() ? CompatibilityLib.getItemUtils().makeReal(oldCursor) : oldCursor;
            if (Wand.isSpecial(oldCursor)) {
                Iterator iterator = event.getRawSlots().iterator();
                while (iterator.hasNext()) {
                    int slot = (Integer)iterator.next();
                    if (slot != 1 && slot != 0) continue;
                    event.setCancelled(true);
                    return;
                }
            }
        }
        boolean bl = isSpellInventory = (activeWand = mage.getActiveWand()) != null && activeWand.isInventoryOpen() && activeWand.getMode() == WandMode.INVENTORY;
        if (isSpellInventory && event.getRawSlots().contains(45)) {
            event.setCancelled(true);
            return;
        }
        boolean bl2 = isSkillInventory = activeWand != null && activeWand.isInventoryOpen() && activeWand.getMode() == WandMode.SKILLS;
        if (isSkillInventory) {
            ItemStack oldCursor = event.getOldCursor();
            oldCursor = oldCursor.hasItemMeta() ? CompatibilityLib.getItemUtils().makeReal(oldCursor) : oldCursor;
            boolean isSpell = Wand.isSpell(oldCursor);
            isSpellInventory = false;
            Set slots = event.getRawSlots();
            int spellInventoryStart = event.getInventory().getSize();
            Iterator iterator = slots.iterator();
            while (iterator.hasNext()) {
                int slot = (Integer)iterator.next();
                if (slot >= spellInventoryStart) continue;
                isSpellInventory = true;
            }
            if (!isSpell && isSpellInventory) {
                event.setCancelled(true);
            }
            return;
        }
        Set slots = event.getInventorySlots();
        boolean isArmorSlot = !Collections.disjoint(slots, armorSlots);
        boolean isOffhandSlot = slots.contains(40);
        boolean isHeldSlot = slots.contains(clicked.getInventory().getHeldItemSlot());
        if (isArmorSlot || isOffhandSlot || isHeldSlot) {
            ItemStack oldCursor = event.getOldCursor();
            ItemStack itemStack = oldCursor = oldCursor.hasItemMeta() ? CompatibilityLib.getItemUtils().makeReal(oldCursor) : oldCursor;
            if (isArmorSlot && Wand.isSpell(oldCursor)) {
                event.setCancelled(true);
                return;
            }
            if (Wand.isWand(oldCursor)) {
                Wand wand;
                if (isArmorSlot && (wand = this.controller.getWand(oldCursor)).hasWearable()) {
                    Iterator iterator = slots.iterator();
                    while (iterator.hasNext()) {
                        int slot = (Integer)iterator.next();
                        if (wand.isWearableInSlot(slot)) continue;
                        event.setCancelled(true);
                        return;
                    }
                }
                this.controller.onArmorUpdated(mage);
            }
        }
        if (!this.enableItemHacks) {
            return;
        }
        ItemStack oldStack = event.getOldCursor();
        HumanEntity entity = event.getWhoClicked();
        if (oldStack != null && oldStack.hasItemMeta() && entity instanceof Player) {
            Map draggedSlots = event.getNewItems();
            if (draggedSlots.size() != 1) {
                return;
            }
            event.setCancelled(true);
            InventoryView view = event.getView();
            for (Integer dslot : draggedSlots.keySet()) {
                CompleteDragTask completeDrag = new CompleteDragTask((Player)entity, view, dslot);
                completeDrag.runTaskLater(this.controller.getPlugin(), 1L);
            }
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        Wand testWand;
        ItemStack destinationItem;
        boolean isWatchedSlot;
        Wand activeWand;
        boolean isWandInventoryOpen;
        boolean tryingToWear;
        ItemStack item;
        boolean isHotbar;
        boolean isLeftClick;
        GUIAction gui;
        if (event.isCancelled()) {
            return;
        }
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        Mage mage = this.controller.getMage(player);
        InventoryType.SlotType slotType = event.getSlotType();
        Integer slot = event.getSlot();
        if (mage.getDebugLevel() >= 80) {
            mage.sendDebugMessage("CLICK: " + event.getAction() + ", " + event.getClick() + " on " + slotType + " in " + event.getInventory().getType() + " slots: " + slot + ":" + event.getRawSlot());
        }
        if ((gui = mage.getActiveGUI()) != null) {
            gui.clicked(event);
            return;
        }
        InventoryAction action = event.getAction();
        InventoryType inventoryType = event.getInventory().getType();
        boolean isPlayerInventory = inventoryType == InventoryType.CRAFTING || inventoryType == InventoryType.PLAYER;
        ItemStack clickedItem = event.getCurrentItem();
        boolean isSwap = event.getClick().name().equals("SWAP_OFFHAND");
        boolean isDrop = event.getClick() == ClickType.DROP || event.getClick() == ClickType.CONTROL_DROP;
        boolean isSkill = clickedItem != null && Wand.isSkill(clickedItem);
        boolean isRightClick = action == InventoryAction.PICKUP_HALF;
        boolean bl = isLeftClick = !isDrop && !isRightClick;
        if (isSkill && isRightClick) {
            mage.useSkill(clickedItem);
            player.closeInventory();
            event.setCancelled(true);
            return;
        }
        if (clickedItem != null && CompatibilityLib.getItemUtils().isTemporary(clickedItem)) {
            String message = CompatibilityLib.getItemUtils().getTemporaryMessage(clickedItem);
            if (message != null && message.length() > 1) {
                mage.sendMessage(message);
            }
            ItemStack replacement = CompatibilityLib.getItemUtils().getReplacement(clickedItem);
            event.setCurrentItem(replacement);
            event.setCancelled(true);
            mage.armorUpdated();
            return;
        }
        if (CompatibilityLib.getNBTUtils().getBoolean(clickedItem, "unmoveable", false)) {
            event.setCancelled(true);
            return;
        }
        ItemStack heldItem = event.getCursor();
        boolean heldWand = Wand.isWand(heldItem);
        boolean clickedWand = Wand.isWand(clickedItem);
        boolean bl2 = isHotbar = action == InventoryAction.HOTBAR_SWAP || action == InventoryAction.HOTBAR_MOVE_AND_READD;
        if (isSwap) {
            isHotbar = false;
        }
        int hotbarButton = event.getHotbarButton();
        if (isHotbar && hotbarButton < 0) {
            return;
        }
        boolean isGrindstone = inventoryType.name().equals("GRINDSTONE");
        if (isGrindstone && heldWand && (slot == 1 || slot == 0) && slotType == InventoryType.SlotType.CRAFTING) {
            event.setCancelled(true);
            return;
        }
        if (isGrindstone && clickedWand && action == InventoryAction.MOVE_TO_OTHER_INVENTORY && slotType != InventoryType.SlotType.CRAFTING) {
            event.setCancelled(true);
            return;
        }
        if (isGrindstone && isHotbar && Wand.isWand(item = mage.getPlayer().getInventory().getItem(hotbarButton))) {
            event.setCancelled(true);
            return;
        }
        boolean heldSpell = Wand.isSpell(heldItem);
        if (slotType == InventoryType.SlotType.ARMOR) {
            Wand wand;
            if (heldSpell) {
                event.setCancelled(true);
                return;
            }
            if (heldWand && (wand = this.controller.getWand(heldItem)).hasWearable()) {
                if (wand.isWearableInSlot(slot)) {
                    ItemStack existing = player.getInventory().getItem(slot.intValue());
                    player.getInventory().setItem(slot.intValue(), heldItem);
                    event.setCursor(existing);
                    event.setCancelled(true);
                    this.controller.onArmorUpdated(mage);
                    return;
                }
                event.setCancelled(true);
                return;
            }
            this.controller.onArmorUpdated(mage);
        }
        boolean bl3 = tryingToWear = !(action != InventoryAction.MOVE_TO_OTHER_INVENTORY || inventoryType != InventoryType.PLAYER && inventoryType != InventoryType.CRAFTING || slotType != InventoryType.SlotType.CONTAINER && slotType != InventoryType.SlotType.QUICKBAR);
        if (clickedWand && tryingToWear) {
            Wand wand = null;
            if (slot.intValue() == player.getInventory().getHeldItemSlot()) {
                wand = mage.getActiveWand();
            }
            if (wand == null) {
                wand = this.controller.getWand(clickedItem);
            }
            if (wand.tryToWear(mage)) {
                player.getInventory().setItem(slot.intValue(), null);
                event.setCancelled(true);
                mage.checkWand();
                return;
            }
        }
        boolean clickedSpell = Wand.isSpell(clickedItem);
        boolean clickedBrush = Wand.isBrush(clickedItem);
        boolean clickedWearable = this.controller.isWearable(clickedItem);
        if (tryingToWear && clickedSpell && clickedWearable) {
            event.setCancelled(true);
            return;
        }
        if (isHotbar && slotType == InventoryType.SlotType.ARMOR) {
            ItemStack item2 = mage.getPlayer().getInventory().getItem(hotbarButton);
            if (item2 != null && Wand.isSpell(item2)) {
                event.setCancelled(true);
                return;
            }
            this.controller.onArmorUpdated(mage);
        }
        boolean bl4 = isWandInventoryOpen = (activeWand = mage.getActiveWand()) != null && activeWand.isInventoryOpen();
        if (isSkill && !isPlayerInventory && !isWandInventoryOpen) {
            if (!isDrop) {
                event.setCancelled(true);
            }
            return;
        }
        if (!(isWandInventoryOpen || isSkill || !clickedBrush && !clickedSpell || Wand.isAbsorbable(clickedItem))) {
            event.setCurrentItem(new ItemStack(Material.AIR));
            event.setCancelled(true);
            return;
        }
        boolean isFurnace = inventoryType == InventoryType.FURNACE;
        boolean isContainer = this.unstashableTypes.contains(inventoryType);
        boolean isEnderChest = inventoryType == InventoryType.ENDER_CHEST;
        boolean isChest = inventoryType == InventoryType.CHEST;
        boolean isContainerSlot = isChest && event.getSlot() == event.getRawSlot();
        boolean bl5 = isWatchedSlot = !isChest || isContainerSlot;
        if (isWandInventoryOpen) {
            if (clickedSpell && clickedItem.getAmount() != 1) {
                clickedItem.setAmount(1);
            }
            if (isSwap) {
                MageSpell spell;
                String spellName = Wand.getSpell(clickedItem);
                if (spellName != null && !activeWand.isManualQuickCastDisabled() && this.enableInventoryCasting && (spell = mage.getSpell(spellName)) != null) {
                    Wand castWand = activeWand;
                    this.controller.getPlugin().getServer().getScheduler().runTaskLater(this.controller.getPlugin(), (Runnable)new WandCastTask(castWand, spell), 1L);
                }
                event.setCancelled(true);
            }
            if (clickedWand) {
                event.setCancelled(true);
                if (this.dropChangesPages && isDrop || isLeftClick) {
                    activeWand.cycleInventory();
                } else {
                    activeWand.cycleHotbar(1);
                }
                return;
            }
            if (activeWand.getMode() == WandMode.INVENTORY) {
                if (event.getRawSlot() == 45) {
                    event.setCancelled(true);
                    return;
                }
                if (slotType == InventoryType.SlotType.CRAFTING && heldSpell) {
                    event.setCancelled(true);
                    return;
                }
                if (isHotbar && Wand.isWand(player.getInventory().getItem(event.getHotbarButton()))) {
                    event.setCancelled(true);
                    return;
                }
                if (Wand.isWand(event.getCursor())) {
                    activeWand.closeInventory();
                    event.setCursor(null);
                    event.setCancelled(true);
                    return;
                }
            } else if (isHotbar && isWatchedSlot && !CompatibilityLib.getItemUtils().isEmpty(player.getInventory().getItem(event.getHotbarButton()))) {
                event.setCancelled(true);
                return;
            }
        } else if (activeWand != null) {
            int activeSlot = player.getInventory().getHeldItemSlot();
            if (event.getSlot() == activeSlot || isHotbar && event.getHotbarButton() == activeSlot) {
                mage.checkWand();
                activeWand = mage.getActiveWand();
            }
        }
        if (isFurnace && clickedWand) {
            event.setCancelled(true);
            return;
        }
        if (isFurnace && isHotbar && Wand.isWand(destinationItem = player.getInventory().getItem(event.getHotbarButton()))) {
            event.setCancelled(true);
            return;
        }
        if (isHotbar) {
            destinationItem = player.getInventory().getItem(event.getHotbarButton());
            if (CompatibilityLib.getNBTUtils().getBoolean(destinationItem, "unmoveable", false)) {
                event.setCancelled(true);
                return;
            }
            if (isContainer && CompatibilityLib.getNBTUtils().getBoolean(destinationItem, "unstashable", false) && !player.hasPermission("magic.wand.override_stash")) {
                event.setCancelled(true);
                return;
            }
        }
        if (isContainer && !isContainerSlot && !player.hasPermission("magic.wand.override_stash") && CompatibilityLib.getNBTUtils().getBoolean(clickedItem, "unstashable", false)) {
            event.setCancelled(true);
            return;
        }
        if (isContainer && isWatchedSlot && Wand.isBound(clickedItem) && !(testWand = this.controller.getWand(clickedItem)).canUse(player)) {
            event.setCancelled(true);
            return;
        }
        if (tryingToWear && clickedItem != null && clickedWearable) {
            this.controller.onArmorUpdated(mage);
        }
        if (isDrop) {
            if (CompatibilityLib.getNBTUtils().getBoolean(clickedItem, "undroppable", false)) {
                event.setCancelled(true);
                if (activeWand != null) {
                    if (activeWand.getHotbarCount() > 1) {
                        activeWand.cycleHotbar(1);
                    } else {
                        activeWand.closeInventory();
                    }
                }
                return;
            }
            if (isWandInventoryOpen) {
                ItemStack droppedItem = clickedItem;
                if (!Wand.isSpell(droppedItem)) {
                    mage.giveItem(droppedItem);
                    event.setCurrentItem(null);
                    event.setCancelled(true);
                    return;
                }
                int heldSlot = player.getInventory().getHeldItemSlot();
                WandInventory hotbar = activeWand.getHotbar();
                if (hotbar != null && slot >= 0 && slot <= hotbar.getSize() && slot != heldSlot && activeWand.getMode() == WandMode.INVENTORY) {
                    if (slot > heldSlot) {
                        Integer n = slot;
                        slot = slot - 1;
                    }
                    if (slot < hotbar.getSize()) {
                        droppedItem = hotbar.getItem(slot);
                    } else {
                        slot = null;
                    }
                } else {
                    slot = null;
                }
                if (!this.controller.isSpellDroppingEnabled()) {
                    MageSpell spell;
                    player.closeInventory();
                    String spellName = Wand.getSpell(droppedItem);
                    if (spellName != null && !activeWand.isManualQuickCastDisabled() && this.enableInventoryDropCasting && (spell = mage.getSpell(spellName)) != null) {
                        Wand castWand = activeWand;
                        mage.checkLastClick(0L);
                        this.controller.getPlugin().getServer().getScheduler().runTaskLater(this.controller.getPlugin(), (Runnable)new WandCastTask(castWand, spell), 1L);
                    }
                    event.setCancelled(true);
                    if (hotbar != null && slot != null && mage.getActiveGUI() == null) {
                        player.getInventory().setItem(event.getSlot(), droppedItem);
                        CompatibilityLib.getDeprecatedUtils().updateInventory(player);
                    }
                    return;
                }
                ItemStack newDrop = this.controller.removeItemFromWand(activeWand, droppedItem);
                if (newDrop != null) {
                    Location location = player.getLocation();
                    Item item3 = location.getWorld().dropItem(location, newDrop);
                    SafetyUtils.setVelocity((Entity)item3, location.getDirection().normalize());
                } else {
                    event.setCancelled(true);
                }
            }
            return;
        }
        if (activeWand != null) {
            boolean isChestInventory;
            WandMode wandMode = activeWand.getMode();
            boolean bl6 = isChestInventory = wandMode == WandMode.CHEST || wandMode == WandMode.SKILLS;
            if ((wandMode == WandMode.INVENTORY && isPlayerInventory || isChestInventory && inventoryType == InventoryType.CHEST) && activeWand.isInventoryOpen()) {
                boolean isInventoryQuickSelect;
                if (event.getAction() == InventoryAction.NOTHING) {
                    int direction = event.getClick() == ClickType.LEFT ? 1 : -1;
                    activeWand.cycleInventory(direction);
                    event.setCancelled(true);
                    return;
                }
                if (event.getSlotType() == InventoryType.SlotType.ARMOR) {
                    event.setCancelled(true);
                    return;
                }
                boolean bl7 = isInventoryQuickSelect = isRightClick && wandMode == WandMode.INVENTORY && this.enableInventorySelection;
                if (isInventoryQuickSelect || wandMode == WandMode.CHEST) {
                    Plugin plugin = this.controller.getPlugin();
                    plugin.getServer().getScheduler().runTaskLater(plugin, (Runnable)new ActivateIconTask(mage, activeWand, clickedItem), 1L);
                    event.setCancelled(true);
                }
                if (wandMode == WandMode.SKILLS && isWatchedSlot && !CompatibilityLib.getItemUtils().isEmpty(heldItem) && !Wand.isSkill(heldItem)) {
                    event.setCancelled(true);
                }
            }
        }
        if (!isWandInventoryOpen && clickedWand && !isContainer && !isEnderChest && (Wand.isUpgrade(heldItem) || Wand.isSpell(heldItem) || Wand.isSP(heldItem) || Wand.isBrush(heldItem))) {
            if (activeWand != null) {
                activeWand.deactivate();
            }
            Wand wand = this.controller.createWand(clickedItem);
            wand.setMage(mage);
            CurrencyAmount currency = CompatibilityLib.getInventoryUtils().getCurrencyAmount(heldItem);
            if (wand.addItem(heldItem)) {
                event.setCancelled(true);
                if (heldItem.getAmount() > 1 && currency == null) {
                    heldItem.setAmount(heldItem.getAmount() - 1);
                    event.setCursor(heldItem);
                } else {
                    event.setCursor(null);
                }
                event.getClickedInventory().setItem(event.getSlot(), wand.getItem());
            }
            if (activeWand != null) {
                mage.checkWand();
            }
        }
    }

    @EventHandler
    public void onInventoryClosed(InventoryCloseEvent event) {
        GUIAction gui;
        if (!(event.getPlayer() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getPlayer();
        Mage mage = this.controller.getRegisteredMage((Entity)player);
        if (mage == null) {
            return;
        }
        Wand previousWand = mage.getActiveWand();
        Inventory inventory = event.getInventory();
        if (inventory instanceof CraftingInventory && previousWand != null && previousWand.wasInventoryOpen()) {
            CraftingInventory craftingInventory = (CraftingInventory)inventory;
            ItemStack[] matrix = craftingInventory.getMatrix();
            for (int i = 0; i < matrix.length; ++i) {
                matrix[i] = new ItemStack(Material.AIR);
            }
            craftingInventory.setMatrix(matrix);
        }
        if ((gui = mage.getActiveGUI()) != null) {
            mage.onGUIDeactivate();
        }
        if (previousWand != null && previousWand.isInventoryOpen()) {
            if (previousWand.getMode() == WandMode.INVENTORY) {
                previousWand.saveInventory();
                previousWand.updateHotbar();
            } else if (previousWand.getMode() == WandMode.CHEST || previousWand.getMode() == WandMode.SKILLS) {
                previousWand.closeInventory();
            }
        } else {
            if (previousWand != null && !previousWand.wasInventoryOpen() && previousWand.isAutoAbsorb()) {
                previousWand.checkInventoryForUpgrades();
            }
            mage.checkWand();
        }
    }

    @EventHandler
    public void onInventoryOpen(InventoryOpenEvent event) {
        Player player = (Player)event.getPlayer();
        Mage mage = this.controller.getRegisteredMage((Entity)player);
        if (mage == null) {
            return;
        }
        mage.setOpenCooldown(this.openCooldown);
        Wand wand = mage.getActiveWand();
        GUIAction gui = mage.getActiveGUI();
        if (!(wand == null || gui != null || event.getView().getType() == InventoryType.CRAFTING || wand.getMode() != WandMode.INVENTORY && wand.isInventoryOpen())) {
            wand.deactivate(false);
        }
    }
}

