/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.protection;

import com.elmakers.mine.bukkit.api.protection.BlockBreakManager;
import com.elmakers.mine.bukkit.api.protection.BlockBuildManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredListener;

public class ProtectionManager
implements BlockBreakManager,
BlockBuildManager {
    private Plugin owningPlugin;
    private final Set<Plugin> plugins = new HashSet<Plugin>();
    private final List<String> pluginNames = new ArrayList<String>();
    private boolean checkedListeners;
    private final List<RegisteredListener> breakListeners = new ArrayList<RegisteredListener>();
    private final List<RegisteredListener> buildListeners = new ArrayList<RegisteredListener>();

    public boolean isEnabled() {
        return this.plugins.size() > 0;
    }

    public void initialize(Plugin owner, List<String> pluginNames) {
        this.owningPlugin = owner;
        this.plugins.clear();
        this.checkedListeners = false;
        this.pluginNames.clear();
        this.pluginNames.addAll(pluginNames);
    }

    public void check() {
        for (String pluginName : this.pluginNames) {
            Plugin plugin = this.owningPlugin.getServer().getPluginManager().getPlugin(pluginName);
            if (plugin == null) continue;
            this.plugins.add(plugin);
            this.owningPlugin.getLogger().info("Integrating with " + pluginName + " using fake break/build events");
        }
    }

    private void checkListeners() {
        if (this.checkedListeners) {
            return;
        }
        this.checkBreakListeners();
        this.checkBuildListeners();
        this.checkedListeners = true;
    }

    private void checkBreakListeners() {
        this.breakListeners.clear();
        HandlerList handlers = BlockBreakEvent.getHandlerList();
        for (RegisteredListener listener : handlers.getRegisteredListeners()) {
            if (!this.plugins.contains(listener.getPlugin())) continue;
            this.breakListeners.add(listener);
        }
    }

    private void checkBuildListeners() {
        this.buildListeners.clear();
        HandlerList handlers = BlockPlaceEvent.getHandlerList();
        for (RegisteredListener listener : handlers.getRegisteredListeners()) {
            if (!this.plugins.contains(listener.getPlugin())) continue;
            this.buildListeners.add(listener);
        }
    }

    @Override
    public boolean hasBuildPermission(Player player, Block block) {
        if (player == null || block == null) {
            return true;
        }
        this.checkListeners();
        BlockPlaceEvent placeEvent = new BlockPlaceEvent(block, block.getState(), block.getRelative(BlockFace.DOWN), player.getInventory().getItemInMainHand(), player, true, EquipmentSlot.HAND);
        for (RegisteredListener listener : this.buildListeners) {
            try {
                listener.callEvent((Event)placeEvent);
                if (!placeEvent.isCancelled()) continue;
                return false;
            }
            catch (Exception ex) {
                this.owningPlugin.getLogger().log(Level.WARNING, "An error occurred sending a BlockPlaceEvent to " + listener.getPlugin().getName(), ex);
            }
        }
        return true;
    }

    @Override
    public boolean hasBreakPermission(Player player, Block block) {
        if (player == null || block == null) {
            return true;
        }
        this.checkListeners();
        BlockBreakEvent breakEvent = new BlockBreakEvent(block, player);
        for (RegisteredListener listener : this.breakListeners) {
            try {
                listener.callEvent((Event)breakEvent);
                if (!breakEvent.isCancelled()) continue;
                return false;
            }
            catch (Exception ex) {
                this.owningPlugin.getLogger().log(Level.WARNING, "An error occurred sending a BlockBreakEvent to " + listener.getPlugin().getName(), ex);
            }
        }
        return true;
    }
}

