/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.batch;

import com.elmakers.mine.bukkit.api.block.MaterialBrush;
import com.elmakers.mine.bukkit.api.entity.EntityData;
import com.elmakers.mine.bukkit.batch.SpellBatch;
import com.elmakers.mine.bukkit.spell.BrushSpell;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;

public abstract class BrushBatch
extends SpellBatch {
    private final Set<Chunk> affectedChunks = new HashSet<Chunk>();
    private boolean lockChunks = false;

    public BrushBatch(BrushSpell spell) {
        super(spell);
    }

    protected abstract boolean contains(Location var1);

    protected void touch(Block block) {
        Chunk chunk = block.getChunk();
        if (this.affectedChunks.add(chunk) && this.lockChunks) {
            this.controller.lockChunk(chunk);
        }
    }

    @Override
    public void finish() {
        if (!this.finished) {
            MaterialBrush brush = this.spell.getBrush();
            if (brush != null && brush.hasEntities()) {
                Collection<EntityData> entities = brush.getEntities(this.affectedChunks);
                Collection<Entity> targetEntities = brush.getTargetEntities();
                if (targetEntities != null) {
                    for (Entity entity : targetEntities) {
                        if (!this.contains(entity.getLocation())) continue;
                        this.undoList.modify(entity);
                        entity.remove();
                    }
                }
                if (entities != null) {
                    for (EntityData entityData : entities) {
                        if (!this.contains(entityData.getLocation())) continue;
                        this.undoList.add(entityData.spawn());
                    }
                }
            }
            if (this.lockChunks) {
                for (Chunk chunk : this.affectedChunks) {
                    this.controller.unlockChunk(chunk);
                }
            }
            this.affectedChunks.clear();
            super.finish();
        }
    }

    public void setLockChunks(boolean lockChunks) {
        this.lockChunks = lockChunks;
        if (this.undoList != null) {
            this.undoList.setLockChunks(lockChunks);
        }
    }
}

