/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.world.block;

import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.world.BlockResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public abstract class BlockRule {
    protected MagicController controller;
    protected List<Material> blockTypes;
    protected boolean isGlobal;
    protected String worldName;
    protected String action;
    protected BlockResult result;

    protected void initialize(MagicController controller, String worldName, String action) {
        this.controller = controller;
        this.worldName = worldName;
        this.action = action;
    }

    public boolean load(ConfigurationSection config, MagicController controller, String worldName, String action) {
        this.initialize(controller, worldName, action);
        String resultType = config.getString("result");
        if (resultType != null && !resultType.isEmpty()) {
            try {
                this.result = BlockResult.valueOf(resultType.toUpperCase());
            }
            catch (Exception ex) {
                controller.getLogger().warning("Invalid block rule result type: " + resultType);
            }
        }
        boolean bl = this.isGlobal = !config.contains("type") && !config.contains("types");
        if (!this.isGlobal) {
            List<String> typeList;
            this.blockTypes = new ArrayList<Material>();
            String oneType = config.getString("type");
            if (oneType != null && !oneType.isEmpty()) {
                try {
                    Material material = Material.valueOf((String)oneType.toUpperCase());
                    this.blockTypes.add(material);
                }
                catch (Exception ex) {
                    controller.getLogger().warning("Invalid material in block rule type: " + oneType);
                }
            }
            if ((typeList = ConfigurationUtils.getStringList(config, "types")) != null && !typeList.isEmpty()) {
                for (String typeKey : typeList) {
                    try {
                        Material material = Material.valueOf((String)typeKey.toUpperCase());
                        this.blockTypes.add(material);
                    }
                    catch (Exception ex) {
                        controller.getLogger().warning("Invalid material in block rule types list: " + typeKey);
                    }
                }
            }
        }
        return this.onLoad(config);
    }

    public boolean isGlobal() {
        return this.isGlobal;
    }

    public List<Material> getBlockTypes() {
        return this.blockTypes;
    }

    public String getTargetBlockTypeNames() {
        if (this.isGlobal) {
            return "all block types";
        }
        return StringUtils.join(this.blockTypes, (String)",");
    }

    protected void logBlockRule(String message) {
        message = message + " on " + this.action + " of " + this.getTargetBlockTypeNames() + " in " + this.worldName;
        this.controller.info(message);
    }

    public BlockResult handle(Block block, Random random, Player cause) {
        BlockResult result = this.onHandle(block, random, cause);
        return this.result != null ? this.result : result;
    }

    public abstract boolean onLoad(ConfigurationSection var1);

    public abstract BlockResult onHandle(Block var1, Random var2, Player var3);
}

