/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.protection;

import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.api.wand.Wand;
import com.elmakers.mine.bukkit.protection.WorldGuardFlags;
import com.mewin.WGCustomFlags.WGCustomFlagsPlugin;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.association.RegionAssociable;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.RegionGroup;
import com.sk89q.worldguard.protection.flags.SetFlag;
import com.sk89q.worldguard.protection.flags.StringFlag;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nullable;
import org.bukkit.plugin.Plugin;

public class WGCustomFlagsManager
implements WorldGuardFlags {
    private final WGCustomFlagsPlugin customFlags;
    public static SetFlag<String> ALLOWED_SPELLS = new SetFlag("allowed-spells", RegionGroup.ALL, (Flag)new StringFlag(null));
    public static SetFlag<String> BLOCKED_SPELLS = new SetFlag("blocked-spells", RegionGroup.ALL, (Flag)new StringFlag(null));
    public static SetFlag<String> ALLOWED_SPELL_CATEGORIES = new SetFlag("allowed-spell-categories", RegionGroup.ALL, (Flag)new StringFlag(null));
    public static SetFlag<String> BLOCKED_SPELL_CATEGORIES = new SetFlag("blocked-spell-categories", RegionGroup.ALL, (Flag)new StringFlag(null));
    public static SetFlag<String> ALLOWED_WANDS = new SetFlag("allowed-wands", RegionGroup.ALL, (Flag)new StringFlag(null));
    public static SetFlag<String> BLOCKED_WANDS = new SetFlag("blocked-wands", RegionGroup.ALL, (Flag)new StringFlag(null));
    public static SetFlag<String> SPELL_OVERRIDES = new SetFlag("spell-overrides", RegionGroup.ALL, (Flag)new StringFlag(null));
    public static SetFlag<String> TAGS = new SetFlag("magic-tags", RegionGroup.ALL, (Flag)new StringFlag(null));
    public static StringFlag DESTRUCTIBLE = new StringFlag("destructible", RegionGroup.ALL);
    public static StringFlag REFLECTIVE = new StringFlag("reflective", RegionGroup.ALL);
    public static StringFlag PORTAL_SPELL = new StringFlag("portal-spell", RegionGroup.ALL);
    public static StringFlag PORTAL_WARP = new StringFlag("portal-warp", RegionGroup.ALL);
    public static SetFlag<String> SPAWN_TAGS = new SetFlag("spawn-tags", RegionGroup.ALL, (Flag)new StringFlag(null));

    public WGCustomFlagsManager(Plugin wgCustomFlags) {
        this.customFlags = (WGCustomFlagsPlugin)wgCustomFlags;
        this.customFlags.addCustomFlag(ALLOWED_SPELLS);
        this.customFlags.addCustomFlag(BLOCKED_SPELLS);
        this.customFlags.addCustomFlag(ALLOWED_SPELL_CATEGORIES);
        this.customFlags.addCustomFlag(BLOCKED_SPELL_CATEGORIES);
        this.customFlags.addCustomFlag(ALLOWED_WANDS);
        this.customFlags.addCustomFlag(BLOCKED_WANDS);
        this.customFlags.addCustomFlag(SPELL_OVERRIDES);
        this.customFlags.addCustomFlag((Flag)DESTRUCTIBLE);
        this.customFlags.addCustomFlag((Flag)REFLECTIVE);
        this.customFlags.addCustomFlag(SPAWN_TAGS);
        this.customFlags.addCustomFlag(TAGS);
        this.customFlags.addCustomFlag((Flag)PORTAL_SPELL);
        this.customFlags.addCustomFlag((Flag)PORTAL_WARP);
    }

    @Override
    @Nullable
    public String getPortalSpell(RegionAssociable source, ApplicableRegionSet checkSet) {
        return (String)checkSet.queryValue(source, (Flag)PORTAL_SPELL);
    }

    @Override
    @Nullable
    public String getPortalWarp(RegionAssociable source, ApplicableRegionSet checkSet) {
        return (String)checkSet.queryValue(source, (Flag)PORTAL_WARP);
    }

    @Override
    @Nullable
    public String getDestructible(RegionAssociable source, ApplicableRegionSet checkSet) {
        return (String)checkSet.queryValue(source, (Flag)DESTRUCTIBLE);
    }

    @Override
    @Nullable
    public String getReflective(RegionAssociable source, ApplicableRegionSet checkSet) {
        return (String)checkSet.queryValue(source, (Flag)REFLECTIVE);
    }

    @Override
    @Nullable
    public Set<String> getSpellOverrides(RegionAssociable source, ApplicableRegionSet checkSet) {
        return (Set)checkSet.queryValue(source, SPELL_OVERRIDES);
    }

    @Override
    @Nullable
    public Boolean getWandPermission(RegionAssociable source, ApplicableRegionSet checkSet, Wand wand) {
        String wandTemplate = wand.getTemplateKey();
        Set blocked = (Set)checkSet.queryValue(source, BLOCKED_WANDS);
        if (blocked != null && blocked.contains(wandTemplate)) {
            return false;
        }
        Set allowed = (Set)checkSet.queryValue(source, ALLOWED_WANDS);
        if (allowed != null && (allowed.contains("*") || allowed.contains(wandTemplate))) {
            return true;
        }
        if (blocked != null && blocked.contains("*")) {
            return false;
        }
        return null;
    }

    @Override
    @Nullable
    public Boolean getCastPermission(RegionAssociable source, ApplicableRegionSet checkSet, SpellTemplate spell) {
        String spellKey = spell.getSpellKey().getBaseKey();
        Set blocked = (Set)checkSet.queryValue(source, BLOCKED_SPELLS);
        if (blocked != null && blocked.contains(spellKey)) {
            return false;
        }
        Set blockedCategories = (Set)checkSet.queryValue(source, BLOCKED_SPELL_CATEGORIES);
        if (blockedCategories != null && spell.hasAnyTag(blockedCategories)) {
            return false;
        }
        Set allowed = (Set)checkSet.queryValue(source, ALLOWED_SPELLS);
        if (allowed != null && (allowed.contains("*") || allowed.contains(spellKey))) {
            return true;
        }
        Set allowedCategories = (Set)checkSet.queryValue(source, ALLOWED_SPELL_CATEGORIES);
        if (allowedCategories != null && spell.hasAnyTag(allowedCategories)) {
            return true;
        }
        if (blocked != null && blocked.contains("*")) {
            return false;
        }
        return null;
    }

    @Override
    public boolean inTaggedRegion(RegionAssociable source, ApplicableRegionSet checkSet, Set<String> tags) {
        Set regionTags = (Set)checkSet.queryValue(source, TAGS);
        if (regionTags == null) {
            regionTags = (Set)checkSet.queryValue(source, SPAWN_TAGS);
        }
        if (regionTags == null) {
            return false;
        }
        return regionTags.contains("*") || !Collections.disjoint(regionTags, tags);
    }
}

