/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.builtin.EntityProjectileAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.block.MaterialBrush;
import com.elmakers.mine.bukkit.api.item.ItemData;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.api.wand.Wand;
import com.elmakers.mine.bukkit.item.InventorySlot;
import com.elmakers.mine.bukkit.slikey.effectlib.math.VectorTransform;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;

public class ArmorStandProjectileAction
extends EntityProjectileAction {
    private boolean smallArmorStand = false;
    private boolean armorStandMarker = false;
    private boolean armorStandInvisible = false;
    private boolean armorStandGravity = false;
    private boolean adjustArmPitch = false;
    private boolean adjustHeadPitch = false;
    private boolean showArmorStandArms = true;
    private boolean showArmorStandBaseplate = false;
    private boolean unbreakableItems = false;
    private ItemData rightArmItem = null;
    private ItemData helmetItem = null;
    private ItemData chestplateItem = null;
    private ItemData leggingsItem = null;
    private ItemData bootsItem = null;
    private VectorTransform leftArmTransform;
    private VectorTransform rightArmTransform;
    private VectorTransform leftLegTransform;
    private VectorTransform rightLegTransform;
    private VectorTransform bodyTransform;
    private VectorTransform headTransform;
    private int visibleDelayTicks = 1;
    private InventorySlot wandSlot;
    private boolean useWand;
    private String useBrushItem;
    private ItemStack wandItem;
    private int slotNumber;
    private int stepCount = 0;

    @Override
    public void initialize(Spell spell, ConfigurationSection parameters) {
        super.initialize(spell, parameters);
        if (parameters.isConfigurationSection("left_arm_transform")) {
            this.leftArmTransform = new VectorTransform(ConfigurationUtils.getConfigurationSection(parameters, "right_arm_transform"));
        }
        if (parameters.isConfigurationSection("right_arm_transform")) {
            this.rightArmTransform = new VectorTransform(ConfigurationUtils.getConfigurationSection(parameters, "right_arm_transform"));
        }
        if (parameters.isConfigurationSection("right_leg_transform")) {
            this.rightLegTransform = new VectorTransform(ConfigurationUtils.getConfigurationSection(parameters, "right_leg_transform"));
        }
        if (parameters.isConfigurationSection("left_leg_transform")) {
            this.leftLegTransform = new VectorTransform(ConfigurationUtils.getConfigurationSection(parameters, "left_leg_transform"));
        }
        if (parameters.isConfigurationSection("head_transform")) {
            this.headTransform = new VectorTransform(ConfigurationUtils.getConfigurationSection(parameters, "head_transform"));
        }
        if (parameters.isConfigurationSection("body_transform")) {
            this.bodyTransform = new VectorTransform(ConfigurationUtils.getConfigurationSection(parameters, "body_transform"));
        }
    }

    @Override
    protected boolean teleportByDefault() {
        return true;
    }

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        parameters.set("type", (Object)"armor_stand");
        super.prepare(context, parameters);
        this.armorStandMarker = parameters.getBoolean("armor_stand_marker", true);
        this.armorStandInvisible = parameters.getBoolean("armor_stand_invisible", true);
        this.armorStandGravity = parameters.getBoolean("armor_stand_gravity", false);
        this.showArmorStandArms = parameters.getBoolean("armor_stand_arms", true);
        this.showArmorStandBaseplate = parameters.getBoolean("armor_stand_baseplate", false);
        this.smallArmorStand = parameters.getBoolean("armor_stand_small", false);
        this.adjustHeadPitch = parameters.getBoolean("orient_head", false);
        this.adjustArmPitch = parameters.getBoolean("orient_right_arm", false);
        this.unbreakableItems = parameters.getBoolean("unbreakable_items", false);
        this.visibleDelayTicks = parameters.getInt("visible_delay_ticks", 1);
        this.useWand = parameters.getBoolean("mount_wand", false);
        this.useBrushItem = parameters.getString("use_brush");
        String wandSlotString = parameters.getString("wand_slot", "HELMET");
        this.wandSlot = InventorySlot.parse(wandSlotString);
        if (this.wandSlot == null) {
            context.getLogger().warning("Invalid wand slot: " + wandSlotString);
        }
        MageController controller = context.getController();
        this.rightArmItem = controller.getOrCreateItem(parameters.getString("right_arm_item"));
        this.helmetItem = controller.getOrCreateItem(parameters.getString("helmet_item"));
        this.chestplateItem = controller.getOrCreateItem(parameters.getString("chestplate_item"));
        this.leggingsItem = controller.getOrCreateItem(parameters.getString("leggings_item"));
        this.bootsItem = controller.getOrCreateItem(parameters.getString("boots_item"));
    }

    @Override
    public SpellResult start(CastContext context) {
        MageController controller = context.getController();
        this.checkItems(context);
        Location location = this.adjustStartLocation(this.sourceLocation.getLocation(context));
        ArmorStand armorStand = (ArmorStand)this.setEntity(controller, (Entity)CompatibilityLib.getCompatibilityUtils().createArmorStand(location));
        armorStand.setMarker(this.armorStandMarker);
        armorStand.setVisible(!this.armorStandInvisible);
        armorStand.setBasePlate(this.showArmorStandBaseplate);
        armorStand.setGravity(this.armorStandGravity);
        armorStand.setSmall(this.smallArmorStand);
        armorStand.setArms(this.showArmorStandArms);
        CompatibilityLib.getCompatibilityUtils().setSilent((Entity)armorStand, true);
        CompatibilityLib.getCompatibilityUtils().setDisabledSlots(armorStand, 0x1F1F00);
        this.update(armorStand);
        CompatibilityLib.getCompatibilityUtils().addToWorld(location.getWorld(), (Entity)armorStand, this.spawnReason);
        return super.start(context);
    }

    protected void update(ArmorStand armorStand) {
        double pitchOffset;
        Vector direction;
        double t = (double)this.flightTime / 1000.0;
        Location currentLocation = armorStand.getLocation();
        if (this.leftArmTransform != null) {
            direction = this.leftArmTransform.get(this.launchLocation, t);
            armorStand.setLeftArmPose(new EulerAngle(direction.getX(), direction.getY(), direction.getZ()));
        }
        if (this.rightArmTransform != null) {
            direction = this.rightArmTransform.get(this.launchLocation, t);
            pitchOffset = this.adjustArmPitch ? Math.toRadians(currentLocation.getPitch()) : 0.0;
            armorStand.setRightArmPose(new EulerAngle(direction.getX(), direction.getY() + pitchOffset, direction.getZ()));
        } else if (this.adjustArmPitch) {
            EulerAngle armPose = armorStand.getRightArmPose();
            armPose = armPose.setY(Math.toRadians(-currentLocation.getPitch()));
            armorStand.setRightArmPose(armPose);
        }
        if (this.leftLegTransform != null) {
            direction = this.leftLegTransform.get(this.launchLocation, t);
            armorStand.setLeftLegPose(new EulerAngle(direction.getX(), direction.getY(), direction.getZ()));
        }
        if (this.rightLegTransform != null) {
            direction = this.rightLegTransform.get(this.launchLocation, t);
            armorStand.setRightLegPose(new EulerAngle(direction.getX(), direction.getY(), direction.getZ()));
        }
        if (this.bodyTransform != null) {
            direction = this.bodyTransform.get(this.launchLocation, t);
            armorStand.setBodyPose(new EulerAngle(direction.getX(), direction.getY(), direction.getZ()));
        }
        if (this.headTransform != null) {
            direction = this.headTransform.get(this.launchLocation, t);
            pitchOffset = this.adjustHeadPitch ? Math.toRadians(currentLocation.getPitch()) : 0.0;
            armorStand.setHeadPose(new EulerAngle(direction.getX(), direction.getY() + pitchOffset, direction.getZ()));
        } else if (this.adjustHeadPitch) {
            EulerAngle headPose = armorStand.getHeadPose();
            headPose = headPose.setX(Math.toRadians(currentLocation.getPitch()));
            armorStand.setHeadPose(headPose);
        }
    }

    @Override
    public SpellResult step(CastContext context) {
        SpellResult result = super.step(context);
        if (this.entity == null) {
            return SpellResult.FAIL;
        }
        Player player = context.getMage().getPlayer();
        if (player == null && this.useWand) {
            return SpellResult.PLAYER_REQUIRED;
        }
        ArmorStand armorStand = (ArmorStand)this.entity;
        this.update(armorStand);
        if (this.useWand && this.wandItem == null) {
            Wand wand = context.getWand();
            if (wand == null) {
                return SpellResult.NO_TARGET;
            }
            wand.deactivate();
            this.wandItem = wand.getItem();
            if (this.wandItem == null || this.wandItem.getType() == Material.AIR) {
                return SpellResult.FAIL;
            }
            this.slotNumber = wand.getHeldSlot();
            player.getInventory().setItem(this.slotNumber, new ItemStack(Material.AIR));
        }
        if (this.stepCount == this.visibleDelayTicks) {
            EntityEquipment equipment = armorStand.getEquipment();
            if (this.wandItem != null && this.wandSlot == InventorySlot.HELMET) {
                equipment.setHelmet(this.wandItem);
            } else {
                equipment.setHelmet(this.getItem(this.helmetItem));
            }
            if (this.wandItem != null && this.wandSlot == InventorySlot.RIGHT_ARM) {
                equipment.setItemInMainHand(this.wandItem);
            } else {
                equipment.setItemInMainHand(this.getItem(this.rightArmItem));
            }
            if (this.wandItem != null && this.wandSlot == InventorySlot.CHESTPLATE) {
                equipment.setChestplate(this.wandItem);
            } else {
                equipment.setChestplate(this.getItem(this.chestplateItem));
            }
            if (this.wandItem != null && this.wandSlot == InventorySlot.LEGGINGS) {
                equipment.setLeggings(this.wandItem);
            } else {
                equipment.setLeggings(this.getItem(this.leggingsItem));
            }
            if (this.wandItem != null && this.wandSlot == InventorySlot.BOOTS) {
                equipment.setBoots(this.wandItem);
            } else {
                equipment.setBoots(this.getItem(this.bootsItem));
            }
        }
        ++this.stepCount;
        return result;
    }

    private void checkItems(CastContext context) {
        if (this.useBrushItem != null) {
            MaterialBrush brush = context.getBrush();
            if (brush == null || !brush.isValid()) {
                return;
            }
            ItemData brushItem = context.getController().getOrCreateItem(brush.getKey());
            if (brushItem == null) {
                return;
            }
            switch (this.useBrushItem) {
                case "right_arm": {
                    this.rightArmItem = brushItem;
                    break;
                }
                case "helmet": {
                    this.helmetItem = brushItem;
                    break;
                }
                case "chestplate": {
                    this.chestplateItem = brushItem;
                    break;
                }
                case "leggings": {
                    this.leggingsItem = brushItem;
                    break;
                }
                case "boots": {
                    this.bootsItem = brushItem;
                }
            }
        }
    }

    @Nullable
    private ItemStack getItem(ItemData itemData) {
        ItemStack itemStack = null;
        if (itemData != null && (itemStack = itemData.getItemStack(1)) != null && this.unbreakableItems) {
            CompatibilityLib.getItemUtils().makeUnbreakable(CompatibilityLib.getItemUtils().makeReal(itemStack));
        }
        return itemStack;
    }

    @Override
    public void finish(CastContext context) {
        super.finish(context);
        Mage mage = context.getMage();
        Player player = mage.getPlayer();
        if (player == null || this.wandItem == null) {
            return;
        }
        ItemStack currentItem = player.getInventory().getItem(this.slotNumber);
        if (currentItem != null || mage.hasStoredInventory()) {
            mage.giveItem(this.wandItem);
        } else {
            player.getInventory().setItem(this.slotNumber, this.wandItem);
        }
        context.checkWand();
        this.wandItem = null;
    }

    @Override
    public void reset(CastContext context) {
        super.reset(context);
        this.stepCount = 0;
    }
}

